/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.bcel.Constants;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.BCELFactory;

public class BCELifier
extends EmptyVisitor {
    private JavaClass _clazz;
    private PrintWriter _out;
    private ConstantPoolGen _cp;

    public BCELifier(JavaClass javaClass, OutputStream outputStream) {
        this._clazz = javaClass;
        this._out = new PrintWriter(outputStream);
        this._cp = new ConstantPoolGen(this._clazz.getConstantPool());
    }

    public void start() {
        this.visitJavaClass(this._clazz);
        this._out.flush();
    }

    public void visitJavaClass(JavaClass javaClass) {
        String string = javaClass.getClassName();
        String string2 = javaClass.getSuperclassName();
        String string3 = javaClass.getPackageName();
        String string4 = Utility.printArray(javaClass.getInterfaceNames(), false, true);
        if (!"".equals(string3)) {
            string = string.substring(string3.length() + 1);
            this._out.println("package " + string3 + ";\n");
        }
        this._out.println("import org.apache.bcel.generic.*;");
        this._out.println("import org.apache.bcel.classfile.*;");
        this._out.println("import org.apache.bcel.*;");
        this._out.println("import java.io.*;\n");
        this._out.println("public class " + string + "Creator implements Constants {");
        this._out.println("  private InstructionFactory _factory;");
        this._out.println("  private ConstantPoolGen    _cp;");
        this._out.println("  private ClassGen           _cg;\n");
        this._out.println("  public " + string + "Creator() {");
        this._out.println("    _cg = new ClassGen(\"" + ("".equals(string3) ? string : string3 + "." + string) + "\", \"" + string2 + "\", " + "\"" + javaClass.getSourceFileName() + "\", " + BCELifier.printFlags(javaClass.getAccessFlags(), true) + ", " + "new String[] { " + string4 + " });\n");
        this._out.println("    _cp = _cg.getConstantPool();");
        this._out.println("    _factory = new InstructionFactory(_cg, _cp);");
        this._out.println("  }\n");
        this.printCreate();
        Field[] fieldArray = javaClass.getFields();
        if (fieldArray.length > 0) {
            this._out.println("  private void createFields() {");
            this._out.println("    FieldGen field;");
            for (int i = 0; i < fieldArray.length; ++i) {
                fieldArray[i].accept(this);
            }
            this._out.println("  }\n");
        }
        Method[] methodArray = javaClass.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            this._out.println("  private void createMethod_" + i + "() {");
            methodArray[i].accept(this);
            this._out.println("  }\n");
        }
        this.printMain();
        this._out.println("}");
    }

    private void printCreate() {
        this._out.println("  public void create(OutputStream out) throws IOException {");
        Field[] fieldArray = this._clazz.getFields();
        if (fieldArray.length > 0) {
            this._out.println("    createFields();");
        }
        Method[] methodArray = this._clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            this._out.println("    createMethod_" + i + "();");
        }
        this._out.println("    _cg.getJavaClass().dump(out);");
        this._out.println("  }\n");
    }

    private void printMain() {
        String string = this._clazz.getClassName();
        this._out.println("  public static void main(String[] args) throws Exception {");
        this._out.println("    " + string + "Creator creator = new " + string + "Creator();");
        this._out.println("    creator.create(new FileOutputStream(\"" + string + ".class\"));");
        this._out.println("  }");
    }

    public void visitField(Field field) {
        this._out.println("\n    field = new FieldGen(" + BCELifier.printFlags(field.getAccessFlags()) + ", " + BCELifier.printType(field.getSignature()) + ", \"" + field.getName() + "\", _cp);");
        ConstantValue constantValue = field.getConstantValue();
        if (constantValue != null) {
            String string = constantValue.toString();
            this._out.println("    field.setInitValue(" + string + ")");
        }
        this._out.println("    _cg.addField(field.getField());");
    }

    public void visitMethod(Method method) {
        MethodGen methodGen = new MethodGen(method, this._clazz.getClassName(), this._cp);
        Type type = methodGen.getReturnType();
        Type[] typeArray = methodGen.getArgumentTypes();
        this._out.println("    InstructionList il = new InstructionList();");
        this._out.println("    MethodGen method = new MethodGen(" + BCELifier.printFlags(method.getAccessFlags()) + ", " + BCELifier.printType(type) + ", " + BCELifier.printArgumentTypes(typeArray) + ", " + "new String[] { " + Utility.printArray(methodGen.getArgumentNames(), false, true) + " }, \"" + method.getName() + "\", \"" + this._clazz.getClassName() + "\", il, _cp);\n");
        BCELFactory bCELFactory = new BCELFactory(methodGen, this._out);
        bCELFactory.start();
        this._out.println("    method.setMaxStack();");
        this._out.println("    method.setMaxLocals();");
        this._out.println("    _cg.addMethod(method.getMethod());");
        this._out.println("    il.dispose();");
    }

    static String printFlags(int n) {
        return BCELifier.printFlags(n, false);
    }

    static String printFlags(int n, boolean bl) {
        if (n == 0) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 1;
        for (int i = 0; i <= 2048; ++i) {
            if ((n & n2) != 0) {
                if (n2 == 32 && bl) {
                    stringBuffer.append("ACC_SUPER | ");
                } else {
                    stringBuffer.append("ACC_" + Constants.ACCESS_NAMES[i].toUpperCase() + " | ");
                }
            }
            n2 <<= 1;
        }
        String string = stringBuffer.toString();
        return string.substring(0, string.length() - 3);
    }

    static String printArgumentTypes(Type[] typeArray) {
        if (typeArray.length == 0) {
            return "Type.NO_ARGS";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < typeArray.length; ++i) {
            stringBuffer.append(BCELifier.printType(typeArray[i]));
            if (i >= typeArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return "new Type[] { " + stringBuffer.toString() + " }";
    }

    static String printType(Type type) {
        return BCELifier.printType(type.getSignature());
    }

    static String printType(String string) {
        Type type = Type.getType(string);
        byte by = type.getType();
        if (by <= 12) {
            return "Type." + Constants.TYPE_NAMES[by].toUpperCase();
        }
        if (type.toString().equals("java.lang.String")) {
            return "Type.STRING";
        }
        if (type.toString().equals("java.lang.Object")) {
            return "Type.OBJECT";
        }
        if (type.toString().equals("java.lang.StringBuffer")) {
            return "Type.STRINGBUFFER";
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return "new ArrayType(" + BCELifier.printType(arrayType.getBasicType()) + ", " + arrayType.getDimensions() + ")";
        }
        return "new ObjectType(\"" + Utility.signatureToString(string, false) + "\")";
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        JavaClass javaClass = Repository.lookupClass(string);
        if (javaClass == null) {
            javaClass = new ClassParser(string).parse();
        }
        BCELifier bCELifier = new BCELifier(javaClass, System.out);
        bCELifier.start();
    }
}

