/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.Repository;

public class ClassLoaderRepository
implements Repository {
    private ClassLoader loader;
    private HashMap loadedClasses = new HashMap();

    public ClassLoaderRepository(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public void storeClass(JavaClass javaClass) {
        this.loadedClasses.put(javaClass.getClassName(), javaClass);
        javaClass.setRepository(this);
    }

    public void removeClass(JavaClass javaClass) {
        this.loadedClasses.remove(javaClass.getClassName());
    }

    public JavaClass findClass(String string) {
        if (this.loadedClasses.containsKey(string)) {
            return (JavaClass)this.loadedClasses.get(string);
        }
        return null;
    }

    public JavaClass loadClass(String string) throws ClassNotFoundException {
        String string2 = string.replace('.', '/');
        JavaClass javaClass = this.findClass(string);
        if (javaClass != null) {
            return javaClass;
        }
        try {
            InputStream inputStream = this.loader.getResourceAsStream(string2 + ".class");
            if (inputStream == null) {
                throw new ClassNotFoundException(string + " not found.");
            }
            ClassParser classParser = new ClassParser(inputStream, string);
            javaClass = classParser.parse();
            this.storeClass(javaClass);
            return javaClass;
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(iOException.toString());
        }
    }

    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        return this.loadClass(clazz.getName());
    }

    public void clear() {
        this.loadedClasses.clear();
    }
}

