/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;

public class Hex
implements BinaryEncoder,
BinaryDecoder {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] decodeHex(char[] cArray) throws DecoderException {
        int n = cArray.length;
        if ((n & 1) != 0) {
            throw new DecoderException("Odd number of characters.");
        }
        byte[] byArray = new byte[n >> 1];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = Hex.toDigit(cArray[n3], n3) << 4;
            n4 |= Hex.toDigit(cArray[++n3], n3);
            ++n3;
            byArray[n2] = (byte)(n4 & 0xFF);
            ++n2;
        }
        return byArray;
    }

    protected static int toDigit(char c, int n) throws DecoderException {
        int n2 = Character.digit(c, 16);
        if (n2 == -1) {
            throw new DecoderException("Illegal hexadecimal charcter " + c + " at index " + n);
        }
        return n2;
    }

    public static char[] encodeHex(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n << 1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            cArray[n2++] = DIGITS[(0xF0 & byArray[i]) >>> 4];
            cArray[n2++] = DIGITS[0xF & byArray[i]];
        }
        return cArray;
    }

    public byte[] decode(byte[] byArray) throws DecoderException {
        return Hex.decodeHex(new String(byArray).toCharArray());
    }

    public Object decode(Object object) throws DecoderException {
        try {
            char[] cArray = object instanceof String ? ((String)object).toCharArray() : (char[])object;
            return Hex.decodeHex(cArray);
        }
        catch (ClassCastException classCastException) {
            throw new DecoderException(classCastException.getMessage());
        }
    }

    public byte[] encode(byte[] byArray) {
        return new String(Hex.encodeHex(byArray)).getBytes();
    }

    public Object encode(Object object) throws EncoderException {
        try {
            byte[] byArray = object instanceof String ? ((String)object).getBytes() : (byte[])object;
            return Hex.encodeHex(byArray);
        }
        catch (ClassCastException classCastException) {
            throw new EncoderException(classCastException.getMessage());
        }
    }
}

