/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.discovery.Resource;
import org.apache.commons.discovery.log.DiscoveryLogFactory;
import org.apache.commons.logging.Log;

public class ResourceClass
extends Resource {
    private static Log log = DiscoveryLogFactory.newLog(ResourceClass.class);
    protected Class resourceClass;

    public static void setLog(Log log) {
        ResourceClass.log = log;
    }

    public ResourceClass(Class clazz, URL uRL) {
        super(clazz.getName(), uRL, clazz.getClassLoader());
        this.resourceClass = clazz;
    }

    public ResourceClass(String string, URL uRL, ClassLoader classLoader) {
        super(string, uRL, classLoader);
    }

    public Class loadClass() {
        if (this.resourceClass == null && this.getClassLoader() != null) {
            if (log.isDebugEnabled()) {
                log.debug("loadClass: Loading class '" + this.getName() + "' with " + this.getClassLoader());
            }
            this.resourceClass = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return ResourceClass.this.getClassLoader().loadClass(ResourceClass.this.getName());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return null;
                    }
                }
            });
        }
        return this.resourceClass;
    }

    public String toString() {
        return "ResourceClass[" + this.getName() + ", " + this.getResource() + ", " + this.getClassLoader() + "]";
    }
}

