/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.resource.names;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.commons.discovery.ResourceNameDiscover;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.log.DiscoveryLogFactory;
import org.apache.commons.discovery.resource.names.ResourceNameDiscoverImpl;
import org.apache.commons.logging.Log;

public class DiscoverNamesInDictionary
extends ResourceNameDiscoverImpl
implements ResourceNameDiscover {
    private static Log log = DiscoveryLogFactory.newLog(DiscoverNamesInDictionary.class);
    private Dictionary dictionary;

    public static void setLog(Log log) {
        DiscoverNamesInDictionary.log = log;
    }

    public DiscoverNamesInDictionary() {
        this.setDictionary(new Hashtable());
    }

    public DiscoverNamesInDictionary(Dictionary dictionary) {
        this.setDictionary(dictionary);
    }

    protected Dictionary getDictionary() {
        return this.dictionary;
    }

    public void setDictionary(Dictionary dictionary) {
        this.dictionary = dictionary;
    }

    public void addResource(String string, String string2) {
        this.dictionary.put(string, string2);
    }

    public void addResource(String string, String[] stringArray) {
        this.dictionary.put(string, stringArray);
    }

    public ResourceNameIterator findResourceNames(String string) {
        Object v;
        if (log.isDebugEnabled()) {
            log.debug("find: resourceName='" + string + "'");
        }
        final String[] stringArray = (v = this.dictionary.get(string)) instanceof String ? new String[]{(String)v} : (v instanceof String[] ? (String[])v : null);
        return new ResourceNameIterator(){
            private int idx = 0;

            public boolean hasNext() {
                if (stringArray != null) {
                    while (this.idx < stringArray.length && stringArray[this.idx] == null) {
                        ++this.idx;
                    }
                    return this.idx < stringArray.length;
                }
                return false;
            }

            public String nextResourceName() {
                return this.hasNext() ? stringArray[this.idx++] : null;
            }
        };
    }
}

