/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.resource.names;

import java.util.Vector;
import org.apache.commons.discovery.ResourceNameDiscover;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.log.DiscoveryLogFactory;
import org.apache.commons.discovery.resource.names.ResourceNameDiscoverImpl;
import org.apache.commons.logging.Log;

public class NameDiscoverers
extends ResourceNameDiscoverImpl
implements ResourceNameDiscover {
    private static Log log = DiscoveryLogFactory.newLog(NameDiscoverers.class);
    private Vector discoverers = new Vector();

    public static void setLog(Log log) {
        NameDiscoverers.log = log;
    }

    public void addResourceNameDiscover(ResourceNameDiscover resourceNameDiscover) {
        if (resourceNameDiscover != null) {
            this.discoverers.addElement(resourceNameDiscover);
        }
    }

    protected ResourceNameDiscover getResourceNameDiscover(int n) {
        return (ResourceNameDiscover)this.discoverers.get(n);
    }

    protected int size() {
        return this.discoverers.size();
    }

    public ResourceNameIterator findResourceNames(final String string) {
        if (log.isDebugEnabled()) {
            log.debug("find: resourceName='" + string + "'");
        }
        return new ResourceNameIterator(){
            private int idx = 0;
            private ResourceNameIterator iterator = null;

            public boolean hasNext() {
                if (this.iterator == null || !this.iterator.hasNext()) {
                    this.iterator = this.getNextIterator();
                    if (this.iterator == null) {
                        return false;
                    }
                }
                return this.iterator.hasNext();
            }

            public String nextResourceName() {
                return this.iterator.nextResourceName();
            }

            private ResourceNameIterator getNextIterator() {
                while (this.idx < NameDiscoverers.this.size()) {
                    ResourceNameIterator resourceNameIterator;
                    if (!(resourceNameIterator = NameDiscoverers.this.getResourceNameDiscover(this.idx++).findResourceNames(string)).hasNext()) continue;
                    return resourceNameIterator;
                }
                return null;
            }
        };
    }
}

