/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.tools;

import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.discovery.DiscoveryException;
import org.apache.commons.discovery.jdk.JDKHooks;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.tools.DefaultClassHolder;
import org.apache.commons.discovery.tools.DiscoverClass;
import org.apache.commons.discovery.tools.EnvironmentCache;
import org.apache.commons.discovery.tools.PropertiesHolder;
import org.apache.commons.discovery.tools.SPInterface;

public class DiscoverSingleton {
    public static Object find(Class clazz) throws DiscoveryException {
        return DiscoverSingleton.find(null, new SPInterface(clazz), DiscoverClass.nullProperties, DiscoverClass.nullDefaultImpl);
    }

    public static Object find(Class clazz, Properties properties) throws DiscoveryException {
        return DiscoverSingleton.find(null, new SPInterface(clazz), new PropertiesHolder(properties), DiscoverClass.nullDefaultImpl);
    }

    public static Object find(Class clazz, String string) throws DiscoveryException {
        return DiscoverSingleton.find(null, new SPInterface(clazz), DiscoverClass.nullProperties, new DefaultClassHolder(string));
    }

    public static Object find(Class clazz, Properties properties, String string) throws DiscoveryException {
        return DiscoverSingleton.find(null, new SPInterface(clazz), new PropertiesHolder(properties), new DefaultClassHolder(string));
    }

    public static Object find(Class clazz, String string, String string2) throws DiscoveryException {
        return DiscoverSingleton.find(null, new SPInterface(clazz), new PropertiesHolder(string), new DefaultClassHolder(string2));
    }

    public static Object find(ClassLoaders classLoaders, SPInterface sPInterface, PropertiesHolder propertiesHolder, DefaultClassHolder defaultClassHolder) throws DiscoveryException {
        ClassLoader classLoader = JDKHooks.getJDKHooks().getThreadContextClassLoader();
        Object object = DiscoverSingleton.get(classLoader, sPInterface.getSPName());
        if (object == null) {
            try {
                object = DiscoverClass.newInstance(classLoaders, sPInterface, propertiesHolder, defaultClassHolder);
                if (object != null) {
                    DiscoverSingleton.put(classLoader, sPInterface.getSPName(), object);
                }
            }
            catch (DiscoveryException discoveryException) {
                throw discoveryException;
            }
            catch (Exception exception) {
                throw new DiscoveryException("Unable to instantiate implementation class for " + sPInterface.getSPName(), exception);
            }
        }
        return object;
    }

    public static synchronized void release() {
        EnvironmentCache.release();
    }

    public static synchronized void release(Class clazz) {
        HashMap hashMap = (HashMap)EnvironmentCache.get(JDKHooks.getJDKHooks().getThreadContextClassLoader());
        if (hashMap != null) {
            hashMap.remove(clazz.getName());
        }
    }

    private static synchronized Object get(ClassLoader classLoader, String string) {
        HashMap hashMap = (HashMap)EnvironmentCache.get(classLoader);
        return hashMap != null ? hashMap.get(string) : null;
    }

    private static synchronized void put(ClassLoader classLoader, String string, Object object) {
        if (object != null) {
            HashMap<String, Object> hashMap = (HashMap<String, Object>)EnvironmentCache.get(classLoader);
            if (hashMap == null) {
                hashMap = new HashMap<String, Object>(13);
                EnvironmentCache.put(classLoader, hashMap);
            }
            hashMap.put(string, object);
        }
    }
}

