/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import org.apache.commons.logging.Log;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public final class Log4JCategoryLog
implements Log {
    private static final String FQCN = Log4JCategoryLog.class.getName();
    private Category category = null;

    public Log4JCategoryLog() {
    }

    public Log4JCategoryLog(String string) {
        this.category = Category.getInstance(string);
    }

    public Log4JCategoryLog(Category category) {
        this.category = category;
    }

    public void trace(Object object) {
        this.category.log(FQCN, Priority.DEBUG, object, null);
    }

    public void trace(Object object, Throwable throwable) {
        this.category.log(FQCN, Priority.DEBUG, object, throwable);
    }

    public void debug(Object object) {
        this.category.log(FQCN, Priority.DEBUG, object, null);
    }

    public void debug(Object object, Throwable throwable) {
        this.category.log(FQCN, Priority.DEBUG, object, throwable);
    }

    public void info(Object object) {
        this.category.log(FQCN, Priority.INFO, object, null);
    }

    public void info(Object object, Throwable throwable) {
        this.category.log(FQCN, Priority.INFO, object, throwable);
    }

    public void warn(Object object) {
        this.category.log(FQCN, Priority.WARN, object, null);
    }

    public void warn(Object object, Throwable throwable) {
        this.category.log(FQCN, Priority.WARN, object, throwable);
    }

    public void error(Object object) {
        this.category.log(FQCN, Priority.ERROR, object, null);
    }

    public void error(Object object, Throwable throwable) {
        this.category.log(FQCN, Priority.ERROR, object, throwable);
    }

    public void fatal(Object object) {
        this.category.log(FQCN, Priority.FATAL, object, null);
    }

    public void fatal(Object object, Throwable throwable) {
        this.category.log(FQCN, Priority.FATAL, object, throwable);
    }

    public Category getCategory() {
        return this.category;
    }

    public boolean isDebugEnabled() {
        return this.category.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.category.isEnabledFor(Priority.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.category.isEnabledFor(Priority.FATAL);
    }

    public boolean isInfoEnabled() {
        return this.category.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.category.isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        return this.category.isEnabledFor(Priority.WARN);
    }
}

