/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4JLogger
implements Log,
Serializable {
    private static final String FQCN = Log4JLogger.class.getName();
    private static final boolean is12 = Priority.class.isAssignableFrom(Level.class);
    private transient Logger logger = null;
    private String name = null;

    public Log4JLogger() {
    }

    public Log4JLogger(String string) {
        this.name = string;
        this.logger = this.getLogger();
    }

    public Log4JLogger(Logger logger2) {
        this.name = logger2.getName();
        this.logger = logger2;
    }

    public void trace(Object object) {
        if (is12) {
            this.getLogger().log(FQCN, Level.DEBUG, object, null);
        } else {
            this.getLogger().log(FQCN, Level.DEBUG, object, null);
        }
    }

    public void trace(Object object, Throwable throwable) {
        if (is12) {
            this.getLogger().log(FQCN, Level.DEBUG, object, throwable);
        } else {
            this.getLogger().log(FQCN, Level.DEBUG, object, throwable);
        }
    }

    public void debug(Object object) {
        if (is12) {
            this.getLogger().log(FQCN, Level.DEBUG, object, null);
        } else {
            this.getLogger().log(FQCN, Level.DEBUG, object, null);
        }
    }

    public void debug(Object object, Throwable throwable) {
        if (is12) {
            this.getLogger().log(FQCN, Level.DEBUG, object, throwable);
        } else {
            this.getLogger().log(FQCN, Level.DEBUG, object, throwable);
        }
    }

    public void info(Object object) {
        if (is12) {
            this.getLogger().log(FQCN, Level.INFO, object, null);
        } else {
            this.getLogger().log(FQCN, Level.INFO, object, null);
        }
    }

    public void info(Object object, Throwable throwable) {
        if (is12) {
            this.getLogger().log(FQCN, Level.INFO, object, throwable);
        } else {
            this.getLogger().log(FQCN, Level.INFO, object, throwable);
        }
    }

    public void warn(Object object) {
        if (is12) {
            this.getLogger().log(FQCN, Level.WARN, object, null);
        } else {
            this.getLogger().log(FQCN, Level.WARN, object, null);
        }
    }

    public void warn(Object object, Throwable throwable) {
        if (is12) {
            this.getLogger().log(FQCN, Level.WARN, object, throwable);
        } else {
            this.getLogger().log(FQCN, Level.WARN, object, throwable);
        }
    }

    public void error(Object object) {
        if (is12) {
            this.getLogger().log(FQCN, Level.ERROR, object, null);
        } else {
            this.getLogger().log(FQCN, Level.ERROR, object, null);
        }
    }

    public void error(Object object, Throwable throwable) {
        if (is12) {
            this.getLogger().log(FQCN, Level.ERROR, object, throwable);
        } else {
            this.getLogger().log(FQCN, Level.ERROR, object, throwable);
        }
    }

    public void fatal(Object object) {
        if (is12) {
            this.getLogger().log(FQCN, Level.FATAL, object, null);
        } else {
            this.getLogger().log(FQCN, Level.FATAL, object, null);
        }
    }

    public void fatal(Object object, Throwable throwable) {
        if (is12) {
            this.getLogger().log(FQCN, Level.FATAL, object, throwable);
        } else {
            this.getLogger().log(FQCN, Level.FATAL, object, throwable);
        }
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.name);
        }
        return this.logger;
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        if (is12) {
            return this.getLogger().isEnabledFor(Level.ERROR);
        }
        return this.getLogger().isEnabledFor(Level.ERROR);
    }

    public boolean isFatalEnabled() {
        if (is12) {
            return this.getLogger().isEnabledFor(Level.FATAL);
        }
        return this.getLogger().isEnabledFor(Level.FATAL);
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        if (is12) {
            return this.getLogger().isEnabledFor(Level.WARN);
        }
        return this.getLogger().isEnabledFor(Level.WARN);
    }
}

