/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import java.io.Serializable;
import java.util.Hashtable;

public final class ContextMap
implements Serializable {
    private static final ThreadLocal c_localContext = new InheritableThreadLocal();
    private final ContextMap m_parent;
    private Hashtable m_map = new Hashtable();
    private transient boolean m_readOnly;

    public static final ContextMap getCurrentContext() {
        return ContextMap.getCurrentContext(true);
    }

    public static final ContextMap getCurrentContext(boolean bl) {
        ContextMap contextMap = (ContextMap)c_localContext.get();
        if (null == contextMap && bl) {
            contextMap = new ContextMap();
            c_localContext.set(contextMap);
        }
        return contextMap;
    }

    public static final void bind(ContextMap contextMap) {
        c_localContext.set(contextMap);
    }

    public ContextMap() {
        this(null);
    }

    public ContextMap(ContextMap contextMap) {
        this.m_parent = contextMap;
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public void clear() {
        this.checkReadable();
        this.m_map.clear();
    }

    public Object get(String string, Object object) {
        Object object2 = this.get(string);
        if (null != object2) {
            return object2;
        }
        return object;
    }

    public Object get(String string) {
        if (string == null) {
            return null;
        }
        Object v = this.m_map.get(string);
        if (null == v && null != this.m_parent) {
            return this.m_parent.get(string);
        }
        return v;
    }

    public void set(String string, Object object) {
        this.checkReadable();
        if (object == null) {
            this.m_map.remove(string);
        } else {
            this.m_map.put(string, object);
        }
    }

    public int getSize() {
        return this.m_map.size();
    }

    private Object readResolve() {
        this.makeReadOnly();
        return this;
    }

    private void checkReadable() {
        if (this.isReadOnly()) {
            throw new IllegalStateException("ContextMap is read only and can not be modified");
        }
    }
}

