/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import org.apache.log.ContextMap;
import org.apache.log.ErrorAware;
import org.apache.log.ErrorHandler;
import org.apache.log.LogEvent;
import org.apache.log.LogTarget;
import org.apache.log.Priority;
import org.apache.log.util.LoggerListener;

public class Logger {
    private static final Logger[] EMPTY_SET = new Logger[0];
    public static final char CATEGORY_SEPARATOR = '.';
    private final ErrorHandler m_errorHandler;
    private final LoggerListener m_loggerListener;
    private final Logger m_parent;
    private final String m_category;
    private Logger[] m_children;
    private LogTarget[] m_logTargets;
    private boolean m_logTargetsForceSet;
    private Priority m_priority;
    private boolean m_priorityForceSet;
    private boolean m_additivity;

    Logger(ErrorHandler errorHandler, LoggerListener loggerListener, String string, LogTarget[] logTargetArray, Logger logger2) {
        this.m_errorHandler = errorHandler;
        this.m_loggerListener = loggerListener;
        this.m_category = string;
        this.m_logTargets = logTargetArray;
        this.m_parent = logger2;
        if (null == this.m_logTargets) {
            this.unsetLogTargets();
        }
        this.unsetPriority();
    }

    public final boolean isDebugEnabled() {
        return this.m_priority.isLowerOrEqual(Priority.DEBUG);
    }

    public final void debug(String string, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.output(Priority.DEBUG, string, throwable);
        }
    }

    public final void debug(String string) {
        if (this.isDebugEnabled()) {
            this.output(Priority.DEBUG, string, null);
        }
    }

    public final boolean isInfoEnabled() {
        return this.m_priority.isLowerOrEqual(Priority.INFO);
    }

    public final void info(String string, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.output(Priority.INFO, string, throwable);
        }
    }

    public final void info(String string) {
        if (this.isInfoEnabled()) {
            this.output(Priority.INFO, string, null);
        }
    }

    public final boolean isWarnEnabled() {
        return this.m_priority.isLowerOrEqual(Priority.WARN);
    }

    public final void warn(String string, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.output(Priority.WARN, string, throwable);
        }
    }

    public final void warn(String string) {
        if (this.isWarnEnabled()) {
            this.output(Priority.WARN, string, null);
        }
    }

    public final boolean isErrorEnabled() {
        return this.m_priority.isLowerOrEqual(Priority.ERROR);
    }

    public final void error(String string, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.output(Priority.ERROR, string, throwable);
        }
    }

    public final void error(String string) {
        if (this.isErrorEnabled()) {
            this.output(Priority.ERROR, string, null);
        }
    }

    public final boolean isFatalErrorEnabled() {
        return this.m_priority.isLowerOrEqual(Priority.FATAL_ERROR);
    }

    public final void fatalError(String string, Throwable throwable) {
        if (this.isFatalErrorEnabled()) {
            this.output(Priority.FATAL_ERROR, string, throwable);
        }
    }

    public final void fatalError(String string) {
        if (this.isFatalErrorEnabled()) {
            this.output(Priority.FATAL_ERROR, string, null);
        }
    }

    public final void setAdditivity(boolean bl) {
        this.m_additivity = bl;
    }

    public final boolean isPriorityEnabled(Priority priority) {
        return this.m_priority.isLowerOrEqual(priority);
    }

    public final void log(Priority priority, String string, Throwable throwable) {
        if (this.m_priority.isLowerOrEqual(priority)) {
            this.output(priority, string, throwable);
        }
    }

    public final void log(Priority priority, String string) {
        if (this.m_priority.isLowerOrEqual(priority)) {
            this.log(priority, string, null);
        }
    }

    public synchronized void setPriority(Priority priority) {
        this.m_priority = priority;
        this.m_priorityForceSet = true;
        this.resetChildPriorities(false);
    }

    public synchronized void unsetPriority() {
        this.unsetPriority(false);
    }

    public synchronized void unsetPriority(boolean bl) {
        this.m_priority = null != this.m_parent ? this.m_parent.m_priority : Priority.DEBUG;
        this.m_priorityForceSet = false;
        this.resetChildPriorities(bl);
    }

    public synchronized void setLogTargets(LogTarget[] logTargetArray) {
        if (null != logTargetArray) {
            for (int i = 0; i < logTargetArray.length; ++i) {
                if (null != logTargetArray[i]) continue;
                String string = "logTargets[ " + i + " ]";
                throw new NullPointerException(string);
            }
        }
        this.m_logTargets = logTargetArray;
        this.setupErrorHandlers();
        this.m_logTargetsForceSet = true;
        this.resetChildLogTargets(false);
    }

    public synchronized void unsetLogTargets() {
        this.unsetLogTargets(false);
    }

    public synchronized void unsetLogTargets(boolean bl) {
        this.m_logTargets = null != this.m_parent ? this.m_parent.safeGetLogTargets() : null;
        this.m_logTargetsForceSet = false;
        this.resetChildLogTargets(bl);
    }

    public synchronized Logger[] getChildren() {
        if (null == this.m_children) {
            return EMPTY_SET;
        }
        Logger[] loggerArray = new Logger[this.m_children.length];
        for (int i = 0; i < loggerArray.length; ++i) {
            loggerArray[i] = this.m_children[i];
        }
        return loggerArray;
    }

    public synchronized Logger getChildLogger(String string) throws IllegalArgumentException {
        int n = string.indexOf(46);
        String string2 = null;
        String string3 = null;
        if (-1 == n) {
            string2 = string;
        } else {
            if (n == 0) {
                throw new IllegalArgumentException("Logger categories MUST not have empty elements");
            }
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        String string4 = null;
        string4 = this.m_category.equals("") ? string2 : this.m_category + '.' + string2;
        if (null != this.m_children) {
            for (int i = 0; i < this.m_children.length; ++i) {
                if (!this.m_children[i].m_category.equals(string4)) continue;
                if (null == string3) {
                    return this.m_children[i];
                }
                return this.m_children[i].getChildLogger(string3);
            }
        }
        Logger logger2 = new Logger(this.m_errorHandler, this.m_loggerListener, string4, null, this);
        if (this.m_additivity) {
            logger2.setAdditivity(true);
        }
        this.m_loggerListener.loggerCreated(logger2.m_category, logger2);
        if (null == this.m_children) {
            this.m_children = new Logger[]{logger2};
        } else {
            Logger[] loggerArray = new Logger[this.m_children.length + 1];
            System.arraycopy(this.m_children, 0, loggerArray, 0, this.m_children.length);
            loggerArray[this.m_children.length] = logger2;
            this.m_children = loggerArray;
        }
        if (null == string3) {
            return logger2;
        }
        return logger2.getChildLogger(string3);
    }

    private final void output(Priority priority, String string, Throwable throwable) {
        LogEvent logEvent = new LogEvent();
        logEvent.setCategory(this.m_category);
        logEvent.setContextMap(ContextMap.getCurrentContext(false));
        if (null != string) {
            logEvent.setMessage(string);
        } else {
            logEvent.setMessage("");
        }
        logEvent.setThrowable(throwable);
        logEvent.setPriority(priority);
        logEvent.setTime(System.currentTimeMillis());
        this.output(logEvent);
    }

    private final void output(LogEvent logEvent) {
        LogTarget[] logTargetArray = this.m_logTargets;
        if (null == logTargetArray) {
            String string = "LogTarget is null for category '" + this.m_category + "'";
            this.m_errorHandler.error(string, null, logEvent);
        } else if (!this.m_additivity) {
            this.fireEvent(logEvent, logTargetArray);
        } else {
            if (this.m_logTargetsForceSet) {
                this.fireEvent(logEvent, logTargetArray);
            }
            if (null != this.m_parent) {
                this.m_parent.output(logEvent);
            }
        }
    }

    private final void fireEvent(LogEvent logEvent, LogTarget[] logTargetArray) {
        for (int i = 0; i < logTargetArray.length; ++i) {
            logTargetArray[i].processEvent(logEvent);
        }
    }

    private synchronized void resetChildPriorities(boolean bl) {
        if (null == this.m_children) {
            return;
        }
        Logger[] loggerArray = this.m_children;
        for (int i = 0; i < loggerArray.length; ++i) {
            loggerArray[i].resetPriority(bl);
        }
    }

    private synchronized void resetPriority(boolean bl) {
        if (bl) {
            this.m_priorityForceSet = false;
        } else if (this.m_priorityForceSet) {
            return;
        }
        this.m_priority = this.m_parent.m_priority;
        this.resetChildPriorities(bl);
    }

    private synchronized LogTarget[] safeGetLogTargets() {
        if (null == this.m_logTargets) {
            if (null == this.m_parent) {
                return new LogTarget[0];
            }
            return this.m_parent.safeGetLogTargets();
        }
        LogTarget[] logTargetArray = new LogTarget[this.m_logTargets.length];
        for (int i = 0; i < logTargetArray.length; ++i) {
            logTargetArray[i] = this.m_logTargets[i];
        }
        return logTargetArray;
    }

    private synchronized void resetChildLogTargets(boolean bl) {
        if (null == this.m_children) {
            return;
        }
        for (int i = 0; i < this.m_children.length; ++i) {
            this.m_children[i].resetLogTargets(bl);
        }
    }

    private synchronized void setupErrorHandlers() {
        if (null == this.m_logTargets) {
            return;
        }
        for (int i = 0; i < this.m_logTargets.length; ++i) {
            LogTarget logTarget = this.m_logTargets[i];
            if (!(logTarget instanceof ErrorAware)) continue;
            ((ErrorAware)((Object)logTarget)).setErrorHandler(this.m_errorHandler);
        }
    }

    private synchronized void resetLogTargets(boolean bl) {
        if (bl) {
            this.m_logTargetsForceSet = false;
        } else if (this.m_logTargetsForceSet) {
            return;
        }
        this.m_logTargets = this.m_parent.safeGetLogTargets();
        this.resetChildLogTargets(bl);
    }
}

