/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.format;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Stack;
import org.apache.log.ContextMap;
import org.apache.log.LogEvent;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;

public class PatternFormatter
implements Formatter {
    private static final int TYPE_TEXT = 1;
    private static final int TYPE_CATEGORY = 2;
    private static final int TYPE_CONTEXT = 3;
    private static final int TYPE_MESSAGE = 4;
    private static final int TYPE_TIME = 5;
    private static final int TYPE_RELATIVE_TIME = 6;
    private static final int TYPE_THROWABLE = 7;
    private static final int TYPE_PRIORITY = 8;
    private static final int TYPE_THREAD = 9;
    protected static final int MAX_TYPE = 8;
    private static final String TYPE_CATEGORY_STR = "category";
    private static final String TYPE_CONTEXT_STR = "context";
    private static final String TYPE_MESSAGE_STR = "message";
    private static final String TYPE_TIME_STR = "time";
    private static final String TYPE_RELATIVE_TIME_STR = "rtime";
    private static final String TYPE_THROWABLE_STR = "throwable";
    private static final String TYPE_PRIORITY_STR = "priority";
    private static final String TYPE_THREAD_STR = "thread";
    private static final String SPACE_16 = "                ";
    private static final String SPACE_8 = "        ";
    private static final String SPACE_4 = "    ";
    private static final String SPACE_2 = "  ";
    private static final String SPACE_1 = " ";
    private static final String EOL = System.getProperty("line.separator", "\n");
    private PatternRun[] m_formatSpecification;
    private SimpleDateFormat m_simpleDateFormat;
    private final Date m_date = new Date();

    public PatternFormatter(String string) {
        this.parse(string);
    }

    private int addPatternRun(Stack stack, char[] cArray, int n) {
        int n2;
        PatternRun patternRun = new PatternRun();
        int n3 = n++;
        if ('+' == cArray[n]) {
            ++n;
        } else if ('-' == cArray[n]) {
            patternRun.m_rightJustify = true;
            ++n;
        }
        if (Character.isDigit(cArray[n])) {
            n2 = 0;
            while (Character.isDigit(cArray[n])) {
                n2 = n2 * 10 + (cArray[n] - 48);
                ++n;
            }
            patternRun.m_minSize = n2;
        }
        if (n < cArray.length && '.' == cArray[n] && Character.isDigit(cArray[++n])) {
            n2 = 0;
            while (Character.isDigit(cArray[n])) {
                n2 = n2 * 10 + (cArray[n] - 48);
                ++n;
            }
            patternRun.m_maxSize = n2;
        }
        if (n >= cArray.length || '{' != cArray[n]) {
            throw new IllegalArgumentException("Badly formed pattern at character " + n);
        }
        n2 = n;
        while (n < cArray.length && cArray[n] != ':' && cArray[n] != '}') {
            ++n;
        }
        int n4 = n - 1;
        String string = new String(cArray, n2 + 1, n4 - n2);
        patternRun.m_type = this.getTypeIdFor(string);
        if (n < cArray.length && cArray[n] == ':') {
            ++n;
            while (n < cArray.length && cArray[n] != '}') {
                ++n;
            }
            int n5 = n - n4 - 2;
            if (0 != n5) {
                patternRun.m_format = new String(cArray, n4 + 2, n5);
            }
        }
        if (n >= cArray.length || '}' != cArray[n]) {
            throw new IllegalArgumentException("Unterminated type in pattern at character " + n);
        }
        stack.push(patternRun);
        return ++n - n3;
    }

    private int addTextRun(Stack stack, char[] cArray, int n) {
        PatternRun patternRun = new PatternRun();
        int n2 = n;
        boolean bl = false;
        if ('%' == cArray[n]) {
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n < cArray.length && cArray[n] != '%') {
            if (bl) {
                if ('n' == cArray[n]) {
                    stringBuffer.append(EOL);
                } else if ('t' == cArray[n]) {
                    stringBuffer.append('\t');
                } else {
                    stringBuffer.append(cArray[n]);
                }
                bl = false;
            } else if ('\\' == cArray[n]) {
                bl = true;
            } else {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        patternRun.m_data = stringBuffer.toString();
        patternRun.m_type = 1;
        stack.push(patternRun);
        return n - n2;
    }

    private void append(StringBuffer stringBuffer, int n, int n2, boolean bl, String string) {
        int n3 = string.length();
        if (n3 < n) {
            if (bl) {
                this.appendWhiteSpace(stringBuffer, n - n3);
                stringBuffer.append(string);
            } else {
                stringBuffer.append(string);
                this.appendWhiteSpace(stringBuffer, n - n3);
            }
        } else if (n2 > 0 && n2 < n3) {
            if (bl) {
                stringBuffer.append(string.substring(n3 - n2));
            } else {
                stringBuffer.append(string.substring(0, n2));
            }
        } else {
            stringBuffer.append(string);
        }
    }

    private void appendWhiteSpace(StringBuffer stringBuffer, int n) {
        while (n >= 16) {
            stringBuffer.append(SPACE_16);
            n -= 16;
        }
        if (n >= 8) {
            stringBuffer.append(SPACE_8);
            n -= 8;
        }
        if (n >= 4) {
            stringBuffer.append(SPACE_4);
            n -= 4;
        }
        if (n >= 2) {
            stringBuffer.append(SPACE_2);
            n -= 2;
        }
        if (n >= 1) {
            stringBuffer.append(SPACE_1);
            --n;
        }
    }

    public String format(LogEvent logEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_formatSpecification.length; ++i) {
            PatternRun patternRun = this.m_formatSpecification[i];
            if (patternRun.m_type == 1) {
                stringBuffer.append(patternRun.m_data);
                continue;
            }
            String string = this.formatPatternRun(logEvent, patternRun);
            if (null == string) continue;
            this.append(stringBuffer, patternRun.m_minSize, patternRun.m_maxSize, patternRun.m_rightJustify, string);
        }
        return stringBuffer.toString();
    }

    protected String formatPatternRun(LogEvent logEvent, PatternRun patternRun) {
        switch (patternRun.m_type) {
            case 6: {
                return this.getRTime(logEvent.getRelativeTime(), patternRun.m_format);
            }
            case 5: {
                return this.getTime(logEvent.getTime(), patternRun.m_format);
            }
            case 7: {
                return this.getStackTrace(logEvent.getThrowable(), patternRun.m_format);
            }
            case 4: {
                return this.getMessage(logEvent.getMessage(), patternRun.m_format);
            }
            case 2: {
                return this.getCategory(logEvent.getCategory(), patternRun.m_format);
            }
            case 8: {
                return this.getPriority(logEvent.getPriority(), patternRun.m_format);
            }
            case 3: {
                return this.getContextMap(logEvent.getContextMap(), patternRun.m_format);
            }
            case 9: {
                return this.getThread(patternRun.m_format);
            }
        }
        throw new IllegalStateException("Unknown Pattern specification." + patternRun.m_type);
    }

    protected String getCategory(String string, String string2) {
        return string;
    }

    protected String getPriority(Priority priority, String string) {
        return priority.getName();
    }

    protected String getThread(String string) {
        return Thread.currentThread().getName();
    }

    protected String getContextMap(ContextMap contextMap, String string) {
        if (null == contextMap) {
            return "";
        }
        return contextMap.get(string, "").toString();
    }

    protected String getMessage(String string, String string2) {
        return string;
    }

    protected String getStackTrace(Throwable throwable, String string) {
        if (null == throwable) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    protected String getRTime(long l, String string) {
        return this.getTime(l, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getTime(long l, String string) {
        if (null == string) {
            return Long.toString(l);
        }
        Date date = this.m_date;
        synchronized (date) {
            if (null == this.m_simpleDateFormat) {
                this.m_simpleDateFormat = new SimpleDateFormat(string);
            }
            this.m_date.setTime(l);
            return this.m_simpleDateFormat.format(this.m_date);
        }
    }

    protected int getTypeIdFor(String string) {
        if (string.equalsIgnoreCase(TYPE_CATEGORY_STR)) {
            return 2;
        }
        if (string.equalsIgnoreCase(TYPE_CONTEXT_STR)) {
            return 3;
        }
        if (string.equalsIgnoreCase(TYPE_MESSAGE_STR)) {
            return 4;
        }
        if (string.equalsIgnoreCase(TYPE_PRIORITY_STR)) {
            return 8;
        }
        if (string.equalsIgnoreCase(TYPE_TIME_STR)) {
            return 5;
        }
        if (string.equalsIgnoreCase(TYPE_RELATIVE_TIME_STR)) {
            return 6;
        }
        if (string.equalsIgnoreCase(TYPE_THREAD_STR)) {
            return 9;
        }
        if (string.equalsIgnoreCase(TYPE_THROWABLE_STR)) {
            return 7;
        }
        throw new IllegalArgumentException("Unknown Type in pattern - " + string);
    }

    protected final void parse(String string) {
        Stack stack = new Stack();
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        string.getChars(0, n, cArray, 0);
        while (n2 < n) {
            if (cArray[n2] == '%' && (n2 == n - 1 || cArray[n2 + 1] != '%')) {
                n2 += this.addPatternRun(stack, cArray, n2);
                continue;
            }
            n2 += this.addTextRun(stack, cArray, n2);
        }
        int n3 = stack.size();
        this.m_formatSpecification = new PatternRun[n3];
        for (int i = 0; i < n3; ++i) {
            this.m_formatSpecification[i] = (PatternRun)stack.elementAt(i);
        }
    }

    protected static class PatternRun {
        public String m_data;
        public boolean m_rightJustify;
        public int m_minSize;
        public int m_maxSize;
        public int m_type;
        public String m_format;

        protected PatternRun() {
        }
    }
}

