/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output;

import org.apache.log.ErrorAware;
import org.apache.log.ErrorHandler;
import org.apache.log.LogEvent;
import org.apache.log.LogTarget;
import org.apache.log.util.Closeable;
import org.apache.log.util.DefaultErrorHandler;

public abstract class AbstractTarget
implements LogTarget,
ErrorAware,
Closeable {
    private static final ErrorHandler DEFAULT_ERROR_HANDLER = new DefaultErrorHandler();
    private ErrorHandler m_errorHandler = DEFAULT_ERROR_HANDLER;
    private boolean m_isOpen;

    public AbstractTarget() {
    }

    public AbstractTarget(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new NullPointerException("errorHandler specified cannot be null");
        }
        this.setErrorHandler(errorHandler);
    }

    public synchronized void setErrorHandler(ErrorHandler errorHandler) {
        this.m_errorHandler = errorHandler;
    }

    protected synchronized boolean isOpen() {
        return this.m_isOpen;
    }

    protected synchronized void open() {
        if (!this.isOpen()) {
            this.m_isOpen = true;
        }
    }

    public synchronized void processEvent(LogEvent logEvent) {
        if (!this.isOpen()) {
            this.getErrorHandler().error("Writing event to closed stream.", null, logEvent);
            return;
        }
        try {
            this.doProcessEvent(logEvent);
        }
        catch (Throwable throwable) {
            this.getErrorHandler().error("Unknown error writing event.", throwable, logEvent);
        }
    }

    protected abstract void doProcessEvent(LogEvent var1) throws Exception;

    public synchronized void close() {
        if (this.isOpen()) {
            this.m_isOpen = false;
        }
    }

    protected final ErrorHandler getErrorHandler() {
        return this.m_errorHandler;
    }
}

