/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.apache.log.format.Formatter;
import org.apache.log.output.AbstractOutputTarget;

public class DatagramOutputTarget
extends AbstractOutputTarget {
    private static final String DEFAULT_ENCODING = "US-ASCII";
    private DatagramSocket m_socket = new DatagramSocket();
    private String m_encoding;

    public DatagramOutputTarget(InetAddress inetAddress, int n, Formatter formatter, String string) throws IOException {
        super(formatter);
        this.m_socket.connect(inetAddress, n);
        this.m_encoding = string;
        this.open();
    }

    public DatagramOutputTarget(InetAddress inetAddress, int n, Formatter formatter) throws IOException {
        this(inetAddress, n, formatter, DEFAULT_ENCODING);
    }

    public DatagramOutputTarget(InetAddress inetAddress, int n) throws IOException {
        this(inetAddress, n, null);
    }

    protected void write(String string) {
        try {
            byte[] byArray = string.getBytes(this.m_encoding);
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            this.m_socket.send(datagramPacket);
        }
        catch (IOException iOException) {
            this.getErrorHandler().error("Error sending datagram.", iOException, null);
        }
    }

    public synchronized void close() {
        super.close();
        this.m_socket = null;
    }
}

