/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.net;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.log.LogEvent;
import org.apache.log.output.AbstractOutputTarget;

public class SocketOutputTarget
extends AbstractOutputTarget {
    private Socket m_socket;
    private ObjectOutputStream m_outputStream;

    public SocketOutputTarget(InetAddress inetAddress, int n) throws IOException {
        this.m_socket = new Socket(inetAddress, n);
        this.m_outputStream = new ObjectOutputStream(this.m_socket.getOutputStream());
    }

    public SocketOutputTarget(String string, int n) throws IOException {
        this.m_socket = new Socket(string, n);
        this.m_outputStream = new ObjectOutputStream(this.m_socket.getOutputStream());
    }

    protected void write(LogEvent logEvent) {
        try {
            this.m_outputStream.writeObject(logEvent);
        }
        catch (IOException iOException) {
            this.getErrorHandler().error("Error writting to socket", iOException, null);
        }
    }

    protected void doProcessEvent(LogEvent logEvent) {
        this.write(logEvent);
    }

    public synchronized void close() {
        super.close();
        this.m_socket = null;
    }
}

