/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.XSLTVisitor;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.serializer.SerializationHandler;
import org.apache.xpath.Expression;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.xml.sax.SAXException;

public class ElemValueOf
extends ElemTemplateElement {
    static final long serialVersionUID = 3490728458007586786L;
    private XPath m_selectExpression = null;
    private boolean m_isDot = false;
    private boolean m_disableOutputEscaping = false;

    public void setSelect(XPath xPath) {
        if (null != xPath) {
            String string = xPath.getPatternString();
            this.m_isDot = null != string && string.equals(".");
        }
        this.m_selectExpression = xPath;
    }

    public XPath getSelect() {
        return this.m_selectExpression;
    }

    public void setDisableOutputEscaping(boolean bl) {
        this.m_disableOutputEscaping = bl;
    }

    public boolean getDisableOutputEscaping() {
        return this.m_disableOutputEscaping;
    }

    public int getXSLToken() {
        return 30;
    }

    public void compose(StylesheetRoot stylesheetRoot) throws TransformerException {
        super.compose(stylesheetRoot);
        Vector vector = stylesheetRoot.getComposeState().getVariableNames();
        if (null != this.m_selectExpression) {
            this.m_selectExpression.fixupVariables(vector, stylesheetRoot.getComposeState().getGlobalsSize());
        }
    }

    public String getNodeName() {
        return "value-of";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(TransformerImpl transformerImpl) throws TransformerException {
        XPathContext xPathContext = transformerImpl.getXPathContext();
        SerializationHandler serializationHandler = transformerImpl.getResultTreeHandler();
        if (transformerImpl.getDebug()) {
            transformerImpl.getTraceManager().fireTraceEvent(this);
        }
        try {
            xPathContext.pushNamespaceContext(this);
            int n = xPathContext.getCurrentNode();
            xPathContext.pushCurrentNodeAndExpression(n, n);
            if (this.m_disableOutputEscaping) {
                serializationHandler.processingInstruction("javax.xml.transform.disable-output-escaping", "");
            }
            try {
                Expression expression = this.m_selectExpression.getExpression();
                if (transformerImpl.getDebug()) {
                    XObject xObject = expression.execute(xPathContext);
                    transformerImpl.getTraceManager().fireSelectedEvent(n, this, "select", this.m_selectExpression, xObject);
                    xObject.dispatchCharactersEvents(serializationHandler);
                } else {
                    expression.executeCharsToContentHandler(xPathContext, serializationHandler);
                }
            }
            finally {
                if (this.m_disableOutputEscaping) {
                    serializationHandler.processingInstruction("javax.xml.transform.enable-output-escaping", "");
                }
                xPathContext.popNamespaceContext();
                xPathContext.popCurrentNodeAndExpression();
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
        catch (RuntimeException runtimeException) {
            TransformerException transformerException = new TransformerException(runtimeException);
            transformerException.setLocator(this);
            throw transformerException;
        }
        finally {
            if (transformerImpl.getDebug()) {
                transformerImpl.getTraceManager().fireTraceEndEvent(this);
            }
        }
    }

    public ElemTemplateElement appendChild(ElemTemplateElement elemTemplateElement) {
        this.error("ER_CANNOT_ADD", new Object[]{elemTemplateElement.getNodeName(), this.getNodeName()});
        return null;
    }

    protected void callChildVisitors(XSLTVisitor xSLTVisitor, boolean bl) {
        if (bl) {
            this.m_selectExpression.getExpression().callVisitors(this.m_selectExpression, xSLTVisitor);
        }
        super.callChildVisitors(xSLTVisitor, bl);
    }
}

