/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Vector;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.CastExpr;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.FunctionCall;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;

final class ConcatCall
extends FunctionCall {
    public ConcatCall(QName qName, Vector vector) {
        super(qName, vector);
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        for (int i = 0; i < this.argumentCount(); ++i) {
            Expression expression = this.argument(i);
            if (expression.typeCheck(symbolTable).identicalTo(Type.String)) continue;
            this.setArgument(i, new CastExpr(expression, Type.String));
        }
        this._type = Type.String;
        return this._type;
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        int n = this.argumentCount();
        switch (n) {
            case 0: {
                instructionList.append(new PUSH(constantPoolGen, ""));
                break;
            }
            case 1: {
                this.argument().translate(classGenerator, methodGenerator);
                break;
            }
            default: {
                int n2 = constantPoolGen.addMethodref("java.lang.StringBuffer", "<init>", "()V");
                INVOKEVIRTUAL iNVOKEVIRTUAL = new INVOKEVIRTUAL(constantPoolGen.addMethodref("java.lang.StringBuffer", "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;"));
                int n3 = constantPoolGen.addMethodref("java.lang.StringBuffer", "toString", "()Ljava/lang/String;");
                instructionList.append(new NEW(constantPoolGen.addClass("java.lang.StringBuffer")));
                instructionList.append(DUP);
                instructionList.append(new INVOKESPECIAL(n2));
                for (int i = 0; i < n; ++i) {
                    this.argument(i).translate(classGenerator, methodGenerator);
                    instructionList.append(iNVOKEVIRTUAL);
                }
                instructionList.append(new INVOKEVIRTUAL(n3));
            }
        }
    }
}

