/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class NamespaceMappings {
    private int count = 0;
    private Hashtable m_namespaces = new Hashtable();
    private Stack m_nodeStack = new Stack();
    private static final String EMPTYSTRING = "";
    private static final String XML_PREFIX = "xml";

    public NamespaceMappings() {
        this.initNamespaces();
    }

    private void initNamespaces() {
        Stack<MappingRecord> stack = new Stack<MappingRecord>();
        this.m_namespaces.put(EMPTYSTRING, stack);
        stack.push(new MappingRecord(EMPTYSTRING, EMPTYSTRING, 0));
        stack = new Stack();
        this.m_namespaces.put(XML_PREFIX, stack);
        stack.push(new MappingRecord(XML_PREFIX, "http://www.w3.org/XML/1998/namespace", 0));
        this.m_nodeStack.push(new MappingRecord(null, null, -1));
    }

    public String lookupNamespace(String string) {
        Stack stack = (Stack)this.m_namespaces.get(string);
        return stack != null && !stack.isEmpty() ? ((MappingRecord)stack.peek()).m_uri : null;
    }

    MappingRecord getMappingFromPrefix(String string) {
        Stack stack = (Stack)this.m_namespaces.get(string);
        return stack != null && !stack.isEmpty() ? (MappingRecord)stack.peek() : null;
    }

    public String lookupPrefix(String string) {
        String string2 = null;
        Enumeration enumeration = this.m_namespaces.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = this.lookupNamespace(string3);
            if (string4 == null || !string4.equals(string)) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    MappingRecord getMappingFromURI(String string) {
        MappingRecord mappingRecord = null;
        Enumeration enumeration = this.m_namespaces.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            MappingRecord mappingRecord2 = this.getMappingFromPrefix(string2);
            if (mappingRecord2 == null || !mappingRecord2.m_uri.equals(string)) continue;
            mappingRecord = mappingRecord2;
            break;
        }
        return mappingRecord;
    }

    boolean popNamespace(String string) {
        if (string.startsWith(XML_PREFIX)) {
            return false;
        }
        Stack stack = (Stack)this.m_namespaces.get(string);
        if (stack != null) {
            stack.pop();
            return true;
        }
        return false;
    }

    boolean pushNamespace(String string, String string2, int n) {
        if (string.startsWith(XML_PREFIX)) {
            return false;
        }
        Stack<MappingRecord> stack = (Stack<MappingRecord>)this.m_namespaces.get(string);
        if (stack == null) {
            stack = new Stack<MappingRecord>();
            this.m_namespaces.put(string, stack);
        }
        if (!stack.empty() && string2.equals(((MappingRecord)stack.peek()).m_uri)) {
            return false;
        }
        MappingRecord mappingRecord = new MappingRecord(string, string2, n);
        stack.push(mappingRecord);
        this.m_nodeStack.push(mappingRecord);
        return true;
    }

    void popNamespaces(int n, ContentHandler contentHandler) {
        while (!this.m_nodeStack.isEmpty()) {
            MappingRecord mappingRecord = (MappingRecord)this.m_nodeStack.peek();
            int n2 = mappingRecord.m_declarationDepth;
            if (n2 < n) {
                return;
            }
            mappingRecord = (MappingRecord)this.m_nodeStack.pop();
            String string = mappingRecord.m_prefix;
            this.popNamespace(string);
            if (contentHandler == null) continue;
            try {
                contentHandler.endPrefixMapping(string);
            }
            catch (SAXException sAXException) {
            }
        }
        return;
    }

    public String generateNextPrefix() {
        return "ns" + this.count++;
    }

    public Object clone() throws CloneNotSupportedException {
        NamespaceMappings namespaceMappings = new NamespaceMappings();
        namespaceMappings.m_nodeStack = (Stack)this.m_nodeStack.clone();
        namespaceMappings.m_namespaces = (Hashtable)this.m_namespaces.clone();
        namespaceMappings.count = this.count;
        return namespaceMappings;
    }

    final void reset() {
        this.count = 0;
        this.m_namespaces.clear();
        this.m_nodeStack.clear();
        this.initNamespaces();
    }

    class MappingRecord {
        final String m_prefix;
        final String m_uri;
        final int m_declarationDepth;

        MappingRecord(String string, String string2, int n) {
            this.m_prefix = string;
            this.m_uri = string2;
            this.m_declarationDepth = n;
        }
    }
}

