/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

public class FoldFilter {
    private float fold_change;
    private int[] group_membership;
    private String divider;
    private static int NUM_OF_GROUPS = 3;
    private static String BOTH = "both";
    private static String GREATER_THAN = ">";
    private static String LESS_THAN = "<";
    private static float INITAL_FOLD_CHANGE = 2.0f;

    public FoldFilter(String[] stringArray) {
        this.group_membership = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.group_membership[i] = 0;
        }
        this.divider = BOTH;
        this.fold_change = INITAL_FOLD_CHANGE;
    }

    public void set_fold_change(float f) {
        this.fold_change = f;
    }

    public float get_fold_change() {
        return this.fold_change;
    }

    public int get_group_membership(int n) {
        return this.group_membership[n];
    }

    public String get_divider() {
        return this.divider;
    }

    public void set_group_membership(int n, int n2) {
        this.group_membership[n2] = n;
    }

    public void set_divider(String string) {
        this.divider = string;
    }

    public int get_num_members(int n) {
        int n2 = 0;
        for (int i = 0; i < this.group_membership.length; ++i) {
            if (this.get_group_membership(i) != n) continue;
            ++n2;
        }
        return n2;
    }

    public boolean keep_gene(float[] fArray) {
        float[] fArray2 = new float[3];
        fArray2[2] = 0.0f;
        fArray2[1] = 0.0f;
        fArray2[0] = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            int n = this.get_group_membership(i);
            fArray2[n] = fArray2[n] + fArray[i];
        }
        fArray2[0] = fArray2[0] / (float)this.get_num_members(0);
        fArray2[1] = fArray2[1] / (float)this.get_num_members(1);
        if (this.divider.equals(GREATER_THAN)) {
            return fArray2[0] / fArray2[1] > this.fold_change;
        }
        if (this.divider.equals(LESS_THAN)) {
            return fArray2[1] / fArray2[0] > this.fold_change;
        }
        return fArray2[0] / fArray2[1] > this.fold_change || fArray2[1] / fArray2[0] > this.fold_change;
    }

    public String toString() {
        String string = "x";
        if (this.divider.equals(BOTH)) {
            string = "All genes with a fold change of greater than: " + this.fold_change;
        }
        if (this.divider.equals(GREATER_THAN)) {
            string = "Group A > Group B by " + this.fold_change + " fold.";
        }
        if (this.divider.equals(LESS_THAN)) {
            string = "Group B > Group A by " + this.fold_change + "fold.";
        }
        for (int i = 0; i < this.group_membership.length; ++i) {
            string = string + "\nsample: " + i + " is in group: " + this.get_group_membership(i);
        }
        return string;
    }
}

