/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.graph.GraphTick;
import org.tigr.graph.GraphViewer;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.Manager;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.SpotInformationData;
import org.tigr.microarray.mev.TMEV;
import org.tigr.util.Xcon;
import org.tigr.util.awt.ActionInfoDialog;
import org.tigr.util.awt.GBA;

public class InfoDisplay
extends ActionInfoDialog {
    private int feature;
    private int probe;
    private MultipleArrayData data;
    private ISlideData slideData;
    private ISlideDataElement element;
    private int LINEAR = 0;
    private int LOG = 1;

    public InfoDisplay(JFrame jFrame, ISlideData iSlideData, ISlideDataElement iSlideDataElement, int n) {
        super(jFrame, false);
        this.probe = n;
        this.init(iSlideData, iSlideDataElement);
    }

    public InfoDisplay(JFrame jFrame, MultipleArrayData multipleArrayData, int n, int n2) {
        super(jFrame, false);
        this.data = multipleArrayData;
        this.feature = n;
        this.probe = n2;
        this.init(multipleArrayData.getFeature(n), multipleArrayData.getSlideDataElement(n, n2));
    }

    private void init(ISlideData iSlideData, ISlideDataElement iSlideDataElement) {
        this.slideData = iSlideData;
        this.element = iSlideDataElement;
        Font font = new Font("Arial", 0, 10);
        JLabel jLabel = new JLabel(new ImageIcon(InfoDisplay.class.getResource("/org/tigr/images/spot.gif")));
        EventListener eventListener = new EventListener();
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/html");
        jEditorPane.setFont(font);
        jEditorPane.setBackground(new Color(Integer.parseInt("FFFFCC", 16)));
        jEditorPane.setEditable(false);
        jEditorPane.setMargin(new Insets(10, 15, 10, 10));
        jEditorPane.setText(this.createMessage(iSlideDataElement));
        jEditorPane.setCaretPosition(0);
        jEditorPane.addKeyListener(eventListener);
        JButton jButton = new JButton("Gene Graph");
        jButton.setActionCommand("view-gene-graph");
        jButton.addActionListener(eventListener);
        jButton.setEnabled(false);
        if (this.data != null) {
            jButton.setEnabled(true);
        }
        JButton jButton2 = new JButton("Experiment Detail");
        jButton2.setActionCommand("view-experiment");
        jButton2.addActionListener(eventListener);
        jButton2.setEnabled(false);
        JButton jButton3 = new JButton("Set Gene Color");
        jButton3.setActionCommand("set-color");
        jButton3.addActionListener(eventListener);
        jButton3.setEnabled(false);
        JButton jButton4 = new JButton("Close Spot Information");
        jButton4.setActionCommand("close");
        jButton4.addActionListener(eventListener);
        this.contentPane.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(jEditorPane, 20, 30);
        jScrollPane.getViewport().setBackground(Color.white);
        GBA gBA = new GBA();
        gBA.add(this.contentPane, jScrollPane, 0, 0, 3, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.contentPane, jButton, 0, 2, 1, 1, 0, 0, 0, 17, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.contentPane, jButton2, 1, 2, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.contentPane, jButton3, 2, 2, 1, 1, 0, 0, 0, 13, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.contentPane, jButton4, 0, 3, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.contentPane, jLabel, 2, 3, 1, 1, 0, 0, 0, 13, new Insets(5, 5, 5, 5), 0, 0);
        this.pack();
        this.setSize(600, 500);
        this.setResizable(true);
        this.setTitle("Spot Information");
        this.setLocation(300, 100);
        this.show();
    }

    private String createMessage(ISlideDataElement iSlideDataElement) {
        SpotInformationData spotInformationData;
        boolean bl = false;
        int n = iSlideDataElement.getRow(0);
        int n2 = iSlideDataElement.getColumn(0);
        float f = this.slideData.getCY3(this.probe);
        float f2 = this.slideData.getCY5(this.probe);
        float f3 = f2 / f;
        float f4 = f < 0.0f || f2 < 0.0f ? Float.NaN : (float)(Math.log(f3) / Math.log(2.0));
        int n3 = this.data != null ? this.data.getDataType() : this.slideData.getDataType();
        String string = "<html><body bgcolor = \"#FFFFCC\"><basefont face = \"Arial\"><h3>Location and Intensities</h3><table border=2 cellpadding=4 valign=top>";
        if (n3 == 0) {
            string = string + "<tr><td>Row</td><td>" + n + "</td></tr>" + "<tr><td>Column</td><td>" + n2 + "</td></tr>";
            string = string + "<tr><td>Cy3</td><td><b>" + f + "</b></td></tr>" + "<tr><td>Cy5</td><td><b>" + f2 + "</b></td></tr>";
            string = string + "<tr><td>Ratio</td><td>" + f3 + "</td></tr>" + "<tr><td>log2(Ratio)</td><td><b>" + f4 + "</b></td></tr>";
        } else if (n3 == 2) {
            string = string + "<tr><td>File Index</td><td>+" + n + "</td></tr>";
            string = string + "<tr><td>Affy Loading Mode</td><td>Absolute</td></tr>";
            string = string + "<tr><td>Intensity</td><td><b>" + f2 + "</b></td></tr>";
        } else if (n3 == 3) {
            string = string + "<tr><td>File Index</td><td>" + n + "</td></tr>";
            string = string + "<tr><td>Affy Loading Mode</td><td>Reference</td></tr>";
            string = string + "<tr><td>Sample Intensity</td><td><b>" + f2 + "</b></td></tr>";
            string = string + "<tr><td>Ref. Intensity</td><td><b>" + f + "</b></td></tr>";
            string = string + "<tr><td>Ratio (Sample/Ref.)</td><td>" + f3 + "</td></tr>" + "<tr><td>log2(Ratio)</td><td><b>" + f4 + "</b></td></tr>";
        } else if (n3 == 4) {
            string = string + "<tr><td>File Index</td><td>" + n + "</td></tr>";
            string = string + "<tr><td>Affy Loading Mode</td><td>Spot Mean as Ref.</td></tr>";
            string = string + "<tr><td>Sample Intensity</td><td><b>" + f2 + "</b></td></tr>";
            string = string + "<tr><td>Spot Mean Intensity</td><td><b>" + f + "</b></td></tr>";
            string = string + "<tr><td>Ratio (Sample/Mean)</td><td>" + f3 + "</td></tr>" + "<tr><td>log2(Ratio)</td><td><b>" + f4 + "</b></td></tr>";
        } else if (n3 == 5) {
            string = string + "<tr><td>File Index</td><td>" + n + "</td></tr>";
            string = string + "<tr><td>Affy Loading Mode</td><td>Spot Median as Ref.</td></tr>";
            string = string + "<tr><td>Sample Intensity</td><td><b>" + f2 + "</b></td></tr>";
            string = string + "<tr><td>Spot Median Intensity</td><td><b>" + f + "</b></td></tr>";
            string = string + "<tr><td>Ratio (Sample/Median)</td><td>" + f3 + "</td></tr>" + "<tr><td>log2(Ratio)</td><td><b>" + f4 + "</b></td></tr>";
        } else {
            string = string + "<tr><td>File Index</td><td>" + n + "</td></tr>";
            string = string + "<tr><td>log2(Ratio)</td><td><b>" + f4 + "</b></td></tr>";
        }
        string = string + "</table>";
        String[] stringArray = TMEV.getFieldNames();
        if (stringArray != null && stringArray.length > 0) {
            string = string + "<h3>Annotation</h3><table border=2 cellpadding=4>";
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + "<tr valign=top><td>" + stringArray[i] + "</td><td>" + iSlideDataElement.getFieldAt(i) + "</td></tr>";
            }
            string = string + "</table>";
        }
        if ((spotInformationData = this.slideData.getSpotInformationData()) != null) {
            String[] stringArray2 = spotInformationData.getSpotInformationHeader();
            String[] stringArray3 = spotInformationData.getSpotInformationArray(this.probe);
            string = string + "<h3>Spot Information</h3><table border=2 cellpadding=4>";
            for (int i = 0; i < stringArray2.length; ++i) {
                string = string + "<tr valign=top><td>" + stringArray2[i] + "</td><td>" + stringArray3[i] + "</td></tr>";
            }
            string = string + "</table>";
        }
        string = string + "</basefont></body></html>";
        return string;
    }

    public void createGeneGraph() {
        GraphTick graphTick;
        double d;
        double d2;
        float f;
        int n;
        GraphLine graphLine;
        int n2;
        ISlideData iSlideData;
        int n3;
        int n4;
        ISlideData[] iSlideDataArray = new ISlideData[this.data.getFeaturesCount()];
        int n5 = this.data.getFeature(0).getSlideMetaData().getColumns();
        for (n4 = 0; n4 < iSlideDataArray.length; ++n4) {
            iSlideDataArray[n4] = this.data.getFeature(n4);
        }
        n4 = 0;
        int n6 = iSlideDataArray.length;
        int n7 = Integer.MAX_VALUE;
        int n8 = Integer.MIN_VALUE;
        int n9 = 0;
        for (n3 = 0; n3 < iSlideDataArray.length; ++n3) {
            iSlideData = iSlideDataArray[n3];
            n9 = (int)iSlideData.getRatio(this.probe, this.LOG);
            if (n9 < n7) {
                n7 = n9;
            }
            if (n9 <= n8) continue;
            n8 = n9;
        }
        n3 = n6 - n4;
        int n10 = ++n8 - --n7;
        JFrame jFrame = new JFrame("Experiment vs. Log Ratio");
        GraphViewer graphViewer = new GraphViewer(jFrame, 0, 500, 0, 500, n4, n6, n7, n8, 100, 100, 100, 100, "Experiment vs. Log Ratio", "Experiment Name", "Log2 (Cy5 / Cy3)");
        graphViewer.setXAxisValue(0.0);
        graphViewer.setYAxisValue(n4);
        for (n2 = n4 + 1; n2 <= n6; ++n2) {
            graphLine = new GraphLine(n2, n7, n2, n8, Color.yellow);
            graphViewer.addGraphElement(graphLine);
        }
        for (n2 = n7; n2 <= n8; ++n2) {
            if (n2 == 0) continue;
            graphLine = new GraphLine(n4, n2, n6, n2, Color.yellow);
            graphViewer.addGraphElement(graphLine);
        }
        for (n = 0; n < iSlideDataArray.length - 1; ++n) {
            iSlideData = iSlideDataArray[n];
            float f2 = iSlideData.getCY3(this.probe);
            f = iSlideData.getCY5(this.probe);
            d2 = n + 1;
            d = Xcon.log2((double)f / (double)f2);
            iSlideData = iSlideDataArray[n + 1];
            float f3 = iSlideData.getCY3(this.probe);
            float f4 = iSlideData.getCY5(this.probe);
            double d3 = n + 2;
            double d4 = Xcon.log2((double)f4 / (double)f3);
            if (Double.isNaN(d) || Double.isNaN(d4)) continue;
            graphLine = new GraphLine(d2, d, d3, d4, Color.blue);
            graphViewer.addGraphElement(graphLine);
        }
        for (n = 0; n < iSlideDataArray.length; ++n) {
            iSlideData = iSlideDataArray[n];
            float f5 = iSlideData.getCY3(this.probe);
            f = iSlideData.getCY5(this.probe);
            d2 = n + 1;
            d = Xcon.log2((double)f / (double)f5);
            if (Double.isNaN(d)) continue;
            GraphPoint graphPoint = new GraphPoint(d2, d, Color.blue, 3);
            graphViewer.addGraphElement(graphPoint);
        }
        for (n = n7; n <= n8; ++n) {
            graphTick = n == 0 ? new GraphTick(n, 8, Color.black, 1, 0, "0", Color.black) : new GraphTick(n, 8, Color.black, 1, 0, "" + n, Color.black);
            graphViewer.addGraphElement(graphTick);
        }
        for (n = n4 + 1; n <= n6; ++n) {
            graphTick = new GraphTick(n, 8, Color.black, 0, 0, this.data.getSampleName(n - 1), Color.black);
            graphViewer.addGraphElement(graphTick);
        }
        jFrame.setSize(500, 500);
        graphViewer.setVisible(true);
    }

    class EventListener
    implements ActionListener,
    KeyListener {
        EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("close")) {
                InfoDisplay.this.dispose();
            } else if (string.equals("view-gene-graph")) {
                InfoDisplay.this.hide();
                InfoDisplay.this.createGeneGraph();
                InfoDisplay.this.dispose();
            } else if (string.equals("view-experiment")) {
                InfoDisplay.this.hide();
                Manager.createNewSingleArrayViewer(InfoDisplay.this.slideData);
                InfoDisplay.this.dispose();
            } else if (string.equals("set-color")) {
                // empty if block
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                InfoDisplay.this.dispose();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

