/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Properties;
import org.tigr.microarray.mev.DetectionFilter;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.FoldFilter;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.util.Adjustment;
import org.tigr.microarray.util.SlideDataSorter;
import org.tigr.midas.mevdialogs.IterativeLogMCNormInitDialog;
import org.tigr.midas.mevdialogs.LinRegNormInitDialog;
import org.tigr.midas.mevdialogs.RatioStatsNormInitDialog;
import org.tigr.util.FloatMatrix;

public class MultipleArrayData
implements IData {
    private ArrayList featuresList = new ArrayList();
    private ArrayList indicesList = new ArrayList();
    private ArrayList spotColors = new ArrayList();
    private int[] colorIndices;
    private ArrayList experimentColors = new ArrayList();
    private int[] experimentColorIndices;
    private Experiment experiment = null;
    private int dataType;
    private float maxCy3 = 0.0f;
    private float maxCy5 = 0.0f;
    private float maxRatio = 0.0f;
    private float minRatio = 0.0f;
    private float percentageCutoff = 0.0f;
    private boolean usePercentageCutoff = false;
    private float lowerCY3Cutoff = 0.0f;
    private float lowerCY5Cutoff = 0.0f;
    private boolean useLowerCutoffs = false;
    private Progress progressBar;
    private boolean normalizationAbort = false;
    private DetectionFilter detectionFilter;
    private FoldFilter foldFilter;
    private boolean useDetectionFilter = false;
    private boolean dfSet = false;
    private boolean useFoldFilter = false;
    private ClusterRepository geneClusterRepository;
    private ClusterRepository expClusterRepository;

    public void setGeneClusterRepository(ClusterRepository clusterRepository) {
        this.geneClusterRepository = clusterRepository;
    }

    public void setExperimentClusterRepository(ClusterRepository clusterRepository) {
        this.expClusterRepository = clusterRepository;
    }

    public int getFeaturesCount() {
        return this.featuresList.size();
    }

    public int getFeaturesSize() {
        if (this.featuresList.size() == 0) {
            return 0;
        }
        return ((ISlideData)this.featuresList.get(0)).getSize();
    }

    public int getFeaturesSizeSpecific(int n) {
        if (this.featuresList.size() == 0) {
            return 0;
        }
        return ((ISlideData)this.featuresList.get(n)).getSize();
    }

    public float getPercentageCutoff() {
        return this.percentageCutoff;
    }

    public void setPercentageCutoff(float f) {
        this.percentageCutoff = f;
        if (this.isPercentageCutoff()) {
            this.experiment = this.createExperiment();
        }
    }

    public void setUsePercentageCutoff(boolean bl) {
        if (this.usePercentageCutoff == bl) {
            return;
        }
        this.usePercentageCutoff = bl;
        this.experiment = this.createExperiment();
    }

    public void setUseDetectionFilter(boolean bl) {
        if (this.useDetectionFilter == bl) {
            return;
        }
        this.useDetectionFilter = bl;
        this.experiment = this.createExperiment();
    }

    public void setUseFoldFilter(boolean bl) {
        if (this.useFoldFilter == bl) {
            return;
        }
        this.useFoldFilter = bl;
        this.experiment = this.createExperiment();
    }

    public void setdfSet(boolean bl) {
        this.dfSet = bl;
    }

    public boolean getdfSet() {
        return this.dfSet;
    }

    public boolean isDetectionFilter() {
        return this.useDetectionFilter;
    }

    public boolean isFoldFilter() {
        return this.useFoldFilter;
    }

    public DetectionFilter getDetectionFilter() {
        return this.detectionFilter;
    }

    public FoldFilter getFoldFilter() {
        return this.foldFilter;
    }

    public void setDetectionFilter(DetectionFilter detectionFilter) {
        this.detectionFilter = detectionFilter;
        if (this.isDetectionFilter()) {
            this.experiment = this.createExperiment();
        }
    }

    public void setFoldFilter(FoldFilter foldFilter) {
        this.foldFilter = foldFilter;
        if (this.isFoldFilter()) {
            this.experiment = this.createExperiment();
        }
    }

    public String getDetection(int n, int n2) {
        String string;
        if (this.featuresList.size() == 0) {
            return "";
        }
        if (n > 0) {
            FloatSlideData floatSlideData = (FloatSlideData)this.featuresList.get(n);
            string = floatSlideData.getDetection(n2);
        } else {
            SlideData slideData = (SlideData)this.featuresList.get(n);
            ISlideDataElement iSlideDataElement = slideData.getSlideDataElement(n2);
            string = iSlideDataElement.getDetection();
        }
        return string;
    }

    public boolean isPercentageCutoff() {
        return this.usePercentageCutoff;
    }

    public float getLowerCY3Cutoff() {
        return this.lowerCY3Cutoff;
    }

    public void setLowerCutoffs(float f, float f2) {
        this.lowerCY3Cutoff = f;
        this.lowerCY5Cutoff = f2;
        if (this.isLowerCutoffs()) {
            this.experiment = this.createExperiment();
        }
    }

    public float getLowerCY5Cutoff() {
        return this.lowerCY5Cutoff;
    }

    public void setUseLowerCutoffs(boolean bl) {
        if (this.useLowerCutoffs == bl) {
            return;
        }
        this.useLowerCutoffs = bl;
        this.experiment = this.createExperiment();
    }

    public boolean isLowerCutoffs() {
        return this.useLowerCutoffs;
    }

    public float getCY3(int n, int n2) {
        ISlideData iSlideData = (ISlideData)this.featuresList.get(n);
        return iSlideData.getCY3(n2);
    }

    public float getCY5(int n, int n2) {
        ISlideData iSlideData = (ISlideData)this.featuresList.get(n);
        return iSlideData.getCY5(n2);
    }

    public float getRatio(int n, int n2, int n3) {
        ISlideData iSlideData = (ISlideData)this.featuresList.get(n);
        return iSlideData.getRatio(n2, n3);
    }

    public String getSampleName(int n) {
        return ((ISlideData)this.featuresList.get(n)).getSlideDataName();
    }

    public String getFullSampleName(int n) {
        return ((ISlideData)this.featuresList.get(n)).getFullSlideDataName();
    }

    public String getElementAttribute(int n, int n2) {
        if (this.featuresList.size() == 0) {
            return "";
        }
        ISlideData iSlideData = (ISlideData)this.featuresList.get(0);
        ISlideDataElement iSlideDataElement = iSlideData.getSlideDataElement(n);
        return iSlideDataElement.getFieldAt(n2);
    }

    public String getElementAttributeSpecific(int n, int n2, int n3) {
        if (this.featuresList.size() == 0) {
            return "";
        }
        ISlideData iSlideData = (ISlideData)this.featuresList.get(n3);
        ISlideDataElement iSlideDataElement = iSlideData.getSlideDataElement(n);
        return iSlideDataElement.getFieldAt(n2);
    }

    public String getUniqueId(int n) {
        return this.getElementAttribute(n, TMEV.getUniqueIDIndex());
    }

    public String getGeneName(int n) {
        return this.getElementAttribute(n, TMEV.getNameIndex());
    }

    public String[] getFieldNames() {
        return TMEV.getFieldNames();
    }

    public int getProbeRow(int n, int n2) {
        ISlideMetaData iSlideMetaData = this.getFeature(n).getSlideMetaData();
        return iSlideMetaData.getRow(n2);
    }

    public int getProbeColumn(int n, int n2) {
        ISlideMetaData iSlideMetaData = this.getFeature(n).getSlideMetaData();
        return iSlideMetaData.getColumn(n2);
    }

    public Color[] getColors() {
        this.updateSpotColors();
        Color[] colorArray = new Color[this.spotColors.size()];
        return this.spotColors.toArray(colorArray);
    }

    public Color getProbeColor(int n) {
        if (this.geneClusterRepository == null) {
            return null;
        }
        return this.geneClusterRepository.getColor(n);
    }

    public void updateSpotColors() {
        this.colorIndices = new int[this.getFeaturesSize()];
        this.spotColors = new ArrayList();
        int n = 0;
        for (int i = 0; i < this.colorIndices.length; ++i) {
            Color color = this.geneClusterRepository == null ? null : this.geneClusterRepository.getColor(i);
            if (color == null) {
                this.colorIndices[i] = -1;
                continue;
            }
            int n2 = this.spotColors.indexOf(color);
            if (n2 < 0) {
                this.spotColors.add(color);
                this.colorIndices[i] = n++;
                continue;
            }
            this.colorIndices[i] = n2;
        }
    }

    public void updateExperimentColors() {
        this.experimentColorIndices = new int[this.getFeaturesCount()];
        this.experimentColors = new ArrayList();
        int n = 0;
        for (int i = 0; i < this.experimentColorIndices.length; ++i) {
            Color color = this.expClusterRepository == null ? null : this.expClusterRepository.getColor(i);
            if (color == null) {
                this.experimentColorIndices[i] = -1;
                continue;
            }
            int n2 = this.experimentColors.indexOf(color);
            if (n2 < 0) {
                this.experimentColors.add(color);
                this.experimentColorIndices[i] = n++;
                continue;
            }
            this.experimentColorIndices[i] = n2;
        }
    }

    public int[] getColorIndices() {
        this.updateSpotColors();
        return this.colorIndices;
    }

    public int[] getExperimentColorIndices() {
        this.updateExperimentColors();
        return this.experimentColorIndices;
    }

    public void setProbesColor(int[] nArray, Color color) {
        int n;
        if (color == null) {
            n = -1;
        } else {
            n = this.spotColors.indexOf(color);
            if (n < 0) {
                n = this.spotColors.size();
                this.spotColors.add(color);
            }
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.colorIndices[nArray[i]] = n;
        }
        this.removeUnusedColors();
    }

    public int getProbeColorIndex(int n) {
        return this.colorIndices[n];
    }

    public int getColoredProbesCount(int n) {
        int n2 = 0;
        for (int i = 0; i < this.colorIndices.length; ++i) {
            if (this.colorIndices[i] != n) continue;
            ++n2;
        }
        return n2;
    }

    public Color getExperimentColor(int n) {
        if (this.expClusterRepository == null) {
            return null;
        }
        return this.expClusterRepository.getColor(n);
    }

    public void setExperimentColor(int[] nArray, Color color) {
        int n;
        if (this.experimentColorIndices == null) {
            this.experimentColorIndices = this.createExperimentColorIndices();
        }
        if (color == null) {
            n = -1;
        } else {
            n = this.experimentColors.indexOf(color);
            if (n < 0) {
                n = this.experimentColors.size();
                this.experimentColors.add(color);
            }
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.experimentColorIndices[nArray[i]] = n;
        }
        this.removeUnusedExperimentColors();
    }

    public int getColoredExperimentsCount(int n) {
        int n2 = 0;
        if (this.experimentColorIndices == null) {
            this.experimentColorIndices = this.createExperimentColorIndices();
        }
        for (int i = 0; i < this.experimentColorIndices.length; ++i) {
            if (this.experimentColorIndices[i] != n) continue;
            ++n2;
        }
        return n2;
    }

    public Color[] getExperimentColors() {
        this.updateExperimentColors();
        Color[] colorArray = new Color[this.experimentColors.size()];
        return this.experimentColors.toArray(colorArray);
    }

    public int getExperimentColorIndex(int n) {
        if (this.experimentColorIndices == null) {
            this.experimentColorIndices = this.createExperimentColorIndices();
        }
        return this.experimentColorIndices[n];
    }

    public void clearExperimentColor(int n) {
        if (n > this.experimentColorIndices.length) {
            return;
        }
        this.experimentColors.remove(this.experimentColorIndices[n]);
        this.experimentColorIndices[n] = -1;
    }

    public void clearExperimentColors(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.clearExperimentColor(nArray[i]);
        }
    }

    public void deleteExperimentColors() {
        this.experimentColors.clear();
        this.experimentColorIndices = this.createExperimentColorIndices();
    }

    private int[] createExperimentColorIndices() {
        int[] nArray = new int[this.featuresList.size()];
        for (int i = 0; i < this.featuresList.size(); ++i) {
            nArray[i] = -1;
        }
        return nArray;
    }

    private void removeUnusedColors() {
        int n;
        int n2 = n = this.spotColors.size();
        while (--n2 >= 0) {
            boolean bl = true;
            int n3 = this.colorIndices.length;
            while (--n3 >= 0) {
                if (this.colorIndices[n3] != n2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this.spotColors.remove(n2);
            n3 = this.colorIndices.length;
            while (--n3 >= 0) {
                if (this.colorIndices[n3] <= n2) continue;
                int n4 = n3;
                this.colorIndices[n4] = this.colorIndices[n4] - 1;
            }
        }
    }

    private void removeUnusedExperimentColors() {
        int n;
        int n2 = n = this.experimentColors.size();
        while (--n2 >= 0) {
            boolean bl = true;
            int n3 = this.experimentColorIndices.length;
            while (--n3 >= 0) {
                if (this.experimentColorIndices[n3] != n2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this.experimentColors.remove(n2);
            n3 = this.experimentColorIndices.length;
            while (--n3 >= 0) {
                if (this.experimentColorIndices[n3] <= n2) continue;
                int n4 = n3;
                this.experimentColorIndices[n4] = this.experimentColorIndices[n4] - 1;
            }
        }
    }

    public void deleteColors() {
        this.spotColors.clear();
        if (this.colorIndices != null) {
            this.colorIndices = this.createColorIndices(this.colorIndices.length);
        }
    }

    private int[] createIndices(ISlideData iSlideData) {
        int[] nArray = new int[iSlideData.getSize()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    void addFeature(ISlideData iSlideData) {
        this.featuresList.add(iSlideData);
        this.indicesList.add(this.createIndices(iSlideData));
        this.experiment = this.createExperiment();
        if (this.colorIndices == null) {
            this.colorIndices = this.createColorIndices(iSlideData.getSize());
        }
        this.updateMaxValues(iSlideData);
    }

    void addFeatures(ISlideData[] iSlideDataArray) {
        for (int i = 0; i < iSlideDataArray.length; ++i) {
            this.featuresList.add(iSlideDataArray[i]);
            this.indicesList.add(this.createIndices(iSlideDataArray[i]));
            this.updateMaxValues(iSlideDataArray[i]);
        }
        this.experiment = this.createExperiment();
        if (this.colorIndices == null) {
            this.colorIndices = this.createColorIndices(iSlideDataArray[0].getSize());
        }
    }

    private int[] createColorIndices(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = -1;
        }
        return nArray;
    }

    private void updateMaxValues(ISlideData iSlideData) {
        float f = iSlideData.getMaxCY3();
        if (f > this.maxCy3) {
            this.setMaxCY3(f);
        }
        if ((f = iSlideData.getMaxCY5()) > this.maxCy5) {
            this.setMaxCY5(f);
        }
        this.updateMaxMinRatios(iSlideData);
    }

    ISlideMetaData getSlideMetaData() {
        if (this.featuresList.size() > 0) {
            return ((ISlideData)this.featuresList.get(0)).getSlideMetaData();
        }
        return null;
    }

    ISlideData getFeature(int n) {
        return (ISlideData)this.featuresList.get(n);
    }

    ISlideDataElement getSlideDataElement(int n, int n2) {
        ISlideData iSlideData = this.getFeature(n);
        return iSlideData.getSlideDataElement(n2);
    }

    void setNonZero(boolean bl) {
        this.resetMaxValues();
        int n = this.getFeaturesCount();
        for (int i = 0; i < n; ++i) {
            ISlideData iSlideData = this.getFeature(i);
            iSlideData.setNonZero(bl);
            this.updateMaxValues(iSlideData);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String normalize(int n, MultipleArrayViewer multipleArrayViewer) {
        Object object;
        this.resetMaxValues();
        int n2 = this.getFeaturesCount();
        Properties properties = new Properties();
        if (n == 0) {
            for (int i = 0; i < n2; ++i) {
                ISlideData iSlideData = this.getFeature(i);
                iSlideData.applyNormalization(0, properties);
                this.updateMaxValues(iSlideData);
            }
            this.experiment = this.createExperiment();
            return "normalized";
        }
        if (n == 3) {
            object = new LinRegNormInitDialog();
            if (((LinRegNormInitDialog)object).showModal() != 0) return "no_change";
            properties.setProperty("standard-deviation", Double.toString(((LinRegNormInitDialog)object).getSD()));
            properties.setProperty("mode", ((LinRegNormInitDialog)object).getMode());
            ((Window)object).dispose();
        } else if (n == 4 || n == 5) {
            object = new RatioStatsNormInitDialog();
            if (((RatioStatsNormInitDialog)object).showModal() != 0) return "no_change";
            properties.setProperty("confidence-interval", Integer.toString(((RatioStatsNormInitDialog)object).getCI()));
            ((Window)object).dispose();
        } else if (n == 6) {
            object = new IterativeLogMCNormInitDialog();
            if (((IterativeLogMCNormInitDialog)object).showModal() != 0) return "no_change";
            properties.setProperty("standard-deviation", Double.toString(((IterativeLogMCNormInitDialog)object).getSD()));
            ((Window)object).dispose();
        }
        object = new Normalizer(n, properties, n2, multipleArrayViewer);
        ((Normalizer)object).runNormalization();
        this.experiment = this.createExperiment();
        if (this.normalizationAbort) return "process_abort_reset";
        return "normalized";
    }

    void normalizeList(int n) {
        this.resetMaxValues();
        int n2 = this.getFeaturesCount();
        for (int i = 0; i < n2; ++i) {
            ISlideData iSlideData = this.getFeature(i);
            iSlideData.applyNormalizationList(n);
            this.updateMaxValues(iSlideData);
        }
        this.experiment = this.createExperiment();
    }

    public int[] getSortedIndices(int n) {
        return (int[])this.indicesList.get(n);
    }

    private Experiment createExperiment() {
        int n = this.featuresList.size();
        if (n < 1) {
            return null;
        }
        int n2 = this.getFeature(this.getFeaturesCount() - 1).getSize();
        Experiment experiment = null;
        int[] nArray = null;
        int[] nArray2 = null;
        if (this.isLowerCutoffs() || this.isPercentageCutoff() || TMEV.getDataType() == 2 && (this.isDetectionFilter() || this.isFoldFilter())) {
            nArray2 = this.createCutoffGeneList(n, n2);
            experiment = this.createExperiment(n, nArray2);
        } else {
            nArray = this.createDefaultFeatures(n, n2);
            experiment = this.createExperiment(nArray, n2);
        }
        return experiment;
    }

    private int[] createDefaultFeatures(int n, int n2) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private int[] createCutoffFeatures(int n, int n2) {
        int n3;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = true;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            ISlideData iSlideData = this.getFeature(i);
            for (n3 = 0; n3 < n2; ++n3) {
                float f = iSlideData.getCY3(n3);
                float f2 = iSlideData.getCY5(n3);
                if (this.isLowerCutoffs() && (f < this.lowerCY3Cutoff || f2 < this.lowerCY5Cutoff)) {
                    bl = false;
                    break;
                }
                if (!this.isPercentageCutoff() || !(f > 0.0f) || !(f2 > 0.0f)) continue;
                ++n4;
            }
            if (bl && this.isPercentageCutoff() && (float)n4 / (float)n2 * 100.0f < this.percentageCutoff) {
                bl = false;
            }
            if (!bl) continue;
            arrayList.add(new Integer(i));
        }
        int[] nArray = new int[arrayList.size()];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            nArray[n3] = (Integer)arrayList.get(n3);
        }
        return nArray;
    }

    private int[] createCutoffGeneList(int n, int n2) {
        int n3;
        ISlideData[] iSlideDataArray = new ISlideData[n];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        int n4 = 0;
        boolean bl5 = false;
        for (n3 = 0; n3 < iSlideDataArray.length; ++n3) {
            iSlideDataArray[n3] = this.getFeature(n3);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            int n5;
            float[] fArray = new float[n];
            float[] fArray2 = new float[n];
            String[] stringArray = new String[n];
            n4 = 0;
            bl5 = false;
            bl = true;
            bl2 = true;
            bl3 = true;
            bl4 = true;
            for (n5 = 0; n5 < fArray.length; ++n5) {
                fArray[n5] = iSlideDataArray[n5].getCY3(n3);
                fArray2[n5] = iSlideDataArray[n5].getCY5(n3);
                stringArray[n5] = this.getDetection(n5, n3);
            }
            if (this.isLowerCutoffs()) {
                for (n5 = 0; n5 < fArray.length; ++n5) {
                    if (!(fArray[n5] < this.lowerCY3Cutoff) && !(fArray2[n5] < this.lowerCY5Cutoff)) continue;
                    bl = false;
                    break;
                }
            }
            if (this.isPercentageCutoff()) {
                for (n5 = 0; n5 < fArray.length; ++n5) {
                    if (!(fArray[n5] > 0.0f) || !(fArray2[n5] > 0.0f)) continue;
                    ++n4;
                }
                if ((float)n4 / (float)n * 100.0f < this.percentageCutoff) {
                    bl2 = false;
                }
            }
            if (this.isDetectionFilter()) {
                bl3 = this.detectionFilter.keep_gene(stringArray);
            }
            if (this.isFoldFilter()) {
                bl4 = this.foldFilter.keep_gene(fArray2);
            }
            if (!bl || !bl2 || !bl3 || !bl4) continue;
            arrayList.add(new Integer(n3));
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    private Experiment createExperiment(int[] nArray, int n) {
        ISlideData iSlideData;
        for (int i = 0; i < nArray.length; ++i) {
            iSlideData = (ISlideData)this.featuresList.get(nArray[i]);
            if (iSlideData.getSize() <= n) continue;
            n = iSlideData.getSize();
        }
        FloatMatrix floatMatrix = new FloatMatrix(n, nArray.length);
        float[][] fArray = floatMatrix.A;
        for (int i = 0; i < nArray.length; ++i) {
            iSlideData = (ISlideData)this.featuresList.get(nArray[i]);
            int n2 = n = iSlideData.getSize();
            while (--n2 >= 0) {
                floatMatrix.A[n2][nArray[i]] = iSlideData.getRatio(n2, 1);
            }
        }
        return new Experiment(floatMatrix, nArray);
    }

    private Experiment createExperiment(int n, int[] nArray) {
        FloatMatrix floatMatrix = new FloatMatrix(nArray.length, n);
        int[] nArray2 = new int[n];
        float[][] fArray = floatMatrix.A;
        for (int i = 0; i < n; ++i) {
            nArray2[i] = i;
            ISlideData iSlideData = (ISlideData)this.featuresList.get(i);
            for (int j = 0; j < nArray.length; ++j) {
                floatMatrix.A[j][i] = iSlideData.getRatio(nArray[j], 1);
            }
        }
        return new Experiment(floatMatrix, nArray2, nArray);
    }

    public int getNormalizationState() {
        if (this.featuresList == null || this.featuresList.size() < 1) {
            return 0;
        }
        return ((ISlideData)this.featuresList.get(0)).getNormalizedState();
    }

    public MultipleArrayData getDataSubset(int[] nArray) {
        ISlideMetaData iSlideMetaData = null;
        MultipleArrayData multipleArrayData = new MultipleArrayData();
        int n = this.getNormalizationState();
        if (nArray.length < 1) {
            return null;
        }
        for (int i = 0; i < this.getFeaturesCount(); ++i) {
            ISlideDataElement iSlideDataElement;
            int n2;
            int n3;
            String string;
            ISlideData iSlideData;
            if (i == 0) {
                iSlideData = new SlideData();
                string = this.getSampleName(i);
                if (string.endsWith("...")) {
                    this.toggleExptNameLength();
                    iSlideData.setSlideDataName(this.getSampleName(i));
                    ((SlideData)iSlideData).setSlideFileName(this.getSampleName(i));
                    this.toggleExptNameLength();
                } else {
                    iSlideData.setSlideDataName(this.getSampleName(i));
                    ((SlideData)iSlideData).setSlideFileName(this.getSampleName(i));
                }
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    n2 = nArray[n3];
                    iSlideDataElement = new SlideDataElement(this.getSlideDataElement(i, n2));
                    iSlideData.addSlideDataElement(iSlideDataElement);
                }
                iSlideMetaData = (ISlideMetaData)((Object)iSlideData);
            } else {
                iSlideData = new FloatSlideData(iSlideMetaData);
                ((FloatSlideData)iSlideData).createCurrentIntensityArrays();
                string = this.getSampleName(i);
                if (string.endsWith("...")) {
                    this.toggleExptNameLength();
                    iSlideData.setSlideDataName(this.getSampleName(i));
                    ((FloatSlideData)iSlideData).setSlideFileName(this.getSampleName(i));
                    this.toggleExptNameLength();
                } else {
                    iSlideData.setSlideDataName(this.getSampleName(i));
                    ((FloatSlideData)iSlideData).setSlideFileName(this.getSampleName(i));
                }
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    n2 = nArray[n3];
                    iSlideDataElement = this.getSlideDataElement(i, n2);
                    ((FloatSlideData)iSlideData).setIntensities(n3, iSlideDataElement.getTrueIntensity(0), iSlideDataElement.getTrueIntensity(1));
                    ((FloatSlideData)iSlideData).setCurrentIntensities(n3, iSlideDataElement.getCurrentIntensity()[0], iSlideDataElement.getCurrentIntensity()[1]);
                }
            }
            iSlideData.setNormalizedState(n);
            multipleArrayData.addFeature(iSlideData);
        }
        return multipleArrayData;
    }

    public MultipleArrayData getDataSubset(int[] nArray, int[] nArray2) {
        ISlideMetaData iSlideMetaData = (ISlideMetaData)this.featuresList.get(0);
        MultipleArrayData multipleArrayData = new MultipleArrayData();
        int n = this.getNormalizationState();
        if (nArray.length < 1 || nArray2.length < 1) {
            return null;
        }
        for (int i = 0; i < nArray.length; ++i) {
            ISlideDataElement iSlideDataElement;
            int n2;
            String string;
            ISlideData iSlideData;
            int n3 = nArray[i];
            if (n3 == 0) {
                iSlideData = new SlideData();
                string = this.getSampleName(n3);
                if (string.endsWith("...")) {
                    this.toggleExptNameLength();
                    iSlideData.setSlideDataName(this.getSampleName(n3));
                    ((SlideData)iSlideData).setSlideFileName(this.getSampleName(n3));
                    this.toggleExptNameLength();
                } else {
                    iSlideData.setSlideDataName(this.getSampleName(n3));
                    ((SlideData)iSlideData).setSlideFileName(this.getSampleName(n3));
                }
                for (n2 = 0; n2 < nArray2.length; ++n2) {
                    iSlideDataElement = new SlideDataElement(this.getSlideDataElement(n3, nArray2[n2]));
                    iSlideData.addSlideDataElement(iSlideDataElement);
                }
                iSlideMetaData = (ISlideMetaData)((Object)iSlideData);
            } else {
                iSlideData = new FloatSlideData(iSlideMetaData);
                ((FloatSlideData)iSlideData).createCurrentIntensityArrays();
                string = this.getSampleName(n3);
                if (string.endsWith("...")) {
                    this.toggleExptNameLength();
                    iSlideData.setSlideDataName(this.getSampleName(n3));
                    ((FloatSlideData)iSlideData).setSlideFileName(this.getSampleName(n3));
                    this.toggleExptNameLength();
                } else {
                    iSlideData.setSlideDataName(this.getSampleName(n3));
                    ((FloatSlideData)iSlideData).setSlideFileName(this.getSampleName(n3));
                }
                for (n2 = 0; n2 < nArray2.length; ++n2) {
                    iSlideDataElement = this.getSlideDataElement(n3, nArray2[n2]);
                    ((FloatSlideData)iSlideData).setIntensities(n2, iSlideDataElement.getTrueIntensity(0), iSlideDataElement.getTrueIntensity(1));
                    ((FloatSlideData)iSlideData).setCurrentIntensities(n2, iSlideDataElement.getCurrentIntensity()[0], iSlideDataElement.getCurrentIntensity()[1]);
                }
            }
            iSlideData.setNormalizedState(n);
            multipleArrayData.addFeature(iSlideData);
        }
        return multipleArrayData;
    }

    private void resetMaxValues() {
        this.setMaxCY3(0.0f);
        this.setMaxCY5(0.0f);
        this.setMaxRatio(0.0f);
        this.setMinRatio(0.0f);
    }

    private void updateMaxMinRatios(ISlideData iSlideData) {
        int n;
        float f = this.minRatio;
        float f2 = this.maxRatio;
        int n2 = this.featuresList.size();
        int n3 = ((ISlideData)this.featuresList.get(0)).getSize();
        for (n = 0; n < this.featuresList.size(); ++n) {
            ISlideData iSlideData2 = (ISlideData)this.featuresList.get(n);
            if (!iSlideData.getSlideDataName().equals(iSlideData2.getSlideDataName()) || iSlideData.getSize() != iSlideData2.getSize()) continue;
            n3 = ((ISlideData)this.featuresList.get(n)).getSize();
        }
        for (n = 0; n < n3; ++n) {
            float f3 = iSlideData.getRatio(n, 1);
            f2 = Math.max(f2, f3);
            f = Math.min(f, f3);
        }
        this.setMaxRatio(f2);
        this.setMinRatio(f2);
    }

    public void toggleExptNameLength() {
        if (this.getFeaturesCount() < 1) {
            return;
        }
        for (int i = 0; i < this.getFeaturesCount(); ++i) {
            this.getFeature(i).toggleNameLength();
        }
    }

    void sort(int n) {
        SlideDataSorter slideDataSorter = new SlideDataSorter();
        if (n == 9001) {
            for (int i = 0; i < this.featuresList.size(); ++i) {
                slideDataSorter.setSlideData((ISlideData)this.featuresList.get(i));
                slideDataSorter.sort((int[])this.indicesList.get(i), n);
            }
        } else {
            if (this.featuresList.size() < 1) {
                return;
            }
            slideDataSorter.setSlideData((ISlideData)this.featuresList.get(0));
            int[] nArray = (int[])this.indicesList.get(0);
            slideDataSorter.sort(nArray, n);
            for (int i = 1; i < this.featuresList.size(); ++i) {
                int[] nArray2 = (int[])this.indicesList.get(i);
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            }
        }
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    private void setMaxCY3(float f) {
        this.maxCy3 = f;
    }

    private void setMaxCY5(float f) {
        this.maxCy5 = f;
    }

    public float getMaxCY3() {
        return this.maxCy3;
    }

    public float getMaxCY5() {
        return this.maxCy5;
    }

    private void setMaxRatio(float f) {
        this.maxRatio = f;
    }

    private void setMinRatio(float f) {
        this.minRatio = f;
    }

    public float getMaxRatio() {
        return this.maxRatio;
    }

    public float getMinRatio() {
        return this.minRatio;
    }

    void log2Transform() {
        Adjustment.log2Transform(this.experiment.getMatrix());
    }

    void normalizeSpots() {
        Adjustment.normalizeSpots(this.experiment.getMatrix());
    }

    void divideSpotsRMS() {
        Adjustment.divideSpotsRMS(this.experiment.getMatrix());
    }

    void divideSpotsSD() {
        Adjustment.divideSpotsSD(this.experiment.getMatrix());
    }

    void meanCenterSpots() {
        Adjustment.meanCenterSpots(this.experiment.getMatrix());
    }

    void medianCenterSpots() {
        Adjustment.medianCenterSpots(this.experiment.getMatrix());
    }

    void digitalSpots() {
        Adjustment.digitalSpots(this.experiment.getMatrix());
    }

    void normalizeExperiments() {
        Adjustment.normalizeExperiments(this.experiment.getMatrix());
    }

    void divideExperimentsRMS() {
        Adjustment.divideExperimentsRMS(this.experiment.getMatrix());
    }

    void divideExperimentsSD() {
        Adjustment.divideExperimentsSD(this.experiment.getMatrix());
    }

    void meanCenterExperiments() {
        Adjustment.meanCenterExperiments(this.experiment.getMatrix());
    }

    void medianCenterExperiments() {
        Adjustment.medianCenterExperiments(this.experiment.getMatrix());
    }

    void digitalExperiments() {
        Adjustment.digitalExperiments(this.experiment.getMatrix());
    }

    void log10toLog2() {
        Adjustment.log10toLog2(this.experiment.getMatrix());
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int n) {
        this.dataType = n;
        for (int i = 0; i < this.getFeaturesCount(); ++i) {
            ISlideData iSlideData = this.getFeature(i);
            iSlideData.setDataType(n);
        }
    }

    private class NormalizationListener
    extends DialogListener {
        private NormalizationListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                MultipleArrayData.this.normalizationAbort = true;
                MultipleArrayData.this.progressBar.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            MultipleArrayData.this.normalizationAbort = true;
            MultipleArrayData.this.progressBar.dispose();
        }
    }

    private class Normalizer {
        Properties properties;
        int mode;
        int size;
        MultipleArrayViewer viewer;

        public Normalizer(int n, Properties properties, int n2, MultipleArrayViewer multipleArrayViewer) {
            this.mode = n;
            this.properties = properties;
            this.size = n2;
            this.viewer = multipleArrayViewer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runNormalization() {
            try {
                ISlideData iSlideData;
                int n;
                MultipleArrayData.this.normalizationAbort = false;
                MultipleArrayData.this.progressBar = new Progress(new Frame(), "Normalization Progress", new NormalizationListener());
                MultipleArrayData.this.progressBar.show();
                MultipleArrayData.this.progressBar.setUnits(this.size);
                MultipleArrayData.this.progressBar.setValue(0);
                for (n = 0; n < this.size; ++n) {
                    MultipleArrayData.this.progressBar.setValue(n);
                    MultipleArrayData.this.progressBar.setDescription("Normalizing Experiment " + Integer.toString(n));
                    MultipleArrayData.this.progressBar.repaint();
                    iSlideData = MultipleArrayData.this.getFeature(n);
                    if (MultipleArrayData.this.normalizationAbort) break;
                    iSlideData.applyNormalization(this.mode, this.properties);
                    this.viewer.fireDataChanged();
                    MultipleArrayData.this.updateMaxValues(iSlideData);
                }
                if (MultipleArrayData.this.normalizationAbort) {
                    System.out.println("Abort");
                    MultipleArrayData.this.progressBar.setVisible(false);
                    MultipleArrayData.this.progressBar.dispose();
                    for (n = 0; n < this.size; ++n) {
                        iSlideData = MultipleArrayData.this.getFeature(n);
                        iSlideData.applyNormalization(0, this.properties);
                        MultipleArrayData.this.updateMaxValues(iSlideData);
                    }
                }
                MultipleArrayData.this.progressBar.dispose();
            }
            catch (Exception exception) {}
        }
    }
}

