/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.tigr.util.awt.GBA;

public class SetLowerCutoffsDialog
extends JDialog {
    private int result;
    private JTextField cy3TextField;
    private JTextField cy5TextField;

    public SetLowerCutoffsDialog(JFrame jFrame, float f, float f2) {
        super(jFrame, "Set Lower Cutoffs", true);
        Listener listener = new Listener();
        GBA gBA = new GBA();
        JLabel jLabel = new JLabel("Cy3 Lower Cutoff (" + f + "): ");
        this.cy3TextField = new JTextField(10);
        this.cy3TextField.addKeyListener(listener);
        this.cy3TextField.setText("" + f);
        JLabel jLabel2 = new JLabel("Cy5 Lower Cutoff (" + f2 + "): ");
        this.cy5TextField = new JTextField(10);
        this.cy5TextField.addKeyListener(listener);
        this.cy5TextField.setText("" + f2);
        JButton jButton = new JButton("Ok");
        jButton.setActionCommand("ok-command");
        jButton.addActionListener(listener);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("cancel-command");
        jButton2.addActionListener(listener);
        this.getContentPane().setLayout(new GridBagLayout());
        gBA.add(this.getContentPane(), jLabel, 0, 0, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.getContentPane(), this.cy3TextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.getContentPane(), jLabel2, 0, 1, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.getContentPane(), this.cy5TextField, 1, 1, 2, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.getContentPane(), jButton2, 0, 2, 1, 1, 0, 0, 0, 17, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.getContentPane(), jButton, 1, 2, 1, 1, 0, 0, 0, 13, new Insets(5, 5, 5, 5), 0, 0);
        this.addWindowListener(listener);
        this.pack();
        this.setResizable(false);
        this.cy3TextField.grabFocus();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public float getLowerCY3Cutoff() {
        return Float.parseFloat(this.cy3TextField.getText());
    }

    public float getLowerCY5Cutoff() {
        return Float.parseFloat(this.cy5TextField.getText());
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener,
    KeyListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                this.onOk();
            } else if (string.equals("cancel-command")) {
                SetLowerCutoffsDialog.this.result = 2;
                SetLowerCutoffsDialog.this.dispose();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                this.onOk();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            SetLowerCutoffsDialog.this.result = -1;
            SetLowerCutoffsDialog.this.dispose();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        private void onOk() {
            try {
                Float.parseFloat(SetLowerCutoffsDialog.this.cy3TextField.getText());
                Float.parseFloat(SetLowerCutoffsDialog.this.cy5TextField.getText());
                SetLowerCutoffsDialog.this.result = 0;
            }
            catch (Exception exception) {
                SetLowerCutoffsDialog.this.result = 2;
            }
            SetLowerCutoffsDialog.this.dispose();
        }
    }
}

