/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.tigr.graph.GraphBar;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.graph.GraphTick;
import org.tigr.graph.GraphViewer;
import org.tigr.microarray.mev.ArrayViewer;
import org.tigr.microarray.mev.ArrayViewerCanvas;
import org.tigr.microarray.mev.BlockGraphViewer;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.Manager;
import org.tigr.microarray.mev.SetConfidenceDialog;
import org.tigr.microarray.mev.SetDatabaseDialog;
import org.tigr.microarray.mev.SetGreenRedThresholdDialog;
import org.tigr.microarray.mev.SetMetaLocationDialog;
import org.tigr.microarray.mev.SetUpperLimitsDialog;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.util.SlideDataSorter;
import org.tigr.microarray.util.awt.SetSlideFilenameDialog;
import org.tigr.microarray.util.swing.SlideDataLoader;
import org.tigr.midas.mevdialogs.IterativeLogMCNormInitDialog;
import org.tigr.midas.mevdialogs.LinRegNormInitDialog;
import org.tigr.midas.mevdialogs.RatioStatsNormInitDialog;
import org.tigr.util.Xcon;
import org.tigr.util.awt.ActionInfoEvent;
import org.tigr.util.awt.ActionInfoListener;
import org.tigr.util.awt.GBA;
import org.tigr.util.awt.MessageDisplay;
import org.tigr.util.awt.ProgressBar;

public class SingleArrayViewer
extends ArrayViewer
implements Printable {
    private ISlideData slideData;
    private int[] indices;
    public SingleArrayViewerPanel panel;
    private SingleArrayViewerCanvas canvas;
    private SingleArrayViewerInfoBox infoBox;
    private EventListener eventListener = new EventListener();
    private GBA gba = new GBA();
    JScrollPane scrollPane;
    private int oldX = -1;
    private int oldY = -1;
    JMenuBar menuBar = null;
    JMenu fileMenu = null;
    JMenuItem newDatabaseItem = null;
    JMenuItem newFileItem = null;
    JMenuItem newSpotfireItem = null;
    JMenuItem newReportItem = null;
    JMenuItem saveImageItem = null;
    JMenuItem printImageItem = null;
    JMenuItem closeItem = null;
    JMenu viewsMenu = null;
    JMenu viewGraphMenu = null;
    JMenuItem newPlotItem = null;
    JMenuItem newPlotLogItem = null;
    JMenuItem newLogRatioProductItem = null;
    JMenuItem newLogRatioProductByBlockItem = null;
    JMenuItem newHistogramItem = null;
    JMenuItem newHistogramLogItem = null;
    JMenuItem subArrayItem = null;
    JMenuItem regionArrayItem = null;
    JMenu normalizationMenu = null;
    JRadioButtonMenuItem totalIntensityItem = null;
    JRadioButtonMenuItem leastSquaresItem = null;
    JRadioButtonMenuItem linearRegressionItem = null;
    JRadioButtonMenuItem ratioStatisticsItem = null;
    JRadioButtonMenuItem iterativeLogItem = null;
    JRadioButtonMenuItem totalIntensityListItem = null;
    JRadioButtonMenuItem leastSquaresListItem = null;
    JRadioButtonMenuItem linearRegressionListItem = null;
    JRadioButtonMenuItem ratioStatisticsListItem = null;
    JRadioButtonMenuItem iterativeLogListItem = null;
    JRadioButtonMenuItem noNormalizationItem = null;
    JMenu sortMenu = null;
    JRadioButtonMenuItem sortByLocationItem = null;
    JRadioButtonMenuItem sortByRatioItem = null;
    JRadioButtonMenuItem[] sortMenuItems = null;
    JMenu displayMenu = null;
    JCheckBoxMenuItem logItem = null;
    JMenu sizeMenu = null;
    JRadioButtonMenuItem defaultSize1Item = null;
    JRadioButtonMenuItem defaultSize2Item = null;
    JRadioButtonMenuItem defaultSize3Item = null;
    JRadioButtonMenuItem defaultSize4Item = null;
    JRadioButtonMenuItem setElementSizeItem = null;
    JCheckBoxMenuItem changeColorsItem = null;
    JRadioButtonMenuItem blueToRedItem = null;
    JRadioButtonMenuItem greenRedItem = null;
    JRadioButtonMenuItem overlayItem = null;
    JMenu controlMenu = null;
    JMenuItem setUpperLimitsItem = null;
    JMenuItem setGreenRedThresholdsItem = null;
    JMenuItem setConfidenceItem = null;
    JCheckBoxMenuItem setThresholdsItem = null;
    JCheckBoxMenuItem setScaleItem = null;
    ButtonGroup buttonGroup = null;
    private static final int startingXSize = 400;
    private static final int startingYSize = 400;
    private static final int LINEAR = 0;
    private static final int LOG = 1;

    public SingleArrayViewer(JFrame jFrame, ISlideData iSlideData) {
        super(jFrame);
        this.initializeViewer();
        this.initializePanel();
        this.initializeCanvas();
        this.initializeFrame();
        this.setSlideData(iSlideData);
        this.panel.setXYScrollbars((long)this.slideData.getMaxIntensity(0), (long)this.slideData.getMaxIntensity(1));
        this.systemEnable(1003);
    }

    public SingleArrayViewer(JFrame jFrame) {
        super(jFrame);
        this.initializeFrame();
        this.initializeViewer();
        this.initializePanel();
        this.initializeCanvas();
        this.systemDisable(1003);
        this.systemDisable(1002);
    }

    public SingleArrayViewer(ISlideData iSlideData) {
        super(new JFrame("Single Array Viewer"));
        this.setSlideData(iSlideData);
        this.initializeViewer();
        this.initializePanel();
        this.initializeCanvas();
        this.systemEnable(1003);
    }

    public SingleArrayViewer() {
        super(new JFrame("Single Array Viewer"));
        this.initializeViewer();
        this.initializePanel();
        this.initializeCanvas();
    }

    public JFrame getFrame() {
        return this.mainframe;
    }

    private int[] createIndices() {
        int[] nArray = new int[this.slideData.getSize()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private void initializeViewer() {
        this.setLayout(new GridBagLayout());
    }

    private void initializePanel() {
        this.panel = new SingleArrayViewerPanel();
        this.gba.add(this, this.panel, 0, 0, 1, 2, 0, 0, 0, 17, new Insets(5, 5, 5, 5), 0, 0);
        this.infoBox = new SingleArrayViewerInfoBox();
        this.gba.add(this, this.infoBox, 0, 2, 1, 1, 0, 0, 0, 16, new Insets(5, 5, 5, 5), 0, 0);
    }

    private void initializeCanvas() {
        this.canvas = new SingleArrayViewerCanvas(20, 20, 50, 20);
        this.canvas.addMouseListener(this.eventListener);
        this.canvas.addMouseMotionListener(this.eventListener);
        this.canvas.addKeyListener(this.eventListener);
        this.canvas.setBackground(Color.white);
        this.scrollPane = new JScrollPane(this.canvas, 22, 32);
        this.scrollPane.getViewport().setBackground(Color.white);
        this.scrollPane.getVerticalScrollBar().setToolTipText("Use up/down/pgup/pgdown to scroll image");
        this.gba.add(this, this.scrollPane, 1, 0, 1, 1, 1, 1, 1, 18);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(38, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(40, 0);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(33, 0);
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(34, 0);
        this.scrollPane.registerKeyboardAction(this.eventListener, "lineup", keyStroke, 2);
        this.scrollPane.registerKeyboardAction(this.eventListener, "linedown", keyStroke2, 2);
        this.scrollPane.registerKeyboardAction(this.eventListener, "pageup", keyStroke3, 2);
        this.scrollPane.registerKeyboardAction(this.eventListener, "pagedown", keyStroke4, 2);
    }

    private void initializeFrame() {
        this.mainframe.setTitle("Single Array Viewer");
        this.mainframe.getContentPane().setLayout(new GridBagLayout());
        this.mainframe.setResizable(true);
        this.mainframe.setBackground(Color.white);
        this.mainframe.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SingleArrayViewer.this.close();
            }
        });
        this.initializeMenuBar(this.mainframe);
        this.gba.add(this.mainframe.getContentPane(), this, 0, 0, 1, 1, 1, 1, 1, 10);
        this.mainframe.pack();
        this.newDatabaseItem.setEnabled(false);
        this.sortByLocationItem.setSelected(true);
        this.logItem.setSelected(false);
        this.changeColorsItem.setSelected(false);
        this.overlayItem.setSelected(true);
        this.setThresholdsItem.setSelected(false);
        this.setScaleItem.setSelected(true);
        this.noNormalizationItem.setSelected(true);
        this.setConfidenceItem.setEnabled(false);
        this.defaultSize3Item.setSelected(true);
    }

    private void initializeMenuBar(JFrame jFrame) {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.newDatabaseItem = new JMenuItem("Open Experiment from DB");
        this.newDatabaseItem.addActionListener(this.eventListener);
        this.fileMenu.add(this.newDatabaseItem);
        this.fileMenu.getMenuComponent(0).setEnabled(false);
        this.newFileItem = new JMenuItem("Open Experiment From File");
        this.newFileItem.addActionListener(this.eventListener);
        this.fileMenu.add(this.newFileItem);
        this.newReportItem = new JMenuItem("Generate Report");
        this.newReportItem.addActionListener(this.eventListener);
        this.fileMenu.add(this.newReportItem);
        this.fileMenu.addSeparator();
        this.saveImageItem = new JMenuItem("Save Image");
        this.saveImageItem.addActionListener(this.eventListener);
        this.fileMenu.add(this.saveImageItem);
        this.printImageItem = new JMenuItem("Print Image");
        this.printImageItem.addActionListener(this.eventListener);
        this.fileMenu.add(this.printImageItem);
        this.fileMenu.addSeparator();
        this.newSpotfireItem = new JMenuItem("Export to Spotfire");
        this.newSpotfireItem.addActionListener(this.eventListener);
        this.closeItem = new JMenuItem("Close");
        this.closeItem.addActionListener(this.eventListener);
        this.fileMenu.add(this.closeItem);
        this.menuBar.add(this.fileMenu);
        this.viewsMenu = new JMenu("Views");
        this.viewGraphMenu = new JMenu("View Graph");
        this.viewsMenu.add(this.viewGraphMenu);
        this.newPlotItem = new JMenuItem("Intensity Scatterplot");
        this.newPlotItem.addActionListener(this.eventListener);
        this.viewGraphMenu.add(this.newPlotItem);
        this.newPlotLogItem = new JMenuItem("Intensity Scatterplot (log)");
        this.newPlotLogItem.addActionListener(this.eventListener);
        this.viewGraphMenu.add(this.newPlotLogItem);
        this.newLogRatioProductItem = new JMenuItem("Log Ratio x Log Product");
        this.newLogRatioProductItem.addActionListener(this.eventListener);
        this.viewGraphMenu.add(this.newLogRatioProductItem);
        this.newLogRatioProductByBlockItem = new JMenuItem("Log Ratio x Log Product, by Metablock");
        this.newLogRatioProductByBlockItem.addActionListener(this.eventListener);
        this.viewGraphMenu.add(this.newLogRatioProductByBlockItem);
        this.newHistogramItem = new JMenuItem("Ratio Histogram");
        this.newHistogramItem.addActionListener(this.eventListener);
        this.viewGraphMenu.add(this.newHistogramItem);
        this.newHistogramLogItem = new JMenuItem("Ratio Histogram (log)");
        this.newHistogramLogItem.addActionListener(this.eventListener);
        this.viewGraphMenu.add(this.newHistogramLogItem);
        this.subArrayItem = new JMenuItem("View SubArray");
        this.subArrayItem.addActionListener(this.eventListener);
        this.viewsMenu.add(this.subArrayItem);
        this.regionArrayItem = new JMenuItem("View Region");
        this.regionArrayItem.addActionListener(this.eventListener);
        this.viewsMenu.add(this.regionArrayItem);
        this.menuBar.add(this.viewsMenu);
        this.buttonGroup = new ButtonGroup();
        this.normalizationMenu = new JMenu("Normalization");
        this.totalIntensityItem = new JRadioButtonMenuItem("Total Intensity");
        this.totalIntensityItem.addActionListener(this.eventListener);
        this.normalizationMenu.add(this.totalIntensityItem);
        this.buttonGroup.add(this.totalIntensityItem);
        this.linearRegressionItem = new JRadioButtonMenuItem("Linear Regression");
        this.linearRegressionItem.addActionListener(this.eventListener);
        this.normalizationMenu.add(this.linearRegressionItem);
        this.buttonGroup.add(this.linearRegressionItem);
        this.ratioStatisticsItem = new JRadioButtonMenuItem("Ratio Statistics");
        this.ratioStatisticsItem.addActionListener(this.eventListener);
        this.normalizationMenu.add(this.ratioStatisticsItem);
        this.buttonGroup.add(this.ratioStatisticsItem);
        this.iterativeLogItem = new JRadioButtonMenuItem("Iterative Log");
        this.iterativeLogItem.addActionListener(this.eventListener);
        this.normalizationMenu.add(this.iterativeLogItem);
        this.buttonGroup.add(this.iterativeLogItem);
        this.normalizationMenu.addSeparator();
        this.noNormalizationItem = new JRadioButtonMenuItem("No Normalization");
        this.noNormalizationItem.addActionListener(this.eventListener);
        this.normalizationMenu.add(this.noNormalizationItem);
        this.buttonGroup.add(this.noNormalizationItem);
        this.menuBar.add(this.normalizationMenu);
        this.buttonGroup = new ButtonGroup();
        this.sortMenu = new JMenu("Sort");
        this.sortByLocationItem = new JRadioButtonMenuItem("By Location");
        this.sortByLocationItem.addActionListener(this.eventListener);
        this.sortMenu.add(this.sortByLocationItem);
        this.buttonGroup.add(this.sortByLocationItem);
        this.sortByRatioItem = new JRadioButtonMenuItem("By Cy5/Cy3 Ratio");
        this.sortByRatioItem.addActionListener(this.eventListener);
        this.sortMenu.add(this.sortByRatioItem);
        this.buttonGroup.add(this.sortByRatioItem);
        if (TMEV.getFieldNames() != null) {
            this.addSortMenuItems(TMEV.getFieldNames(), this.buttonGroup);
        }
        this.menuBar.add(this.sortMenu);
        this.buttonGroup = new ButtonGroup();
        this.displayMenu = new JMenu("Display");
        this.blueToRedItem = new JRadioButtonMenuItem("Blue -> Red");
        this.blueToRedItem.addActionListener(this.eventListener);
        this.displayMenu.add(this.blueToRedItem);
        this.buttonGroup.add(this.blueToRedItem);
        this.greenRedItem = new JRadioButtonMenuItem("Green / Red");
        this.greenRedItem.addActionListener(this.eventListener);
        this.displayMenu.add(this.greenRedItem);
        this.buttonGroup.add(this.greenRedItem);
        this.overlayItem = new JRadioButtonMenuItem("G/R Overlay");
        this.overlayItem.addActionListener(this.eventListener);
        this.displayMenu.add(this.overlayItem);
        this.buttonGroup.add(this.overlayItem);
        this.displayMenu.addSeparator();
        this.logItem = new JCheckBoxMenuItem("Log Scale");
        this.logItem.addActionListener(this.eventListener);
        this.displayMenu.add(this.logItem);
        this.displayMenu.addSeparator();
        this.changeColorsItem = new JCheckBoxMenuItem("Change Colors");
        this.changeColorsItem.addActionListener(this.eventListener);
        this.displayMenu.add(this.changeColorsItem);
        this.displayMenu.addSeparator();
        this.sizeMenu = new JMenu("Element Size");
        this.sizeMenu.addActionListener(this.eventListener);
        this.displayMenu.add(this.sizeMenu);
        this.buttonGroup = new ButtonGroup();
        this.defaultSize1Item = new JRadioButtonMenuItem("5 x 2");
        this.defaultSize1Item.addActionListener(this.eventListener);
        this.sizeMenu.add(this.defaultSize1Item);
        this.buttonGroup.add(this.defaultSize1Item);
        this.defaultSize2Item = new JRadioButtonMenuItem("10 x 10");
        this.defaultSize2Item.addActionListener(this.eventListener);
        this.sizeMenu.add(this.defaultSize2Item);
        this.buttonGroup.add(this.defaultSize2Item);
        this.defaultSize3Item = new JRadioButtonMenuItem("20 x 5");
        this.defaultSize3Item.addActionListener(this.eventListener);
        this.sizeMenu.add(this.defaultSize3Item);
        this.buttonGroup.add(this.defaultSize3Item);
        this.defaultSize4Item = new JRadioButtonMenuItem("50 x 10");
        this.defaultSize4Item.addActionListener(this.eventListener);
        this.sizeMenu.add(this.defaultSize4Item);
        this.buttonGroup.add(this.defaultSize4Item);
        this.setElementSizeItem = new JRadioButtonMenuItem("Other");
        this.setElementSizeItem.addActionListener(this.eventListener);
        this.sizeMenu.add(this.setElementSizeItem);
        this.buttonGroup.add(this.setElementSizeItem);
        this.menuBar.add(this.displayMenu);
        this.controlMenu = new JMenu("Control");
        this.setUpperLimitsItem = new JMenuItem("Set Thresholds");
        this.setUpperLimitsItem.addActionListener(this.eventListener);
        this.controlMenu.add(this.setUpperLimitsItem);
        this.setGreenRedThresholdsItem = new JMenuItem("Set Expression Ratio");
        this.setGreenRedThresholdsItem.addActionListener(this.eventListener);
        this.controlMenu.add(this.setGreenRedThresholdsItem);
        this.setConfidenceItem = new JMenuItem("Set Confidence Level");
        this.setConfidenceItem.addActionListener(this.eventListener);
        this.controlMenu.add(this.setConfidenceItem);
        this.controlMenu.addSeparator();
        this.setThresholdsItem = new JCheckBoxMenuItem("Expression Ratio");
        this.setThresholdsItem.addActionListener(this.eventListener);
        this.controlMenu.add(this.setThresholdsItem);
        this.controlMenu.addSeparator();
        this.setScaleItem = new JCheckBoxMenuItem("G/R Scale");
        this.setScaleItem.addActionListener(this.eventListener);
        this.controlMenu.add(this.setScaleItem);
        this.menuBar.add(this.controlMenu);
        jFrame.setJMenuBar(this.menuBar);
    }

    public void addSortMenuItems(String[] stringArray, ButtonGroup buttonGroup) {
        this.sortMenuItems = new JRadioButtonMenuItem[stringArray.length];
        for (int i = 0; i < this.sortMenuItems.length; ++i) {
            this.sortMenuItems[i] = new JRadioButtonMenuItem("Sort by " + stringArray[i]);
            this.sortMenuItems[i].addActionListener(this.eventListener);
            this.sortMenu.add(this.sortMenuItems[i]);
            buttonGroup.add(this.sortMenuItems[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISlideData loadDataFromDatabase() {
        ISlideData iSlideData = null;
        try {
            SetSlideFilenameDialog setSlideFilenameDialog = new SetSlideFilenameDialog((Frame)this.mainframe, new String[0]);
            if (setSlideFilenameDialog.showModal() == 0) {
                String string = setSlideFilenameDialog.getFileName();
                this.loadDataFromDatabase(string);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception (SingleArrayViewer.loadDataFromDatabase()): " + exception);
            exception.printStackTrace();
        }
        finally {
            return iSlideData;
        }
    }

    public void loadDataFromDatabase(String string) {
    }

    public void loadFile() {
        Object object;
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir") + "\\Preferences");
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName();
                if (string.endsWith("Preferences")) {
                    return true;
                }
                if (string.endsWith("preferences")) {
                    return true;
                }
                return string.endsWith(".pref");
            }

            public String getDescription() {
                return "Preference Files";
            }
        };
        jFileChooser.setFileFilter(fileFilter);
        int n = jFileChooser.showDialog(this, "Select");
        if (n == 0) {
            object = jFileChooser.getSelectedFile();
            TMEV.readPreferencesFile((File)object);
        }
        try {
            object = this.loadSlideData(null);
            if (object != null) {
                this.setSlideData((ISlideData)object);
                this.panel.setXYScrollbars((long)object.getMaxIntensity(0), (long)object.getMaxIntensity(1));
                this.refreshSlide();
            }
        }
        catch (Exception exception) {
            Manager.message(this.getFrame(), exception);
        }
    }

    public ISlideData getSlideData() {
        return this.slideData;
    }

    public void setSlideData(ISlideData iSlideData) {
        if (iSlideData instanceof SlideData) {
            SlideData slideData = (SlideData)((SlideData)iSlideData).clone();
            this.slideData = SlideDataLoader.fillBlankSpots(slideData);
        } else if (iSlideData instanceof FloatSlideData) {
            this.slideData = new SlideData(iSlideData);
            this.slideData = SlideDataLoader.fillBlankSpots(this.slideData);
        } else {
            this.slideData = iSlideData;
        }
        this.indices = this.createIndices();
        this.canvas.updateSizes();
    }

    public void createSubArray() {
        double d = this.canvas.getLowDifference();
        double d2 = this.canvas.getHighDifference();
        String string = this.canvas.getThresholds() ? "SubArray: Lower " + Math.rint(d * 100.0) / 100.0 + ", Higher " + Math.rint(d2 * 100.0) / 100.0 : "SubArray: No Thresholds";
        JFrame jFrame = new JFrame(string);
        SingleArrayViewer singleArrayViewer = new SingleArrayViewer(jFrame);
        singleArrayViewer.changePaletteStyle(this.canvas.getPaletteStyle());
        singleArrayViewer.setThresholds(this.canvas.getThresholds());
        singleArrayViewer.canvas.setScale(this.canvas.getScale());
        if (this.canvas.getThresholds()) {
            int n;
            int n2;
            ISlideDataElement iSlideDataElement;
            int n3;
            Vector<ISlideDataElement> vector = new Vector<ISlideDataElement>();
            for (n3 = 0; n3 < this.indices.length; ++n3) {
                try {
                    ISlideDataElement iSlideDataElement2 = this.slideData.getSlideDataElement(this.indices[n3]);
                    iSlideDataElement = new SlideDataElement(new int[]{iSlideDataElement2.getRow(0), iSlideDataElement2.getRow(1), iSlideDataElement2.getRow(2)}, new int[]{iSlideDataElement2.getColumn(0), iSlideDataElement2.getColumn(1), iSlideDataElement2.getColumn(2)}, new float[]{iSlideDataElement2.getIntensity(0), iSlideDataElement2.getIntensity(1)}, iSlideDataElement2.getExtraFields());
                    n2 = (int)iSlideDataElement.getIntensity(0);
                    n = (int)iSlideDataElement.getIntensity(1);
                    if (n2 + n <= 0 || !((double)n2 / (double)(n2 + n) > d2) && !((double)n2 / (double)(n2 + n) < d)) continue;
                    vector.addElement(iSlideDataElement);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    nullPointerException.printStackTrace();
                }
            }
            if (vector.size() > 0) {
                n3 = (int)Math.ceil(Math.sqrt(vector.size() / 6));
                n2 = n3 * 6;
                while (n3 * n2 - vector.size() >= n3) {
                    --n2;
                }
                SlideData slideData = new SlideData(n2, n3);
                slideData.setSlideDataName(this.slideData.getSlideDataName());
                slideData.setNormalizedState(this.slideData.getNormalizedState());
                n = slideData.getSlideMetaData().getColumns();
                for (int i = 0; i < vector.size(); ++i) {
                    try {
                        iSlideDataElement = (ISlideDataElement)vector.elementAt(i);
                        iSlideDataElement.setColumn(0, i % n + 1);
                        iSlideDataElement.setRow(0, i / n + 1);
                        slideData.addSlideDataElement(iSlideDataElement);
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("Exception (SingleArrayViewer.createSubArray(): " + exception);
                        exception.printStackTrace();
                    }
                }
                singleArrayViewer.setSlideData(slideData);
                singleArrayViewer.setUpperLimits(this.canvas.getTopCy3(), this.canvas.getTopCy5());
                singleArrayViewer.panel.setXYScrollbars((long)this.slideData.getMaxIntensity(0), (long)this.slideData.getMaxIntensity(1));
                singleArrayViewer.panel.updateXUpperLimitScrollbar((long)this.canvas.getTopCy3());
                singleArrayViewer.panel.updateYUpperLimitScrollbar((long)this.canvas.getTopCy5());
                jFrame.setSize(650, 650);
                jFrame.setLocation(150, 150);
                jFrame.setVisible(true);
            }
        } else {
            singleArrayViewer.setSlideData(this.slideData);
            singleArrayViewer.setUpperLimits(this.canvas.getTopCy3(), this.canvas.getTopCy5());
            singleArrayViewer.panel.setXYScrollbars((long)this.slideData.getMaxIntensity(0), (long)this.slideData.getMaxIntensity(1));
            singleArrayViewer.panel.updateXUpperLimitScrollbar((long)this.canvas.getTopCy3());
            singleArrayViewer.panel.updateYUpperLimitScrollbar((long)this.canvas.getTopCy5());
            jFrame.setSize(650, 650);
            jFrame.setLocation(150, 150);
            jFrame.setVisible(true);
        }
    }

    public void createRegion(int n, int n2) {
        ISlideDataElement iSlideDataElement;
        int n3 = 0;
        int n4 = 0;
        Vector<ISlideDataElement> vector = new Vector<ISlideDataElement>();
        for (int i = 0; i < this.indices.length; ++i) {
            try {
                ISlideDataElement iSlideDataElement2 = this.slideData.getSlideDataElement(this.indices[i]);
                iSlideDataElement = new SlideDataElement(new int[]{iSlideDataElement2.getRow(0), iSlideDataElement2.getRow(1), iSlideDataElement2.getRow(2)}, new int[]{iSlideDataElement2.getColumn(0), iSlideDataElement2.getColumn(1), iSlideDataElement2.getColumn(2)}, new float[]{iSlideDataElement2.getIntensity(0), iSlideDataElement2.getIntensity(1)}, iSlideDataElement2.getExtraFields());
                if (iSlideDataElement.getRow(1) != n || iSlideDataElement.getColumn(1) != n2) continue;
                vector.addElement(iSlideDataElement);
                if (iSlideDataElement.getRow(2) > n3) {
                    n3 = iSlideDataElement.getRow(2);
                }
                if (iSlideDataElement.getColumn(2) <= n4) continue;
                n4 = iSlideDataElement.getColumn(2);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
        }
        if (vector.size() > 0) {
            JFrame jFrame = new JFrame("Region: MetaColumn " + n2 + ", MetaRow " + n);
            SingleArrayViewer singleArrayViewer = new SingleArrayViewer(jFrame);
            singleArrayViewer.changePaletteStyle(this.canvas.getPaletteStyle());
            singleArrayViewer.setThresholds(this.canvas.getThresholds());
            singleArrayViewer.canvas.setScale(this.canvas.getScale());
            SlideData slideData = new SlideData(n4, n3);
            slideData.setSlideDataName(this.slideData.getSlideDataName());
            slideData.setNormalizedState(this.slideData.getNormalizedState());
            int n5 = slideData.getSlideMetaData().getColumns();
            for (int i = 0; i < vector.size(); ++i) {
                try {
                    iSlideDataElement = (ISlideDataElement)vector.elementAt(i);
                    iSlideDataElement.setColumn(0, i % n5 + 1);
                    iSlideDataElement.setRow(0, i / n5 + 1);
                    slideData.addSlideDataElement(iSlideDataElement);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Exception (SingleArrayViewer.createRegion(): " + exception);
                }
            }
            singleArrayViewer.setSlideData(slideData);
            singleArrayViewer.setUpperLimits(this.canvas.getTopCy3(), this.canvas.getTopCy5());
            singleArrayViewer.panel.setXYScrollbars((long)this.slideData.getMaxIntensity(0), (long)this.slideData.getMaxIntensity(1));
            singleArrayViewer.panel.updateXUpperLimitScrollbar((long)this.canvas.getTopCy3());
            singleArrayViewer.panel.updateYUpperLimitScrollbar((long)this.canvas.getTopCy5());
            jFrame.setSize(650, 650);
            jFrame.setLocation(150, 150);
            jFrame.setVisible(true);
        } else {
            MessageDisplay messageDisplay = new MessageDisplay((JFrame)this.getParent(), "No region: Row " + n + ", Column " + n2, "");
        }
    }

    public void setReportFilename() {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setDialogTitle("Choose a Report Name");
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setCurrentDirectory(new File("Data"));
        if (jFileChooser.showSaveDialog(this.getParent()) == 0) {
            this.generateReport(jFileChooser.getSelectedFile());
        }
    }

    public void generateReport(final File file) {
        Thread thread = new Thread(){

            public void run() {
                JDialog jDialog;
                String string = file.getName();
                Object var2_2 = null;
                PrintStream printStream = null;
                String string2 = "";
                try {
                    printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
                }
                catch (IOException iOException) {
                    jDialog = new MessageDisplay(SingleArrayViewer.this.getFrame(), "Can't write output file: " + string, "");
                }
                try {
                    int n = SingleArrayViewer.this.slideData.getSize();
                    jDialog = new ProgressBar(SingleArrayViewer.this.getFrame(), "Writing report: " + string, Color.green, Color.green, Color.black, n);
                    ((ProgressBar)jDialog).drawProgressBar();
                    printStream.println("Report for SlideFile: " + SingleArrayViewer.this.slideData.getSlideDataName());
                    printStream.println("Normalization: " + SlideData.normalizationString(SingleArrayViewer.this.slideData.getNormalizedState()) + "\tThresholds: " + SingleArrayViewer.this.canvas.getLowDifference() + "/" + SingleArrayViewer.this.canvas.getHighDifference());
                    string2 = "Row\tColumn\tMetaRow\tMetaColumn\tSubRow\tSubColumn\tCy3\tCy5\tCy5/Cy3";
                    for (int i = 0; i < TMEV.getFieldNames().length; ++i) {
                        string2 = string2 + "\t" + TMEV.getFieldNames()[i];
                    }
                    printStream.println(string2);
                    for (int i = 0; i < SingleArrayViewer.this.indices.length; ++i) {
                        string2 = "";
                        ISlideDataElement iSlideDataElement = SingleArrayViewer.this.slideData.getSlideDataElement(SingleArrayViewer.this.indices[i]);
                        if (iSlideDataElement != null) {
                            for (int j = 0; j < TMEV.getFieldNames().length; ++j) {
                                string2 = string2 + "\t" + iSlideDataElement.getFieldAt(j);
                            }
                            float f = iSlideDataElement.getIntensity(0);
                            float f2 = iSlideDataElement.getIntensity(1);
                            if (SingleArrayViewer.this.canvas.getThresholds()) {
                                if (f + f2 > 0.0f && ((double)(f / (f + f2)) > SingleArrayViewer.this.canvas.getHighDifference() || (double)(f / (f + f2)) < SingleArrayViewer.this.canvas.getLowDifference())) {
                                    printStream.println(iSlideDataElement.getRow(0) + "\t" + iSlideDataElement.getColumn(0) + "\t" + iSlideDataElement.getRow(1) + "\t" + iSlideDataElement.getColumn(1) + "\t" + iSlideDataElement.getRow(2) + "\t" + iSlideDataElement.getColumn(2) + "\t" + f + "\t" + f2 + "\t" + iSlideDataElement.getRatio(1, 0, 0) + string2);
                                }
                            } else {
                                printStream.println(iSlideDataElement.getRow(0) + "\t" + iSlideDataElement.getColumn(0) + "\t" + iSlideDataElement.getRow(1) + "\t" + iSlideDataElement.getColumn(1) + "\t" + iSlideDataElement.getRow(2) + "\t" + iSlideDataElement.getColumn(2) + "\t" + f + "\t" + f2 + "\t" + iSlideDataElement.getRatio(1, 0, 0) + string2);
                            }
                        }
                        ((ProgressBar)jDialog).increment(1);
                    }
                    printStream.close();
                }
                catch (Exception exception) {
                    jDialog = new MessageDisplay(SingleArrayViewer.this.getFrame(), "Can't write: " + string, "");
                }
            }
        };
        thread.setPriority(1);
        thread.run();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void normalizeData(int n) {
        Properties properties = new Properties();
        if (n == 3) {
            LinRegNormInitDialog linRegNormInitDialog = new LinRegNormInitDialog();
            if (linRegNormInitDialog.showModal() != 0) return;
            properties.setProperty("standard-deviation", Double.toString(linRegNormInitDialog.getSD()));
            properties.setProperty("mode", linRegNormInitDialog.getMode());
            linRegNormInitDialog.dispose();
        } else if (n == 4 || n == 5) {
            RatioStatsNormInitDialog ratioStatsNormInitDialog = new RatioStatsNormInitDialog();
            if (ratioStatsNormInitDialog.showModal() != 0) return;
            properties.setProperty("confidence-interval", Integer.toString(ratioStatsNormInitDialog.getCI()));
            ratioStatsNormInitDialog.dispose();
        } else if (n == 6) {
            IterativeLogMCNormInitDialog iterativeLogMCNormInitDialog = new IterativeLogMCNormInitDialog();
            if (iterativeLogMCNormInitDialog.showModal() != 0) return;
            properties.setProperty("standard-deviation", Double.toString(iterativeLogMCNormInitDialog.getSD()));
            iterativeLogMCNormInitDialog.dispose();
        }
        this.setCursor(3);
        this.slideData.applyNormalization(n, properties);
        this.refreshSlide();
        this.setCursor(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void normalizeDataList(int n) {
        this.setCursor(3);
        Properties properties = new Properties();
        if (n == 3) {
            LinRegNormInitDialog linRegNormInitDialog = new LinRegNormInitDialog();
            if (linRegNormInitDialog.showModal() != 0) return;
            properties.setProperty("standard-deviation", Double.toString(linRegNormInitDialog.getSD()));
            properties.setProperty("mode", linRegNormInitDialog.getMode());
            linRegNormInitDialog.dispose();
        } else if (n == 4 || n == 5) {
            RatioStatsNormInitDialog ratioStatsNormInitDialog = new RatioStatsNormInitDialog();
            if (ratioStatsNormInitDialog.showModal() != 0) return;
            properties.setProperty("confidence-interval", Integer.toString(ratioStatsNormInitDialog.getCI()));
            ratioStatsNormInitDialog.dispose();
        } else if (n == 6) {
            IterativeLogMCNormInitDialog iterativeLogMCNormInitDialog = new IterativeLogMCNormInitDialog();
            if (iterativeLogMCNormInitDialog.showModal() != 0) return;
            properties.setProperty("standard-deviation", Double.toString(iterativeLogMCNormInitDialog.getSD()));
            iterativeLogMCNormInitDialog.dispose();
        }
        this.slideData.applyNormalization(n, properties);
        this.refreshSlide();
        this.setCursor(0);
    }

    public void refreshSlide() {
        this.systemEnable(1003);
        this.repaint();
    }

    public void createScatterPlot(int n) {
        try {
            if (n == 1) {
                GraphTick graphTick;
                int n2;
                GraphLine graphLine;
                int n3;
                int n4 = (int)Xcon.log10(this.slideData.getMaxIntensity(0)) + 1;
                int n5 = (int)Xcon.log10(this.slideData.getMaxIntensity(1)) + 1;
                int n6 = (int)Xcon.log10(this.slideData.getMinIntensity(0, false));
                int n7 = (int)Xcon.log10(this.slideData.getMinIntensity(1, false));
                int n8 = n4 - n6;
                int n9 = n5 - n7;
                JFrame jFrame = new JFrame("Log Cy3 vs. Log Cy5");
                GraphViewer graphViewer = new GraphViewer(jFrame, 0, 500, 0, 500, n6, n4, n7, n5, 100, 100, 100, 100, "Log Cy3 vs. Log Cy5 - " + SlideData.normalizationString(this.slideData.getNormalizedState()), "Log Cy3", "Log Cy5");
                graphViewer.setXAxisValue(n7);
                graphViewer.setYAxisValue(n6);
                for (n3 = n6 + 1; n3 <= n4; ++n3) {
                    graphLine = new GraphLine(n3, n7, n3, n5, Color.yellow);
                    graphViewer.addGraphElement(graphLine);
                }
                for (n3 = n7 + 1; n3 <= n5; ++n3) {
                    graphLine = new GraphLine(n6, n3, n4, n3, Color.yellow);
                    graphViewer.addGraphElement(graphLine);
                }
                for (n2 = 0; n2 < this.indices.length; ++n2) {
                    GraphPoint graphPoint;
                    ISlideDataElement iSlideDataElement = this.slideData.getSlideDataElement(this.indices[n2]);
                    float f = iSlideDataElement.getIntensity(0);
                    float f2 = iSlideDataElement.getIntensity(1);
                    double d = Xcon.log10(f);
                    double d2 = Xcon.log10(f2);
                    if (this.canvas.thresholdsOn) {
                        if (f + f2 > 0.0f && ((double)(f / (f + f2)) > this.canvas.highDifference || (double)f / (double)(f + f2) < this.canvas.lowDifference)) {
                            graphPoint = new GraphPoint(d, d2, Color.red, 3);
                            graphViewer.addGraphElement(graphPoint);
                            continue;
                        }
                        graphPoint = new GraphPoint(d, d2, Color.blue, 3);
                        graphViewer.addGraphElement(graphPoint);
                        continue;
                    }
                    graphPoint = new GraphPoint(d, d2, Color.blue, 3);
                    graphViewer.addGraphElement(graphPoint);
                }
                for (n2 = n7; n2 <= n5; ++n2) {
                    graphTick = new GraphTick(n2, 8, Color.black, 1, 0, "1.0E" + n2, Color.black);
                    graphViewer.addGraphElement(graphTick);
                }
                for (n2 = n6; n2 <= n4; ++n2) {
                    graphTick = new GraphTick(n2, 8, Color.black, 0, 0, "1.0E" + n2, Color.black);
                    graphViewer.addGraphElement(graphTick);
                }
                jFrame.setSize(500, 500);
                graphViewer.setVisible(true);
            } else if (n == 0) {
                int n10;
                float f = this.slideData.getMaxIntensity(0);
                float f3 = this.slideData.getMaxIntensity(1);
                float f4 = f;
                float f5 = f3;
                long l = 0L;
                long l2 = 0L;
                int n11 = 0;
                while (!(f4 < 10.0f) || !(f4 > 0.0f)) {
                    f4 /= 10.0f;
                    ++n11;
                }
                l = (long)((double)((int)(f4 * 10.0f)) * Math.pow(10.0, n11 - 2));
                n11 = 0;
                while (!(f5 < 10.0f) || !(f5 > 0.0f)) {
                    f5 /= 10.0f;
                    ++n11;
                }
                l2 = (long)((double)((int)(f5 * 10.0f)) * Math.pow(10.0, n11 - 2));
                f = l * 11L;
                f3 = l2 * 11L;
                JFrame jFrame = new JFrame("Cy3 vs. Cy5");
                GraphViewer graphViewer = new GraphViewer(jFrame, 0, 500, 0, 500, 0.0, f, 0.0, f3, 75, 75, 75, 75, "Cy3 vs. Cy5 - " + SlideData.normalizationString(this.slideData.getNormalizedState()), "Cy3", "Cy5");
                for (int i = 1; i < 12; ++i) {
                    GraphLine graphLine = new GraphLine(0.0, (long)i * l2, f, (long)i * l2, Color.yellow);
                    graphViewer.addGraphElement(graphLine);
                    graphLine = new GraphLine((long)i * l, 0.0, (long)i * l, f3, Color.yellow);
                    graphViewer.addGraphElement(graphLine);
                }
                for (n10 = 0; n10 < this.indices.length; ++n10) {
                    GraphPoint graphPoint;
                    ISlideDataElement iSlideDataElement = this.slideData.getSlideDataElement(this.indices[n10]);
                    float f6 = iSlideDataElement.getIntensity(0);
                    float f7 = iSlideDataElement.getIntensity(1);
                    if (this.canvas.thresholdsOn) {
                        if (f6 + f7 > 0.0f && ((double)(f6 / (f6 + f7)) > this.canvas.highDifference || (double)f6 / (double)(f6 + f7) < this.canvas.lowDifference)) {
                            graphPoint = new GraphPoint(f6, f7, Color.red, 3);
                            graphViewer.addGraphElement(graphPoint);
                            continue;
                        }
                        graphPoint = new GraphPoint(f6, f7, Color.blue, 3);
                        graphViewer.addGraphElement(graphPoint);
                        continue;
                    }
                    graphPoint = new GraphPoint(f6, f7, Color.blue, 3);
                    graphViewer.addGraphElement(graphPoint);
                }
                for (n10 = 0; n10 < 12; ++n10) {
                    GraphTick graphTick = new GraphTick((long)n10 * l, 8, Color.black, 0, 0, "" + (long)n10 * l, Color.black);
                    graphViewer.addGraphElement(graphTick);
                    graphTick = new GraphTick((long)n10 * l2, 8, Color.black, 1, 0, "" + (long)n10 * l2, Color.black);
                    graphViewer.addGraphElement(graphTick);
                }
                jFrame.setSize(500, 500);
                graphViewer.setVisible(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void createRatioProductPlotByBlock() {
        try {
            GraphTick graphTick;
            int n;
            GraphLine graphLine;
            int n2;
            int n3 = (int)Xcon.log10(this.slideData.getMaxProduct(0, 1)) + 1;
            int n4 = (int)Xcon.log10(this.slideData.getMaxRatio(1, 0, 0)) + 1;
            int n5 = (int)Xcon.log10(this.slideData.getMinProduct(0, 1, false, 2));
            int n6 = (int)Xcon.log10(this.slideData.getMinRatio(1, 0, 0));
            int n7 = n3 - n5;
            int n8 = n4 - n6;
            int n9 = this.slideData.getSlideDataElement(this.slideData.getSize() - 1).getRow(1);
            int n10 = this.slideData.getSlideDataElement(this.slideData.getSize() - 1).getColumn(1);
            JFrame jFrame = new JFrame("Log Product vs. Log Ratio, by Metablock");
            BlockGraphViewer blockGraphViewer = new BlockGraphViewer(jFrame, n9, n10, 0, 500, 0, 500, n5, n3, n6, n4, 100, 100, 100, 100, "Log Product vs. Log Ratio - " + SlideData.normalizationString(this.slideData.getNormalizedState()), "Log (Cy3 x Cy5)", "Log (Cy5 / Cy3)");
            blockGraphViewer.setXAxisValue(0.0);
            blockGraphViewer.setYAxisValue(n5);
            for (n2 = n5 + 1; n2 <= n3; ++n2) {
                graphLine = new GraphLine(n2, n6, n2, n4, Color.yellow);
                blockGraphViewer.addGraphElement(graphLine);
            }
            for (n2 = n6; n2 <= n4; ++n2) {
                if (n2 == 0) continue;
                graphLine = new GraphLine(n5, n2, n3, n2, Color.yellow);
                blockGraphViewer.addGraphElement(graphLine);
            }
            Color[] colorArray = blockGraphViewer.getColors();
            for (n = 0; n < this.indices.length; ++n) {
                ISlideDataElement iSlideDataElement = this.slideData.getSlideDataElement(this.indices[n]);
                float f = iSlideDataElement.getIntensity(0);
                float f2 = iSlideDataElement.getIntensity(1);
                int n11 = iSlideDataElement.getRow(1);
                int n12 = iSlideDataElement.getColumn(1);
                int n13 = n11 * n12 + (n11 - 1) * (n10 - n12) - 1;
                double d = Xcon.log10(f * f2);
                double d2 = Xcon.log10((double)f2 / (double)f);
                GraphPoint graphPoint = n13 < colorArray.length ? new GraphPoint(d, d2, colorArray[n13], 3) : new GraphPoint(d, d2, Color.black, 3);
                blockGraphViewer.addGraphElement(graphPoint);
            }
            for (n = n6; n <= n4; ++n) {
                graphTick = n == 0 ? new GraphTick(n, 8, Color.black, 1, 0, "0" + n, Color.black) : new GraphTick(n, 8, Color.black, 1, 0, "1.0E" + n, Color.black);
                blockGraphViewer.addGraphElement(graphTick);
            }
            for (n = n5; n <= n3; ++n) {
                graphTick = n == 0 ? new GraphTick(n, 8, Color.black, 0, 0, "0" + n, Color.black) : new GraphTick(n, 8, Color.black, 0, 0, "1.0E" + n, Color.black);
                blockGraphViewer.addGraphElement(graphTick);
            }
            jFrame.setSize(500, 500);
            blockGraphViewer.setVisible(true);
        }
        catch (Exception exception) {
            System.out.println("Exception (createRatioProduct()): " + exception);
            exception.printStackTrace();
        }
    }

    public void createRatioProductPlot() {
        try {
            GraphTick graphTick;
            int n;
            GraphLine graphLine;
            int n2;
            int n3 = (int)Xcon.log10(this.slideData.getMaxProduct(0, 1)) + 1;
            int n4 = (int)Xcon.log10(this.slideData.getMaxRatio(1, 0, 0)) + 1;
            int n5 = (int)Xcon.log10(this.slideData.getMinProduct(0, 1, false));
            int n6 = (int)Xcon.log10(this.slideData.getMinRatio(1, 0, 0));
            int n7 = n3 - n5;
            int n8 = n4 - n6;
            JFrame jFrame = new JFrame("Log Product vs. Log Ratio");
            GraphViewer graphViewer = new GraphViewer(jFrame, 0, 500, 0, 500, n5, n3, n6, n4, 100, 100, 100, 100, "Log Product vs. Log Ratio - " + SlideData.normalizationString(this.slideData.getNormalizedState()), "Log (Cy3 x Cy5)", "Log (Cy5 / Cy3)");
            graphViewer.setXAxisValue(0.0);
            graphViewer.setYAxisValue(n5);
            for (n2 = n5 + 1; n2 <= n3; ++n2) {
                graphLine = new GraphLine(n2, n6, n2, n4, Color.yellow);
                graphViewer.addGraphElement(graphLine);
            }
            for (n2 = n6; n2 <= n4; ++n2) {
                if (n2 == 0) continue;
                graphLine = new GraphLine(n5, n2, n3, n2, Color.yellow);
                graphViewer.addGraphElement(graphLine);
            }
            for (n = 0; n < this.indices.length; ++n) {
                GraphPoint graphPoint;
                ISlideDataElement iSlideDataElement = this.slideData.getSlideDataElement(this.indices[n]);
                float f = iSlideDataElement.getIntensity(0);
                float f2 = iSlideDataElement.getIntensity(1);
                double d = Xcon.log10(f * f2);
                double d2 = Xcon.log10(f2 / f);
                if (this.canvas.thresholdsOn) {
                    if (f + f2 > 0.0f && ((double)(f / (f + f2)) > this.canvas.highDifference || (double)f / (double)(f + f2) < this.canvas.lowDifference)) {
                        graphPoint = new GraphPoint(d, d2, Color.red, 3);
                        graphViewer.addGraphElement(graphPoint);
                        continue;
                    }
                    graphPoint = new GraphPoint(d, d2, Color.blue, 3);
                    graphViewer.addGraphElement(graphPoint);
                    continue;
                }
                graphPoint = new GraphPoint(d, d2, Color.blue, 3);
                graphViewer.addGraphElement(graphPoint);
            }
            for (n = n6; n <= n4; ++n) {
                graphTick = n == 0 ? new GraphTick(n, 8, Color.black, 1, 0, "0" + n, Color.black) : new GraphTick(n, 8, Color.black, 1, 0, "1.0E" + n, Color.black);
                graphViewer.addGraphElement(graphTick);
            }
            for (n = n5; n <= n3; ++n) {
                graphTick = n == 0 ? new GraphTick(n, 8, Color.black, 0, 0, "0" + n, Color.black) : new GraphTick(n, 8, Color.black, 0, 0, "1.0E" + n, Color.black);
                graphViewer.addGraphElement(graphTick);
            }
            jFrame.setSize(500, 500);
            graphViewer.setVisible(true);
        }
        catch (Exception exception) {
            System.out.println("Exception (createRatioProduct()): " + exception);
        }
    }

    public void createHistogram(int n) {
        try {
            if (n == 1) {
                int n2;
                int n3;
                int n4;
                int n5 = 103;
                double d = 0.0;
                double d2 = -5.0;
                double d3 = 5.0;
                double d4 = 0.0;
                int n6 = 0;
                int[] nArray = new int[n5];
                double d5 = 0.0;
                if (n5 % 2 == 1) {
                    d = (d3 - d2) / (double)(n5 - 3);
                }
                for (n4 = 0; n4 < this.indices.length; ++n4) {
                    ISlideDataElement iSlideDataElement = this.slideData.getSlideDataElement(this.indices[n4]);
                    d4 = iSlideDataElement.getRatio(1, 0, 1);
                    for (n3 = 0; n3 < n5; ++n3) {
                        double d6;
                        double d7;
                        if (n3 == 0) {
                            d7 = Double.MIN_VALUE;
                            d6 = d2 - d / 2.0;
                        } else if (n3 == n5 - 1) {
                            d7 = d3 + d / 2.0;
                            d6 = Double.MAX_VALUE;
                        } else {
                            d7 = d2 - d / 2.0 + (double)(n3 - 1) * d;
                            d6 = d7 + d;
                        }
                        if (!(d4 >= d7) || !(d4 <= d6) || !iSlideDataElement.hasNoZeros()) continue;
                        int n7 = n3;
                        nArray[n7] = nArray[n7] + 1;
                    }
                }
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    if (n6 >= nArray[n4]) continue;
                    n6 = nArray[n4];
                }
                n3 = 0;
                float f = n6;
                n4 = 0;
                while (!(f < 10.0f) || !(f > 0.0f)) {
                    f /= 10.0f;
                    ++n4;
                }
                n3 = (int)((double)((int)(f * 10.0f)) * Math.pow(10.0, n4 - 2));
                n6 = n3 * 11;
                JFrame jFrame = new JFrame("Log (Cy5 / Cy3)");
                GraphViewer graphViewer = new GraphViewer(jFrame, 0, 500, 0, 500, d2 - 3.0 * d / 2.0, d3 + 3.0 * d / 2.0, 0.0, n6, 75, 75, 75, 75, "Log (Cy5 / Cy3) - " + SlideData.normalizationString(this.slideData.getNormalizedState()), "Ratio", "Count");
                for (int i = 1; i < 12; ++i) {
                }
                double d8 = Math.log(1.0f / this.canvas.getFactor());
                double d9 = Math.log(this.canvas.getFactor());
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    GraphBar graphBar = this.canvas.thresholdsOn ? (d2 + (double)(n2 - 1) * d <= d8 || d2 + (double)(n2 - 1) * d >= d9 ? new GraphBar(d2 - 3.0 * d / 2.0 + (double)n2 * d, d2 - d / 2.0 + (double)n2 * d, nArray[n2], Color.red, 0, 0) : new GraphBar(d2 - 3.0 * d / 2.0 + (double)n2 * d, d2 - d / 2.0 + (double)n2 * d, nArray[n2], Color.blue, 0, 0)) : new GraphBar(d2 - 3.0 * d / 2.0 + (double)n2 * d, d2 - d / 2.0 + (double)n2 * d, nArray[n2], Color.blue, 0, 0);
                    graphViewer.addGraphElement(graphBar);
                }
                d5 = d2 - 3.0 * d / 2.0 + 0.0 * d;
                GraphTick graphTick = new GraphTick(d5, 8, Color.black, 0, 0, "Minimum", Color.black);
                graphViewer.addGraphElement(graphTick);
                d5 = d2 - 3.0 * d / 2.0 + (double)nArray.length * d;
                graphTick = new GraphTick(d5, 8, Color.black, 0, 0, "Maximum", Color.black);
                graphViewer.addGraphElement(graphTick);
                for (n2 = (int)d2; n2 <= (int)d3; ++n2) {
                    graphTick = new GraphTick(n2, 8, Color.black, 0, 0, "" + n2, Color.black);
                    graphViewer.addGraphElement(graphTick);
                }
                for (n2 = 1; n2 < 12; ++n2) {
                    graphTick = new GraphTick(n2 * n3, 8, Color.black, 1, 0, "" + n2 * n3, Color.black);
                    graphViewer.addGraphElement(graphTick);
                }
                jFrame.setSize(500, 500);
                graphViewer.setVisible(true);
            } else if (n == 0) {
                int n8;
                int n9;
                int n10;
                int n11 = 53;
                double d = 0.0;
                double d10 = 0.0;
                double d11 = 5.0;
                double d12 = 0.0;
                int n12 = 0;
                int[] nArray = new int[n11];
                double d13 = 0.0;
                if (n11 % 2 == 1) {
                    d = (d11 - d10) / (double)(n11 - 3);
                }
                for (n10 = 0; n10 < this.indices.length; ++n10) {
                    ISlideDataElement iSlideDataElement = this.slideData.getSlideDataElement(this.indices[n10]);
                    d12 = iSlideDataElement.getRatio(1, 0, 0);
                    for (n9 = 0; n9 < n11; ++n9) {
                        double d14;
                        double d15;
                        if (n9 == 0) {
                            d15 = Double.MIN_VALUE;
                            d14 = d10 - d / 2.0;
                        } else if (n9 == n11 - 1) {
                            d15 = d11 + d / 2.0;
                            d14 = Double.MAX_VALUE;
                        } else {
                            d15 = d10 - d / 2.0 + (double)(n9 - 1) * d;
                            d14 = d15 + d;
                        }
                        if (!(d12 >= d15) || !(d12 <= d14) || !iSlideDataElement.hasNoZeros()) continue;
                        int n13 = n9;
                        nArray[n13] = nArray[n13] + 1;
                    }
                }
                for (n10 = 0; n10 < nArray.length; ++n10) {
                    if (n12 >= nArray[n10]) continue;
                    n12 = nArray[n10];
                }
                n9 = 0;
                float f = n12;
                n10 = 0;
                while (!(f < 10.0f) || !(f > 0.0f)) {
                    f /= 10.0f;
                    ++n10;
                }
                n9 = (int)((double)((int)(f * 10.0f)) * Math.pow(10.0, n10 - 2));
                n12 = n9 * 11;
                JFrame jFrame = new JFrame("Cy5 / Cy3");
                GraphViewer graphViewer = new GraphViewer(jFrame, 0, 500, 0, 500, d10 - 3.0 * d / 2.0, d11 + 3.0 * d / 2.0, 0.0, n12, 75, 75, 75, 75, "Cy5 / Cy3 - " + SlideData.normalizationString(this.slideData.getNormalizedState()), "Ratio", "Count");
                for (int i = 1; i < 12; ++i) {
                }
                double d16 = 1.0f / this.canvas.getFactor();
                double d17 = this.canvas.getFactor();
                for (n8 = 0; n8 < nArray.length; ++n8) {
                    GraphBar graphBar = this.canvas.thresholdsOn ? (d10 + (double)(n8 - 1) * d <= d16 || d10 + (double)(n8 - 1) * d >= d17 ? new GraphBar(d10 - 3.0 * d / 2.0 + (double)n8 * d, d10 - d / 2.0 + (double)n8 * d, nArray[n8], Color.red, 0, 0) : new GraphBar(d10 - 3.0 * d / 2.0 + (double)n8 * d, d10 - d / 2.0 + (double)n8 * d, nArray[n8], Color.blue, 0, 0)) : new GraphBar(d10 - 3.0 * d / 2.0 + (double)n8 * d, d10 - d / 2.0 + (double)n8 * d, nArray[n8], Color.blue, 0, 0);
                    graphViewer.addGraphElement(graphBar);
                }
                d13 = d10 - 3.0 * d / 2.0 + 0.0 * d;
                GraphTick graphTick = new GraphTick(d13, 8, Color.black, 0, 0, "Minimum", Color.black);
                graphViewer.addGraphElement(graphTick);
                d13 = d10 - 3.0 * d / 2.0 + (double)nArray.length * d;
                graphTick = new GraphTick(d13, 8, Color.black, 0, 0, "Maximum", Color.black);
                graphViewer.addGraphElement(graphTick);
                for (n8 = (int)d10; n8 <= (int)d11; ++n8) {
                    graphTick = new GraphTick(n8, 8, Color.black, 0, 0, "" + n8, Color.black);
                    graphViewer.addGraphElement(graphTick);
                }
                for (n8 = 1; n8 < 12; ++n8) {
                    graphTick = new GraphTick(n8 * n9, 8, Color.black, 1, 0, "" + n8 * n9, Color.black);
                    graphViewer.addGraphElement(graphTick);
                }
                jFrame.setSize(500, 500);
                graphViewer.setVisible(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setThresholds(boolean bl) {
        this.setCursor(3);
        this.canvas.setThresholds(bl);
        this.setCursor(0);
    }

    public void setFactor(float f) {
        double d;
        double d2;
        this.setCursor(3);
        this.canvas.setFactor(f);
        try {
            d2 = 1.0f / (f + 1.0f);
        }
        catch (NumberFormatException numberFormatException) {
            d2 = 1.0f / (this.canvas.getFactor() + 1.0f);
        }
        try {
            d = f / (f + 1.0f);
        }
        catch (NumberFormatException numberFormatException) {
            d = this.canvas.getFactor() / (this.canvas.getFactor() + 1.0f);
        }
        this.canvas.setLowDifference(d2);
        this.canvas.setHighDifference(d);
        this.panel.updateThresholdScrollbar(Math.rint(f * 100.0f) / 100.0);
        if (this.setThresholdsItem.isSelected()) {
            this.refreshSlide();
        }
        this.setCursor(0);
    }

    public void setUpperLimits(float f, float f2) {
        this.setCursor(3);
        this.canvas.setUpperLimits(f, f2);
        this.panel.xUpperLimitScrollbar.setValue((int)f);
        this.panel.yUpperLimitScrollbar.setValue((int)f2);
        this.refreshSlide();
        this.setCursor(0);
    }

    public void changePaletteStyle(int n) {
        switch (n) {
            case 1: {
                this.canvas.setPaletteStyle(1);
                break;
            }
            case 2: {
                this.canvas.setPaletteStyle(2);
                break;
            }
            case 3: {
                this.canvas.setPaletteStyle(3);
            }
        }
    }

    public void sort(int n) {
        this.setCursor(3);
        SlideDataSorter slideDataSorter = new SlideDataSorter(this.slideData);
        this.indices = slideDataSorter.sort(this.indices, n);
        this.refreshSlide();
        this.setCursor(0);
    }

    public void saveImage() {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setCurrentDirectory(new File("Data"));
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String string = "";
                if (file.isDirectory()) {
                    return true;
                }
                int n = file.getName().lastIndexOf(46);
                if (n > 0) {
                    string = file.getName().substring(n + 1).toLowerCase();
                }
                return string.equals("bmp");
            }

            public String getDescription() {
                return "Bitmap Files (*.bmp)";
            }
        });
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String string = "";
                if (file.isDirectory()) {
                    return true;
                }
                int n = file.getName().lastIndexOf(46);
                if (n > 0) {
                    string = file.getName().substring(n + 1).toLowerCase();
                }
                return string.equals("jpg") || string.equals("jpeg");
            }

            public String getDescription() {
                return "JPEG Files (*.jpg; *.jpeg)";
            }
        });
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String string = "";
                if (file.isDirectory()) {
                    return true;
                }
                int n = file.getName().lastIndexOf(46);
                if (n > 0) {
                    string = file.getName().substring(n + 1).toLowerCase();
                }
                return string.equals("png");
            }

            public String getDescription() {
                return "PNG Files (*.png)";
            }
        });
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String string = "";
                if (file.isDirectory()) {
                    return true;
                }
                int n = file.getName().lastIndexOf(46);
                if (n > 0) {
                    string = file.getName().substring(n + 1).toLowerCase();
                }
                return string.equals("tif") || string.equals("tiff");
            }

            public String getDescription() {
                return "TIFF Files (*.tif; *.tiff)";
            }
        });
        int n = jFileChooser.showSaveDialog(this.getFrame());
        if (n == 0) {
            final File file = jFileChooser.getSelectedFile();
            final BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.canvas.getWidth(), this.canvas.getHeight());
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            this.canvas.controlPaint(graphics2D);
            if (jFileChooser.getFileFilter().getDescription() == "Bitmap Files (*.bmp)") {
                try {
                    Thread thread = new Thread(){

                        public void run() {
                            RenderedOp renderedOp = JAI.create("filestore", (RenderedImage)bufferedImage, (Object)file.getPath(), (Object)"BMP");
                            Manager.message(SingleArrayViewer.this.getFrame(), "BMP image saved");
                        }
                    };
                    thread.setPriority(1);
                    thread.start();
                }
                catch (Exception exception) {
                    Manager.message(this.getFrame(), exception);
                }
            } else if (jFileChooser.getFileFilter().getDescription() == "JPEG Files (*.jpg; *.jpeg)") {
                try {
                    Thread thread = new Thread(){

                        public void run() {
                            JPEGEncodeParam jPEGEncodeParam = new JPEGEncodeParam();
                            jPEGEncodeParam.setQuality(1.0f);
                            RenderedOp renderedOp = JAI.create("filestore", (RenderedImage)bufferedImage, (Object)file.getPath(), (Object)"JPEG", (Object)jPEGEncodeParam);
                            Manager.message(SingleArrayViewer.this.getFrame(), "JPEG image saved");
                        }
                    };
                    thread.setPriority(1);
                    thread.start();
                }
                catch (Exception exception) {
                    Manager.message(this.getFrame(), exception);
                }
            } else if (jFileChooser.getFileFilter().getDescription() == "PNG Files (*.png)") {
                try {
                    Thread thread = new Thread(){

                        public void run() {
                            RenderedOp renderedOp = JAI.create("filestore", (RenderedImage)bufferedImage, (Object)file.getPath(), (Object)"PNG");
                            Manager.message(SingleArrayViewer.this.getFrame(), "PNG image saved");
                        }
                    };
                    thread.setPriority(1);
                    thread.start();
                }
                catch (Exception exception) {
                    Manager.message(this.getFrame(), exception);
                }
            } else if (jFileChooser.getFileFilter().getDescription() == "TIFF Files (*.tif; *.tiff)") {
                try {
                    Thread thread = new Thread(){

                        public void run() {
                            TIFFEncodeParam tIFFEncodeParam = new TIFFEncodeParam();
                            tIFFEncodeParam.setCompression(1);
                            RenderedOp renderedOp = JAI.create("filestore", (RenderedImage)bufferedImage, (Object)file.getPath(), (Object)"TIFF", (Object)tIFFEncodeParam);
                            Manager.message(SingleArrayViewer.this.getFrame(), "TIFF image saved");
                        }
                    };
                    thread.setPriority(1);
                    thread.start();
                }
                catch (Exception exception) {
                    Manager.message(this.getFrame(), exception);
                }
            }
        }
    }

    public void printImage() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this, printerJob.defaultPage());
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                System.out.println(printerException);
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        double d;
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        SingleArrayViewerCanvas singleArrayViewerCanvas = this.canvas;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Dimension dimension = singleArrayViewerCanvas.getSize();
        double d2 = pageFormat.getImageableWidth();
        double d3 = pageFormat.getImageableHeight();
        if ((double)dimension.width > d2) {
            d = d2 / (double)dimension.width;
            graphics2D.scale(d, d);
            d2 /= d;
            d3 /= d;
        }
        if ((double)dimension.height > d3) {
            d = d3 / (double)dimension.height;
            graphics2D.scale(d, d);
            d2 /= d;
            d3 /= d;
        }
        graphics2D.translate((d2 - (double)dimension.width) / 2.0, (d3 - (double)dimension.height) / 2.0);
        graphics2D.drawRect(-1, -1, dimension.width + 2, dimension.height + 2);
        graphics2D.setClip(0, 0, dimension.width, dimension.height);
        if (singleArrayViewerCanvas instanceof JComponent) {
            ((JComponent)singleArrayViewerCanvas).setDoubleBuffered(false);
        }
        singleArrayViewerCanvas.paintAll(graphics2D);
        if (singleArrayViewerCanvas instanceof JComponent) {
            ((JComponent)singleArrayViewerCanvas).setDoubleBuffered(true);
        }
        return 0;
    }

    public void systemDisable(int n) {
        this.slideData = null;
        switch (n) {
            case 1000: {
                this.fileMenu.setEnabled(true);
                this.newDatabaseItem.setEnabled(false);
                this.newFileItem.setEnabled(false);
                this.newReportItem.setEnabled(false);
                this.newSpotfireItem.setEnabled(false);
                this.saveImageItem.setEnabled(false);
                this.printImageItem.setEnabled(false);
                break;
            }
            case 1003: {
                this.fileMenu.setEnabled(true);
                this.newReportItem.setEnabled(false);
                this.newSpotfireItem.setEnabled(false);
                this.newDatabaseItem.setEnabled(false);
                break;
            }
            case 1001: {
                this.fileMenu.setEnabled(true);
                this.newDatabaseItem.setEnabled(false);
                break;
            }
            case 1002: {
                this.fileMenu.setEnabled(true);
                this.newDatabaseItem.setEnabled(false);
            }
        }
        this.viewsMenu.setEnabled(false);
        this.normalizationMenu.setEnabled(false);
        this.sortMenu.setEnabled(false);
        this.displayMenu.setEnabled(false);
        this.controlMenu.setEnabled(false);
        this.panel.systemDisable(n);
    }

    public void systemEnable(int n) {
        switch (n) {
            case 1000: {
                this.fileMenu.setEnabled(true);
                break;
            }
            case 1003: {
                this.fileMenu.setEnabled(true);
                this.newFileItem.setEnabled(true);
                this.newReportItem.setEnabled(true);
                this.newSpotfireItem.setEnabled(true);
                this.saveImageItem.setEnabled(true);
                this.printImageItem.setEnabled(true);
                this.viewsMenu.setEnabled(true);
                this.normalizationMenu.setEnabled(true);
                this.sortMenu.setEnabled(true);
                this.displayMenu.setEnabled(true);
                this.controlMenu.setEnabled(true);
                break;
            }
            case 1001: {
                this.fileMenu.setEnabled(true);
                break;
            }
            case 1002: {
                this.fileMenu.setEnabled(true);
                this.newDatabaseItem.setEnabled(false);
            }
        }
        this.panel.systemEnable(n);
    }

    public void handleItems(Object object) {
        if (object == this.newDatabaseItem) {
            this.noNormalizationItem.setSelected(true);
        } else if (object == this.newFileItem) {
            this.noNormalizationItem.setSelected(true);
        } else if (object == this.totalIntensityItem) {
            this.setConfidenceItem.setEnabled(false);
        } else if (object == this.linearRegressionItem) {
            this.setConfidenceItem.setEnabled(false);
        } else if (object == this.ratioStatisticsItem) {
            this.setConfidenceItem.setEnabled(true);
        } else if (object == this.iterativeLogItem) {
            this.setConfidenceItem.setEnabled(false);
        } else if (object == this.totalIntensityListItem) {
            this.setConfidenceItem.setEnabled(false);
        } else if (object == this.linearRegressionListItem) {
            this.setConfidenceItem.setEnabled(false);
        } else if (object == this.ratioStatisticsListItem) {
            this.setConfidenceItem.setEnabled(true);
        } else if (object == this.noNormalizationItem) {
            this.setConfidenceItem.setEnabled(false);
        } else if (object == this.logItem) {
            this.panel.linearItem.setSelected(this.logItem.isSelected());
        } else if (object == this.setThresholdsItem) {
            this.panel.thresholdCheckbox.setSelected(this.setThresholdsItem.isSelected());
        } else if (object == this.setScaleItem) {
            this.panel.greenRedScaleCheckbox.setSelected(this.setScaleItem.isSelected());
        } else if (object == this.changeColorsItem) {
            if (this.greenRedItem.getText().equals("Green / Red")) {
                this.greenRedItem.setText("Blue / Red");
                this.overlayItem.setText("B/R Overlay");
                this.setScaleItem.setText("Use B/R Scale");
                this.panel.greenRedCheckbox.setText("B/R Bar Display");
                this.panel.overlayCheckbox.setText("B/R Overlay");
                this.panel.greenRedScaleCheckbox.setText("B/R Scale");
            } else if (this.greenRedItem.getText().equals("Blue / Red")) {
                this.greenRedItem.setText("Green / Red");
                this.overlayItem.setText("G/R Overlay");
                this.setScaleItem.setText("Use G/R Scale");
                this.panel.greenRedCheckbox.setText("G/R Bar Display");
                this.panel.overlayCheckbox.setText("G/R Overlay");
                this.panel.greenRedScaleCheckbox.setText("G/R Scale");
            }
        } else if (object == this.blueToRedItem) {
            if (!this.panel.blueRedCheckbox.isSelected()) {
                this.panel.blueRedCheckbox.setSelected(true);
            }
        } else if (object == this.panel.blueRedCheckbox) {
            if (this.panel.blueRedCheckbox.isSelected() && !this.blueToRedItem.isSelected()) {
                this.blueToRedItem.setSelected(true);
            }
        } else if (object == this.greenRedItem) {
            if (!this.panel.greenRedCheckbox.isSelected()) {
                this.panel.greenRedCheckbox.setSelected(true);
            }
        } else if (object == this.panel.greenRedCheckbox) {
            if (this.panel.greenRedCheckbox.isSelected() && !this.greenRedItem.isSelected()) {
                this.greenRedItem.setSelected(true);
            }
            this.panel.greenRedScaleCheckbox.setSelected(false);
            this.setScaleItem.setSelected(false);
        } else if (object == this.overlayItem) {
            if (!this.panel.overlayCheckbox.isSelected()) {
                this.panel.overlayCheckbox.setSelected(true);
            }
        } else if (object == this.panel.overlayCheckbox && this.panel.overlayCheckbox.isSelected() && !this.overlayItem.isSelected()) {
            this.overlayItem.setSelected(true);
        }
    }

    public void close() {
        this.mainframe.dispose();
        Manager.removeComponent(this);
    }

    private void setXOldEvent(int n) {
        this.oldX = n;
    }

    private void setYOldEvent(int n) {
        this.oldY = n;
    }

    private int getXOldEvent() {
        return this.oldX;
    }

    private int getYOldEvent() {
        return this.oldY;
    }

    public Vector buildPalette() {
        Vector<Color> vector = new Vector<Color>(256);
        Color color = new Color(0, 0, 0);
        vector.addElement(color);
        for (int i = 1; i < 256; ++i) {
            i = 255 - i;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            if (i < 33) {
                d = 255.0;
            } else if (i > 32 && i < 108) {
                d = Math.abs(255.0 * Math.cos((double)(i - 32) * Math.PI / 151.0));
            } else if (i > 107) {
                d = 0.0;
            }
            if (i < 5) {
                d2 = 0.0;
            } else if (i > 4 && i < 101) {
                d2 = Math.abs(255.0 * Math.cos((double)(i - 100) * Math.PI / 189.0));
            } else if (i > 100 && i < 229) {
                d2 = Math.abs(255.0 * Math.cos((double)(i - 100) * Math.PI / 294.0));
            } else if (i > 230) {
                d2 = 0.0;
            }
            if (i < 72) {
                d3 = 0.0;
            } else if (i > 71 && i < 200) {
                d3 = Math.abs(255.0 * Math.cos((double)(i - 199) * Math.PI / 256.0));
            } else if (i > 199) {
                d3 = Math.abs(255.0 * Math.cos((double)(i - 199) * Math.PI / 175.0));
            }
            color = new Color((float)d / 255.0f, (float)d2 / 255.0f, (float)d3 / 255.0f);
            vector.addElement(color);
            i = 255 - i;
        }
        return vector;
    }

    private class SingleArrayViewerFrame
    extends Frame {
        private SingleArrayViewerFrame() {
        }

        protected void processWindowEvent(WindowEvent windowEvent) {
            if (windowEvent.getID() == 201) {
                this.dispose();
            }
            super.processWindowEvent(windowEvent);
        }
    }

    private class SingleArrayViewerCanvas
    extends ArrayViewerCanvas {
        public static final int LINEAR = 0;
        public static final int LOG = 1;
        public static final int BLUETORED = 1;
        public static final int GREENRED = 2;
        public static final int OVERLAY = 3;
        public static final int RED_GREEN_COLOR_SCHEME = 0;
        public static final int RED_BLUE_COLOR_SCHEME = 1;
        private int maxRow;
        private int maxColumn;
        private Vector palette;
        private int style;
        private int paletteStyle;
        private int colorScheme;
        private double lowDifference;
        private double highDifference;
        private float factor;
        private boolean scaleOn;
        private boolean thresholdsOn;
        private boolean highlightOn;
        private int startx;
        private int stopx;
        private int starty;
        private int stopy;
        private int xspacing;
        private int yspacing;
        private int xgap;
        private int ygap;
        private Font tinyFont;
        private Font smallFont;
        private Font largeFont;
        private float topCy3;
        private float topCy5;
        private int preXSpacing;
        private int postXSpacing;
        private int preYSpacing;
        private int postYSpacing;
        private int xElementSize;
        private int yElementSize;
        private int paletteSpacing;

        public SingleArrayViewerCanvas(int n, int n2, int n3, int n4) {
            super(0, n + n2, 0, n3 + n4);
            this.topCy3 = 0.0f;
            this.topCy5 = 0.0f;
            this.paletteSpacing = 0;
            this.style = 0;
            this.paletteStyle = 3;
            this.tinyFont = new Font("monospaced", 0, 8);
            this.smallFont = new Font("serif", 0, 12);
            this.largeFont = new Font("serif", 0, 16);
            this.colorScheme = 0;
            this.preXSpacing = n;
            this.postXSpacing = n2;
            this.preYSpacing = n3;
            this.postYSpacing = n4;
            this.scaleOn = true;
            this.thresholdsOn = false;
            this.highlightOn = true;
            this.lowDifference = 0.33;
            this.highDifference = 0.66;
            this.factor = 2.0f;
            this.paletteSpacing = 50;
            this.setElementSize(20, 5);
            this.palette = SingleArrayViewer.this.buildPalette();
            SingleArrayViewer.this.setXOldEvent(-1);
            SingleArrayViewer.this.setYOldEvent(-1);
        }

        public void controlPaint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (SingleArrayViewer.this.slideData != null) {
                this.drawSlide(graphics2D);
            }
        }

        public void setSpacing(int n, int n2, int n3, int n4) {
            this.preXSpacing = n;
            this.postXSpacing = n2;
            this.preYSpacing = n3;
            this.postYSpacing = n4;
            this.updateSizes();
        }

        public void setSize() {
            if (SingleArrayViewer.this.slideData != null) {
                int n = this.preXSpacing + this.getXSize() + this.postXSpacing;
                int n2 = this.preYSpacing + this.getYSize() + this.postYSpacing;
                this.setPreferredSize(new Dimension(n, n2));
                SingleArrayViewer.this.scrollPane.setViewportView(SingleArrayViewer.this.canvas);
            }
        }

        public void setX2Size() {
            if (SingleArrayViewer.this.slideData != null) {
                int n = this.getX2Start() + this.getXSize() + this.postXSpacing;
                int n2 = this.preYSpacing + this.getYSize() + this.postYSpacing;
                this.setPreferredSize(new Dimension(n, n2));
                SingleArrayViewer.this.scrollPane.setViewportView(SingleArrayViewer.this.canvas);
            }
        }

        public void setElementSize(int n, int n2) {
            this.xElementSize = n;
            this.yElementSize = n2;
            this.updateSizes();
        }

        public void updateSizes() {
            if (this.paletteStyle == 1) {
                this.setX2Size();
            } else {
                this.setSize();
            }
        }

        public int getXElementSize() {
            return this.xElementSize;
        }

        public int getYElementSize() {
            return this.yElementSize;
        }

        public int getXSize() {
            int n = 0;
            if (SingleArrayViewer.this.slideData != null) {
                n = SingleArrayViewer.this.slideData.getSlideMetaData().getColumns();
            }
            if (n > 0) {
                return n * this.xElementSize;
            }
            return 0;
        }

        public int getYSize() {
            int n = 0;
            if (SingleArrayViewer.this.slideData != null) {
                n = SingleArrayViewer.this.slideData.getSlideMetaData().getRows();
            }
            if (n > 0) {
                return n * this.yElementSize;
            }
            return 0;
        }

        public void setScale(boolean bl) {
            this.scaleOn = bl;
            SingleArrayViewer.this.refreshSlide();
        }

        public boolean getScale() {
            return this.scaleOn;
        }

        public void setColorScheme(int n) {
            this.colorScheme = n;
        }

        public int getColorScheme() {
            return this.colorScheme;
        }

        public void changeColorScheme() {
            if (this.colorScheme == 0) {
                this.colorScheme = 1;
            } else if (this.colorScheme == 1) {
                this.colorScheme = 0;
            }
            SingleArrayViewer.this.refreshSlide();
        }

        public void setThresholds(boolean bl) {
            this.thresholdsOn = bl;
            SingleArrayViewer.this.refreshSlide();
        }

        public boolean getThresholds() {
            return this.thresholdsOn;
        }

        public boolean getHighlight() {
            return this.highlightOn;
        }

        public void setHighlight(boolean bl) {
            this.highlightOn = bl;
        }

        public float getFactor() {
            return this.factor;
        }

        public void setFactor(float f) {
            this.factor = f;
        }

        public double getLowDifference() {
            return this.lowDifference;
        }

        public void setLowDifference(double d) {
            this.lowDifference = d;
        }

        public double getHighDifference() {
            return this.highDifference;
        }

        public void setHighDifference(double d) {
            this.highDifference = d;
        }

        public void setTopCy3(float f) {
            this.topCy3 = f;
        }

        public float getTopCy3() {
            return this.topCy3;
        }

        public void setTopCy5(float f) {
            this.topCy5 = f;
        }

        public float getTopCy5() {
            return this.topCy5;
        }

        public void setUpperLimits(float f, float f2) {
            this.setTopCy3(f);
            this.setTopCy5(f2);
        }

        public int getPaletteSpacing() {
            return this.paletteSpacing;
        }

        public void setPaletteSpacing(int n) {
            this.paletteSpacing = n;
        }

        public void setStyle(int n) {
            this.style = n;
            SingleArrayViewer.this.refreshSlide();
        }

        public int getStyle() {
            return this.style;
        }

        public void setPaletteStyle(int n) {
            this.setCursor(3);
            this.paletteStyle = n;
            if (this.paletteStyle != 1) {
                if (this.paletteStyle == 2) {
                    this.setScale(false);
                } else if (this.paletteStyle == 3) {
                    // empty if block
                }
            }
            this.updateSizes();
            SingleArrayViewer.this.refreshSlide();
            this.setCursor(0);
        }

        public int getPaletteStyle() {
            return this.paletteStyle;
        }

        public void slideDataElementAt(int n, int n2) {
            ISlideDataElement iSlideDataElement = null;
            int n3 = this.findColumn(n, n2);
            int n4 = this.findRow(n, n2);
            int n5 = SingleArrayViewer.this.slideData.getSlideMetaData().getColumns();
            if (n3 > 0 && n4 > 0) {
                iSlideDataElement = SingleArrayViewer.this.slideData.getSlideDataElement(SingleArrayViewer.this.indices[(n4 - 1) * n5 + n3 - 1]);
            }
            if (iSlideDataElement != null) {
                int n6;
                int n7 = 0;
                int n8 = iSlideDataElement.getRow(0);
                int n9 = iSlideDataElement.getColumn(0);
                float f = iSlideDataElement.getIntensity(0);
                float f2 = iSlideDataElement.getIntensity(1);
                String[] stringArray = TMEV.getFieldNames();
                String string = "Row : Column";
                String string2 = "Cy3 : Cy5";
                n7 = 12;
                for (n6 = 0; n6 < stringArray.length; ++n6) {
                    n7 = Math.max(n7, stringArray[n6].length());
                }
                String string3 = string + this.space(12, n7) + n8 + " : " + n9 + "\n";
                string3 = string3 + string2 + this.space(9, n7) + f + " : " + f2;
                for (n6 = 0; n6 < stringArray.length; ++n6) {
                    string3 = string3 + "\n" + stringArray[n6] + this.space(stringArray[n6].length(), n7) + iSlideDataElement.getFieldAt(n6);
                }
            }
        }

        public ISlideDataElement getSlideDataElementAt(int n, int n2) {
            int n3;
            Object var3_3 = null;
            int n4 = this.findRow(n, n2);
            int n5 = this.findColumn(n, n2);
            int n6 = SingleArrayViewer.this.slideData.getSlideMetaData().getColumns();
            if (n5 > 0 && n4 > 0 && (n3 = (n4 - 1) * n6 + n5 - 1) < SingleArrayViewer.this.indices.length) {
                return SingleArrayViewer.this.slideData.getSlideDataElement(SingleArrayViewer.this.indices[n3]);
            }
            return null;
        }

        public int findColumn(int n, int n2) {
            int n3 = 0;
            if (this.inHorizontalPositionOne(n, n2)) {
                n3 = (n - this.preXSpacing) / this.xElementSize + 1;
            } else if (this.inHorizontalPositionTwo(n, n2)) {
                n3 = (n - this.getX2Start()) / this.xElementSize + 1;
            }
            return n3;
        }

        public int findRow(int n, int n2) {
            int n3 = 0;
            if (this.inVerticalPosition(n, n2)) {
                n3 = (n2 - this.preYSpacing) / this.yElementSize + 1;
            }
            return n3;
        }

        public boolean inHorizontalPositionOne(int n, int n2) {
            return n - this.preXSpacing > 0 && n - this.preXSpacing - this.getXSize() < 0;
        }

        public boolean inHorizontalPositionTwo(int n, int n2) {
            if (this.paletteStyle != 1) {
                return false;
            }
            return n - this.getX2Start() > 0 && n - this.getX2Start() - this.getXSize() < 0;
        }

        public boolean inHorizontalPosition(int n, int n2) {
            return this.inHorizontalPositionOne(n, n2) || this.inHorizontalPositionTwo(n, n2);
        }

        public boolean inVerticalPosition(int n, int n2) {
            return n2 - this.preYSpacing > 0 && n2 - this.preYSpacing - this.getYSize() < 0;
        }

        public boolean inPositionOne(int n, int n2) {
            return this.inHorizontalPositionOne(n, n2) && this.inVerticalPosition(n, n2);
        }

        public boolean inPositionTwo(int n, int n2) {
            if (this.paletteStyle != 1) {
                return false;
            }
            return this.inHorizontalPositionTwo(n, n2) && this.inVerticalPosition(n, n2);
        }

        public boolean inPosition(int n, int n2) {
            return this.inHorizontalPosition(n, n2) && this.inVerticalPosition(n, n2);
        }

        public void drawColoredBoxAt(Graphics2D graphics2D, int n, int n2, Color color) {
            int n3;
            int n4;
            boolean bl = false;
            boolean bl2 = false;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            boolean bl3 = false;
            boolean bl4 = false;
            int n9 = SingleArrayViewer.this.getXOldEvent();
            int n10 = SingleArrayViewer.this.getYOldEvent();
            n5 = this.findColumn(n, n2);
            n6 = this.findRow(n, n2);
            n7 = this.findColumn(n9, n10);
            n8 = this.findRow(n9, n10);
            if (n7 == n5 && n8 == n6 && this.paletteStyle != 1) {
                return;
            }
            if (this.inPositionOne(n9, n10)) {
                n4 = this.getXpos(n7);
                n3 = this.getYpos(n8);
                this.drawRect(graphics2D, n4 + this.preXSpacing, n3 + this.preYSpacing, this.xElementSize, this.yElementSize, Color.black);
                bl2 = true;
            } else if (this.inPositionTwo(n9, n10)) {
                n4 = this.getXpos(n7);
                n3 = this.getYpos(n8);
                this.drawRect(graphics2D, n4 + this.getX2Start(), n3 + this.preYSpacing, this.xElementSize, this.yElementSize, Color.black);
                bl2 = true;
            }
            if (this.inPositionOne(n, n2)) {
                n4 = this.getXpos(n5);
                n3 = this.getYpos(n6);
                this.drawRect(graphics2D, n4 + this.preXSpacing, n3 + this.preYSpacing, this.xElementSize, this.yElementSize, color);
                bl2 = true;
                bl = true;
            } else if (this.inPositionTwo(n, n2)) {
                n4 = this.getXpos(n5);
                n3 = this.getYpos(n6);
                this.drawRect(graphics2D, n4 + this.getX2Start(), n3 + this.preYSpacing, this.xElementSize, this.yElementSize, color);
                bl2 = true;
                bl = true;
            }
        }

        public int getXpos(int n) {
            int n2 = (n - 1) * this.xElementSize;
            return n2;
        }

        public int getYpos(int n) {
            int n2 = (n - 1) * this.yElementSize;
            return n2;
        }

        public void drawSlide(Graphics2D graphics2D) {
            if (SingleArrayViewer.this.slideData == null) {
                System.out.println("IN SAV canvas null data");
                return;
            }
            int n = SingleArrayViewer.this.slideData.getSlideMetaData().getRows();
            int n2 = SingleArrayViewer.this.slideData.getSlideMetaData().getColumns();
            if (n2 == 0) {
                System.out.println("IN SAV canvas columns = 0");
                return;
            }
            int n3 = SingleArrayViewer.this.indices.length;
            if (this.paletteStyle == 1) {
                int n4;
                this.eraseAll(graphics2D);
                this.eraseFoot(graphics2D);
                this.drawSlideFileName(graphics2D, SingleArrayViewer.this.slideData.getSlideDataName());
                for (n4 = 0; n4 < n3; ++n4) {
                    ISlideDataElement iSlideDataElement = SingleArrayViewer.this.slideData.getSlideDataElement(SingleArrayViewer.this.indices[n4]);
                    int n5 = n4 / n2 + 1;
                    int n6 = n4 % n2 + 1;
                    if (iSlideDataElement != null) {
                        this.drawSlideDataElement(graphics2D, SingleArrayViewer.this.indices[n4], n5, n6);
                        this.drawSlideDataElement2(graphics2D, SingleArrayViewer.this.indices[n4], n5, n6);
                        continue;
                    }
                    this.drawNullElement(graphics2D, n4);
                    this.drawNullElement2(graphics2D, n4);
                }
                if (n3 < n * n2) {
                    for (n4 = n3; n4 < n * n2; ++n4) {
                        this.drawNullElement(graphics2D, n4);
                        this.drawNullElement2(graphics2D, n4);
                    }
                }
                this.drawScale(graphics2D);
                this.setFoot(graphics2D);
            } else {
                int n7;
                this.eraseAll(graphics2D);
                this.drawSlideFileName(graphics2D, SingleArrayViewer.this.slideData.getSlideDataName());
                for (n7 = 0; n7 < n3; ++n7) {
                    ISlideDataElement iSlideDataElement = SingleArrayViewer.this.slideData.getSlideDataElement(SingleArrayViewer.this.indices[n7]);
                    int n8 = n7 / n2 + 1;
                    int n9 = n7 % n2 + 1;
                    if (iSlideDataElement != null) {
                        this.drawSlideDataElement(graphics2D, SingleArrayViewer.this.indices[n7], n8, n9);
                        continue;
                    }
                    this.drawNullElement(graphics2D, n7);
                }
                if (n3 < n * n2) {
                    for (n7 = n3; n7 < n * n2; ++n7) {
                        this.drawNullElement(graphics2D, n7);
                    }
                }
            }
        }

        public void eraseAll(Graphics2D graphics2D) {
            this.eraseSlideDataElements(graphics2D);
            this.eraseSlideDataElements2(graphics2D);
            this.eraseSlideFileName(graphics2D);
            this.eraseFoot(graphics2D);
        }

        public void eraseSlideDataElements(Graphics2D graphics2D) {
            this.fillRect(graphics2D, 0, 0, this.getXSize(), this.getYSize(), Color.white);
        }

        public void eraseSlideDataElements2(Graphics2D graphics2D) {
            this.fillRect(graphics2D, this.getX2Start(), 0, this.getXSize(), this.getYSize(), Color.white);
        }

        public void eraseSlideFileName(Graphics2D graphics2D) {
            this.fillRect(graphics2D, this.preXSpacing, 0, this.getXSize(), this.preYSpacing - 20, Color.white);
        }

        public void eraseFoot(Graphics2D graphics2D) {
            this.fillRect(graphics2D, 0, 0, 2 * this.getXSize(), this.preYSpacing, Color.white);
            this.fillRect(graphics2D, this.preXSpacing + 1, this.preYSpacing, this.preXSpacing, this.getYSize() + this.preYSpacing, Color.white);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Color getFalseColor(long l) {
            Color color = null;
            Double d = new Double(0.0);
            try {
                if (this.style == 1) {
                    d = l == 0L ? new Double(255.0 * (Math.log(1.0) / Math.log(this.getTopCy3()))) : new Double(255.0 * (Math.log(l) / Math.log(this.getTopCy3())));
                } else if (this.style == 0) {
                    d = new Double(255.0 * (double)l / (double)this.getTopCy3());
                }
                if (d > 255.0) {
                    d = new Double(255.0);
                } else if (d < 0.0) {
                    d = new Double(0.0);
                }
                try {
                    color = (Color)this.palette.elementAt(d.intValue());
                }
                catch (Exception exception) {
                    System.out.println("!!!!!");
                }
            }
            catch (Exception exception) {
                System.out.println("Exception (SingleArrayViewerCanvas.getFalseColor()): " + exception);
            }
            finally {
                return color;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Color getFalseColor2(long l) {
            Color color = new Color(0, 0, 0);
            Double d = new Double(0.0);
            try {
                if (this.style == 1) {
                    d = l == 0L ? new Double(255.0 * (Math.log(1.0) / Math.log(this.getTopCy5()))) : new Double(255.0 * (Math.log(l) / Math.log(this.getTopCy5())));
                } else if (this.style == 0) {
                    d = new Double(255.0 * (double)l / (double)this.getTopCy5());
                }
                if (d > 255.0) {
                    d = new Double(255.0);
                } else if (d < 0.0) {
                    d = new Double(0.0);
                }
                color = (Color)this.palette.elementAt(d.intValue());
                return color;
            }
            catch (Exception exception) {
                System.out.println("Exception (SingleArrayViewerCanvas.getFalseColor()): " + exception);
            }
            finally {
                return color;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Color getGreenScaleColor(long l) {
            Color color = null;
            try {
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                block22: {
                                    block23: {
                                        block24: {
                                            if (!this.scaleOn) break block22;
                                            if (this.style != 1) break block23;
                                            if (l != 0L) break block24;
                                            float f = new Double((double)((float)Math.log(1.0)) / Math.log(this.getTopCy3())).floatValue();
                                            if (f > 255.0f) {
                                                f = 255.0f;
                                            }
                                            if (f < 0.0f) {
                                                f = 0.0f;
                                            }
                                            if (this.colorScheme == 0) {
                                                color = new Color(0.0f, f, 0.0f);
                                            }
                                            if (this.colorScheme == 1) {
                                                color = new Color(0.0f, 0.0f, f);
                                            }
                                            break block25;
                                        }
                                        float f = new Double((double)((float)Math.log(l)) / Math.log(this.getTopCy3())).floatValue();
                                        if (f > 255.0f) {
                                            f = 255.0f;
                                        }
                                        if (f < 0.0f) {
                                            f = 0.0f;
                                        }
                                        if (this.colorScheme == 0) {
                                            color = new Color(0.0f, f, 0.0f);
                                        }
                                        if (this.colorScheme == 1) {
                                            color = new Color(0.0f, 0.0f, f);
                                        }
                                        break block26;
                                    }
                                    if (this.style != 0) break block27;
                                    float f = (float)l / this.getTopCy3();
                                    if (f > 1.0f) {
                                        f = 1.0f;
                                    }
                                    if (f < 0.0f) {
                                        f = 0.0f;
                                    }
                                    if (this.colorScheme == 0) {
                                        color = new Color(0.0f, f, 0.0f);
                                    }
                                    if (this.colorScheme == 1) {
                                        color = new Color(0.0f, 0.0f, f);
                                    }
                                    break block28;
                                }
                                if (this.scaleOn) break;
                                if (l == 0L) {
                                    color = new Color(0, 0, 0);
                                }
                                if (this.colorScheme == 0) {
                                    color = new Color(0, 255, 0);
                                }
                                if (this.colorScheme == 1) {
                                    color = new Color(0, 0, 255);
                                    return color;
                                }
                                break;
                            }
                        }
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            catch (Exception exception) {
                System.out.println("Exception (SingleArrayViewerCanvas.getGreenScaleColor()): " + exception);
            }
            finally {
                return color;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Color getRedScaleColor(long l) {
            Color color = null;
            try {
                if (!this.scaleOn) {
                    if (!this.scaleOn) {
                        if (l == 0L) {
                            color = new Color(0, 0, 0);
                        }
                        color = new Color(255, 0, 0);
                        return color;
                    }
                } else {
                    if (this.style == 1) {
                        if (l == 0L) {
                            float f = new Double((double)((float)Math.log(1.0)) / Math.log(this.getTopCy5())).floatValue();
                            if (f > 255.0f) {
                                f = 255.0f;
                            }
                            if (f < 0.0f) {
                                f = 0.0f;
                            }
                            color = new Color(f, 0.0f, 0.0f);
                        }
                        float f = new Double((double)((float)Math.log(l)) / Math.log(this.getTopCy5())).floatValue();
                        if (f > 255.0f) {
                            f = 255.0f;
                        }
                        if (f < 0.0f) {
                            f = 0.0f;
                        }
                        color = new Color(f, 0.0f, 0.0f);
                    }
                    if (this.style == 0) {
                        float f = (float)l / this.getTopCy5();
                        if (f > 1.0f) {
                            f = 1.0f;
                        }
                        if (f < 0.0f) {
                            f = 0.0f;
                        }
                        color = new Color(f, 0.0f, 0.0f);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            catch (Exception exception) {
                System.out.println("Exception (SingleArrayViewerCanvas.getRedScaleColor()): " + exception);
            }
            finally {
                return color;
            }
        }

        public void drawSlideDataElement(Graphics2D graphics2D, int n, int n2, int n3) {
            float f = SingleArrayViewer.this.slideData.getCY3(n);
            float f2 = SingleArrayViewer.this.slideData.getCY5(n);
            int n4 = this.getXpos(n3);
            int n5 = this.getYpos(n2);
            switch (this.paletteStyle) {
                case 1: {
                    if (this.thresholdsOn) {
                        if (f + f2 > 0.0f && ((double)(f / (f + f2)) > this.highDifference || (double)(f / (f + f2)) < this.lowDifference)) {
                            this.fillRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, this.xElementSize, this.yElementSize, this.getFalseColor((long)f));
                            break;
                        }
                        if (f == 0.0f && f2 == 0.0f) {
                            this.fillRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, this.xElementSize, this.yElementSize, Color.gray);
                            break;
                        }
                        this.fillRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, this.xElementSize, this.yElementSize, Color.black);
                        break;
                    }
                    if (f == 0.0f && f2 == 0.0f) {
                        this.fillRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, this.xElementSize, this.yElementSize, Color.gray);
                        break;
                    }
                    this.fillRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, this.xElementSize, this.yElementSize, this.getFalseColor((long)f));
                    break;
                }
                case 2: {
                    int n6 = f + f2 == 0.0f ? 0 : (int)((float)this.xElementSize * f / (f + f2));
                    if (n6 > this.xElementSize) {
                        n6 = this.xElementSize;
                    }
                    if (f <= 0.0f && f2 <= 0.0f) {
                        this.fillRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, this.xElementSize, this.yElementSize, Color.gray);
                        break;
                    }
                    if (this.thresholdsOn) {
                        if (f + f2 > 0.0f && ((double)(f / (f + f2)) > this.highDifference || (double)(f / (f + f2)) < this.lowDifference)) {
                            this.fillRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, this.xElementSize, this.yElementSize, this.getRedScaleColor((long)f2));
                            this.fillRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, n6, this.yElementSize, this.getGreenScaleColor((long)f));
                            break;
                        }
                        this.fillRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, this.xElementSize, this.yElementSize, Color.black);
                        break;
                    }
                    this.fillRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, this.xElementSize, this.yElementSize, this.getRedScaleColor((long)f2));
                    this.fillRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, n6, this.yElementSize, this.getGreenScaleColor((long)f));
                    break;
                }
                case 3: {
                    if (this.thresholdsOn) {
                        if (f + f2 > 0.0f && ((double)(f / (f + f2)) > this.highDifference || (double)(f / (f + f2)) < this.lowDifference)) {
                            if (this.colorScheme == 0) {
                                this.fillRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, this.xElementSize, this.yElementSize, new Color(this.getRedScaleColor((long)f2).getRed(), this.getGreenScaleColor((long)f).getGreen(), 0));
                                break;
                            }
                            if (this.colorScheme != 1) break;
                            this.fillRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, this.xElementSize, this.yElementSize, new Color(this.getRedScaleColor((long)f2).getRed(), 0, this.getGreenScaleColor((long)f).getBlue()));
                            break;
                        }
                        if (f == 0.0f && f2 == 0.0f) {
                            this.fillRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, this.xElementSize, this.yElementSize, Color.gray);
                            break;
                        }
                        this.fillRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, this.xElementSize, this.yElementSize, Color.black);
                        break;
                    }
                    if (f == 0.0f && f2 == 0.0f) {
                        this.fillRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, this.xElementSize, this.yElementSize, Color.gray);
                        break;
                    }
                    if (this.colorScheme == 0) {
                        this.fillRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, this.xElementSize, this.yElementSize, new Color(this.getRedScaleColor((long)f2).getRed(), this.getGreenScaleColor((long)f).getGreen(), 0));
                        break;
                    }
                    if (this.colorScheme != 1) break;
                    this.fillRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, this.xElementSize, this.yElementSize, new Color(this.getRedScaleColor((long)f2).getRed(), 0, this.getGreenScaleColor((long)f).getBlue()));
                    break;
                }
            }
            this.drawRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, this.xElementSize, this.yElementSize, Color.black);
        }

        public void drawSlideDataElement2(Graphics2D graphics2D, int n, int n2, int n3) {
            float f = SingleArrayViewer.this.slideData.getCY3(n);
            float f2 = SingleArrayViewer.this.slideData.getCY5(n);
            int n4 = this.getXpos(n3);
            int n5 = this.getYpos(n2);
            if (this.thresholdsOn) {
                if (f + f2 > 0.0f && ((double)(f / (f + f2)) > this.highDifference || (double)(f / (f + f2)) < this.lowDifference)) {
                    this.fillRect(graphics2D, n4 + this.getX2Start(), n5 + this.preYSpacing, this.xElementSize, this.yElementSize, this.getFalseColor2((long)f2));
                    this.drawRect(graphics2D, n4 + this.getX2Start(), n5 + this.preYSpacing, this.xElementSize, this.yElementSize, Color.black);
                } else {
                    this.fillRect(graphics2D, n4 + this.getX2Start(), n5 + this.preYSpacing, this.xElementSize, this.yElementSize, Color.black);
                }
            } else {
                this.fillRect(graphics2D, n4 + this.getX2Start(), n5 + this.preYSpacing, this.xElementSize, this.yElementSize, this.getFalseColor2((long)f2));
                this.drawRect(graphics2D, n4 + this.getX2Start(), n5 + this.preYSpacing, this.xElementSize, this.yElementSize, Color.black);
            }
        }

        public int getX2Start() {
            return this.preXSpacing + this.getXSize() + this.getPaletteSpacing();
        }

        public void drawNullElement(Graphics2D graphics2D, int n) {
            int n2 = n / SingleArrayViewer.this.slideData.getSlideMetaData().getColumns() + 1;
            int n3 = n % SingleArrayViewer.this.slideData.getSlideMetaData().getColumns() + 1;
            int n4 = this.getXpos(n3);
            int n5 = this.getYpos(n2);
            this.fillRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, this.xElementSize, this.yElementSize, Color.gray);
            this.drawRect(graphics2D, n4 + this.preXSpacing, n5 + this.preYSpacing, this.xElementSize, this.yElementSize, Color.black);
        }

        public void drawNullElement2(Graphics2D graphics2D, int n) {
            int n2 = n / SingleArrayViewer.this.slideData.getSlideMetaData().getColumns() + 1;
            int n3 = n % SingleArrayViewer.this.slideData.getSlideMetaData().getColumns() + 1;
            int n4 = this.getXpos(n3);
            int n5 = this.getYpos(n2);
            this.fillRect(graphics2D, n4 + this.getX2Start(), n5 + this.preYSpacing, this.xElementSize, this.yElementSize, Color.gray);
            this.drawRect(graphics2D, n4 + this.getX2Start(), n5 + this.preYSpacing, this.xElementSize, this.yElementSize, Color.black);
        }

        public void drawSlideFileName(Graphics2D graphics2D, String string) {
            this.drawString(graphics2D, string, 16 * this.getXSize() / 40 + this.preXSpacing, this.preYSpacing / 2, Color.black, this.largeFont);
        }

        public void setFoot(Graphics2D graphics2D) {
            int n = this.getXSize();
            int n2 = this.getYSize();
            this.drawString(graphics2D, "Cy3", 19 * n / 40 + this.preXSpacing, this.preYSpacing + n2 + this.postYSpacing - 10, Color.black, this.largeFont);
            this.drawString(graphics2D, "Cy5", 19 * n / 40 + 2 * this.preXSpacing + n + 15, this.preYSpacing + n2 + this.postYSpacing - 10, Color.black, this.largeFont);
            this.drawString(graphics2D, Long.toString((long)this.getTopCy3()), 16 * n / 20 + this.preXSpacing, this.preYSpacing - 5, Color.black, this.smallFont);
            this.drawString(graphics2D, Long.toString((long)this.getTopCy5()), this.preXSpacing + n + this.getPaletteSpacing(), this.preYSpacing - 5, Color.black, this.smallFont);
        }

        public void drawScale(Graphics2D graphics2D) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            n = this.xElementSize / 2 < 1 ? 1 : (int)((double)this.xElementSize / 2.0);
            n2 = this.getYSize() / this.palette.size() < 1 ? 1 : (int)((double)this.getYSize() / (double)this.palette.size());
            n3 = this.preXSpacing + this.getXSize() + (this.getPaletteSpacing() - n) / 2;
            int n4 = this.preYSpacing + (this.getYSize() - n2 * this.palette.size()) / 2;
            for (int i = 0; i < this.palette.size(); ++i) {
                this.fillRect(graphics2D, n3, n4 + i * n2, n, n2, (Color)this.palette.elementAt(255 - i));
            }
        }
    }

    private class SingleArrayViewerInfoBox
    extends JPanel {
        private GBA gba = new GBA();
        private JLabel slideLabel;
        private JLabel normalizationLabel;

        public SingleArrayViewerInfoBox() {
            this.setBackground(Color.white);
            this.slideLabel = new JLabel("Sample Text");
            this.normalizationLabel = new JLabel("Normalization Text");
        }

        public JLabel getSlideLabel() {
            return this.slideLabel;
        }

        public JLabel getNormalizationLabel() {
            return this.normalizationLabel;
        }
    }

    public class SingleArrayViewerPanel
    extends JPanel {
        GridBagLayout displayPanelLayout = new GridBagLayout();
        ButtonGroup displayCheckboxGroup;
        JRadioButton blueRedCheckbox;
        JRadioButton greenRedCheckbox;
        JRadioButton overlayCheckbox;
        JCheckBox thresholdCheckbox;
        JCheckBox greenRedScaleCheckbox;
        JCheckBox linearItem;
        JLabel xUpperLimitLabel;
        JLabel yUpperLimitLabel;
        JLabel xUpperLimitValueLabel;
        JLabel yUpperLimitValueLabel;
        JLabel thresholdValueLabel;
        JSlider xUpperLimitScrollbar;
        JSlider yUpperLimitScrollbar;
        JSlider thresholdScrollbar;
        long xLastValue = 0L;
        long yLastValue = 0L;
        long tLastValue = 0L;

        public SingleArrayViewerPanel() {
            SingleArrayViewer.this.buttonGroup = new ButtonGroup();
            Font font = new Font("monospaced", 0, 9);
            this.blueRedCheckbox = new JRadioButton("Blue -> Red", false);
            this.blueRedCheckbox.addItemListener(SingleArrayViewer.this.eventListener);
            GridBagConstraints gridBagConstraints = this.createConstraints(1, 1, 17, 0);
            this.displayPanelLayout.setConstraints(this.blueRedCheckbox, gridBagConstraints);
            SingleArrayViewer.this.buttonGroup.add(this.blueRedCheckbox);
            this.greenRedCheckbox = new JRadioButton("G/R Bar Display", false);
            this.greenRedCheckbox.addItemListener(SingleArrayViewer.this.eventListener);
            gridBagConstraints = this.createConstraints(1, 2, 17, 0);
            this.displayPanelLayout.setConstraints(this.greenRedCheckbox, gridBagConstraints);
            SingleArrayViewer.this.buttonGroup.add(this.greenRedCheckbox);
            this.overlayCheckbox = new JRadioButton("G/R Overlay", true);
            this.overlayCheckbox.addItemListener(SingleArrayViewer.this.eventListener);
            gridBagConstraints = this.createConstraints(1, 3, 17, 0);
            this.displayPanelLayout.setConstraints(this.overlayCheckbox, gridBagConstraints);
            SingleArrayViewer.this.buttonGroup.add(this.overlayCheckbox);
            this.greenRedScaleCheckbox = new JCheckBox("G/R Scale");
            this.greenRedScaleCheckbox.setSelected(true);
            this.greenRedScaleCheckbox.addItemListener(SingleArrayViewer.this.eventListener);
            gridBagConstraints = this.createConstraints(1, 4, 17, 0);
            this.displayPanelLayout.setConstraints(this.greenRedScaleCheckbox, gridBagConstraints);
            this.linearItem = new JCheckBox("Log Scale");
            this.linearItem.addActionListener(SingleArrayViewer.this.eventListener);
            gridBagConstraints = this.createConstraints(1, 5, 17, 0);
            this.displayPanelLayout.setConstraints(this.linearItem, gridBagConstraints);
            this.xUpperLimitLabel = new JLabel("Cy3 Upper Limit");
            gridBagConstraints = this.createConstraints(1, 6, new Insets(10, 5, 0, 0), 17, 0);
            this.displayPanelLayout.setConstraints(this.xUpperLimitLabel, gridBagConstraints);
            this.xUpperLimitScrollbar = new JSlider(0, 0, 10000, 0);
            this.xUpperLimitScrollbar.addChangeListener(SingleArrayViewer.this.eventListener);
            gridBagConstraints = this.createConstraints(1, 7, new Insets(10, 5, 0, 0), 17, 2);
            this.displayPanelLayout.setConstraints(this.xUpperLimitScrollbar, gridBagConstraints);
            this.xUpperLimitValueLabel = new JLabel("0/0", 2);
            this.xUpperLimitValueLabel.setFont(font);
            gridBagConstraints = this.createConstraints(1, 8, new Insets(10, 5, 10, 0), 17, 2);
            this.displayPanelLayout.setConstraints(this.xUpperLimitValueLabel, gridBagConstraints);
            this.yUpperLimitLabel = new JLabel("Cy5 Upper Limit");
            gridBagConstraints = this.createConstraints(1, 9, new Insets(10, 5, 0, 0), 17, 0);
            this.displayPanelLayout.setConstraints(this.yUpperLimitLabel, gridBagConstraints);
            this.yUpperLimitScrollbar = new JSlider(0, 0, 10000, 0);
            this.yUpperLimitScrollbar.addChangeListener(SingleArrayViewer.this.eventListener);
            gridBagConstraints = this.createConstraints(1, 10, new Insets(10, 5, 0, 0), 17, 2);
            this.displayPanelLayout.setConstraints(this.yUpperLimitScrollbar, gridBagConstraints);
            this.yUpperLimitValueLabel = new JLabel("0/0", 2);
            this.yUpperLimitValueLabel.setFont(font);
            gridBagConstraints = this.createConstraints(1, 11, new Insets(10, 5, 10, 0), 17, 2);
            this.displayPanelLayout.setConstraints(this.yUpperLimitValueLabel, gridBagConstraints);
            this.thresholdCheckbox = new JCheckBox("Expression Ratio");
            this.thresholdCheckbox.addItemListener(SingleArrayViewer.this.eventListener);
            gridBagConstraints = this.createConstraints(1, 12, 17, 0);
            this.displayPanelLayout.setConstraints(this.thresholdCheckbox, gridBagConstraints);
            this.thresholdScrollbar = new JSlider(0, 0, 10000, 2000);
            this.thresholdScrollbar.addChangeListener(SingleArrayViewer.this.eventListener);
            gridBagConstraints = this.createConstraints(1, 13, new Insets(10, 5, 0, 0), 17, 2);
            this.displayPanelLayout.setConstraints(this.thresholdScrollbar, gridBagConstraints);
            this.thresholdValueLabel = new JLabel("2.0", 2);
            this.thresholdValueLabel.setFont(font);
            gridBagConstraints = this.createConstraints(1, 14, new Insets(10, 5, 10, 0), 17, 2);
            this.displayPanelLayout.setConstraints(this.thresholdValueLabel, gridBagConstraints);
            this.setLayout(this.displayPanelLayout);
            this.add(this.blueRedCheckbox);
            this.add(this.greenRedCheckbox);
            this.add(this.overlayCheckbox);
            this.add(this.thresholdCheckbox);
            this.add(this.greenRedScaleCheckbox);
            this.add(this.linearItem);
            this.add(this.xUpperLimitLabel);
            this.add(this.yUpperLimitLabel);
            this.add(this.xUpperLimitValueLabel);
            this.add(this.yUpperLimitValueLabel);
            this.add(this.thresholdValueLabel);
            this.add(this.xUpperLimitScrollbar);
            this.add(this.yUpperLimitScrollbar);
            this.add(this.thresholdScrollbar);
        }

        public void setXYScrollbars(long l, long l2) {
            if (l > l2) {
                this.xUpperLimitScrollbar.setMinimum(0);
                this.xUpperLimitScrollbar.setMaximum((int)l);
                this.xUpperLimitScrollbar.setValue((int)l);
                this.yUpperLimitScrollbar.setMinimum(0);
                this.yUpperLimitScrollbar.setMaximum((int)l);
                this.yUpperLimitScrollbar.setValue((int)l2);
                this.xUpperLimitValueLabel.setText(l + " / " + l);
                this.yUpperLimitValueLabel.setText(l2 + " / " + l);
            } else {
                this.xUpperLimitScrollbar.setMinimum(0);
                this.xUpperLimitScrollbar.setMaximum((int)l2);
                this.xUpperLimitScrollbar.setValue((int)l);
                this.yUpperLimitScrollbar.setMinimum(0);
                this.yUpperLimitScrollbar.setMaximum((int)l2);
                this.yUpperLimitScrollbar.setValue((int)l2);
                this.xUpperLimitValueLabel.setText(l + " / " + l2);
                this.yUpperLimitValueLabel.setText(l2 + " / " + l2);
            }
            this.xLastValue = l;
            this.yLastValue = l2;
        }

        public void setThresholdScrollbar(double d) {
            this.thresholdScrollbar.setMinimum(0);
            this.thresholdScrollbar.setMaximum(10000);
            this.thresholdScrollbar.setValue((int)(1000.0 * d));
            if (d >= 0.0) {
                this.thresholdValueLabel.setText(d + "");
            } else {
                this.thresholdValueLabel.setText("Off");
            }
            this.tLastValue = (long)(1000.0 * d);
        }

        public void updateXUpperLimitScrollbar(long l) {
            this.xUpperLimitScrollbar.setValue((int)l);
            this.xUpperLimitValueLabel.setText(l + " / " + this.xUpperLimitScrollbar.getMaximum());
            this.xLastValue = l;
        }

        public void updateYUpperLimitScrollbar(long l) {
            this.yUpperLimitScrollbar.setValue((int)l);
            this.yUpperLimitValueLabel.setText(l + " / " + this.yUpperLimitScrollbar.getMaximum());
            this.yLastValue = l;
        }

        public void updateThresholdScrollbar(double d) {
            this.thresholdScrollbar.setValue((int)(1000.0 * d));
            if (d >= 0.0) {
                this.thresholdValueLabel.setText(d + "");
            } else {
                this.thresholdValueLabel.setText("Off");
            }
            this.tLastValue = (long)(1000.0 * d);
        }

        public GridBagConstraints createConstraints(int n, int n2, int n3, int n4) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.anchor = n3;
            gridBagConstraints.fill = n4;
            return gridBagConstraints;
        }

        public GridBagConstraints createConstraints(int n, int n2, Insets insets, int n3, int n4) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.insets = insets;
            gridBagConstraints.anchor = n3;
            gridBagConstraints.fill = n4;
            return gridBagConstraints;
        }

        public GridBagConstraints createConstraints(int n, int n2, int n3, int n4, int n5, int n6) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.anchor = n5;
            gridBagConstraints.fill = n6;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            return gridBagConstraints;
        }

        public void systemDisable(int n) {
            switch (n) {
                case 1003: {
                    this.blueRedCheckbox.setEnabled(false);
                    this.greenRedCheckbox.setEnabled(false);
                    this.overlayCheckbox.setEnabled(false);
                    this.thresholdCheckbox.setEnabled(false);
                    this.greenRedScaleCheckbox.setEnabled(false);
                    this.linearItem.setEnabled(false);
                    this.xUpperLimitScrollbar.setEnabled(false);
                    this.yUpperLimitScrollbar.setEnabled(false);
                    this.thresholdScrollbar.setEnabled(false);
                }
            }
        }

        public void systemEnable(int n) {
            switch (n) {
                case 1003: {
                    this.blueRedCheckbox.setEnabled(true);
                    this.greenRedCheckbox.setEnabled(true);
                    this.overlayCheckbox.setEnabled(true);
                    this.thresholdCheckbox.setEnabled(true);
                    this.greenRedScaleCheckbox.setEnabled(true);
                    this.linearItem.setEnabled(true);
                    this.xUpperLimitScrollbar.setEnabled(true);
                    this.yUpperLimitScrollbar.setEnabled(true);
                    this.thresholdScrollbar.setEnabled(true);
                }
            }
        }
    }

    private class EventListener
    implements ActionListener,
    AdjustmentListener,
    ChangeListener,
    ItemListener,
    KeyListener,
    MouseListener,
    MouseMotionListener {
        private EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            SingleArrayViewer.this.handleItems(object);
            if (object == SingleArrayViewer.this.newDatabaseItem) {
                SetDatabaseDialog setDatabaseDialog = new SetDatabaseDialog(SingleArrayViewer.this.getFrame());
                if (setDatabaseDialog.showModal() == 0) {
                    SingleArrayViewer.this.loadDataFromDatabase();
                }
            } else if (object == SingleArrayViewer.this.newFileItem) {
                SingleArrayViewer.this.loadFile();
                SingleArrayViewer.this.refreshSlide();
            } else if (object == SingleArrayViewer.this.newReportItem) {
                SingleArrayViewer.this.setReportFilename();
            } else if (object == SingleArrayViewer.this.saveImageItem) {
                SingleArrayViewer.this.saveImage();
            } else if (object == SingleArrayViewer.this.printImageItem) {
                SingleArrayViewer.this.printImage();
            } else if (object != SingleArrayViewer.this.newSpotfireItem) {
                if (object == SingleArrayViewer.this.closeItem) {
                    SingleArrayViewer.this.close();
                } else if (object == SingleArrayViewer.this.newPlotItem) {
                    SingleArrayViewer.this.createScatterPlot(0);
                } else if (object == SingleArrayViewer.this.newPlotLogItem) {
                    SingleArrayViewer.this.createScatterPlot(1);
                } else if (object == SingleArrayViewer.this.newLogRatioProductItem) {
                    SingleArrayViewer.this.createRatioProductPlot();
                } else if (object == SingleArrayViewer.this.newLogRatioProductByBlockItem) {
                    SingleArrayViewer.this.createRatioProductPlotByBlock();
                } else if (object == SingleArrayViewer.this.newHistogramItem) {
                    SingleArrayViewer.this.createHistogram(0);
                } else if (object == SingleArrayViewer.this.newHistogramLogItem) {
                    SingleArrayViewer.this.createHistogram(1);
                } else if (object == SingleArrayViewer.this.subArrayItem) {
                    SingleArrayViewer.this.createSubArray();
                } else if (object == SingleArrayViewer.this.regionArrayItem) {
                    SetMetaLocationDialog setMetaLocationDialog = new SetMetaLocationDialog(SingleArrayViewer.this.getFrame());
                    setMetaLocationDialog.addActionInfoListener(new ActionInfoListener(){

                        public void actionInfoPerformed(ActionInfoEvent actionInfoEvent) {
                            Hashtable hashtable = actionInfoEvent.getHashtable();
                            SingleArrayViewer.this.createRegion(Integer.parseInt((String)hashtable.get("row")), Integer.parseInt((String)hashtable.get("column")));
                        }
                    });
                    setMetaLocationDialog.show();
                } else if (object == SingleArrayViewer.this.totalIntensityItem) {
                    SingleArrayViewer.this.normalizeData(1);
                } else if (object == SingleArrayViewer.this.leastSquaresItem) {
                    SingleArrayViewer.this.normalizeData(2);
                } else if (object == SingleArrayViewer.this.linearRegressionItem) {
                    SingleArrayViewer.this.normalizeData(3);
                } else if (object == SingleArrayViewer.this.ratioStatisticsItem) {
                    SingleArrayViewer.this.normalizeData(4);
                } else if (object == SingleArrayViewer.this.iterativeLogItem) {
                    SingleArrayViewer.this.normalizeData(6);
                } else if (object == SingleArrayViewer.this.totalIntensityListItem) {
                    SingleArrayViewer.this.normalizeDataList(101);
                } else if (object == SingleArrayViewer.this.leastSquaresListItem) {
                    SingleArrayViewer.this.normalizeDataList(102);
                } else if (object == SingleArrayViewer.this.linearRegressionListItem) {
                    SingleArrayViewer.this.normalizeDataList(103);
                } else if (object == SingleArrayViewer.this.ratioStatisticsListItem) {
                    SingleArrayViewer.this.normalizeDataList(104);
                } else if (object == SingleArrayViewer.this.iterativeLogListItem) {
                    SingleArrayViewer.this.normalizeDataList(106);
                } else if (object == SingleArrayViewer.this.noNormalizationItem) {
                    SingleArrayViewer.this.normalizeData(0);
                } else if (object == SingleArrayViewer.this.sortByLocationItem) {
                    SingleArrayViewer.this.sort(9000);
                } else if (object == SingleArrayViewer.this.sortByRatioItem) {
                    SingleArrayViewer.this.sort(9001);
                } else if (object == SingleArrayViewer.this.logItem) {
                    if (SingleArrayViewer.this.logItem.isSelected()) {
                        SingleArrayViewer.this.canvas.setStyle(1);
                    } else {
                        SingleArrayViewer.this.canvas.setStyle(0);
                    }
                } else if (object == SingleArrayViewer.this.changeColorsItem) {
                    SingleArrayViewer.this.canvas.changeColorScheme();
                } else if (object != SingleArrayViewer.this.blueToRedItem && object != SingleArrayViewer.this.greenRedItem && object != SingleArrayViewer.this.overlayItem) {
                    if (object == SingleArrayViewer.this.defaultSize1Item) {
                        SingleArrayViewer.this.canvas.setElementSize(5, 2);
                        SingleArrayViewer.this.refreshSlide();
                    } else if (object == SingleArrayViewer.this.defaultSize2Item) {
                        SingleArrayViewer.this.canvas.setElementSize(10, 10);
                        SingleArrayViewer.this.refreshSlide();
                    } else if (object == SingleArrayViewer.this.defaultSize3Item) {
                        SingleArrayViewer.this.canvas.setElementSize(20, 5);
                        SingleArrayViewer.this.refreshSlide();
                    } else if (object == SingleArrayViewer.this.defaultSize4Item) {
                        SingleArrayViewer.this.canvas.setElementSize(50, 10);
                        SingleArrayViewer.this.refreshSlide();
                    } else if (object != SingleArrayViewer.this.setElementSizeItem) {
                        if (object == SingleArrayViewer.this.setUpperLimitsItem) {
                            SetUpperLimitsDialog setUpperLimitsDialog = new SetUpperLimitsDialog(SingleArrayViewer.this.getFrame(), SingleArrayViewer.this.panel.xLastValue, SingleArrayViewer.this.panel.yLastValue);
                            if (setUpperLimitsDialog.showModal() == 0) {
                                SingleArrayViewer.this.setUpperLimits((long)setUpperLimitsDialog.getUpperCY3(), (long)setUpperLimitsDialog.getUpperCY5());
                            }
                        } else if (object == SingleArrayViewer.this.setGreenRedThresholdsItem) {
                            SetGreenRedThresholdDialog setGreenRedThresholdDialog = new SetGreenRedThresholdDialog(SingleArrayViewer.this.getFrame(), new Double(SingleArrayViewer.this.canvas.getFactor()));
                            setGreenRedThresholdDialog.addActionInfoListener(new ActionInfoListener(){

                                public void actionInfoPerformed(ActionInfoEvent actionInfoEvent) {
                                    Hashtable hashtable = actionInfoEvent.getHashtable();
                                    SingleArrayViewer.this.setFactor(Float.parseFloat((String)hashtable.get("factor")));
                                }
                            });
                            setGreenRedThresholdDialog.show();
                        } else if (object == SingleArrayViewer.this.setConfidenceItem) {
                            SetConfidenceDialog setConfidenceDialog = new SetConfidenceDialog(SingleArrayViewer.this.getFrame());
                            setConfidenceDialog.addActionInfoListener(new ActionInfoListener(){

                                public void actionInfoPerformed(ActionInfoEvent actionInfoEvent) {
                                    Hashtable hashtable = actionInfoEvent.getHashtable();
                                }
                            });
                            setConfidenceDialog.show();
                        } else if (object == SingleArrayViewer.this.setThresholdsItem) {
                            if (SingleArrayViewer.this.setThresholdsItem.isSelected()) {
                                SingleArrayViewer.this.setThresholds(true);
                            } else {
                                SingleArrayViewer.this.setThresholds(false);
                            }
                        } else if (object == SingleArrayViewer.this.setScaleItem) {
                            if (SingleArrayViewer.this.setScaleItem.isSelected()) {
                                SingleArrayViewer.this.canvas.setScale(true);
                            } else {
                                SingleArrayViewer.this.canvas.setScale(false);
                            }
                        } else if (object == SingleArrayViewer.this.panel.linearItem) {
                            if (SingleArrayViewer.this.panel.linearItem.isSelected()) {
                                SingleArrayViewer.this.logItem.setSelected(true);
                                SingleArrayViewer.this.canvas.setStyle(1);
                            } else {
                                SingleArrayViewer.this.logItem.setSelected(false);
                                SingleArrayViewer.this.canvas.setStyle(0);
                            }
                        } else if (object == SingleArrayViewer.this.panel.thresholdCheckbox) {
                            if (SingleArrayViewer.this.panel.thresholdCheckbox.isSelected()) {
                                SingleArrayViewer.this.setGreenRedThresholdsItem.setSelected(true);
                            } else {
                                SingleArrayViewer.this.setGreenRedThresholdsItem.setSelected(false);
                            }
                        } else if (object == SingleArrayViewer.this.panel.greenRedScaleCheckbox) {
                            if (SingleArrayViewer.this.panel.greenRedScaleCheckbox.isSelected()) {
                                SingleArrayViewer.this.setScaleItem.setSelected(true);
                                SingleArrayViewer.this.canvas.setScale(true);
                            } else {
                                SingleArrayViewer.this.setScaleItem.setSelected(false);
                                SingleArrayViewer.this.canvas.setScale(false);
                            }
                        } else if (object != SingleArrayViewer.this.panel.blueRedCheckbox && object != SingleArrayViewer.this.panel.greenRedCheckbox && object != SingleArrayViewer.this.panel.overlayCheckbox) {
                            if (actionEvent.getActionCommand() == "lineup") {
                                JScrollBar jScrollBar = SingleArrayViewer.this.scrollPane.getVerticalScrollBar();
                                jScrollBar.setValue(jScrollBar.getValue() - SingleArrayViewer.this.canvas.getYElementSize());
                            } else if (actionEvent.getActionCommand() == "linedown") {
                                JScrollBar jScrollBar = SingleArrayViewer.this.scrollPane.getVerticalScrollBar();
                                jScrollBar.setValue(jScrollBar.getValue() + SingleArrayViewer.this.canvas.getYElementSize());
                            } else if (actionEvent.getActionCommand() == "pageup") {
                                JScrollBar jScrollBar = SingleArrayViewer.this.scrollPane.getVerticalScrollBar();
                                jScrollBar.setValue(jScrollBar.getValue() - SingleArrayViewer.this.scrollPane.getViewport().getHeight());
                            } else if (actionEvent.getActionCommand() == "pagedown") {
                                JScrollBar jScrollBar = SingleArrayViewer.this.scrollPane.getVerticalScrollBar();
                                jScrollBar.setValue(jScrollBar.getValue() + SingleArrayViewer.this.scrollPane.getViewport().getHeight());
                            } else {
                                for (int i = 0; i < SingleArrayViewer.this.sortMenuItems.length; ++i) {
                                    if (actionEvent.getSource() != SingleArrayViewer.this.sortMenuItems[i]) continue;
                                    SingleArrayViewer.this.sort(i);
                                }
                            }
                        }
                    }
                }
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object == SingleArrayViewer.this.panel.xUpperLimitScrollbar) {
                SingleArrayViewer.this.setCursor(3);
                SingleArrayViewer.this.panel.xLastValue = ((JSlider)object).getValue();
                SingleArrayViewer.this.panel.xUpperLimitValueLabel.setText(SingleArrayViewer.this.panel.xLastValue + " / " + SingleArrayViewer.this.panel.xUpperLimitScrollbar.getMaximum());
                SingleArrayViewer.this.canvas.setTopCy3(SingleArrayViewer.this.panel.xLastValue);
                SingleArrayViewer.this.refreshSlide();
                SingleArrayViewer.this.setCursor(0);
            } else if (object == SingleArrayViewer.this.panel.yUpperLimitScrollbar) {
                SingleArrayViewer.this.setCursor(3);
                SingleArrayViewer.this.panel.yLastValue = ((JSlider)object).getValue();
                SingleArrayViewer.this.panel.yUpperLimitValueLabel.setText(SingleArrayViewer.this.panel.yLastValue + " / " + SingleArrayViewer.this.panel.yUpperLimitScrollbar.getMaximum());
                SingleArrayViewer.this.canvas.setTopCy5(SingleArrayViewer.this.panel.yLastValue);
                SingleArrayViewer.this.refreshSlide();
                SingleArrayViewer.this.setCursor(0);
            } else if (object == SingleArrayViewer.this.panel.thresholdScrollbar) {
                SingleArrayViewer.this.setCursor(3);
                SingleArrayViewer.this.panel.tLastValue = ((JSlider)object).getValue();
                SingleArrayViewer.this.setFactor((float)SingleArrayViewer.this.panel.tLastValue / 1000.0f);
                SingleArrayViewer.this.panel.updateThresholdScrollbar((double)SingleArrayViewer.this.panel.tLastValue / 1000.0);
                if (SingleArrayViewer.this.panel.tLastValue > 0L) {
                    SingleArrayViewer.this.panel.thresholdValueLabel.setText((double)SingleArrayViewer.this.panel.tLastValue / 1000.0 + "");
                }
                if (SingleArrayViewer.this.panel.thresholdCheckbox.isSelected()) {
                    SingleArrayViewer.this.refreshSlide();
                }
                SingleArrayViewer.this.setCursor(0);
            }
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == SingleArrayViewer.this.panel.blueRedCheckbox && itemEvent.getStateChange() == 1) {
                SingleArrayViewer.this.changePaletteStyle(1);
                SingleArrayViewer.this.handleItems(object);
            } else if (object == SingleArrayViewer.this.panel.greenRedCheckbox && itemEvent.getStateChange() == 1) {
                SingleArrayViewer.this.changePaletteStyle(2);
                SingleArrayViewer.this.handleItems(object);
            } else if (object == SingleArrayViewer.this.panel.overlayCheckbox && itemEvent.getStateChange() == 1) {
                SingleArrayViewer.this.changePaletteStyle(3);
                SingleArrayViewer.this.handleItems(object);
            } else if (object == SingleArrayViewer.this.panel.thresholdCheckbox) {
                if (!SingleArrayViewer.this.canvas.getThresholds()) {
                    SingleArrayViewer.this.setThresholdsItem.setSelected(true);
                    SingleArrayViewer.this.setThresholds(true);
                } else if (SingleArrayViewer.this.canvas.getThresholds()) {
                    SingleArrayViewer.this.setThresholdsItem.setSelected(false);
                    SingleArrayViewer.this.setThresholds(false);
                }
            } else if (object == SingleArrayViewer.this.panel.greenRedScaleCheckbox) {
                if (!SingleArrayViewer.this.canvas.getScale()) {
                    SingleArrayViewer.this.setScaleItem.setSelected(true);
                    SingleArrayViewer.this.canvas.setScale(true);
                } else if (SingleArrayViewer.this.canvas.getScale()) {
                    SingleArrayViewer.this.setScaleItem.setSelected(false);
                    SingleArrayViewer.this.canvas.setScale(false);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SingleArrayViewer.this.canvas.inPosition(mouseEvent.getX(), mouseEvent.getY()) && !mouseEvent.isShiftDown()) {
                try {
                    ISlideDataElement iSlideDataElement = SingleArrayViewer.this.canvas.getSlideDataElementAt(mouseEvent.getX(), mouseEvent.getY());
                    if (iSlideDataElement == null) {
                        return;
                    }
                    int n = SingleArrayViewer.this.canvas.findRow(mouseEvent.getX(), mouseEvent.getY());
                    int n2 = SingleArrayViewer.this.canvas.findColumn(mouseEvent.getX(), mouseEvent.getY());
                    int n3 = SingleArrayViewer.this.slideData.getSlideMetaData().getColumns();
                    int n4 = (n - 1) * n3 + n2 - 1;
                    Manager.displaySlideElementInfo(SingleArrayViewer.this.getFrame(), SingleArrayViewer.this.slideData, iSlideDataElement, n3 * (n - 1) + (n2 - 1));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (SingleArrayViewer.this.slideData == null || mouseEvent.isShiftDown()) {
                return;
            }
            if (SingleArrayViewer.this.slideData.getSize() > 0) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (SingleArrayViewer.this.canvas.inPosition(n, n2)) {
                    if (SingleArrayViewer.this.canvas.getHighlight()) {
                        SingleArrayViewer.this.canvas.drawColoredBoxAt((Graphics2D)SingleArrayViewer.this.canvas.getGraphics(), n, n2, Color.white);
                    }
                    SingleArrayViewer.this.setXOldEvent(n);
                    SingleArrayViewer.this.setYOldEvent(n2);
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

