/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Container;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.tigr.microarray.mev.InformationPanel;
import org.tigr.microarray.mev.Manager;
import org.tigr.microarray.mev.TMEVAlgorithmFactory;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmFactory;
import org.tigr.microarray.mev.cluster.gui.IGUIFactory;
import org.tigr.util.ConfMap;
import org.tigr.util.awt.ImageScreen;

public class TMEV {
    public static final int SYSTEM = 1000;
    public static final int DB_AVAILABLE = 1001;
    public static final int DB_LOGIN = 1002;
    public static final int DATA_AVAILABLE = 1003;
    public static final int SPOTFIRE_AVAILABLE = 1004;
    public static final int DATA_TYPE_TWO_DYE = 1;
    public static final int DATA_TYPE_AFFY = 2;
    private static Connection connection;
    private static Hashtable properties;
    private static AlgorithmFactory algorithmFactory;
    private static IGUIFactory guiFactory;
    private static int coordinatePairCount;
    private static int intensityCount;
    private static int headerRowCount;
    private static int headerColumnCount;
    private static int uniqueIDIndex;
    private static int nameIndex;
    private static boolean indicesAdjusted;
    private static String[] fieldNames;
    private static String[] databases;
    private static int dataType;

    public static void main(String[] stringArray) {
        try {
            String string;
            String string2;
            String string3;
            Container container;
            System.out.println("TIGR MultiExperimentViewer (1057937513220) - version 2.2 - " + System.getProperty("os.name"));
            try {
                container = new InformationPanel();
                string3 = ((InformationPanel)container).getJava3DRunTimeEnvironment();
                string2 = ((InformationPanel)container).getJava3DVendor();
                string = ((InformationPanel)container).getJava3DVersion();
            }
            catch (Exception exception) {
                string3 = "not installed";
                string2 = "not available";
                string = "not available";
            }
            System.out.println("Java Runtime Environment version: " + System.getProperty("java.version"));
            System.out.println("Java Runtime Environment vendor: " + System.getProperty("java.vendor"));
            System.out.println("Java Virtual Machine name: " + System.getProperty("java.vm.name"));
            System.out.println("Java Virtual Machine version: " + System.getProperty("java.vm.version"));
            System.out.println("Java Virtual Machine vendor: " + System.getProperty("java.vm.vendor"));
            System.out.println("Java 3D Runtime Environment: " + string3);
            System.out.println("Java 3D Runtime Environment vendor: " + string2);
            System.out.println("Java 3D Runtime Environment version:" + string);
            System.out.println("Operating System name: " + System.getProperty("os.name"));
            System.out.println("Operating System version: " + System.getProperty("os.version"));
            System.out.println("Operating System architecture: " + System.getProperty("os.arch"));
            TMEV.configure();
            container = new ImageScreen();
            ((ImageScreen)container).showImageScreen(1500L);
            Manager manager = new Manager();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean readPreferencesFile(File file) {
        String string;
        StringTokenizer stringTokenizer;
        String string2;
        BufferedReader bufferedReader = null;
        boolean bl = true;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
        }
        try {
            properties = new Hashtable();
            indicesAdjusted = false;
            while ((string2 = bufferedReader.readLine()) != null) {
                string2.trim();
                if (string2.startsWith("//") || string2.length() == 0) continue;
                stringTokenizer = new StringTokenizer(string2, "\t");
                string = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    properties.put(string, stringTokenizer.nextToken());
                    continue;
                }
                properties.put(string, new String(""));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            string2 = TMEV.getSettingForOption("Element Info");
            stringTokenizer = new StringTokenizer(string2, ":");
            coordinatePairCount = Integer.parseInt(stringTokenizer.nextToken());
            intensityCount = Integer.parseInt(stringTokenizer.nextToken());
            string = TMEV.getSettingForOption("Headers");
            stringTokenizer = new StringTokenizer(string, ":");
            headerRowCount = Integer.parseInt(stringTokenizer.nextToken());
            headerColumnCount = Integer.parseInt(stringTokenizer.nextToken());
            String string3 = TMEV.getSettingForOption("Unique ID");
            uniqueIDIndex = Integer.parseInt(string3);
            String string4 = TMEV.getSettingForOption("Spot Name");
            nameIndex = Integer.parseInt(string4);
            String string5 = TMEV.getSettingForOption("Database Names");
            stringTokenizer = new StringTokenizer(string5, ":");
            databases = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                TMEV.databases[n] = stringTokenizer.nextToken();
                ++n;
            }
            String string6 = TMEV.getSettingForOption("Additional Fields");
            stringTokenizer = new StringTokenizer(string6, ":");
            if (stringTokenizer.countTokens() > 0) {
                fieldNames = new String[stringTokenizer.countTokens()];
                int n2 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    TMEV.fieldNames[n2] = stringTokenizer.nextToken();
                    ++n2;
                }
            } else {
                fieldNames = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public static String getSettingForOption(String string) {
        String string2 = "";
        try {
            string2 = (String)properties.get(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public static boolean connect(String string, String string2) {
        try {
            Object object;
            System.err.println("jdbc.drivers " + System.getProperty("jdbc.drivers"));
            Object object2 = DriverManager.getDrivers();
            while (object2.hasMoreElements()) {
                System.err.println("jdbc.driver " + object2.nextElement());
            }
            object2 = System.getProperty("jdbc.drivers");
            if (object2 != null) {
                object = new StringTokenizer((String)object2, ":");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    try {
                        Class.forName(((StringTokenizer)object).nextToken());
                    }
                    catch (Exception exception) {}
                }
            }
            object = new String(TMEV.getSettingForOption("Database Server Name"));
            Properties properties = new Properties();
            properties.put("user", string);
            properties.put("password", string2);
            properties.put("APPLICATIONNAME", "TIGR MultiExperimentViewer");
            DriverManager.setLoginTimeout(2200);
            connection = DriverManager.getConnection((String)object, properties);
            return true;
        }
        catch (Exception exception) {
            System.out.println("Exception (TMEV.connect()): " + exception);
            return false;
        }
    }

    public static int getCoordinatePairCount() {
        return coordinatePairCount;
    }

    public static int getIntensityCount() {
        return intensityCount;
    }

    public static int getHeaderRowCount() {
        return headerRowCount;
    }

    public static int getHeaderColumnCount() {
        return headerColumnCount;
    }

    public static String[] getFieldNames() {
        if (fieldNames == null) {
            return new String[0];
        }
        return fieldNames;
    }

    public static String[] getDatabases() {
        return databases;
    }

    public static int getUniqueIDIndex() {
        return uniqueIDIndex;
    }

    public static int getNameIndex() {
        return nameIndex;
    }

    public static Connection getConnection() {
        return connection;
    }

    public static int getDataType() {
        return dataType;
    }

    public static void setDataType(int n) {
        dataType = n;
    }

    public static void setIndicesAdjusted(boolean bl) {
        indicesAdjusted = bl;
    }

    public static boolean indicesAdjusted() {
        return indicesAdjusted;
    }

    public static void setUniqueIDIndex(int n) {
        uniqueIDIndex = n < 0 ? 0 : n;
    }

    public static void setNameIndex(int n) {
        nameIndex = n < 0 ? 0 : n;
    }

    public static void setFieldNames(String[] stringArray) {
        fieldNames = stringArray;
    }

    public static void appendFieldNames(String[] stringArray) {
        if (fieldNames == null || stringArray == null) {
            fieldNames = stringArray;
        } else {
            String[] stringArray2 = new String[fieldNames.length + stringArray.length];
            System.arraycopy(fieldNames, 0, stringArray2, 0, fieldNames.length);
            System.arraycopy(stringArray, 0, stringArray2, fieldNames.length, stringArray.length);
            fieldNames = stringArray2;
        }
    }

    public static void clearFieldNames() {
        fieldNames = null;
    }

    public static void configure() {
        String string = "tmev.cfg";
        ConfMap confMap = new ConfMap();
        try {
            Object object;
            try {
                object = TMEV.class.getClassLoader().getResourceAsStream(string);
                if (object != null) {
                    confMap.load((InputStream)object);
                }
            }
            catch (SecurityException securityException) {
                System.out.println("resource configuration file " + securityException);
            }
            catch (IOException iOException) {
                System.out.println("Error 1");
                System.out.println("Error to load configuration file.");
                iOException.printStackTrace();
            }
            object = confMap.getString("gui.factory.class");
            if (object == null || ((String)object).equals("null")) {
                throw new Exception("GUI factory class name not found, check the 'gui.factory.class' key in " + string + " file.");
            }
            Class<?> clazz = Class.forName((String)object);
            guiFactory = (IGUIFactory)clazz.newInstance();
            algorithmFactory = new TMEVAlgorithmFactory(confMap);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static AlgorithmFactory getAlgorithmFactory() {
        return algorithmFactory;
    }

    public static IGUIFactory getGUIFactory() {
        return guiFactory;
    }

    public static void quit() {
        try {
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    static {
        indicesAdjusted = false;
        dataType = 1;
    }
}

