/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import JSci.maths.statistics.FDistribution;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.FloatMatrix;

public class OneWayANOVA
extends AbstractAlgorithm {
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    private FloatMatrix expMatrix;
    private Vector[] clusters;
    private int k;
    private int numGenes;
    private int numExps;
    private int numGroups;
    private float alpha;
    private int correctionMethod;
    int[] groupAssignments;
    float currentP = 0.0f;
    float currentF = 0.0f;
    int currentIndex = 0;
    double constant;
    Vector fValuesVector = new Vector();
    Vector pValuesVector = new Vector();
    int validN;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        Object object;
        int n;
        int n2;
        this.groupAssignments = algorithmData.getIntArray("group-assignments");
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.function = algorithmParameters.getInt("distance-function", 4);
        this.factor = algorithmParameters.getFloat("distance-factor", 1.0f);
        this.absolute = algorithmParameters.getBoolean("distance-absolute", false);
        boolean bl = algorithmParameters.getBoolean("hierarchical-tree", false);
        int n3 = algorithmParameters.getInt("method-linkage", 0);
        boolean bl2 = algorithmParameters.getBoolean("calculate-genes", false);
        boolean bl3 = algorithmParameters.getBoolean("calculate-experiments", false);
        this.expMatrix = algorithmData.getMatrix("experiment");
        this.numGenes = this.expMatrix.getRowDimension();
        this.numExps = this.expMatrix.getColumnDimension();
        this.alpha = algorithmParameters.getFloat("alpha", 0.01f);
        this.correctionMethod = algorithmParameters.getInt("correction-method", 1);
        this.numGroups = algorithmParameters.getInt("numGroups", 3);
        Vector vector = this.sortGenesBySignificance();
        this.k = vector.size();
        FloatMatrix floatMatrix = new FloatMatrix(this.fValuesVector.size(), 1);
        FloatMatrix floatMatrix2 = new FloatMatrix(this.pValuesVector.size(), 1);
        FloatMatrix floatMatrix3 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix4 = new FloatMatrix(this.numGenes, 1);
        for (n2 = 0; n2 < this.fValuesVector.size(); ++n2) {
            floatMatrix.A[n2][0] = ((Float)this.fValuesVector.get(n2)).floatValue();
        }
        for (n2 = 0; n2 < this.pValuesVector.size(); ++n2) {
            floatMatrix2.A[n2][0] = ((Float)this.pValuesVector.get(n2)).floatValue();
        }
        for (n2 = 0; n2 < this.numGenes; ++n2) {
            floatMatrix3.A[n2][0] = this.getDfNum(n2);
            floatMatrix4.A[n2][0] = this.getDfDenom(n2);
        }
        FloatMatrix floatMatrix5 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix6 = new FloatMatrix(this.numGenes, 1);
        for (n = 0; n < floatMatrix5.getRowDimension(); ++n) {
            object = this.getGene(n);
            this.constant = this.getConstant((float[])object);
            floatMatrix5.A[n][0] = (float)this.getGroupsSS((float[])object);
            floatMatrix6.A[n][0] = (float)(this.getTotalSS((float[])object) - this.getGroupsSS((float[])object));
        }
        this.clusters = new Vector[this.k];
        for (n = 0; n < this.k; ++n) {
            this.clusters[n] = (Vector)vector.get(n);
        }
        FloatMatrix floatMatrix7 = this.getMeans(this.clusters);
        object = this.getVariances(this.clusters, floatMatrix7);
        AlgorithmEvent algorithmEvent = null;
        if (bl) {
            algorithmEvent = new AlgorithmEvent(this, 1, this.clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(algorithmEvent);
            algorithmEvent.setIntValue(0);
            algorithmEvent.setId(2);
            this.fireValueChanged(algorithmEvent);
        }
        Cluster cluster = new Cluster();
        NodeList nodeList = cluster.getNodeList();
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] nArray = this.convert2int(this.clusters[i]);
            Node node = new Node(nArray);
            nodeList.addNode(node);
            if (!bl) continue;
            node.setValues(this.calculateHierarchicalTree(nArray, n3, bl2, bl3));
            algorithmEvent.setIntValue(i + 1);
            this.fireValueChanged(algorithmEvent);
        }
        AlgorithmData algorithmData2 = new AlgorithmData();
        algorithmData2.addCluster("cluster", cluster);
        algorithmData2.addParam("number-of-clusters", String.valueOf(this.clusters.length));
        algorithmData2.addMatrix("clusters_means", floatMatrix7);
        algorithmData2.addMatrix("clusters_variances", (FloatMatrix)object);
        algorithmData2.addMatrix("pValues", floatMatrix2);
        algorithmData2.addMatrix("fValues", floatMatrix);
        algorithmData2.addMatrix("dfNumMatrix", floatMatrix3);
        algorithmData2.addMatrix("dfDenomMatrix", floatMatrix4);
        algorithmData2.addMatrix("ssGroupsMatrix", floatMatrix5);
        algorithmData2.addMatrix("ssErrorMatrix", floatMatrix6);
        algorithmData2.addMatrix("geneGroupMeansMatrix", this.getAllGeneGroupMeans());
        algorithmData2.addMatrix("geneGroupSDsMatrix", this.getAllGeneGroupSDs());
        return algorithmData2;
    }

    private NodeValueList calculateHierarchicalTree(int[] nArray, int n, boolean bl, boolean bl2) throws AlgorithmException {
        AlgorithmData algorithmData;
        NodeValueList nodeValueList = new NodeValueList();
        AlgorithmData algorithmData2 = new AlgorithmData();
        FloatMatrix floatMatrix = this.getSubExperiment(this.expMatrix, nArray);
        algorithmData2.addMatrix("experiment", floatMatrix);
        algorithmData2.addParam("distance-function", String.valueOf(this.function));
        algorithmData2.addParam("distance-absolute", String.valueOf(this.absolute));
        algorithmData2.addParam("method-linkage", String.valueOf(n));
        HCL hCL = new HCL();
        if (bl) {
            algorithmData2.addParam("calculate-genes", String.valueOf(true));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        if (bl2) {
            algorithmData2.addParam("calculate-genes", String.valueOf(false));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        return nodeValueList;
    }

    private void addNodeValues(NodeValueList nodeValueList, AlgorithmData algorithmData) {
        nodeValueList.addNodeValue(new NodeValue("child-1-array", algorithmData.getIntArray("child-1-array")));
        nodeValueList.addNodeValue(new NodeValue("child-2-array", algorithmData.getIntArray("child-2-array")));
        nodeValueList.addNodeValue(new NodeValue("node-order", algorithmData.getIntArray("node-order")));
        nodeValueList.addNodeValue(new NodeValue("height", algorithmData.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = floatMatrix.A[nArray[i]];
        }
        return floatMatrix2;
    }

    private void validate(AlgorithmData algorithmData) throws AlgorithmException {
        if (algorithmData.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (algorithmData.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (algorithmData.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (algorithmData.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    private FloatMatrix getMeans(Vector[] vectorArray) {
        FloatMatrix floatMatrix = new FloatMatrix(vectorArray.length, this.numExps);
        for (int i = 0; i < vectorArray.length; ++i) {
            FloatMatrix floatMatrix2 = this.getMean(vectorArray[i]);
            floatMatrix.A[i] = floatMatrix2.A[0];
        }
        return floatMatrix;
    }

    private FloatMatrix getMean(Vector vector) {
        FloatMatrix floatMatrix = new FloatMatrix(1, this.numExps);
        int n = vector.size();
        int n2 = 0;
        for (int i = 0; i < this.numExps; ++i) {
            float f = 0.0f;
            n2 = 0;
            for (int j = 0; j < n; ++j) {
                float f2 = this.expMatrix.get((Integer)vector.get(j), i);
                if (Float.isNaN(f2)) continue;
                f += f2;
                ++n2;
            }
            floatMatrix.set(0, i, f / (float)n2);
        }
        return floatMatrix;
    }

    private FloatMatrix getVariances(Vector[] vectorArray, FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                floatMatrix2.set(i, j, this.getSampleVariance(vectorArray[i], j, floatMatrix.get(i, j)));
            }
        }
        return floatMatrix2;
    }

    private float getSampleNormalizedSum(Vector vector, int n, float f) {
        int n2 = vector.size();
        float f2 = 0.0f;
        this.validN = 0;
        for (int i = 0; i < n2; ++i) {
            float f3 = this.expMatrix.get((Integer)vector.get(i), n);
            if (Float.isNaN(f3)) continue;
            f2 = (float)((double)f2 + Math.pow(f3 - f, 2.0));
            ++this.validN;
        }
        return f2;
    }

    private float getSampleVariance(Vector vector, int n, float f) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(vector, n, f) / (float)(this.validN - 1));
    }

    private Vector sortGenesBySignificance() throws AlgorithmException {
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        AlgorithmEvent algorithmEvent = new AlgorithmEvent(this, 1, this.numGenes);
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        if (this.correctionMethod == 1 || this.correctionMethod == 2) {
            vector = new Vector();
            vector2 = new Vector();
            for (int i = 0; i < this.numGenes; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                algorithmEvent.setIntValue(i);
                algorithmEvent.setDescription("Current gene = " + (i + 1));
                this.fireValueChanged(algorithmEvent);
                if (this.isSignificant(i)) {
                    vector.add(new Integer(i));
                    this.fValuesVector.add(new Float(this.currentF));
                    this.pValuesVector.add(new Float(this.currentP));
                    continue;
                }
                vector2.add(new Integer(i));
                this.fValuesVector.add(new Float(this.currentF));
                this.pValuesVector.add(new Float(this.currentP));
            }
        }
        Vector<Vector<Integer>> vector3 = new Vector<Vector<Integer>>();
        vector3.add(vector);
        vector3.add(vector2);
        return vector3;
    }

    private float[] getGene(int n) {
        float[] fArray = new float[this.expMatrix.getColumnDimension()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.expMatrix.A[n][i];
        }
        return fArray;
    }

    private int getDfNum(int n) {
        int n2 = 0;
        for (int i = 0; i < this.numExps; ++i) {
            if (Float.isNaN(this.expMatrix.A[n][i]) || this.groupAssignments[i] == 0) continue;
            ++n2;
        }
        if (n2 == 0) {
            return -1;
        }
        return this.numGroups - 1;
    }

    private int getDfDenom(int n) {
        int n2 = 0;
        for (int i = 0; i < this.numExps; ++i) {
            if (Float.isNaN(this.expMatrix.A[n][i]) || this.groupAssignments[i] == 0) continue;
            ++n2;
        }
        if (n2 == 0) {
            return -1;
        }
        return n2 - this.numGroups;
    }

    private boolean isSignificant(int n) {
        boolean bl = false;
        float[] fArray = new float[this.numExps];
        int n2 = 0;
        for (int i = 0; i < this.numExps; ++i) {
            fArray[i] = this.expMatrix.A[n][i];
            if (Float.isNaN(fArray[i])) continue;
            ++n2;
        }
        if (n2 == 0) {
            this.currentF = Float.NaN;
            this.currentP = Float.NaN;
            return false;
        }
        this.constant = this.getConstant(fArray);
        double d = this.getTotalSS(fArray);
        double d2 = this.getGroupsSS(fArray);
        double d3 = d - d2;
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3)) {
            this.currentF = Float.NaN;
            this.currentP = Float.NaN;
            return false;
        }
        int n3 = this.getDfNum(n);
        int n4 = this.getDfDenom(n);
        double d4 = d2 / (double)n3;
        double d5 = d3 / (double)n4;
        double d6 = d4 / d5;
        this.currentF = (float)d6;
        FDistribution fDistribution = new FDistribution(n3, n4);
        double d7 = fDistribution.cumulative(d6);
        double d8 = 1.0 - d7;
        if (d8 > 1.0) {
            d8 = 1.0;
        }
        this.currentP = (float)d8;
        double d9 = 0.0;
        if (this.correctionMethod == 1) {
            d9 = this.alpha;
        } else if (this.correctionMethod == 2) {
            d9 = (double)this.alpha / (double)this.numGenes;
        }
        bl = d8 <= d9;
        return bl;
    }

    private double getConstant(float[] fArray) {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i]) || this.groupAssignments[i] == 0) continue;
            d += (double)fArray[i];
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        double d2 = Math.pow(d, 2.0) / (double)n;
        return d2;
    }

    private double getTotalSS(float[] fArray) {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i]) || this.groupAssignments[i] == 0) continue;
            d += Math.pow(fArray[i], 2.0);
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        return d -= this.constant;
    }

    private double getGroupsSS(float[] fArray) {
        float[][] fArrayArray = new float[this.numGroups][];
        for (int i = 0; i < this.numGroups; ++i) {
            fArrayArray[i] = this.getGeneValuesForGroup(fArray, i + 1);
        }
        double[] dArray = new double[this.numGroups];
        for (int i = 0; i < this.numGroups; ++i) {
            dArray[i] = this.getAvSquare(fArrayArray[i]);
        }
        double d = 0.0;
        for (int i = 0; i < this.numGroups; ++i) {
            d += dArray[i];
        }
        return d - this.constant;
    }

    private float[] getGeneGroupMeans(int n) {
        float[] fArray = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            fArray[i] = this.expMatrix.A[n][i];
        }
        float[][] fArrayArray = new float[this.numGroups][];
        for (int i = 0; i < this.numGroups; ++i) {
            fArrayArray[i] = this.getGeneValuesForGroup(fArray, i + 1);
        }
        float[] fArray2 = new float[this.numGroups];
        for (int i = 0; i < this.numGroups; ++i) {
            fArray2[i] = this.getMean(fArrayArray[i]);
        }
        return fArray2;
    }

    private float[] getGeneGroupSDs(int n) {
        float[] fArray = new float[this.numExps];
        for (int i = 0; i < this.numExps; ++i) {
            fArray[i] = this.expMatrix.A[n][i];
        }
        float[][] fArrayArray = new float[this.numGroups][];
        for (int i = 0; i < this.numGroups; ++i) {
            fArrayArray[i] = this.getGeneValuesForGroup(fArray, i + 1);
        }
        float[] fArray2 = new float[this.numGroups];
        for (int i = 0; i < this.numGroups; ++i) {
            fArray2[i] = this.getStdDev(fArrayArray[i]);
        }
        return fArray2;
    }

    private float[] getGeneValuesForGroup(float[] fArray, int n) {
        Vector<Float> vector = new Vector<Float>();
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] != n) continue;
            vector.add(new Float(fArray[i]));
        }
        float[] fArray2 = new float[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            fArray2[i] = ((Float)vector.get(i)).floatValue();
        }
        return fArray2;
    }

    private FloatMatrix getAllGeneGroupMeans() {
        FloatMatrix floatMatrix = new FloatMatrix(this.numGenes, this.numGroups);
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            floatMatrix.A[i] = this.getGeneGroupMeans(i);
        }
        return floatMatrix;
    }

    private FloatMatrix getAllGeneGroupSDs() {
        FloatMatrix floatMatrix = new FloatMatrix(this.numGenes, this.numGroups);
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            floatMatrix.A[i] = this.getGeneGroupSDs(i);
        }
        return floatMatrix;
    }

    private double getAvSquare(float[] fArray) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            d2 += (double)fArray[i];
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        d = Math.pow(d2, 2.0) / (double)n;
        return d;
    }

    private float getMean(float[] fArray) {
        float f = 0.0f;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            f += fArray[i];
            ++n;
        }
        if (n == 0) {
            return Float.NaN;
        }
        float f2 = f / (float)n;
        if (Float.isInfinite(f2)) {
            return Float.NaN;
        }
        return f2;
    }

    private float getStdDev(float[] fArray) {
        float f = this.getMean(fArray);
        int n = 0;
        float f2 = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            f2 = (float)((double)f2 + Math.pow(fArray[i] - f, 2.0));
            ++n;
        }
        if (n < 2) {
            return Float.NaN;
        }
        float f3 = f2 / (float)(n - 1);
        if (Float.isInfinite(f3)) {
            return Float.NaN;
        }
        return (float)Math.sqrt(f3);
    }
}

