/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class ClusterAttributesDialog
extends AlgorithmDialog {
    JTextArea textArea;
    JLabel colorLabel;
    JTextField clusterLabelField;
    int result = 2;
    String clusterLabelStr;
    String clusterDescriptionStr;
    Color clusterColor;

    public ClusterAttributesDialog(String string, String string2, String string3) {
        this(string, string2, string3, null, null, null);
    }

    public ClusterAttributesDialog(String string, String string2, String string3, String string4, String string5, Color color) {
        super(new JFrame(), string, true);
        this.clusterLabelStr = string4;
        this.clusterDescriptionStr = string5;
        this.clusterColor = color;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        EventListener eventListener = new EventListener();
        JLabel jLabel = new JLabel("Analysis Node");
        JTextField jTextField = new JTextField(string2);
        jTextField.setEditable(false);
        jTextField.setHorizontalAlignment(0);
        JLabel jLabel2 = new JLabel("Cluster Node");
        JTextField jTextField2 = new JTextField(string3);
        jTextField2.setEditable(false);
        jTextField2.setHorizontalAlignment(0);
        JLabel jLabel3 = new JLabel("Cluster Label*");
        this.clusterLabelField = new JTextField(15);
        if (this.clusterLabelStr != null) {
            this.clusterLabelField.setText(this.clusterLabelStr);
        }
        JLabel jLabel4 = new JLabel("Remarks: *");
        this.textArea = new JTextArea(2, 30);
        this.textArea.setBorder(BorderFactory.createBevelBorder(1, Color.lightGray, Color.gray));
        this.textArea.setMargin(new Insets(0, 3, 0, 3));
        this.textArea.setSize(350, 50);
        this.textArea.setPreferredSize(new Dimension(370, 50));
        this.textArea.setMargin(new Insets(2, 3, 2, 3));
        if (this.clusterDescriptionStr != null) {
            this.textArea.setText(this.clusterDescriptionStr);
        }
        JButton jButton = new JButton("Select Color");
        jButton.setFocusPainted(false);
        jButton.setBorder(BorderFactory.createBevelBorder(0, Color.gray, Color.darkGray));
        jButton.setSize(80, 25);
        jButton.setPreferredSize(new Dimension(100, 25));
        jButton.setActionCommand("set-color-command");
        jButton.addActionListener(eventListener);
        this.colorLabel = new JLabel("Preview: No Color");
        this.colorLabel.setHorizontalAlignment(0);
        this.colorLabel.setBorder(BorderFactory.createLineBorder(Color.black, 2));
        this.colorLabel.setBackground(Color.lightGray);
        this.colorLabel.setOpaque(true);
        this.colorLabel.setEnabled(false);
        if (this.clusterColor != null) {
            this.colorLabel.setBackground(color);
            this.colorLabel.setText(" ");
        }
        JLabel jLabel5 = new JLabel("(* = optional fields)");
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 20, 0), 0, 0));
        jPanel.add((Component)jTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 20, 20, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        jPanel.add((Component)jTextField2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 20, 0), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        jPanel.add((Component)this.clusterLabelField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 20, 0), 0, 0));
        jPanel.add((Component)jLabel4, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.textArea, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        jPanel.add((Component)jButton, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        jPanel.add((Component)this.colorLabel, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 50, 10, 50), 0, 0));
        jPanel.add((Component)jLabel5, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(jPanel);
        this.setActionListeners(eventListener);
        if (this.clusterColor == null) {
            this.okButton.setEnabled(false);
        }
        this.pack();
        this.setResizable(false);
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public Color getColor() {
        return this.colorLabel.getBackground();
    }

    public String getLabel() {
        return this.clusterLabelField.getText();
    }

    public String getDescription() {
        return this.textArea.getText();
    }

    public static void main(String[] stringArray) {
        ClusterAttributesDialog clusterAttributesDialog = new ClusterAttributesDialog("Store Cluster Attributes", "KMC-genes (2)", "Cluster 8");
        clusterAttributesDialog.show();
    }

    public class EventListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string == "set-color-command") {
                JColorChooser jColorChooser = new JColorChooser();
                Color color = JColorChooser.showDialog(ClusterAttributesDialog.this, "Cluster Color", null);
                if (color != null) {
                    ClusterAttributesDialog.this.okButton.setEnabled(true);
                    ClusterAttributesDialog.this.colorLabel.setEnabled(true);
                    ClusterAttributesDialog.this.colorLabel.setText(" ");
                    ClusterAttributesDialog.this.colorLabel.setBackground(color);
                } else if (!ClusterAttributesDialog.this.colorLabel.isEnabled()) {
                    ClusterAttributesDialog.this.okButton.setEnabled(false);
                }
            } else if (string == "ok-command") {
                ClusterAttributesDialog.this.result = 0;
                ClusterAttributesDialog.this.dispose();
            } else if (string == "cancel-command") {
                ClusterAttributesDialog.this.result = 2;
                ClusterAttributesDialog.this.dispose();
            } else if (string == "reset-command") {
                if (ClusterAttributesDialog.this.clusterDescriptionStr != null) {
                    ClusterAttributesDialog.this.textArea.setText(ClusterAttributesDialog.this.clusterDescriptionStr);
                    ClusterAttributesDialog.this.textArea.selectAll();
                } else {
                    ClusterAttributesDialog.this.textArea.setText("");
                }
                ClusterAttributesDialog.this.textArea.setCaretPosition(0);
                if (ClusterAttributesDialog.this.clusterColor != null) {
                    ClusterAttributesDialog.this.colorLabel.setBackground(ClusterAttributesDialog.this.clusterColor);
                } else {
                    ClusterAttributesDialog.this.colorLabel.setBackground(Color.lightGray);
                    ClusterAttributesDialog.this.colorLabel.setText("Preview: No Color");
                    ClusterAttributesDialog.this.colorLabel.setEnabled(false);
                }
                if (ClusterAttributesDialog.this.clusterLabelStr != null) {
                    ClusterAttributesDialog.this.clusterLabelField.setText(ClusterAttributesDialog.this.clusterLabelStr);
                    ClusterAttributesDialog.this.clusterLabelField.selectAll();
                } else {
                    ClusterAttributesDialog.this.clusterLabelField.setText("");
                }
                ClusterAttributesDialog.this.clusterLabelField.requestFocus();
                ClusterAttributesDialog.this.clusterLabelField.setCaretPosition(0);
            } else if (string == "info-command") {
                HelpWindow helpWindow = new HelpWindow(ClusterAttributesDialog.this, "Cluster Save Dialog");
                ClusterAttributesDialog.this.result = 2;
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 600);
                    helpWindow.setLocation();
                    helpWindow.show();
                    return;
                }
                helpWindow.setVisible(false);
                helpWindow.dispose();
                return;
            }
        }
    }
}

