/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.fom;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.fom.FOMGraph;

public class FOMContentComponent
extends JPanel {
    private FOMGraph fomGraph;
    private float[] fom_values;

    public FOMContentComponent(float[] fArray) {
        this.setLayout(new GridBagLayout());
        this.fom_values = fArray;
        this.fomGraph = new FOMGraph(fArray, "FOM value vs. # of clusters", "Number of Clusters", "Adjusted FOM");
        this.fomGraph.setItems(this.createXItems(fArray.length), this.createYItems(fArray));
        this.fomGraph.setMaxYValue((float)Math.ceil(this.getMaxValue(fArray)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fomGraph, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.createValuesList(fArray), gridBagConstraints);
    }

    public BufferedImage getImage() {
        return this.fomGraph.getImage();
    }

    private JComponent createValuesList(float[] fArray) {
        String[] stringArray = new String[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            stringArray[i] = String.valueOf(i + 1) + "---->" + String.valueOf((float)Math.round(fArray[i] * 1000.0f) / 1000.0f);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(new JList<String>(stringArray));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        JButton jButton = new JButton("Details");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FOMContentComponent.this.onDetails();
            }
        });
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    private void onDetails() {
        JFrame jFrame = new JFrame("Details");
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.fom_values.length; ++i) {
            stringBuffer.append(String.valueOf(i + 1) + "\t" + String.valueOf((float)Math.round(this.fom_values[i] * 1000.0f) / 1000.0f) + "\n");
        }
        jTextArea.setText(stringBuffer.toString());
        jTextArea.setCaretPosition(0);
        jFrame.getContentPane().add(jScrollPane);
        jFrame.setSize(200, 200);
        Dimension dimension = jFrame.getToolkit().getScreenSize();
        jFrame.setLocation(dimension.width / 2 - jFrame.getSize().width / 2, dimension.height / 2 - jFrame.getSize().height / 2);
        jFrame.setVisible(true);
    }

    public void onSelected(IFramework iFramework) {
        this.fomGraph.setAntiAliasing(iFramework.getDisplayMenu().isAntiAliasing());
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.fomGraph.setAntiAliasing(iDisplayMenu.isAntiAliasing());
    }

    private String[] createXItems(int n) {
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            if ((i + 1) % 5 != 0 && i != 0 && i != stringArray.length - 1) continue;
            stringArray[i] = String.valueOf(i + 1);
        }
        return stringArray;
    }

    private float getMaxValue(float[] fArray) {
        float f = -3.4028235E38f;
        for (int i = 0; i < fArray.length; ++i) {
            f = Math.max(f, fArray[i]);
        }
        return f;
    }

    private String[] createYItems(float[] fArray) {
        int n = (int)Math.ceil(this.getMaxValue(fArray)) + 1;
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            if (i % 2 != 0 && i != stringArray.length - 1) continue;
            stringArray[i] = String.valueOf(i);
        }
        return stringArray;
    }

    public static void main(String[] stringArray) throws Exception {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        float[] fArray = new float[]{1.5f, 0.8888889f, 0.6666667f, 2.5f, 0.33333334f, 0.0f};
        FOMContentComponent fOMContentComponent = new FOMContentComponent(fArray);
        jFrame.getContentPane().add(fOMContentComponent);
        jFrame.setSize(700, 400);
        Dimension dimension = jFrame.getToolkit().getScreenSize();
        jFrame.setLocation(dimension.width / 2 - jFrame.getSize().width / 2, dimension.height / 2 - jFrame.getSize().height / 2);
        jFrame.setVisible(true);
    }
}

