/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.fom;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class FOMGraph
extends JPanel {
    private float[] values;
    private String[] xItems;
    private String[] yItems;
    private String title;
    private String xLabel;
    private String yLabel;
    private Insets insets;
    private boolean isAntiAliasing = false;
    private int maxXItem;
    private int maxYItem;
    private float maxYValue = 1.0f;
    private Color pointColor = Color.red;
    private Color valuesLineColor = Color.blue;
    private Color mouseLineColor = Color.magenta;
    private Color gridLineColor = Color.yellow;
    private Color axisLineColor = Color.black;
    private int pointSize = 5;
    private MouseHandler mouseHandler;

    public FOMGraph(float[] fArray, String string, String string2, String string3) {
        if (fArray == null) {
            throw new IllegalArgumentException("values == null");
        }
        this.setBackground(Color.white);
        this.insets = new Insets(60, 60, 60, 60);
        this.values = fArray;
        this.title = string;
        this.xLabel = string2;
        this.yLabel = string3;
        this.mouseHandler = new MouseHandler();
        this.addMouseMotionListener(this.mouseHandler);
    }

    public void setItems(String[] stringArray, String[] stringArray2) {
        this.xItems = stringArray;
        this.yItems = stringArray2;
        this.maxXItem = this.getMaxWidth(stringArray);
        this.maxYItem = this.getMaxWidth(stringArray2);
    }

    public void setMaxYValue(float f) {
        this.maxYValue = f;
    }

    public BufferedImage getImage() {
        BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.getWidth(), this.getHeight());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        this.paint(graphics2D);
        return bufferedImage;
    }

    public void setAntiAliasing(boolean bl) {
        this.isAntiAliasing = bl;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        float f;
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n4 = fontMetrics.getDescent();
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Dimension dimension = this.getSize();
        int n5 = this.insets.left + this.maxYItem;
        int n6 = this.insets.top;
        int n7 = dimension.width - n5 - this.insets.right;
        int n8 = dimension.height - this.insets.bottom - n6 - this.maxXItem;
        float f2 = (float)n7 / (float)(this.values.length - 1);
        float f3 = (float)n8 / this.maxYValue;
        int n9 = fontMetrics.stringWidth(this.title);
        graphics2D.drawString(this.title, n5 + (n7 - n9) / 2, (this.insets.top + n4) / 2);
        n9 = fontMetrics.stringWidth(this.xLabel);
        graphics2D.drawString(this.xLabel, n5 + (n7 - n9) / 2, this.insets.top + n8 + this.maxXItem + (this.insets.top + n4) / 2);
        n9 = fontMetrics.stringWidth(this.yLabel);
        graphics2D.rotate(-1.5707963267948966);
        graphics2D.drawString(this.yLabel, -(this.insets.top + (n8 + n9) / 2), (this.insets.left + n4) / 2);
        graphics2D.rotate(1.5707963267948966);
        graphics2D.setColor(this.gridLineColor);
        if (this.yItems != null) {
            f = (float)n8 / (float)(this.yItems.length - 1);
            for (n3 = 0; n3 < this.yItems.length; ++n3) {
                if (this.yItems[this.yItems.length - n3 - 1] == null) continue;
                graphics2D.drawLine(n5, n6 + Math.round((float)n3 * f), n5 + n7, n6 + Math.round((float)n3 * f));
            }
        }
        if (this.xItems != null) {
            f = (float)n7 / (float)(this.xItems.length - 1);
            for (n3 = 0; n3 < this.xItems.length; ++n3) {
                if (this.xItems[n3] == null) continue;
                graphics2D.drawLine(n5 + Math.round((float)n3 * f), n6, n5 + Math.round((float)n3 * f), n6 + n8);
            }
        }
        graphics2D.setColor(this.axisLineColor);
        graphics2D.drawLine(n5, n6, n5, n6 + n8);
        if (this.yItems != null) {
            f = (float)n8 / (float)(this.yItems.length - 1);
            for (n3 = 0; n3 < this.yItems.length; ++n3) {
                graphics2D.drawLine(n5 - 5, n6 + Math.round((float)n3 * f), n5 + 5, n6 + Math.round((float)n3 * f));
                if (this.yItems[this.yItems.length - n3 - 1] == null) continue;
                graphics2D.drawString(this.yItems[this.yItems.length - n3 - 1], n5 - 7 - fontMetrics.stringWidth(this.yItems[this.yItems.length - n3 - 1]), n6 + Math.round((float)n3 * f) + n4);
            }
        }
        if (this.xItems != null) {
            f = (float)n7 / (float)(this.xItems.length - 1);
            for (n3 = 0; n3 < this.xItems.length; ++n3) {
                graphics2D.drawLine(n5 + Math.round((float)n3 * f), n6 + n8 - 5, n5 + Math.round((float)n3 * f), n6 + n8 + 5);
            }
            graphics2D.rotate(-1.5707963267948966);
            n3 = n6 + n8 + 7;
            for (n2 = 0; n2 < this.xItems.length; ++n2) {
                if (this.xItems[n2] == null) continue;
                graphics2D.drawString(this.xItems[n2], -(n3 + fontMetrics.stringWidth(this.xItems[n2])), n5 + Math.round((float)n2 * f) + n4);
            }
            graphics2D.rotate(1.5707963267948966);
        }
        graphics2D.drawLine(n5, n6 + n8, n5 + n7, n6 + n8);
        graphics2D.setColor(this.valuesLineColor);
        for (n = 0; n < this.values.length - 1; ++n) {
            int n10 = n5 + Math.round((float)n * f2);
            n3 = n6 + n8 - Math.round(this.values[n] * f3);
            n2 = n5 + Math.round((float)(n + 1) * f2);
            int n11 = n6 + n8 - Math.round(this.values[n + 1] * f3);
            graphics2D.drawLine(n10, n3, n2, n11);
        }
        graphics2D.setColor(this.pointColor);
        for (n = 0; n < this.values.length; ++n) {
            graphics2D.fillOval(n5 + Math.round((float)n * f2) - this.pointSize / 2, n6 + n8 - Math.round(this.values[n] * f3) - this.pointSize / 2, this.pointSize, this.pointSize);
        }
        this.mouseHandler.validate();
    }

    private int getMaxWidth(String[] stringArray) {
        if (stringArray == null) {
            return 0;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            n = Math.max(n, fontMetrics.stringWidth(stringArray[i]));
        }
        return n;
    }

    private void drawMouseCross(int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        graphics2D.setColor(this.mouseLineColor);
        graphics2D.setXORMode(this.getBackground());
        Dimension dimension = this.getSize();
        int n3 = this.insets.left + this.maxYItem;
        int n4 = dimension.width - this.insets.right;
        int n5 = this.insets.top;
        int n6 = dimension.height - this.insets.bottom - this.maxXItem;
        graphics2D.drawLine(n, n5, n, n6);
        graphics2D.drawLine(n3, n2, n4, n2);
        graphics2D.setPaintMode();
        graphics2D.dispose();
    }

    private class MouseHandler
    extends MouseMotionAdapter {
        private Point prevCoords = new Point(-1, -1);

        private MouseHandler() {
        }

        public void validate() {
            if (this.isCoordsValid(this.prevCoords.x, this.prevCoords.y)) {
                FOMGraph.this.drawMouseCross(this.prevCoords.x, this.prevCoords.y);
            }
            this.prevCoords.setLocation(-1, -1);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (this.isCoordsValid(this.prevCoords.x, this.prevCoords.y)) {
                FOMGraph.this.drawMouseCross(this.prevCoords.x, this.prevCoords.y);
            }
            if (this.isCoordsValid(n, n2)) {
                FOMGraph.this.drawMouseCross(n, n2);
            }
            this.prevCoords.setLocation(n, n2);
        }

        private boolean isCoordsValid(int n, int n2) {
            Dimension dimension = FOMGraph.this.getSize();
            int n3 = ((FOMGraph)FOMGraph.this).insets.left + FOMGraph.this.maxYItem;
            int n4 = ((FOMGraph)FOMGraph.this).insets.top;
            int n5 = dimension.width - ((FOMGraph)FOMGraph.this).insets.right;
            int n6 = dimension.height - ((FOMGraph)FOMGraph.this).insets.bottom - FOMGraph.this.maxXItem;
            return n3 < n && n < n5 && n4 < n2 && n2 < n6;
        }
    }
}

