/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.kmcs;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;

public class KMCSuppExperimentCentroidViewer
extends ExperimentClusterCentroidViewer {
    private JPopupMenu popup;

    public KMCSuppExperimentCentroidViewer(Experiment experiment, int[][] nArray) {
        super(experiment, nArray);
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveAllExperimentClusters(frame, this.getExperiment(), this.getData(), this.getClusters());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveExperimentCluster(frame, this.getExperiment(), this.getData(), this.getCluster());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSetColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color color = JColorChooser.showDialog(frame, "Choose color", DEF_CLUSTER_COLOR);
        if (color != null) {
            this.setClusterColor(color);
        }
    }

    private void onSetDefaultColor() {
        this.setClusterColor(null);
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("save-cluster-cmd")) {
                KMCSuppExperimentCentroidViewer.this.onSaveCluster();
            } else if (string.equals("save-all-clusters-cmd")) {
                KMCSuppExperimentCentroidViewer.this.onSaveClusters();
            } else if (string.equals("set-def-color-cmd")) {
                KMCSuppExperimentCentroidViewer.this.onSetDefaultColor();
            } else if (string.equals("set-y-to-exp-max-cmd")) {
                KMCSuppExperimentCentroidViewer.this.yRangeOption = ExperimentClusterCentroidViewer.USE_EXPERIMENT_MAX;
                KMCSuppExperimentCentroidViewer.this.setClusterMaxMenuItem.setEnabled(true);
                KMCSuppExperimentCentroidViewer.this.setOverallMaxMenuItem.setEnabled(false);
                KMCSuppExperimentCentroidViewer.this.repaint();
            } else if (string.equals("set-y-to-cluster-max-cmd")) {
                KMCSuppExperimentCentroidViewer.this.yRangeOption = ExperimentClusterCentroidViewer.USE_CLUSTER_MAX;
                KMCSuppExperimentCentroidViewer.this.setClusterMaxMenuItem.setEnabled(false);
                KMCSuppExperimentCentroidViewer.this.setOverallMaxMenuItem.setEnabled(true);
                KMCSuppExperimentCentroidViewer.this.repaint();
            } else if (string.equals("store-cluster-cmd")) {
                KMCSuppExperimentCentroidViewer.this.storeCluster();
            } else if (string.equals("launch-new-session-cmd")) {
                KMCSuppExperimentCentroidViewer.this.launchNewSession();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() || KMCSuppExperimentCentroidViewer.this.getCluster() == null || KMCSuppExperimentCentroidViewer.this.getCluster().length == 0) {
                return;
            }
            KMCSuppExperimentCentroidViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

