/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.owa;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.util.StringSplitter;

public class OneWayANOVAInitBox
extends AlgorithmDialog {
    public static final int JUST_ALPHA = 1;
    public static final int STD_BONFERRONI = 2;
    public static final int ADJ_BONFERRONI = 3;
    boolean okPressed = false;
    Vector exptNames;
    MultiClassPanel mPanel;
    PValuePanel pPanel;
    HCLSelectionPanel hclOpsPanel;

    public OneWayANOVAInitBox(JFrame jFrame, boolean bl, Vector vector) {
        super(jFrame, "One-way ANOVA Initialization", bl);
        this.exptNames = vector;
        this.setBounds(0, 0, 700, 720);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.mPanel = new MultiClassPanel();
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 80);
        gridBagLayout.setConstraints(this.mPanel, gridBagConstraints);
        jPanel.add(this.mPanel);
        this.pPanel = new PValuePanel();
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 10);
        gridBagLayout.setConstraints(this.pPanel, gridBagConstraints);
        jPanel.add(this.pPanel);
        this.hclOpsPanel = new HCLSelectionPanel();
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 10);
        gridBagLayout.setConstraints(this.hclOpsPanel, gridBagConstraints);
        jPanel.add(this.hclOpsPanel);
        this.addContent(jPanel);
        EventListener eventListener = new EventListener();
        this.setActionListeners(eventListener);
        this.addWindowListener(eventListener);
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
        if (bl) {
            // empty if block
        }
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean drawTrees() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public int[] getGroupAssignments() {
        int[] nArray = new int[this.exptNames.size()];
        block0: for (int i = 0; i < this.exptNames.size(); ++i) {
            if (this.mPanel.mulgPanel.notInGroupRadioButtons[i].isSelected()) {
                nArray[i] = 0;
                continue;
            }
            for (int j = 0; j < this.mPanel.mulgPanel.exptGroupRadioButtons.length; ++j) {
                if (!this.mPanel.mulgPanel.exptGroupRadioButtons[j][i].isSelected()) continue;
                nArray[i] = j + 1;
                continue block0;
            }
        }
        return nArray;
    }

    public int getNumGroups() {
        return this.mPanel.numGroups;
    }

    public double getPValue() {
        return Double.parseDouble(this.pPanel.pValueInputField.getText());
    }

    public int getCorrectionMethod() {
        int n = 1;
        n = this.pPanel.justAlphaButton.isSelected() ? 1 : (this.pPanel.stdBonfButton.isSelected() ? 2 : 3);
        return n;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < 100; ++i) {
            vector.add("Expt " + i);
        }
        OneWayANOVAInitBox oneWayANOVAInitBox = new OneWayANOVAInitBox(jFrame, true, vector);
        oneWayANOVAInitBox.setVisible(true);
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            block15: {
                String string = actionEvent.getActionCommand();
                if (string.equals("ok-command")) {
                    int n;
                    boolean bl = false;
                    int[] nArray = OneWayANOVAInitBox.this.getGroupAssignments();
                    int n2 = OneWayANOVAInitBox.this.getNumGroups();
                    int[] nArray2 = new int[n2];
                    for (n = 0; n < nArray2.length; ++n) {
                        nArray2[n] = 0;
                    }
                    for (n = 0; n < nArray.length; ++n) {
                        int n3 = nArray[n];
                        if (n3 == 0) continue;
                        int n4 = n3 - 1;
                        nArray2[n4] = nArray2[n4] + 1;
                    }
                    for (n = 0; n < nArray2.length; ++n) {
                        if (nArray2[n] > 1) continue;
                        JOptionPane.showMessageDialog(null, "Each group must contain more than one experiment", "Error", 2);
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        try {
                            double d = Double.parseDouble(OneWayANOVAInitBox.this.pPanel.pValueInputField.getText());
                            if (d <= 0.0 || d > 1.0) {
                                JOptionPane.showMessageDialog(null, "P-value must be between 0 and 1", "Error!", 0);
                                break block15;
                            }
                            OneWayANOVAInitBox.this.okPressed = true;
                            OneWayANOVAInitBox.this.dispose();
                        }
                        catch (NumberFormatException numberFormatException) {
                            JOptionPane.showMessageDialog(null, "P-value must be between 0 and 1", "Error!", 0);
                        }
                    }
                } else if (string.equals("reset-command")) {
                    OneWayANOVAInitBox.this.mPanel.reset();
                    OneWayANOVAInitBox.this.pPanel.reset();
                } else if (string.equals("cancel-command")) {
                    OneWayANOVAInitBox.this.okPressed = false;
                    OneWayANOVAInitBox.this.dispose();
                } else if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow(OneWayANOVAInitBox.this, "One Way ANOVA Initialization Dialog");
                    OneWayANOVAInitBox.this.okPressed = false;
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(450, 600);
                        helpWindow.setLocation();
                        helpWindow.show();
                        return;
                    }
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                    return;
                }
            }
        }
    }

    class PValuePanel
    extends JPanel {
        JTextField pValueInputField;
        JRadioButton justAlphaButton;
        JRadioButton stdBonfButton;
        JRadioButton adjBonfButton;

        public PValuePanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "P-value parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setBackground(Color.white);
            this.setLayout(gridBagLayout);
            JLabel jLabel = new JLabel("Enter alpha (critical p-value): ");
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 33, 50);
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            this.pValueInputField = new JTextField("0.01", 7);
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.pValueInputField, gridBagConstraints);
            this.add(this.pValueInputField);
            gridBagConstraints.anchor = 10;
            this.justAlphaButton = new JRadioButton("Just alpha (no correction)", true);
            this.justAlphaButton.setBackground(Color.white);
            this.justAlphaButton.setVisible(false);
            this.stdBonfButton = new JRadioButton("Standard Bonferroni correction", false);
            this.stdBonfButton.setBackground(Color.white);
            this.stdBonfButton.setVisible(false);
            this.adjBonfButton = new JRadioButton("Adjusted Bonferroni correction", false);
            this.adjBonfButton.setBackground(Color.white);
            this.adjBonfButton.setVisible(false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.justAlphaButton);
            buttonGroup.add(this.stdBonfButton);
            buttonGroup.add(this.adjBonfButton);
            this.stdBonfButton.setEnabled(false);
            this.adjBonfButton.setEnabled(false);
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 33, 50);
            gridBagLayout.setConstraints(this.justAlphaButton, gridBagConstraints);
            this.add(this.justAlphaButton);
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 33, 0);
            gridBagLayout.setConstraints(this.stdBonfButton, gridBagConstraints);
            this.add(this.stdBonfButton);
            OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 2, 1, 1, 1, 34, 0);
            gridBagLayout.setConstraints(this.adjBonfButton, gridBagConstraints);
            this.add(this.adjBonfButton);
        }

        private void reset() {
            this.pValueInputField.setText("0.01");
            this.justAlphaButton.setSelected(true);
        }
    }

    class MultiClassPanel
    extends JPanel {
        NumGroupsPanel ngPanel;
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        JPanel dummyPanel;
        MultiGroupExperimentsPanel mulgPanel;
        int numGroups;

        public MultiClassPanel() {
            this.setBackground(Color.white);
            this.setLayout(this.gridbag);
            this.ngPanel = new NumGroupsPanel();
            OneWayANOVAInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 10);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(this.ngPanel, this.constraints);
            this.ngPanel.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MultiClassPanel.this.ngPanel.okPressed = true;
                    try {
                        MultiClassPanel.this.numGroups = Integer.parseInt(MultiClassPanel.this.ngPanel.numGroupsField.getText());
                        if (MultiClassPanel.this.numGroups <= 2) {
                            JOptionPane.showMessageDialog(null, "Please enter a positive integer > 2!", "Error", 0);
                        } else {
                            MultiClassPanel.this.mulgPanel = new MultiGroupExperimentsPanel(OneWayANOVAInitBox.this.exptNames, MultiClassPanel.this.numGroups);
                            OneWayANOVAInitBox.this.buildConstraints(MultiClassPanel.this.constraints, 0, 1, 1, 1, 0, 90);
                            MultiClassPanel.this.constraints.fill = 1;
                            MultiClassPanel.this.gridbag.setConstraints(MultiClassPanel.this.mulgPanel, MultiClassPanel.this.constraints);
                            MultiClassPanel.this.remove(MultiClassPanel.this.dummyPanel);
                            MultiClassPanel.this.add(MultiClassPanel.this.mulgPanel);
                            MultiClassPanel.this.validate();
                            MultiClassPanel.this.ngPanel.okButton.setEnabled(false);
                            MultiClassPanel.this.ngPanel.numGroupsField.setEnabled(false);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(null, "Please enter a positive integer > 2!", "Error", 0);
                    }
                }
            });
            this.add(this.ngPanel);
            OneWayANOVAInitBox.this.buildConstraints(this.constraints, 0, 1, 1, 1, 0, 90);
            this.dummyPanel = new JPanel();
            this.dummyPanel.setBackground(Color.white);
            this.gridbag.setConstraints(this.dummyPanel, this.constraints);
            this.add(this.dummyPanel);
        }

        private void reset() {
            this.mulgPanel.reset();
        }

        class MultiGroupExperimentsPanel
        extends JPanel {
            JLabel[] expLabels;
            JRadioButton[][] exptGroupRadioButtons;
            JRadioButton[] notInGroupRadioButtons;

            MultiGroupExperimentsPanel(Vector vector, int n) {
                int n2;
                this.setBorder(new TitledBorder(new EtchedBorder(), "Group Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
                this.setBackground(Color.white);
                JPanel jPanel = new JPanel();
                this.expLabels = new JLabel[vector.size()];
                this.exptGroupRadioButtons = new JRadioButton[n][vector.size()];
                this.notInGroupRadioButtons = new JRadioButton[vector.size()];
                ButtonGroup[] buttonGroupArray = new ButtonGroup[vector.size()];
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagLayout gridBagLayout2 = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.setLayout(gridBagLayout2);
                jPanel.setLayout(gridBagLayout);
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    int n3;
                    String string = (String)vector.get(n2);
                    this.expLabels[n2] = new JLabel(string);
                    buttonGroupArray[n2] = new ButtonGroup();
                    for (n3 = 0; n3 < n; ++n3) {
                        this.exptGroupRadioButtons[n3][n2] = new JRadioButton("Group " + (n3 + 1) + "     ", n3 == 0);
                        buttonGroupArray[n2].add(this.exptGroupRadioButtons[n3][n2]);
                    }
                    this.notInGroupRadioButtons[n2] = new JRadioButton("Not in groups", false);
                    buttonGroupArray[n2].add(this.notInGroupRadioButtons[n2]);
                    for (n3 = 0; n3 < n; ++n3) {
                        OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, n3, n2, 1, 1, 100, 100);
                        gridBagLayout.setConstraints(this.exptGroupRadioButtons[n3][n2], gridBagConstraints);
                        jPanel.add(this.exptGroupRadioButtons[n3][n2]);
                    }
                    OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, n + 1, n2, 1, 1, 100, 100);
                    gridBagLayout.setConstraints(this.notInGroupRadioButtons[n2], gridBagConstraints);
                    jPanel.add(this.notInGroupRadioButtons[n2]);
                }
                n2 = 0;
                for (int i = 0; i < this.expLabels.length; ++i) {
                    if (!(this.expLabels[i].getPreferredSize().getWidth() > (double)n2)) continue;
                    n2 = (int)Math.ceil(this.expLabels[i].getPreferredSize().getWidth());
                }
                JScrollPane jScrollPane = new JScrollPane(jPanel);
                jScrollPane.setHorizontalScrollBarPolicy(32);
                jScrollPane.setVerticalScrollBarPolicy(22);
                JPanel jPanel2 = new JPanel();
                GridBagLayout gridBagLayout3 = new GridBagLayout();
                jPanel2.setSize(50, jPanel.getPreferredSize().height);
                jPanel2.setPreferredSize(new Dimension(n2 + 10, jPanel.getPreferredSize().height));
                jPanel2.setLayout(gridBagLayout3);
                for (int i = 0; i < this.expLabels.length; ++i) {
                    OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, i, 1, 1, 100, 100);
                    gridBagConstraints.fill = 1;
                    gridBagLayout3.setConstraints(this.expLabels[i], gridBagConstraints);
                    jPanel2.add(this.expLabels[i]);
                }
                jScrollPane.setRowHeaderView(jPanel2);
                OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 90);
                gridBagConstraints.fill = 1;
                gridBagLayout2.setConstraints(jScrollPane, gridBagConstraints);
                this.add(jScrollPane);
                JLabel jLabel = new JLabel("Note: Each group MUST each contain more than one experiment.");
                jLabel.setHorizontalAlignment(0);
                OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 5);
                gridBagConstraints.anchor = 13;
                gridBagLayout2.setConstraints(jLabel, gridBagConstraints);
                this.add(jLabel);
                JPanel jPanel3 = new JPanel();
                GridBagLayout gridBagLayout4 = new GridBagLayout();
                jPanel3.setLayout(gridBagLayout4);
                jPanel3.setBackground(Color.white);
                JButton jButton = new JButton("  Save settings  ");
                jButton.setFocusPainted(false);
                jButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                JButton jButton2 = new JButton("  Load settings  ");
                jButton2.setFocusPainted(false);
                jButton2.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                JButton jButton3 = new JButton("  Reset  ");
                jButton3.setFocusPainted(false);
                jButton3.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                final int n4 = vector.size();
                jButton3.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        for (int i = 0; i < n4; ++i) {
                            MultiGroupExperimentsPanel.this.exptGroupRadioButtons[0][i].setSelected(true);
                        }
                    }
                });
                final JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setCurrentDirectory(new File("Data"));
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = jFileChooser.showSaveDialog(MultiGroupExperimentsPanel.this);
                        if (n == 0) {
                            File file = jFileChooser.getSelectedFile();
                            try {
                                PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                                int[] nArray = OneWayANOVAInitBox.this.getGroupAssignments();
                                for (int i = 0; i < nArray.length; ++i) {
                                    printWriter.print(nArray[i]);
                                    if (i >= nArray.length - 1) continue;
                                    printWriter.print("\t");
                                }
                                printWriter.println();
                                printWriter.flush();
                                printWriter.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                });
                jButton2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = jFileChooser.showOpenDialog(MultiGroupExperimentsPanel.this);
                        if (n == 0) {
                            try {
                                Object object;
                                FileReader fileReader = new FileReader(jFileChooser.getSelectedFile());
                                BufferedReader bufferedReader = new BufferedReader(fileReader);
                                String string = bufferedReader.readLine();
                                StringSplitter stringSplitter = new StringSplitter('\t');
                                stringSplitter.init(string);
                                Vector<Integer> vector = new Vector<Integer>();
                                while (stringSplitter.hasMoreTokens()) {
                                    object = stringSplitter.nextToken();
                                    vector.add(new Integer((String)object));
                                }
                                bufferedReader.close();
                                object = OneWayANOVAInitBox.this.getGroupAssignments();
                                if (vector.size() != ((Object)object).length) {
                                    JOptionPane.showMessageDialog(OneWayANOVAInitBox.this.mPanel, "Incompatible file!", "Error", 2);
                                } else {
                                    for (int i = 0; i < vector.size(); ++i) {
                                        int n2 = (Integer)vector.get(i);
                                        if (n2 != 0) {
                                            MultiGroupExperimentsPanel.this.exptGroupRadioButtons[n2 - 1][i].setSelected(true);
                                            continue;
                                        }
                                        MultiGroupExperimentsPanel.this.notInGroupRadioButtons[i].setSelected(true);
                                    }
                                }
                            }
                            catch (Exception exception) {
                                JOptionPane.showMessageDialog(OneWayANOVAInitBox.this.mPanel, "Incompatible file!", "Error", 2);
                                for (int i = 0; i < n4; ++i) {
                                    MultiGroupExperimentsPanel.this.exptGroupRadioButtons[0][i].setSelected(true);
                                }
                            }
                        }
                    }
                });
                gridBagConstraints.anchor = 10;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 33, 100);
                gridBagLayout4.setConstraints(jButton, gridBagConstraints);
                jPanel3.add(jButton);
                OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
                gridBagLayout4.setConstraints(jButton2, gridBagConstraints);
                jPanel3.add(jButton2);
                OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 34, 0);
                gridBagLayout4.setConstraints(jButton3, gridBagConstraints);
                jPanel3.add(jButton3);
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 5);
                gridBagConstraints.anchor = 10;
                gridBagLayout2.setConstraints(jPanel3, gridBagConstraints);
                this.add(jPanel3);
            }

            private void reset() {
                for (int i = 0; i < OneWayANOVAInitBox.this.exptNames.size(); ++i) {
                    this.exptGroupRadioButtons[0][i].setSelected(true);
                }
            }
        }

        class NumGroupsPanel
        extends JPanel {
            JTextField numGroupsField;
            JButton okButton;
            boolean okPressed = false;

            public NumGroupsPanel() {
                this.setBackground(Color.white);
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.setLayout(gridBagLayout);
                JLabel jLabel = new JLabel("Number of groups ");
                OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 30, 100);
                gridBagConstraints.anchor = 13;
                gridBagLayout.setConstraints(jLabel, gridBagConstraints);
                this.add(jLabel);
                this.numGroupsField = new JTextField("", 7);
                gridBagConstraints.anchor = 17;
                OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 30, 0);
                gridBagLayout.setConstraints(this.numGroupsField, gridBagConstraints);
                this.add(this.numGroupsField);
                this.okButton = new JButton("OK");
                OneWayANOVAInitBox.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 40, 0);
                gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
                this.add(this.okButton);
            }

            public void setVisible(boolean bl) {
                this.setLocation((MultiClassPanel.this.getWidth() - this.getSize().width) / 2, (MultiClassPanel.this.getHeight() - this.getSize().height) / 2);
                super.setVisible(bl);
                if (bl) {
                    // empty if block
                }
            }

            public boolean isOkPressed() {
                return this.okPressed;
            }
        }
    }
}

