/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.qtc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class QTCInfoViewer
extends ViewerAdapter {
    private JComponent header;
    private JTextArea content;
    private boolean clusterGenes = true;

    public QTCInfoViewer(int[][] nArray, int n) {
        this.header = this.createHeader();
        this.content = this.createContent(nArray, n);
        this.setMaxWidth(this.content, this.header);
    }

    public QTCInfoViewer(int[][] nArray, int n, boolean bl) {
        this.clusterGenes = bl;
        this.header = this.createHeader();
        this.content = this.createContent(nArray, n);
        this.setMaxWidth(this.content, this.header);
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Cluster Information</b></font></body></html>"), gridBagConstraints);
        return jPanel;
    }

    private JTextArea createContent(int[][] nArray, int n) {
        JTextArea jTextArea = new JTextArea(nArray.length * 3, 20);
        jTextArea.setMargin(new Insets(0, 10, 0, 0));
        jTextArea.setEditable(false);
        StringBuffer stringBuffer = new StringBuffer(nArray.length * 3 * 10);
        if (this.clusterGenes) {
            for (int i = 0; i < nArray.length - 1; ++i) {
                stringBuffer.append("Cluster " + (i + 1));
                stringBuffer.append("\t\t");
                stringBuffer.append("# of Genes in Cluster: " + nArray[i].length);
                stringBuffer.append("\n\t\t");
                stringBuffer.append("% of Genes in Cluster: " + Math.round((float)nArray[i].length / (float)n * 100.0f) + "%");
                stringBuffer.append("\n\n");
            }
            stringBuffer.append("Unassigned Genes ");
            stringBuffer.append("\t");
            stringBuffer.append("# of Unassigned Genes: " + nArray[nArray.length - 1].length);
            stringBuffer.append("\n\t\t");
            stringBuffer.append("% of Genes that are Unassigned: " + Math.round((float)nArray[nArray.length - 1].length / (float)n * 100.0f) + "%");
            stringBuffer.append("\n\n");
        } else {
            for (int i = 0; i < nArray.length - 1; ++i) {
                stringBuffer.append("Cluster " + (i + 1));
                stringBuffer.append("\t\t");
                stringBuffer.append("# of Experiments in Cluster: " + nArray[i].length);
                stringBuffer.append("\n\t\t");
                stringBuffer.append("% of Experiments in Cluster: " + Math.round((float)nArray[i].length / (float)n * 100.0f) + "%");
                stringBuffer.append("\n\n");
            }
            stringBuffer.append("Unassigned Experiments ");
            stringBuffer.append("\t");
            stringBuffer.append("# of Unassigned Experiments: " + nArray[nArray.length - 1].length);
            stringBuffer.append("\n\t\t");
            stringBuffer.append("% of Experiments that are Unassigned: " + Math.round((float)nArray[nArray.length - 1].length / (float)n * 100.0f) + "%");
            stringBuffer.append("\n\n");
        }
        jTextArea.setText(stringBuffer.toString());
        jTextArea.setCaretPosition(0);
        return jTextArea;
    }

    private void setMaxWidth(JComponent jComponent, JComponent jComponent2) {
        int n = jComponent.getPreferredSize().width;
        int n2 = jComponent2.getPreferredSize().width;
        if (n > n2) {
            jComponent2.setPreferredSize(new Dimension(n, jComponent2.getPreferredSize().height));
        } else {
            jComponent.setPreferredSize(new Dimension(n2, jComponent.getPreferredSize().height));
        }
    }
}

