/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.rn;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class RNElementSeedInfoViewer
extends ViewerAdapter {
    private JComponent header;
    private JTextArea content;
    private boolean clusterGenes;
    private Experiment experiment;
    private int[] indices;

    public RNElementSeedInfoViewer(int[][] nArray, int n) {
        this.header = this.createHeader();
        this.clusterGenes = true;
        this.content = this.createContent(nArray, n);
        this.setMaxWidth(this.content, this.header);
    }

    public RNElementSeedInfoViewer(int[][] nArray, Experiment experiment, int[] nArray2, int n, boolean bl) {
        this.indices = nArray2;
        this.experiment = experiment;
        this.header = this.createHeader();
        this.clusterGenes = bl;
        this.content = this.createContent(nArray, n);
        this.setMaxWidth(this.content, this.header);
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Element Seed Cluster Information</b></font></body></html>"), gridBagConstraints);
        return jPanel;
    }

    private JTextArea createContent(int[][] nArray, int n) {
        int n2;
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setMargin(new Insets(0, 10, 0, 0));
        StringBuffer stringBuffer = new StringBuffer(nArray.length * 6 * 25);
        String string = "";
        int n3 = 0;
        if (this.clusterGenes) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                string = "";
                if (nArray[this.indices[n2]].length <= 1) continue;
                string = string + "Seed Gene Index " + (this.experiment.getGeneIndexMappedToData(nArray[n2][0]) + 1);
                string = string + "\t";
                string = string + "# of Genes in Cluster: " + nArray[this.indices[n2]].length;
                string = string + "\n\t\t";
                string = string + "% of Genes in Cluster: " + Math.round((float)nArray[this.indices[n2]].length / (float)n * 100.0f) + "%";
                string = string + "\n\n";
                stringBuffer.append(string);
                n3 += string.length();
            }
        } else {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                string = "";
                if (nArray[this.indices[n2]].length <= 1) continue;
                string = string + "Seed Experiment Index " + (nArray[n2][0] + 1);
                string = string + "\t";
                string = string + "# of Experiments in Cluster: " + nArray[this.indices[n2]].length;
                string = string + "\n\t\t";
                string = string + "% of Experiments in Cluster: " + Math.round((float)nArray[this.indices[n2]].length / (float)n * 100.0f) + "%";
                string = string + "\n\n";
                stringBuffer.append(string);
                n3 += string.length();
            }
        }
        String string2 = stringBuffer.substring(0, n3);
        jTextArea.setText(string2);
        jTextArea.setCaretPosition(0);
        return jTextArea;
    }

    private void setMaxWidth(JComponent jComponent, JComponent jComponent2) {
        int n = jComponent.getPreferredSize().width;
        int n2 = jComponent2.getPreferredSize().width;
        if (n > n2) {
            jComponent2.setPreferredSize(new Dimension(n, jComponent2.getPreferredSize().height));
        } else {
            jComponent.setPreferredSize(new Dimension(n2, jComponent.getPreferredSize().height));
        }
    }
}

