/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.rn;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RelNetClusterList;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RelNetSelectionDlg;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RelevanceNetworkLayout;

public class RelevanceNetworkViewer
extends JPanel
implements IViewer,
Scrollable {
    private static final String ZOOM_IN_CMD = "zoom-in-cmd";
    private static final String ZOOM_OUT_CMD = "zoom-out-cmd";
    private static final String SHOW_ALL_CMD = "show-all-cmd";
    private static final String SELECT_BY_DEGREE_CMD = "select-by-degree-cmd";
    private static final String SELECT_BY_GENE_ID_CMD = "select-by-gene-id-cmd";
    private static final String LINKS_COLOR_CMD = "links-color-cmd";
    private static final String LINKS_THRESHOLD_CMD = "links-threshold-cmd";
    private static final String DESELECT_CMD = "deselect-cmd";
    private static final String SET_PUBLIC_CLUSTER_CMD = "set-public-cluster";
    private static final String RANDOM_LAYOUT_CMD = "random-layout-cmd";
    private static final String CIRCULAR_LAYOUT_CMD = "circular-layout-cmd";
    private static final String DEBUG_LAYOUT_CMD = "debug-layout-cmd";
    private static final String SET_LABEL_COLOR_CMD = "set-label-color-cmd";
    private static final String SET_SELECTION_COLOR_CMD = "set-selection-color-cmd";
    private static final String SET_BACKGROUND_COLOR_CMD = "set-background-color-cmd";
    private static final String SHAPE_RECT_CMD = "shape-rect-cmd";
    private static final String SHAPE_OVAL_CMD = "shape-oval-cmd";
    private static final String FIND_CLUSTER_CMD = "find-cluster-cmd";
    private static final int SHAPE_RECT = 0;
    private static final int SHAPE_OVAL = 1;
    private static final int MAX_CONTENT_SIZE = 0x7FFFFFFE;
    private static final float ZOOM_COEFFICIENT = 2.0f;
    private Rectangle prevZoomRect = new Rectangle();
    private Experiment experiment;
    private IData data;
    private IFramework framework;
    private boolean isGenes;
    private int[][] clusters;
    private float[][] weights;
    private int[] indices;
    private float[][] coords;
    private boolean[] selected;
    private boolean[] draw;
    private float links_threshold = 0.0f;
    private boolean isLinksColor = true;
    private static final int COLORS_DEEP = 100;
    private Color[] LINKS_PALETTE = this.createPalette(Color.blue, Color.red, 100);
    private float weight_min = 0.0f;
    private float weight_scale;
    private Color selectionColor = Color.green;
    private Color labelColor = Color.black;
    private Insets insets = new Insets(10, 10, 10, 10);
    private boolean isDrawBorders;
    private boolean isAntiAliasing = true;
    private Dimension elementSize = new Dimension(20, 5);
    private int labelIndex = -1;
    private String status;
    private int shape_type = 0;
    private JPopupMenu popup;
    private JWindow tipWindow;

    public Color[] createPalette(Color color, Color color2, int n) {
        BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(n, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, n - 1, 0.0f, color2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.drawRect(0, 0, n - 1, 1);
        Color[] colorArray = new Color[n];
        for (int i = 0; i < n; ++i) {
            colorArray[i] = new Color(bufferedImage.getRGB(i, 0));
        }
        return colorArray;
    }

    public static float getWeightsMinValue(float[][] fArray) {
        if (fArray == null || fArray.length == 0) {
            return Float.NaN;
        }
        float f = Float.MAX_VALUE;
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 1; j < fArray[i].length; ++j) {
                f = Math.min(f, fArray[i][j]);
            }
        }
        return f;
    }

    public static float getWeightsMaxValue(float[][] fArray) {
        if (fArray == null || fArray.length == 0) {
            return Float.NaN;
        }
        float f = -3.4028235E38f;
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 1; j < fArray[i].length; ++j) {
                f = Math.max(f, fArray[i][j]);
            }
        }
        return f;
    }

    public RelevanceNetworkViewer(boolean bl, Experiment experiment, int[][] nArray, float[][] fArray, int[] nArray2) {
        this.setLayout(null);
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 1, this.elementSize.height));
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.tipWindow = this.createTipWindow();
        this.getContentComponent().addMouseListener(listener);
        this.getContentComponent().addMouseMotionListener(listener);
        this.isGenes = bl;
        this.experiment = experiment;
        this.clusters = nArray;
        this.weights = fArray;
        this.weight_min = RelevanceNetworkViewer.getWeightsMinValue(fArray);
        this.weight_scale = 100.0f / (RelevanceNetworkViewer.getWeightsMaxValue(fArray) - this.weight_min);
        this.indices = nArray2;
        RelevanceNetworkLayout relevanceNetworkLayout = new RelevanceNetworkLayout();
        this.coords = relevanceNetworkLayout.doLayout(nArray, fArray, 1);
        this.selected = this.createSelected(nArray);
        this.draw = new boolean[nArray.length];
        this.setPreferredSize(new Dimension(300, 300));
    }

    private boolean[] createSelected(int[][] nArray) {
        boolean[] blArray = new boolean[nArray.length];
        this.clearSelected(blArray);
        return blArray;
    }

    private void clearSelected(boolean[] blArray) {
        Arrays.fill(blArray, false);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isFocusable() {
        return true;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Rectangle rectangle = graphics2D.getClipBounds();
        float f = this.getScale();
        this.drawLines(graphics2D, rectangle, f);
        this.drawLabels(graphics2D, rectangle, f);
        this.drawShapes(graphics2D, rectangle, f);
    }

    private final float getScale() {
        return Math.min(this.getPreferredSize().width - this.insets.left - this.insets.right, this.getPreferredSize().height - this.insets.top - this.insets.bottom);
    }

    private final boolean isRectIntersects(Rectangle rectangle, int n, int n2, int n3, int n4) {
        if (n < rectangle.x && n3 < rectangle.x) {
            return false;
        }
        if (n > rectangle.x + rectangle.width && n3 > rectangle.x + rectangle.width) {
            return false;
        }
        if (n2 < rectangle.y && n4 < rectangle.y) {
            return false;
        }
        return n2 <= rectangle.y + rectangle.height || n4 <= rectangle.y + rectangle.height;
    }

    private final boolean isIntersectVerticalLine(Point point, Point point2, int n, int n2, int n3, Point point3) {
        if (point.x < n && point2.x < n || point.x > n && point2.x > n) {
            return false;
        }
        float f = (float)(point2.y - point.y) / (float)(point2.x - point.x);
        float f2 = f * (float)(n - point.x);
        float f3 = (float)point.y + f2;
        point3.y = point.y + Math.round(f2);
        point3.x = n;
        return f3 > (float)Math.min(n2, n3) && f3 < (float)Math.max(n2, n3);
    }

    private final boolean isIntersectHorizontalLine(Point point, Point point2, int n, int n2, int n3, Point point3) {
        if (point.y < n && point2.y < n || point.y > n && point2.y > n) {
            return false;
        }
        float f = (float)(point2.y - point.y) / (float)(point2.x - point.x);
        float f2 = (float)(n - point.y) / f;
        float f3 = (float)point.x + f2;
        point3.x = point.x + Math.round(f2);
        point3.y = n;
        return f3 > (float)Math.min(n2, n3) && f3 < (float)Math.max(n2, n3);
    }

    private final boolean isInternalPoint(Rectangle rectangle, Point point, Point point2, Point point3) {
        boolean bl = rectangle.contains(point);
        boolean bl2 = rectangle.contains(point2);
        if (bl) {
            point3.setLocation(point);
            return true;
        }
        if (bl2) {
            point3.setLocation(point2);
            return true;
        }
        return false;
    }

    private final boolean isLineIntersects(Rectangle rectangle, Point point, Point point2, Point point3, Point point4) {
        point3.setLocation(point);
        point4.setLocation(point2);
        if (rectangle.contains(point) && rectangle.contains(point2)) {
            return true;
        }
        if (point.x < rectangle.x && point2.x < rectangle.x) {
            return false;
        }
        if (point.y < rectangle.y && point2.y < rectangle.y) {
            return false;
        }
        if (point.x > rectangle.x + rectangle.width && point2.x > rectangle.x + rectangle.width) {
            return false;
        }
        if (point.y > rectangle.y + rectangle.height && point2.y > rectangle.y + rectangle.height) {
            return false;
        }
        if (point.x == point2.x) {
            if (point.y < rectangle.y) {
                point3.y = rectangle.y;
            } else if (point.y > rectangle.y + rectangle.height) {
                point3.y = rectangle.y + rectangle.height;
            }
            if (point2.y < rectangle.y) {
                point4.y = rectangle.y;
            } else if (point2.y > rectangle.y + rectangle.height) {
                point4.y = rectangle.y + rectangle.height;
            }
            return true;
        }
        if (point.y == point2.y) {
            if (point.x < rectangle.x) {
                point3.x = rectangle.x;
            } else if (point.x > rectangle.x + rectangle.width) {
                point3.x = rectangle.x + rectangle.width;
            }
            if (point2.x < rectangle.x) {
                point4.x = rectangle.x;
            } else if (point2.x > rectangle.x + rectangle.width) {
                point4.x = rectangle.x + rectangle.width;
            }
            return true;
        }
        if (this.isIntersectVerticalLine(point, point2, rectangle.x, rectangle.y, rectangle.y + rectangle.height, point3)) {
            return this.isIntersectVerticalLine(point, point2, rectangle.x + rectangle.width, rectangle.y, rectangle.y + rectangle.height, point4) || this.isIntersectHorizontalLine(point, point2, rectangle.y, rectangle.x, rectangle.x + rectangle.width, point4) || this.isIntersectHorizontalLine(point, point2, rectangle.y + rectangle.height, rectangle.x, rectangle.x + rectangle.width, point4) || this.isInternalPoint(rectangle, point, point2, point4);
            {
            }
        }
        if (this.isIntersectVerticalLine(point, point2, rectangle.x + rectangle.width, rectangle.y, rectangle.y + rectangle.height, point3)) {
            return this.isIntersectHorizontalLine(point, point2, rectangle.y + rectangle.height, rectangle.x, rectangle.x + rectangle.width, point4) || this.isIntersectHorizontalLine(point, point2, rectangle.y, rectangle.x, rectangle.x + rectangle.width, point4) || this.isInternalPoint(rectangle, point, point2, point4);
            {
            }
        }
        if (this.isIntersectHorizontalLine(point, point2, rectangle.y, rectangle.x, rectangle.x + rectangle.width, point3)) {
            return this.isIntersectHorizontalLine(point, point2, rectangle.y + rectangle.height, rectangle.x, rectangle.x + rectangle.width, point4) || this.isInternalPoint(rectangle, point, point2, point4);
            {
            }
        }
        if (this.isIntersectHorizontalLine(point, point2, rectangle.y + rectangle.height, rectangle.x, rectangle.x + rectangle.width, point3)) {
            return this.isInternalPoint(rectangle, point, point2, point4);
            {
            }
        }
        return false;
    }

    private final void drawLines(Graphics2D graphics2D, Rectangle rectangle, float f) {
        Point point = new Point();
        Point point2 = new Point();
        Point point3 = new Point();
        Point point4 = new Point();
        graphics2D.setColor(Color.black);
        Arrays.fill(this.draw, true);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.clusters[i].length <= 1) continue;
            int n = this.clusters[i][0];
            this.draw[n] = false;
            float f2 = this.coords[n][0] * f + (float)this.insets.left;
            float f3 = this.coords[n][1] * f + (float)this.insets.top;
            for (int j = 1; j < this.clusters[i].length; ++j) {
                int n2;
                if (this.weights != null && this.weights[i][j] < this.links_threshold) continue;
                if (this.isLinksColor) {
                    graphics2D.setColor(this.LINKS_PALETTE[(int)((this.weights[i][j] - this.weight_min) * this.weight_scale - 0.001f)]);
                }
                if (!this.draw[n2 = this.clusters[i][j]]) continue;
                float f4 = this.coords[n2][0] * f + (float)this.insets.left;
                float f5 = this.coords[n2][1] * f + (float)this.insets.top;
                point.move((int)f2, (int)f3);
                point2.move((int)f4, (int)f5);
                if (!this.isLineIntersects(rectangle, point, point2, point3, point4)) continue;
                graphics2D.drawLine(point3.x, point3.y, point4.x, point4.y);
            }
        }
    }

    private final boolean isElementIntersects(Rectangle rectangle, int n, int n2) {
        int n3 = n - this.elementSize.width / 2;
        int n4 = n2 - this.elementSize.height / 2;
        int n5 = n + this.elementSize.width / 2;
        int n6 = n2 + this.elementSize.height / 2;
        return this.isRectIntersects(rectangle, n3, n4, n5, n6);
    }

    private final void fillShape(Graphics graphics, int n, int n2) {
        if (this.shape_type == 0) {
            graphics.fillRect(n, n2, this.elementSize.width, this.elementSize.height);
        } else {
            graphics.fillOval(n, n2, this.elementSize.width, this.elementSize.height);
        }
    }

    private final void drawShape(Graphics graphics, int n, int n2) {
        this.drawShape(graphics, n, n2, this.elementSize.width - 1, this.elementSize.height - 1);
    }

    private final void drawShape(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.shape_type == 0) {
            graphics.drawRect(n, n2, n3, n4);
        } else {
            graphics.drawOval(n, n2, n3, n4);
        }
    }

    private final void drawNode(Graphics graphics, int n, int n2, int n3) {
        if (this.selected[n]) {
            graphics.setColor(this.selectionColor);
        } else {
            graphics.setColor(this.getProbeColor(n));
        }
        this.fillShape(graphics, n2, n3);
        if (this.isDrawBorders) {
            graphics.setColor(Color.black);
            this.drawShape(graphics, n2, n3);
        }
    }

    private final void drawShapes(Graphics2D graphics2D, Rectangle rectangle, float f) {
        Arrays.fill(this.draw, true);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.clusters[i].length <= 1) continue;
            for (int j = 0; j < this.clusters[i].length; ++j) {
                int n = this.clusters[i][j];
                if (!this.draw[n]) continue;
                this.draw[n] = false;
                float f2 = this.coords[n][0] * f + (float)this.insets.left;
                float f3 = this.coords[n][1] * f + (float)this.insets.top;
                if (!this.isElementIntersects(rectangle, (int)f2, (int)f3)) continue;
                this.drawNode(graphics2D, n, (int)f2 - this.elementSize.width / 2, (int)f3 - this.elementSize.height / 2);
            }
        }
    }

    private final void drawSpot(Graphics graphics, int n) {
        float f = this.getScale();
        float f2 = this.coords[n][0] * f + (float)this.insets.left;
        float f3 = this.coords[n][1] * f + (float)this.insets.top;
        this.drawNode(graphics, n, (int)f2 - this.elementSize.width / 2, (int)f3 - this.elementSize.height / 2);
    }

    private final void drawSelectedSpot(Graphics graphics, int n) {
        float f = this.getScale();
        float f2 = this.coords[n][0] * f + (float)this.insets.left;
        float f3 = this.coords[n][1] * f + (float)this.insets.top;
        this.drawNode(graphics, n, (int)f2 - this.elementSize.width / 2, (int)f3 - this.elementSize.height / 2);
        graphics.setColor(Color.white);
        this.drawShape(graphics, (int)f2 - this.elementSize.width / 2 + 1, (int)f3 - this.elementSize.height / 2 + 1, this.elementSize.width - 3, this.elementSize.height - 3);
    }

    private void onStartDrawZoom() {
        this.prevZoomRect.setBounds(0, 0, 0, 0);
    }

    private void drawZoomRect(Rectangle rectangle) {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        graphics2D.setColor(Color.black);
        graphics2D.setXORMode(this.getBackground());
        graphics2D.drawRect(this.prevZoomRect.x, this.prevZoomRect.y, this.prevZoomRect.width - 1, this.prevZoomRect.height - 1);
        this.prevZoomRect.setBounds(rectangle);
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        graphics2D.setPaintMode();
        graphics2D.dispose();
    }

    private final boolean isLabelIntersects(FontMetrics fontMetrics, Rectangle rectangle, String string, int n, int n2) {
        int n3 = fontMetrics.stringWidth(string);
        int n4 = fontMetrics.getHeight();
        return this.isRectIntersects(rectangle, n, n2, n + n3, n2 + n4);
    }

    private int getMaxLabelWidth() {
        if (this.isGenes && this.labelIndex < 0) {
            return 0;
        }
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = 0;
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.clusters[i].length <= 1) continue;
            for (int j = 0; j < this.clusters[i].length; ++j) {
                String string;
                String string2 = string = this.isGenes ? this.data.getElementAttribute(this.clusters[i][j], this.labelIndex) : this.data.getSampleName(this.clusters[i][j]);
                if (string == null) continue;
                n = Math.max(n, fontMetrics.stringWidth(string));
            }
        }
        return n;
    }

    private final void drawLabels(Graphics2D graphics2D, Rectangle rectangle, float f) {
        if (this.isGenes && this.labelIndex < 0) {
            return;
        }
        graphics2D.setColor(this.labelColor);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Arrays.fill(this.draw, true);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.clusters[i].length <= 1) continue;
            for (int j = 0; j < this.clusters[i].length; ++j) {
                String string;
                int n = this.clusters[i][j];
                if (!this.draw[n]) continue;
                this.draw[n] = false;
                float f2 = this.coords[n][0] * f + (float)this.insets.left + (float)(this.elementSize.width / 2) + 10.0f;
                float f3 = this.coords[n][1] * f + (float)this.insets.top + (float)(this.elementSize.height / 2);
                String string2 = string = this.isGenes ? this.data.getElementAttribute(n, this.labelIndex) : this.data.getSampleName(n);
                if (!this.isLabelIntersects(fontMetrics, rectangle, string, (int)f2, (int)f3)) continue;
                graphics2D.drawString(string, (int)f2, (int)f3);
            }
        }
    }

    private final Color getProbeColor(int n) {
        Color color = this.isGenes ? this.data.getProbeColor(n) : this.data.getExperimentColor(n);
        return color == null ? Color.gray : color;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.data = iFramework.getData();
        IDisplayMenu iDisplayMenu = iFramework.getDisplayMenu();
        this.isDrawBorders = iDisplayMenu.isDrawingBorder();
        this.isAntiAliasing = iDisplayMenu.isAntiAliasing();
        this.labelIndex = iDisplayMenu.getLabelIndex();
        this.setElementSize(iDisplayMenu.getElementSize());
        this.updateSize();
    }

    public void onDataChanged(IData iData) {
        this.data = iData;
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.isDrawBorders = iDisplayMenu.isDrawingBorder();
        this.isAntiAliasing = iDisplayMenu.isAntiAliasing();
        this.labelIndex = iDisplayMenu.getLabelIndex();
        this.setElementSize(iDisplayMenu.getElementSize());
        this.updateSize();
    }

    private void updateSize() {
        int n = this.getPreferredSize().width - this.insets.right - this.insets.left;
        int n2 = this.getPreferredSize().height - this.insets.top - this.insets.bottom;
        this.insets.left = this.elementSize.width / 2 + 10;
        this.insets.right = this.getMaxLabelWidth() + this.elementSize.width / 2 + 10;
        this.insets.top = this.insets.bottom = this.elementSize.height / 2 + 10;
        this.setSizes(n + this.insets.left + this.insets.right, n2 + this.insets.top + this.insets.bottom);
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    private void setElementSize(Dimension dimension) {
        if (dimension.equals(this.elementSize)) {
            return;
        }
        this.elementSize = new Dimension(dimension);
        this.setFont(new Font("monospaced", 1, dimension.height));
    }

    public BufferedImage getImage() {
        return null;
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    private void addMenuItems(JPopupMenu jPopupMenu, Listener listener) {
        JMenuItem jMenuItem = new JMenuItem("Zoom in", GUIFactory.getIcon("zoom_in.gif"));
        jMenuItem.setActionCommand(ZOOM_IN_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Zoom out", GUIFactory.getIcon("zoom_out.gif"));
        jMenuItem.setActionCommand(ZOOM_OUT_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show all", GUIFactory.getIcon("show_all.gif"));
        jMenuItem.setActionCommand(SHOW_ALL_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        JMenu jMenu = new JMenu("Select");
        jMenuItem = new JMenuItem("Feature Degree...");
        jMenuItem.setActionCommand(SELECT_BY_DEGREE_CMD);
        jMenuItem.addActionListener(listener);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Element ID...");
        jMenuItem.setActionCommand(SELECT_BY_GENE_ID_CMD);
        jMenuItem.addActionListener(listener);
        jMenu.add(jMenuItem);
        jPopupMenu.add(jMenu);
        JMenu jMenu2 = new JMenu("Links");
        jMenuItem = new JMenuItem("Threshold...");
        jMenuItem.setActionCommand(LINKS_THRESHOLD_CMD);
        jMenuItem.addActionListener(listener);
        jMenu2.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("Color");
        jMenuItem.setSelected(true);
        jMenuItem.setActionCommand(LINKS_COLOR_CMD);
        jMenuItem.addActionListener(listener);
        jMenu2.add(jMenuItem);
        jPopupMenu.add(jMenu2);
        jMenuItem = new JMenuItem("Deselect");
        jMenuItem.setActionCommand(DESELECT_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Set Public Cluster...");
        jMenuItem.setActionCommand(SET_PUBLIC_CLUSTER_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Find Clusters");
        jMenuItem.setActionCommand(FIND_CLUSTER_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        JMenu jMenu3 = new JMenu("Shape");
        ButtonGroup buttonGroup = new ButtonGroup();
        jMenuItem = new JRadioButtonMenuItem("Rectangle");
        jMenuItem.setSelected(true);
        jMenuItem.setActionCommand(SHAPE_RECT_CMD);
        jMenuItem.addActionListener(listener);
        jMenu3.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem = new JRadioButtonMenuItem("Oval");
        jMenuItem.setActionCommand(SHAPE_OVAL_CMD);
        jMenuItem.addActionListener(listener);
        jMenu3.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jPopupMenu.add(jMenu3);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Set selection...");
        jMenuItem.setActionCommand(SET_SELECTION_COLOR_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Set labels...");
        jMenuItem.setActionCommand(SET_LABEL_COLOR_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Set background...");
        jMenuItem.setActionCommand(SET_BACKGROUND_COLOR_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
    }

    private JMenuItem getJMenuItem(JPopupMenu jPopupMenu, String string) {
        Component[] componentArray = jPopupMenu.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JMenuItem jMenuItem;
            if (componentArray[i] instanceof JMenu && (jMenuItem = this.getJMenuItem(((JMenu)componentArray[i]).getPopupMenu(), string)) != null) {
                return jMenuItem;
            }
            if (!(componentArray[i] instanceof JMenuItem) || !((JMenuItem)componentArray[i]).getActionCommand().equals(string)) continue;
            return (JMenuItem)componentArray[i];
        }
        return null;
    }

    private void setEnableMenuItem(String string, boolean bl) {
        JMenuItem jMenuItem = this.getJMenuItem(this.popup, string);
        if (jMenuItem == null) {
            return;
        }
        jMenuItem.setEnabled(bl);
    }

    private void onShowAll() {
        this.setSizes(300 + this.insets.left + this.insets.right, 300 + this.insets.top + this.insets.bottom);
        this.revalidate();
    }

    private void onZoomIn() {
        this.zoom(2.0f);
    }

    private void onZoomOut() {
        this.zoom(0.5f);
        if (this.getPreferredSize().width < this.getWidth() || this.getPreferredSize().height < this.getHeight()) {
            this.repaint();
        }
    }

    private void zoom(float f) {
        int n = (int)((float)(this.getPreferredSize().width - this.insets.left - this.insets.right) * f);
        int n2 = (int)((float)(this.getPreferredSize().height - this.insets.top - this.insets.bottom) * f);
        int n3 = this.getParent().getWidth();
        int n4 = this.getParent().getHeight();
        int n5 = Math.abs(this.getX()) - this.insets.left + (int)((float)n3 * (f - 1.0f) / (f * 2.0f));
        int n6 = Math.abs(this.getY()) - this.insets.top + (int)((float)n4 * (f - 1.0f) / (f * 2.0f));
        this.setSizes(n + this.insets.left + this.insets.right, n2 + this.insets.top + this.insets.bottom);
        this.framework.setContentLocation((int)((float)n5 * f + (float)this.insets.left), (int)((float)n6 * f + (float)this.insets.top));
    }

    private void zoom(Rectangle rectangle) {
        if (rectangle == null || rectangle.width < 10 || rectangle.height < 10) {
            this.drawZoomRect(new Rectangle());
            return;
        }
        int n = this.getParent().getWidth();
        int n2 = this.getParent().getHeight();
        float f = Math.min((float)n / (float)rectangle.width, (float)n2 / (float)rectangle.height);
        float f2 = (float)(this.getPreferredSize().width - this.insets.left - this.insets.right) * f;
        float f3 = (float)(this.getPreferredSize().height - this.insets.top - this.insets.bottom) * f;
        if (f2 > 2.1474836E9f || f3 > 2.1474836E9f) {
            this.drawZoomRect(new Rectangle());
            return;
        }
        int n3 = (int)f2;
        int n4 = (int)f3;
        float f4 = rectangle.x - this.insets.left;
        float f5 = rectangle.y - this.insets.top;
        this.setSizes(n3 + this.insets.left + this.insets.right, n4 + this.insets.top + this.insets.bottom);
        this.framework.setContentLocation((int)(f4 * f + (float)this.insets.left), (int)(f5 * f + (float)this.insets.top));
    }

    private void setSizes(int n, int n2) {
        this.setSize(n, n2);
        this.setPreferredSize(new Dimension(n, n2));
        this.revalidate();
    }

    private void selectByDegree(String string, int n, int n2) {
        this.clearSelected(this.selected);
        int n3 = 0;
        if (string.equals("Equal to")) {
            n3 = 1;
        } else if (string.equals("Less than")) {
            n3 = 2;
        } else if (string.equals("Between")) {
            n3 = 3;
        }
        block6: for (int i = 0; i < this.clusters.length; ++i) {
            switch (n3) {
                case 0: {
                    if (this.clusters[i].length - 1 <= n2) continue block6;
                    this.selected[this.clusters[i][0]] = true;
                    continue block6;
                }
                case 1: {
                    if (this.clusters[i].length - 1 != n2) continue block6;
                    this.selected[this.clusters[i][0]] = true;
                    continue block6;
                }
                case 2: {
                    if (this.clusters[i].length - 1 >= n) continue block6;
                    this.selected[this.clusters[i][0]] = true;
                    continue block6;
                }
                case 3: {
                    int n4 = this.clusters[i].length - 1;
                    if (n4 >= n2 || n4 <= n) continue block6;
                    this.selected[this.clusters[i][0]] = true;
                }
            }
        }
        this.repaint();
    }

    private void selectByGeneID(String string, String string2) {
        this.clearSelected(this.selected);
        boolean bl = string.equals("Like");
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.clusters[i].length <= 1) continue;
            for (int j = 0; j < this.clusters[i].length; ++j) {
                String string3;
                String string4 = string3 = this.isGenes ? this.data.getUniqueId(this.clusters[i][j]) : this.data.getSampleName(this.clusters[i][j]);
                if (string3 == null) continue;
                boolean bl2 = bl ? string3.indexOf(string2) != -1 : string3.equals(string2);
                this.selected[this.clusters[i][j]] = bl2;
            }
        }
        this.repaint();
    }

    private void onSetBackgroundColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color color = JColorChooser.showDialog(frame, "Choose color", this.getBackground());
        if (color != null) {
            this.setBackground(color);
        }
    }

    private void setSelectionColor(Color color) {
        this.selectionColor = color;
        this.repaint();
    }

    private void setLabelColor(Color color) {
        this.labelColor = color;
        this.repaint();
    }

    private void onSetSelectionColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color color = JColorChooser.showDialog(frame, "Choose selection color", this.getBackground());
        if (color != null) {
            this.setSelectionColor(color);
        }
    }

    private void onSetLabelColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color color = JColorChooser.showDialog(frame, "Choose label color", this.getBackground());
        if (color != null) {
            this.setLabelColor(color);
        }
    }

    private void onDegreeSelection() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        RelNetSelectionDlg relNetSelectionDlg = new RelNetSelectionDlg(frame, 0);
        if (relNetSelectionDlg.showModal() == 0) {
            this.selectByDegree(relNetSelectionDlg.getCondition(), relNetSelectionDlg.getMinDegree(), relNetSelectionDlg.getMaxDegree());
        }
    }

    private void onGeneIDSelection() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        RelNetSelectionDlg relNetSelectionDlg = new RelNetSelectionDlg(frame, 1);
        if (relNetSelectionDlg.showModal() == 0) {
            this.selectByGeneID(relNetSelectionDlg.getCondition(), relNetSelectionDlg.getGeneID());
        }
    }

    private void onLinksThreshold() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        String string = (String)JOptionPane.showInputDialog(frame, "Enter in links threshold (from 0 to 1).", "Input", 2, null, null, String.valueOf(this.links_threshold));
        if (string == null || string.equals("")) {
            return;
        }
        try {
            float f = Float.parseFloat(string);
            if (f < 0.0f || f > 1.0f) {
                throw new NumberFormatException("value must be between 0 and 1.");
            }
            this.links_threshold = f;
            this.repaint();
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(frame, "Illegal number: " + numberFormatException.getMessage(), "Error", 0);
        }
    }

    private void onLinksColor() {
        JMenuItem jMenuItem = this.getJMenuItem(this.popup, LINKS_COLOR_CMD);
        this.isLinksColor = jMenuItem.isSelected();
        this.repaint();
    }

    private void onDeselect() {
        this.clearSelected(this.selected);
        this.repaint();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return this.elementSize.height;
        }
        return this.elementSize.width;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return rectangle.height;
        }
        return rectangle.width;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    private int findSpot(float f, float f2, Rectangle2D.Float float_) {
        float f3 = this.getScale();
        float f4 = (float)this.elementSize.getWidth() / f3;
        float f5 = (float)this.elementSize.getHeight() / f3;
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.clusters[i].length <= 1) continue;
            for (int j = 0; j < this.clusters[i].length; ++j) {
                float_.setRect(this.coords[this.clusters[i][j]][0] - f4 / 2.0f, this.coords[this.clusters[i][j]][1] - f5 / 2.0f, f4, f5);
                if (!float_.contains(f, f2)) continue;
                return this.clusters[i][j];
            }
        }
        return -1;
    }

    private void unselectSpot(int n) {
        this.framework.setStatusText(this.status);
        Graphics graphics = this.getContentComponent().getGraphics();
        this.drawSpot(graphics, n);
        graphics.dispose();
        this.hideTipWindow();
    }

    private void selectSpot(int n) {
        this.status = this.framework.getStatusText();
        if (this.isGenes) {
            this.framework.setStatusText("Gene Id: " + this.data.getUniqueId(n) + " Gene Name: " + this.data.getGeneName(n));
        } else {
            this.framework.setStatusText("Experiment: " + this.data.getSampleName(n));
        }
        Graphics graphics = this.getContentComponent().getGraphics();
        this.drawSelectedSpot(graphics, n);
        graphics.dispose();
        this.showTipWindow(n);
    }

    private void showTipWindow(int n) {
        if (this.isGenes && this.labelIndex < 0) {
            return;
        }
        JComponent jComponent = this.getContentComponent();
        String string = this.isGenes ? this.data.getElementAttribute(n, this.labelIndex) : this.data.getSampleName(n);
        JToolTip jToolTip = new JToolTip();
        jToolTip.setTipText(string);
        Dimension dimension = jToolTip.getPreferredSize();
        float f = this.getScale();
        float f2 = this.coords[n][0] * f + (float)this.insets.left + (float)(this.elementSize.width / 2) + 10.0f;
        float f3 = this.coords[n][1] * f + (float)this.insets.top + (float)((double)this.elementSize.height - dimension.getHeight()) / 2.0f;
        Point point = jComponent.getLocationOnScreen();
        this.tipWindow.getContentPane().add((Component)jToolTip, "Center");
        this.tipWindow.setLocation((int)((float)point.x + f2), (int)((float)point.y + f3));
        this.tipWindow.pack();
        this.tipWindow.setVisible(true);
    }

    private void hideTipWindow() {
        this.tipWindow.getContentPane().removeAll();
        this.tipWindow.setVisible(false);
    }

    private JWindow createTipWindow() {
        return new JWindow(JOptionPane.getFrameForComponent(this.getContentComponent()));
    }

    private void onShapeRect() {
        this.setShapeType(0);
    }

    private void onShapeOval() {
        this.setShapeType(1);
    }

    private void setShapeType(int n) {
        this.shape_type = n;
        this.repaint();
    }

    private boolean hasSelected() {
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            return true;
        }
        return false;
    }

    private void onSetPublicCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color color = JColorChooser.showDialog(frame, "Choose color", Color.green);
        if (color == null) {
            return;
        }
        int n = 0;
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            ++n;
        }
        if (n == 0) {
            return;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            nArray[n2] = i;
            ++n2;
        }
        if (this.isGenes) {
            this.data.setProbesColor(nArray, color);
        } else {
            this.data.setExperimentColor(nArray, color);
        }
        this.clearSelected(this.selected);
        this.repaint();
    }

    private void onFindCluster(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.clusters[this.indices[i]].length <= 1) continue;
            for (int j = 0; j < this.clusters[this.indices[i]].length; ++j) {
                if (n != this.clusters[this.indices[i]][j]) continue;
                arrayList.add(new String("Cluster " + String.valueOf(this.indices[i] + 1) + " (" + this.clusters[this.indices[i]].length + ")"));
            }
        }
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        String string = this.isGenes ? this.data.getUniqueId(n) + " (" + this.data.getGeneName(n) + ")" : this.data.getSampleName(n);
        String string2 = "Clusters for node: " + string;
        RelNetClusterList relNetClusterList = new RelNetClusterList(frame, string2, arrayList.toArray(new String[arrayList.size()]));
        relNetClusterList.showModal();
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    MouseMotionListener {
        private boolean isSpotSelected = false;
        private int spotIndex = -1;
        private Rectangle2D.Float spotRect = new Rectangle2D.Float();
        private boolean isZoomStarted = false;
        private Rectangle zoomRect = new Rectangle();
        private Point zoomPoint = new Point();

        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(RelevanceNetworkViewer.SET_BACKGROUND_COLOR_CMD)) {
                RelevanceNetworkViewer.this.onSetBackgroundColor();
            } else if (string.equals(RelevanceNetworkViewer.SET_SELECTION_COLOR_CMD)) {
                RelevanceNetworkViewer.this.onSetSelectionColor();
            } else if (string.equals(RelevanceNetworkViewer.SET_LABEL_COLOR_CMD)) {
                RelevanceNetworkViewer.this.onSetLabelColor();
            } else if (string.equals(RelevanceNetworkViewer.ZOOM_IN_CMD)) {
                RelevanceNetworkViewer.this.onZoomIn();
            } else if (string.equals(RelevanceNetworkViewer.ZOOM_OUT_CMD)) {
                RelevanceNetworkViewer.this.onZoomOut();
            } else if (string.equals(RelevanceNetworkViewer.SHOW_ALL_CMD)) {
                RelevanceNetworkViewer.this.onShowAll();
            } else if (!(string.equals(RelevanceNetworkViewer.CIRCULAR_LAYOUT_CMD) || string.equals(RelevanceNetworkViewer.RANDOM_LAYOUT_CMD) || string.equals(RelevanceNetworkViewer.DEBUG_LAYOUT_CMD))) {
                if (string.equals(RelevanceNetworkViewer.SELECT_BY_DEGREE_CMD)) {
                    RelevanceNetworkViewer.this.onDegreeSelection();
                } else if (string.equals(RelevanceNetworkViewer.SELECT_BY_GENE_ID_CMD)) {
                    RelevanceNetworkViewer.this.onGeneIDSelection();
                } else if (string.equals(RelevanceNetworkViewer.LINKS_THRESHOLD_CMD)) {
                    RelevanceNetworkViewer.this.onLinksThreshold();
                } else if (string.equals(RelevanceNetworkViewer.LINKS_COLOR_CMD)) {
                    RelevanceNetworkViewer.this.onLinksColor();
                } else if (string.equals(RelevanceNetworkViewer.DESELECT_CMD)) {
                    RelevanceNetworkViewer.this.onDeselect();
                } else if (string.equals(RelevanceNetworkViewer.SHAPE_OVAL_CMD)) {
                    RelevanceNetworkViewer.this.onShapeOval();
                } else if (string.equals(RelevanceNetworkViewer.SHAPE_RECT_CMD)) {
                    RelevanceNetworkViewer.this.onShapeRect();
                } else if (string.equals(RelevanceNetworkViewer.SET_PUBLIC_CLUSTER_CMD)) {
                    RelevanceNetworkViewer.this.onSetPublicCluster();
                } else if (string.equals(RelevanceNetworkViewer.FIND_CLUSTER_CMD)) {
                    RelevanceNetworkViewer.this.onFindCluster(this.spotIndex);
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            if (this.isZoomStarted) {
                this.processDrawZoom(mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.startDrawZoom(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void startDrawZoom(int n, int n2) {
            this.isZoomStarted = true;
            this.zoomPoint.setLocation(n, n2);
            RelevanceNetworkViewer.this.onStartDrawZoom();
        }

        private void processDrawZoom(int n, int n2) {
            int n3 = n;
            if (n > this.zoomPoint.x) {
                n3 = this.zoomPoint.x;
            }
            int n4 = n2;
            if (n2 > this.zoomPoint.y) {
                n4 = this.zoomPoint.y;
            }
            this.zoomRect.setBounds(n3, n4, Math.abs(n - this.zoomPoint.x), Math.abs(n2 - this.zoomPoint.y));
            RelevanceNetworkViewer.this.drawZoomRect(this.zoomRect);
        }

        private void stopDrawZoom() {
            this.isZoomStarted = false;
            RelevanceNetworkViewer.this.zoom(this.zoomRect);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (RelevanceNetworkViewer.this.popup.isVisible()) {
                return;
            }
            float f = RelevanceNetworkViewer.this.getScale();
            float f2 = (float)(mouseEvent.getX() - ((RelevanceNetworkViewer)RelevanceNetworkViewer.this).insets.left) / f;
            float f3 = (float)(mouseEvent.getY() - ((RelevanceNetworkViewer)RelevanceNetworkViewer.this).insets.top) / f;
            if (this.isSpotSelected) {
                if (this.spotRect.contains(f2, f3)) {
                    return;
                }
                this.isSpotSelected = false;
                RelevanceNetworkViewer.this.unselectSpot(this.spotIndex);
                this.spotIndex = -1;
            }
            if ((this.spotIndex = RelevanceNetworkViewer.this.findSpot(f2, f3, this.spotRect)) != -1) {
                RelevanceNetworkViewer.this.selectSpot(this.spotIndex);
                this.isSpotSelected = true;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            if (!mouseEvent.isShiftDown() && this.isSpotSelected) {
                if (RelevanceNetworkViewer.this.isGenes) {
                    RelevanceNetworkViewer.this.framework.displaySlideElementInfo(0, this.spotIndex);
                } else {
                    RelevanceNetworkViewer.this.framework.displaySingleArrayViewer(this.spotIndex);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.maybeShowPopup(mouseEvent);
            } else if (this.isZoomStarted) {
                this.stopDrawZoom();
            }
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            RelevanceNetworkViewer.this.setEnableMenuItem(RelevanceNetworkViewer.ZOOM_OUT_CMD, RelevanceNetworkViewer.this.getPreferredSize().width - ((RelevanceNetworkViewer)RelevanceNetworkViewer.this).insets.left - ((RelevanceNetworkViewer)RelevanceNetworkViewer.this).insets.right >= 300 || RelevanceNetworkViewer.this.getPreferredSize().height - ((RelevanceNetworkViewer)RelevanceNetworkViewer.this).insets.top - ((RelevanceNetworkViewer)RelevanceNetworkViewer.this).insets.bottom >= 300);
            RelevanceNetworkViewer.this.setEnableMenuItem(RelevanceNetworkViewer.ZOOM_IN_CMD, (float)Math.max(RelevanceNetworkViewer.this.getWidth() + ((RelevanceNetworkViewer)RelevanceNetworkViewer.this).insets.left + ((RelevanceNetworkViewer)RelevanceNetworkViewer.this).insets.right, RelevanceNetworkViewer.this.getHeight() + ((RelevanceNetworkViewer)RelevanceNetworkViewer.this).insets.top + ((RelevanceNetworkViewer)RelevanceNetworkViewer.this).insets.bottom) < 1.0737418E9f);
            RelevanceNetworkViewer.this.setEnableMenuItem(RelevanceNetworkViewer.SET_PUBLIC_CLUSTER_CMD, RelevanceNetworkViewer.this.hasSelected());
            RelevanceNetworkViewer.this.setEnableMenuItem(RelevanceNetworkViewer.FIND_CLUSTER_CMD, this.isSpotSelected);
            RelevanceNetworkViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

