/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sam;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMDeltaInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMGraphViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMPreDialog;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMState;
import org.tigr.util.FloatMatrix;

public class SAMGUI
implements IClusterGUI {
    private Algorithm algorithm;
    private Progress progress;
    private Experiment experiment;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private float[] dValues;
    private float[] rValues;
    private float[] qLowestFDR;
    private float[] foldChangeArray;
    private double[] xArray;
    private double[] yArray;
    private float delta;
    private double[] deltaGrid;
    private double[] medNumFalse;
    private double[] false90th;
    private double[] FDRMedian;
    private double[] FDR90th;
    private int[] numSig;
    int[] groupAssignments;
    int numMultiClassGroups;
    int studyDesign;
    boolean[] inSurvivalAnalysis;
    boolean[] censored;
    double[] survivalTimes;
    public static JFrame SAMFrame;
    boolean calculateQLowestFDR;
    Vector exptNamesVector;
    Vector geneNamesVector;
    Vector pairedGroupAExpts;
    Vector pairedGroupBExpts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        Object object;
        int n;
        SAMFrame = (JFrame)iFramework.getFrame();
        this.experiment = iFramework.getData().getExperiment();
        this.exptNamesVector = new Vector();
        this.geneNamesVector = new Vector();
        int n2 = this.experiment.getNumberOfSamples();
        int n3 = this.experiment.getNumberOfGenes();
        for (n = 0; n < n2; ++n) {
            this.exptNamesVector.add(iFramework.getData().getFullSampleName(n));
        }
        for (n = 0; n < n3; ++n) {
            this.geneNamesVector.add(iFramework.getData().getGeneName(n));
        }
        this.studyDesign = 0;
        int n4 = 0;
        int n5 = 0;
        this.numMultiClassGroups = 0;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        double d = 0.0;
        if (!SAMState.firstRun) {
            SAMPreDialog sAMPreDialog = new SAMPreDialog((JFrame)iFramework.getFrame(), true);
            sAMPreDialog.setVisible(true);
            if (!sAMPreDialog.isOkPressed()) {
                return null;
            }
            if (sAMPreDialog.usePrevious()) {
                bl3 = true;
                this.groupAssignments = SAMState.groupAssignments;
                this.studyDesign = SAMState.studyDesign;
                if (this.studyDesign == 6) {
                    this.numMultiClassGroups = SAMState.numMultiClassGroups;
                }
                if (this.studyDesign == 5) {
                    this.pairedGroupAExpts = SAMState.pairedGroupAExpts;
                    this.pairedGroupBExpts = SAMState.pairedGroupBExpts;
                }
                if (this.studyDesign == 7) {
                    this.inSurvivalAnalysis = SAMState.inSurvivalAnalysis;
                    this.survivalTimes = SAMState.survivalTimes;
                    this.censored = SAMState.censored;
                }
                n4 = SAMState.numCombs;
                n5 = SAMState.numNeighbors;
                bl = SAMState.useKNearest;
                bl2 = sAMPreDialog.drawTrees();
                bl5 = SAMState.useTusherEtAlS0;
                this.calculateQLowestFDR = SAMState.calculateQLowestFDR;
            } else {
                bl3 = false;
                SAMInitDialog sAMInitDialog = new SAMInitDialog((JFrame)iFramework.getFrame(), true, this.exptNamesVector, n3);
                sAMInitDialog.setVisible(true);
                if (!sAMInitDialog.isOkPressed()) {
                    return null;
                }
                SAMState.firstRun = false;
                SAMState.studyDesign = this.studyDesign = sAMInitDialog.getStudyDesign();
                if (this.studyDesign == 5) {
                    this.pairedGroupAExpts = sAMInitDialog.getPairedAExpts();
                    this.pairedGroupBExpts = sAMInitDialog.getPairedBExpts();
                    SAMState.pairedGroupAExpts = this.pairedGroupAExpts;
                    SAMState.pairedGroupBExpts = this.pairedGroupBExpts;
                }
                if (this.studyDesign == 6) {
                    SAMState.numMultiClassGroups = this.numMultiClassGroups = sAMInitDialog.getMultiClassNumGroups();
                }
                if (this.studyDesign == 7) {
                    this.inSurvivalAnalysis = sAMInitDialog.isInSurvivalAnalysis();
                    SAMState.inSurvivalAnalysis = this.inSurvivalAnalysis;
                    this.censored = sAMInitDialog.isCensored();
                    SAMState.censored = this.censored;
                    this.survivalTimes = sAMInitDialog.getSurvivalTimes();
                    SAMState.survivalTimes = this.survivalTimes;
                }
                this.groupAssignments = sAMInitDialog.getGroupAssignments();
                SAMState.groupAssignments = this.groupAssignments;
                SAMState.numCombs = n4 = sAMInitDialog.getUserNumCombs();
                SAMState.useKNearest = bl = sAMInitDialog.useKNearest();
                if (bl) {
                    SAMState.numNeighbors = n5 = sAMInitDialog.getNumNeighbors();
                }
                bl4 = sAMInitDialog.isSaveMatrix();
                d = sAMInitDialog.getPercentile();
                SAMState.useTusherEtAlS0 = bl5 = sAMInitDialog.useTusherEtAlS0();
                SAMState.calculateQLowestFDR = this.calculateQLowestFDR = sAMInitDialog.calculateQLowestFDR();
                bl2 = sAMInitDialog.drawTrees();
            }
        } else {
            bl3 = false;
            SAMInitDialog sAMInitDialog = new SAMInitDialog((JFrame)iFramework.getFrame(), true, this.exptNamesVector, n3);
            sAMInitDialog.setVisible(true);
            if (!sAMInitDialog.isOkPressed()) {
                return null;
            }
            SAMState.firstRun = false;
            SAMState.studyDesign = this.studyDesign = sAMInitDialog.getStudyDesign();
            if (this.studyDesign == 5) {
                this.pairedGroupAExpts = sAMInitDialog.getPairedAExpts();
                this.pairedGroupBExpts = sAMInitDialog.getPairedBExpts();
                SAMState.pairedGroupAExpts = this.pairedGroupAExpts;
                SAMState.pairedGroupBExpts = this.pairedGroupBExpts;
            }
            if (this.studyDesign == 6) {
                SAMState.numMultiClassGroups = this.numMultiClassGroups = sAMInitDialog.getMultiClassNumGroups();
            }
            if (this.studyDesign == 7) {
                this.inSurvivalAnalysis = sAMInitDialog.isInSurvivalAnalysis();
                SAMState.inSurvivalAnalysis = this.inSurvivalAnalysis;
                this.censored = sAMInitDialog.isCensored();
                SAMState.censored = this.censored;
                this.survivalTimes = sAMInitDialog.getSurvivalTimes();
                SAMState.survivalTimes = this.survivalTimes;
            }
            this.groupAssignments = sAMInitDialog.getGroupAssignments();
            SAMState.groupAssignments = this.groupAssignments;
            SAMState.numCombs = n4 = sAMInitDialog.getUserNumCombs();
            SAMState.useKNearest = bl = sAMInitDialog.useKNearest();
            if (bl) {
                SAMState.numNeighbors = n5 = sAMInitDialog.getNumNeighbors();
            }
            bl2 = sAMInitDialog.drawTrees();
            bl4 = sAMInitDialog.isSaveMatrix();
            d = sAMInitDialog.getPercentile();
            SAMState.useTusherEtAlS0 = bl5 = sAMInitDialog.useTusherEtAlS0();
            SAMState.calculateQLowestFDR = this.calculateQLowestFDR = sAMInitDialog.calculateQLowestFDR();
        }
        int n6 = 0;
        boolean bl6 = false;
        boolean bl7 = false;
        if (bl2) {
            object = new HCLInitDialog(iFramework.getFrame());
            if (((HCLInitDialog)object).showModal() != 0) {
                return null;
            }
            n6 = ((HCLInitDialog)object).getMethod();
            bl6 = ((HCLInitDialog)object).isClusterExperience();
            bl7 = ((HCLInitDialog)object).isClusterGenes();
        }
        object = new Listener();
        try {
            Serializable serializable;
            float f;
            float f2;
            FloatMatrix floatMatrix;
            FloatMatrix floatMatrix2;
            this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("SAM");
            this.algorithm.addAlgorithmListener((AlgorithmListener)object);
            this.progress = new Progress(iFramework.getFrame(), "SAM Execution", (DialogListener)object);
            this.progress.show();
            AlgorithmData algorithmData = new AlgorithmData();
            algorithmData.addMatrix("experiment", this.experiment.getMatrix());
            algorithmData.addParam("distance-factor", String.valueOf(1.0f));
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
            int n7 = iDistanceMenu.getDistanceFunction();
            if (n7 == 0) {
                n7 = 4;
            }
            algorithmData.addParam("distance-function", String.valueOf(n7));
            algorithmData.addIntArray("group-assignments", this.groupAssignments);
            algorithmData.addParam("study-design", String.valueOf(this.studyDesign));
            if (this.studyDesign == 5) {
                floatMatrix2 = new FloatMatrix(this.pairedGroupAExpts.size(), 1);
                floatMatrix = new FloatMatrix(this.pairedGroupBExpts.size(), 1);
                for (int i = 0; i < this.pairedGroupAExpts.size(); ++i) {
                    floatMatrix2.A[i][0] = ((Integer)this.pairedGroupAExpts.get(i)).floatValue();
                    floatMatrix.A[i][0] = ((Integer)this.pairedGroupBExpts.get(i)).floatValue();
                }
                algorithmData.addMatrix("pairedAExptsMatrix", floatMatrix2);
                algorithmData.addMatrix("pairedBExptsMatrix", floatMatrix);
            }
            if (this.studyDesign == 6) {
                algorithmData.addParam("numMultiClassGroups", String.valueOf(this.numMultiClassGroups));
            }
            if (this.studyDesign == 7) {
                floatMatrix2 = new FloatMatrix(this.inSurvivalAnalysis.length, 1);
                floatMatrix = new FloatMatrix(this.inSurvivalAnalysis.length, 1);
                FloatMatrix floatMatrix3 = new FloatMatrix(this.inSurvivalAnalysis.length, 1);
                for (int i = 0; i < this.inSurvivalAnalysis.length; ++i) {
                    floatMatrix2.A[i][0] = !this.inSurvivalAnalysis[i] ? 0.0f : 1.0f;
                    floatMatrix.A[i][0] = !this.censored[i] ? 0.0f : 1.0f;
                    floatMatrix3.A[i][0] = (float)this.survivalTimes[i];
                }
                algorithmData.addMatrix("inAnalysisMatrix", floatMatrix2);
                algorithmData.addMatrix("isCensoredMatrix", floatMatrix);
                algorithmData.addMatrix("survivalTimesMatrix", floatMatrix3);
            }
            algorithmData.addParam("num-combs", String.valueOf(n4));
            algorithmData.addParam("use-k-nearest", String.valueOf(bl));
            algorithmData.addParam("num-neighbors", String.valueOf(n5));
            algorithmData.addParam("saveImputedMatrix", String.valueOf(bl4));
            algorithmData.addParam("use-previous-graph", String.valueOf(bl3));
            algorithmData.addParam("userPercentile", String.valueOf(d));
            algorithmData.addParam("useTusherEtAlS0", String.valueOf(bl5));
            algorithmData.addParam("calculateQLowestFDR", String.valueOf(this.calculateQLowestFDR));
            if (bl2) {
                algorithmData.addParam("hierarchical-tree", String.valueOf(true));
                algorithmData.addParam("method-linkage", String.valueOf(n6));
                algorithmData.addParam("calculate-genes", String.valueOf(bl7));
                algorithmData.addParam("calculate-experiments", String.valueOf(bl6));
            }
            long l = System.currentTimeMillis();
            AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
            long l2 = System.currentTimeMillis() - l;
            Cluster cluster = algorithmData2.getCluster("cluster");
            NodeList nodeList = cluster.getNodeList();
            AlgorithmParameters algorithmParameters = algorithmData2.getParams();
            int n8 = 0;
            n8 = this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7 ? 4 : 2;
            this.clusters = new int[n8][];
            for (int i = 0; i < n8; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = algorithmData2.getMatrix("clusters_means");
            this.variances = algorithmData2.getMatrix("clusters_variances");
            this.delta = algorithmParameters.getFloat("delta");
            String string = algorithmParameters.getString("numSigGenes");
            String string2 = algorithmParameters.getString("numFalseSigMed");
            String string3 = algorithmParameters.getString("numFalseSig90th");
            String string4 = algorithmParameters.getString("FDRMedian");
            String string5 = algorithmParameters.getString("FDR90th");
            float f3 = algorithmParameters.getFloat("sNought");
            float f4 = algorithmParameters.getFloat("s0Percentile");
            float f5 = algorithmParameters.getFloat("pi0Hat");
            try {
                f2 = algorithmParameters.getFloat("upperCutoff");
            }
            catch (NumberFormatException numberFormatException) {
                f2 = Float.POSITIVE_INFINITY;
            }
            try {
                f = algorithmParameters.getFloat("lowerCutoff");
            }
            catch (NumberFormatException numberFormatException) {
                f = Float.NEGATIVE_INFINITY;
            }
            boolean bl8 = algorithmParameters.getBoolean("useFoldChange");
            float f6 = algorithmParameters.getFloat("foldChangeValue");
            FloatMatrix floatMatrix4 = algorithmData2.getMatrix("dValuesMatrix");
            FloatMatrix floatMatrix5 = algorithmData2.getMatrix("rValuesMatrix");
            FloatMatrix floatMatrix6 = algorithmData2.getMatrix("qLowestFDRMatrix");
            FloatMatrix floatMatrix7 = algorithmData2.getMatrix("foldChangeMatrix");
            this.dValues = new float[floatMatrix4.getRowDimension()];
            this.rValues = new float[floatMatrix5.getRowDimension()];
            this.foldChangeArray = new float[floatMatrix7.getRowDimension()];
            this.qLowestFDR = new float[floatMatrix6.getRowDimension()];
            for (int i = 0; i < this.dValues.length; ++i) {
                this.dValues[i] = floatMatrix4.A[i][0];
                this.rValues[i] = floatMatrix5.A[i][0];
                this.qLowestFDR[i] = floatMatrix6.A[i][0];
                this.foldChangeArray[i] = floatMatrix7.A[i][0];
            }
            FloatMatrix floatMatrix8 = algorithmData2.getMatrix("dBarMatrixX");
            FloatMatrix floatMatrix9 = algorithmData2.getMatrix("sortedDMatrixY");
            this.xArray = new double[floatMatrix8.getRowDimension()];
            this.yArray = new double[floatMatrix9.getRowDimension()];
            for (int i = 0; i < this.xArray.length; ++i) {
                this.xArray[i] = floatMatrix8.A[i][0];
                this.yArray[i] = floatMatrix9.A[i][0];
            }
            FloatMatrix floatMatrix10 = algorithmData2.getMatrix("deltaGridMatrix");
            FloatMatrix floatMatrix11 = algorithmData2.getMatrix("medNumFalseMatrix");
            FloatMatrix floatMatrix12 = algorithmData2.getMatrix("false90thMatrix");
            FloatMatrix floatMatrix13 = algorithmData2.getMatrix("numSigMatrix");
            FloatMatrix floatMatrix14 = algorithmData2.getMatrix("FDRMedianMatrix");
            FloatMatrix floatMatrix15 = algorithmData2.getMatrix("FDR90thMatrix");
            this.deltaGrid = new double[floatMatrix10.getRowDimension()];
            this.medNumFalse = new double[floatMatrix11.getRowDimension()];
            this.false90th = new double[floatMatrix12.getRowDimension()];
            this.numSig = new int[floatMatrix13.getRowDimension()];
            this.FDRMedian = new double[floatMatrix14.getRowDimension()];
            this.FDR90th = new double[floatMatrix15.getRowDimension()];
            for (int i = 0; i < this.deltaGrid.length; ++i) {
                this.deltaGrid[i] = floatMatrix10.A[i][0];
                this.medNumFalse[i] = floatMatrix11.A[i][0];
                this.false90th[i] = floatMatrix12.A[i][0];
                this.numSig[i] = (int)floatMatrix13.A[i][0];
                this.FDRMedian[i] = floatMatrix14.A[i][0];
                this.FDR90th[i] = floatMatrix15.A[i][0];
            }
            if (!bl3 && bl4) {
                FloatMatrix floatMatrix16 = algorithmData2.getMatrix("imputedMatrix");
                serializable = new JFileChooser();
                serializable.setDialogTitle("Save imputed matrix");
                serializable.setCurrentDirectory(new File("Data"));
                int n9 = serializable.showSaveDialog((JFrame)iFramework.getFrame());
                if (n9 == 0) {
                    File file = serializable.getSelectedFile();
                    try {
                        int n10;
                        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                        String[] stringArray = iFramework.getData().getFieldNames();
                        for (n10 = 0; n10 < stringArray.length; ++n10) {
                            printWriter.print(stringArray[n10]);
                            if (n10 >= stringArray.length - 1) continue;
                            printWriter.print("\t");
                        }
                        for (n10 = 0; n10 < this.experiment.getNumberOfSamples(); ++n10) {
                            printWriter.print("\t");
                            printWriter.print(iFramework.getData().getFullSampleName(this.experiment.getSampleIndex(n10)));
                        }
                        printWriter.print("\n");
                        for (n10 = 0; n10 < floatMatrix16.getRowDimension(); ++n10) {
                            int n11;
                            for (n11 = 0; n11 < stringArray.length; ++n11) {
                                printWriter.print(iFramework.getData().getElementAttribute(this.experiment.getGeneIndexMappedToData(n10), n11));
                                if (n11 >= stringArray.length - 1) continue;
                                printWriter.print("\t");
                            }
                            for (n11 = 0; n11 < floatMatrix16.getColumnDimension(); ++n11) {
                                printWriter.print("\t");
                                printWriter.print(Float.toString(floatMatrix16.A[n10][n11]));
                            }
                            printWriter.print("\n");
                        }
                        printWriter.flush();
                        printWriter.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            GeneralInfo generalInfo = new GeneralInfo();
            generalInfo.time = l2;
            generalInfo.delta = this.delta;
            generalInfo.upperCutoff = f2;
            generalInfo.lowerCutoff = f;
            if (this.studyDesign == 4 || this.studyDesign == 5) {
                if (bl8) {
                    generalInfo.useFoldChange = "Yes";
                    generalInfo.foldChangeValue = f6;
                } else {
                    generalInfo.useFoldChange = "No";
                }
            } else {
                generalInfo.useFoldChange = "N/A";
            }
            if (this.studyDesign == 6) {
                generalInfo.numMultiClassGroups = this.numMultiClassGroups;
            }
            generalInfo.numSigGenes = string;
            generalInfo.numFalseSigMed = string2;
            generalInfo.numFalseSig90th = string3;
            generalInfo.FDRMedian = string4;
            generalInfo.FDR90th = string5;
            generalInfo.studyDesign = this.studyDesign;
            if (bl) {
                generalInfo.imputationEngine = "K-Nearest Neighbors";
                generalInfo.numNeighbors = n5;
            } else {
                generalInfo.imputationEngine = "Row Average";
            }
            generalInfo.numCombs = n4;
            generalInfo.sNought = f3;
            generalInfo.s0Percentile = f4;
            generalInfo.pi0Hat = f5;
            generalInfo.hcl = bl2;
            generalInfo.hcl_genes = bl7;
            generalInfo.hcl_samples = bl6;
            generalInfo.hcl_method = n6;
            serializable = this.createResultTree(cluster, generalInfo);
            return serializable;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private DefaultMutableTreeNode createResultTree(Cluster cluster, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("SAM");
        this.addResultNodes(defaultMutableTreeNode, cluster, generalInfo);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        this.addSAMGraph(defaultMutableTreeNode);
        this.addSAMDeltaInfo(defaultMutableTreeNode);
        this.addExpressionImages(defaultMutableTreeNode);
        this.addHierarchicalTrees(defaultMutableTreeNode, cluster, generalInfo);
        this.addCentroidViews(defaultMutableTreeNode);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addSAMGraph(DefaultMutableTreeNode defaultMutableTreeNode) {
        SAMGraphViewer sAMGraphViewer = new SAMGraphViewer(this.xArray, this.yArray, this.studyDesign, this.delta);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("SAM Graph", sAMGraphViewer)));
    }

    private void addSAMDeltaInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        SAMDeltaInfoViewer sAMDeltaInfoViewer = new SAMDeltaInfoViewer(this.deltaGrid, this.medNumFalse, this.false90th, this.numSig, this.FDRMedian, this.FDR90th);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Delta table", sAMDeltaInfoViewer)));
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        SAMExperimentViewer sAMExperimentViewer = new SAMExperimentViewer(this.experiment, this.clusters, this.studyDesign, this.dValues, this.rValues, this.foldChangeArray, this.qLowestFDR, this.calculateQLowestFDR);
        if (this.studyDesign == 5 || this.studyDesign == 4 || this.studyDesign == 7) {
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i == 0) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Positive Significant Genes ", (IViewer)sAMExperimentViewer, new Integer(i))));
                    continue;
                }
                if (i == 1) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Negative Significant Genes ", (IViewer)sAMExperimentViewer, new Integer(i))));
                    continue;
                }
                if (i == 2) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Significant Genes ", (IViewer)sAMExperimentViewer, new Integer(i))));
                    continue;
                }
                if (i != 3) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)sAMExperimentViewer, new Integer(i))));
            }
        } else {
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i == 0) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)sAMExperimentViewer, new Integer(i))));
                    continue;
                }
                if (i != 1) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)sAMExperimentViewer, new Integer(i))));
            }
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        if (!generalInfo.hcl) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = cluster.getNodeList();
        if (this.studyDesign == 5 || this.studyDesign == 4 || this.studyDesign == 7) {
            for (int i = 0; i < nodeList.getSize(); ++i) {
                if (i == 0) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Positive Significant Genes ", this.createHCLViewer(nodeList.getNode(i), generalInfo))));
                    continue;
                }
                if (i == 1) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Negative Significant Genes ", this.createHCLViewer(nodeList.getNode(i), generalInfo))));
                    continue;
                }
                if (i == 2) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Significant Genes ", this.createHCLViewer(nodeList.getNode(i), generalInfo))));
                    continue;
                }
                if (i != 3) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", this.createHCLViewer(nodeList.getNode(i), generalInfo))));
            }
        } else {
            for (int i = 0; i < nodeList.getSize(); ++i) {
                if (i == 0) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", this.createHCLViewer(nodeList.getNode(i), generalInfo))));
                    continue;
                }
                if (i != 1) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", this.createHCLViewer(nodeList.getNode(i), generalInfo))));
            }
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private IViewer createHCLViewer(Node node, GeneralInfo generalInfo) {
        HCLTreeData hCLTreeData;
        HCLTreeData hCLTreeData2 = hCLTreeData = generalInfo.hcl_genes ? this.getResult(node, 0) : null;
        HCLTreeData hCLTreeData3 = generalInfo.hcl_samples ? this.getResult(node, generalInfo.hcl_genes ? 4 : 0) : null;
        return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData, hCLTreeData3);
    }

    private HCLTreeData getResult(Node node, int n) {
        HCLTreeData hCLTreeData = new HCLTreeData();
        NodeValueList nodeValueList = node.getValues();
        hCLTreeData.child_1_array = (int[])nodeValueList.getNodeValue((int)n).value;
        hCLTreeData.child_2_array = (int[])nodeValueList.getNodeValue((int)(n + 1)).value;
        hCLTreeData.node_order = (int[])nodeValueList.getNodeValue((int)(n + 2)).value;
        hCLTreeData.height = (float[])nodeValueList.getNodeValue((int)(n + 3)).value;
        return hCLTreeData;
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Results (#,%)", new SAMInfoViewer(this.clusters, this.experiment.getNumberOfGenes(), this.studyDesign))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        SAMCentroidViewer sAMCentroidViewer = new SAMCentroidViewer(this.experiment, this.clusters, this.studyDesign, this.dValues, this.rValues, this.foldChangeArray, this.qLowestFDR, this.calculateQLowestFDR);
        sAMCentroidViewer.setMeans(this.means.A);
        sAMCentroidViewer.setVariances(this.variances.A);
        if (this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7) {
            for (n = 0; n < this.clusters.length; ++n) {
                if (n == 0) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Positive Significant Genes ", (IViewer)sAMCentroidViewer, new CentroidUserObject(n, 0))));
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Positive Significant Genes ", (IViewer)sAMCentroidViewer, new CentroidUserObject(n, 1))));
                    continue;
                }
                if (n == 1) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Negative Significant Genes ", (IViewer)sAMCentroidViewer, new CentroidUserObject(n, 0))));
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Negative Significant Genes ", (IViewer)sAMCentroidViewer, new CentroidUserObject(n, 1))));
                    continue;
                }
                if (n == 2) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Significant Genes ", (IViewer)sAMCentroidViewer, new CentroidUserObject(n, 0))));
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Significant Genes ", (IViewer)sAMCentroidViewer, new CentroidUserObject(n, 1))));
                    continue;
                }
                if (n != 3) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)sAMCentroidViewer, new CentroidUserObject(n, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)sAMCentroidViewer, new CentroidUserObject(n, 1))));
            }
        } else {
            for (n = 0; n < this.clusters.length; ++n) {
                if (n == 0) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)sAMCentroidViewer, new CentroidUserObject(n, 0))));
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)sAMCentroidViewer, new CentroidUserObject(n, 1))));
                    continue;
                }
                if (n != 1) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)sAMCentroidViewer, new CentroidUserObject(n, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)sAMCentroidViewer, new CentroidUserObject(n, 1))));
            }
        }
        SAMCentroidsViewer sAMCentroidsViewer = new SAMCentroidsViewer(this.experiment, this.clusters, this.studyDesign, this.dValues, this.rValues, this.foldChangeArray, this.qLowestFDR, this.calculateQLowestFDR);
        sAMCentroidsViewer.setMeans(this.means.A);
        sAMCentroidsViewer.setVariances(this.variances.A);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)sAMCentroidsViewer, new Integer(0))));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)sAMCentroidsViewer, new Integer(1))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Input Parameters");
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("Computed Quantities");
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Study Design: " + generalInfo.getStudyDesign()));
        if (this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 6) {
            defaultMutableTreeNode3.add(this.getGroupAssignmentInfo(generalInfo.studyDesign));
        }
        if (generalInfo.studyDesign == 6) {
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Number of classes: " + generalInfo.numMultiClassGroups));
        }
        if (generalInfo.studyDesign == 7) {
            defaultMutableTreeNode3.add(this.getSampleSurvivalInfo());
        }
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Imputation Engine: " + generalInfo.imputationEngine));
        if (generalInfo.imputationEngine == "K-Nearest Neighbors") {
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Number of K-Nearest Neighbors: " + generalInfo.numNeighbors));
        }
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Delta: " + generalInfo.delta));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Upper Cutoff: " + generalInfo.upperCutoff));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Lower Cutoff: " + generalInfo.lowerCutoff));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Number of Permutations: " + generalInfo.numCombs));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Fold Change Criterion Used: " + generalInfo.useFoldChange));
        if (generalInfo.useFoldChange == "Yes") {
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Fold Change Value: " + generalInfo.foldChangeValue));
        }
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("HCL: " + generalInfo.getMethodName()));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode("Computed Exchangeability Factor s0: " + generalInfo.sNought));
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode("s0 Percentile: " + generalInfo.s0Percentile));
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode("Pi0Hat: " + generalInfo.pi0Hat));
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode("Num. False Sig. Genes (Median): " + generalInfo.numFalseSigMed));
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode("Num. False Sig. Genes (90th %ile): " + generalInfo.numFalseSig90th));
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode("False Discovery Rate (Median): " + generalInfo.FDRMedian + " %"));
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode("False Discovery Rate (90th %ile): " + generalInfo.FDR90th + " %"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode2.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private DefaultMutableTreeNode getSampleSurvivalInfo() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Sample information ");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Not in analysis ");
        for (int i = 0; i < this.inSurvivalAnalysis.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode((String)this.exptNamesVector.get(i));
            if (this.inSurvivalAnalysis[i]) {
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Time: " + this.survivalTimes[i]));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode("State: " + (this.censored[i] ? "Censored" : "Dead")));
                defaultMutableTreeNode.add(defaultMutableTreeNode3);
                continue;
            }
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        }
        if (defaultMutableTreeNode2.getChildCount() > 0) {
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getGroupAssignmentInfo(int n) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Group assigments ");
        if (n == 4) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Group A ");
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Group B ");
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("Neither group ");
            int n2 = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i)));
                    continue;
                }
                if (this.groupAssignments[i] == 2) {
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i)));
                    continue;
                }
                defaultMutableTreeNode4.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i)));
                ++n2;
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
            if (n2 > 0) {
                defaultMutableTreeNode.add(defaultMutableTreeNode4);
            }
        } else if (n == 5) {
            int n3;
            defaultMutableTreeNode = new DefaultMutableTreeNode("Pairings ");
            boolean[] blArray = new boolean[this.exptNamesVector.size()];
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = false;
            }
            DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode("Experiment Pairs");
            DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode("Unpaired Experiments");
            for (n3 = 0; n3 < this.pairedGroupAExpts.size(); ++n3) {
                int n4 = (Integer)this.pairedGroupAExpts.get(n3);
                int n5 = (Integer)this.pairedGroupBExpts.get(n3);
                defaultMutableTreeNode5.add(new DefaultMutableTreeNode("A: " + (String)this.exptNamesVector.get(n4) + " - B: " + (String)this.exptNamesVector.get(n5)));
                blArray[n4] = true;
                blArray[n5] = true;
            }
            for (n3 = 0; n3 < blArray.length; ++n3) {
                if (blArray[n3]) continue;
                defaultMutableTreeNode6.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(n3)));
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode5);
            if (!defaultMutableTreeNode6.isLeaf()) {
                defaultMutableTreeNode.add(defaultMutableTreeNode6);
            }
        } else if (n == 6) {
            int n6;
            DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode("Not in groups");
            DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[this.numMultiClassGroups];
            for (n6 = 0; n6 < this.numMultiClassGroups; ++n6) {
                defaultMutableTreeNodeArray[n6] = new DefaultMutableTreeNode("Group " + (n6 + 1));
            }
            for (n6 = 0; n6 < this.groupAssignments.length; ++n6) {
                int n7 = this.groupAssignments[n6];
                if (n7 == 0) {
                    defaultMutableTreeNode7.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(n6)));
                    continue;
                }
                defaultMutableTreeNodeArray[n7 - 1].add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(n6)));
            }
            for (n6 = 0; n6 < defaultMutableTreeNodeArray.length; ++n6) {
                defaultMutableTreeNode.add(defaultMutableTreeNodeArray[n6]);
            }
            if (defaultMutableTreeNode7.getChildCount() > 0) {
                defaultMutableTreeNode.add(defaultMutableTreeNode7);
            }
        }
        return defaultMutableTreeNode;
    }

    private class GeneralInfo {
        public int clusters;
        public String sigMethod;
        public String useFoldChange;
        public long time;
        private float delta;
        private float sNought;
        private float s0Percentile;
        private float pi0Hat;
        private float foldChangeValue;
        private float upperCutoff;
        private float lowerCutoff;
        private String numSigGenes;
        private String numFalseSigMed;
        private String numFalseSig90th;
        private String FDRMedian;
        private String FDR90th;
        private int studyDesign;
        private int numCombs;
        private String imputationEngine;
        private int numNeighbors;
        private int numMultiClassGroups;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }

        public String getStudyDesign() {
            String string = "None";
            if (this.studyDesign == 4) {
                string = "Two Class Unpaired";
            } else if (this.studyDesign == 5) {
                string = "Two Class Paired";
            } else if (this.studyDesign == 6) {
                string = "Multi Class";
            } else if (this.studyDesign == 7) {
                string = "Censored Survival";
            }
            return string;
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            switch (algorithmEvent.getId()) {
                case 1: {
                    SAMGUI.this.progress.setUnits(algorithmEvent.getIntValue());
                    SAMGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 2: {
                    SAMGUI.this.progress.setValue(algorithmEvent.getIntValue());
                    SAMGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 3: {
                    int n = algorithmEvent.getIntValue();
                    if (n != -1) break;
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                SAMGUI.this.algorithm.abort();
                SAMGUI.this.progress.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            SAMGUI.this.algorithm.abort();
            SAMGUI.this.progress.dispose();
        }
    }
}

