/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sam;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;

public class SAMGraphViewer
extends JPanel
implements IViewer {
    private double[] yArray;
    private double[] xArray;
    private double delta;
    int originX;
    int originY;
    int studyDesign;

    public SAMGraphViewer(double[] dArray, double[] dArray2, int n, double d) {
        this.yArray = dArray2;
        this.xArray = dArray;
        this.delta = d;
        this.studyDesign = n;
        this.setBackground(Color.white);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7) {
            this.paint1(graphics);
        } else if (this.studyDesign == 6) {
            this.paint2(graphics);
        }
    }

    private void paint1(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        this.originX = (int)Math.round((double)(this.getWidth() / 2));
        this.originY = (int)Math.round((double)(this.getHeight() / 2));
        double d = this.getMax(this.xArray);
        double d2 = this.getMax(this.yArray);
        double d3 = this.getMin(this.xArray);
        double d4 = this.getMin(this.yArray);
        double d5 = this.getXScalingFactor(d, d3);
        double d6 = this.getYScalingFactor(d2, d4);
        float[] fArray = new float[]{10.0f};
        BasicStroke basicStroke = new BasicStroke(2.0f, 0, 0, 10.0f, fArray, 0.0f);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.drawLine(0, (int)Math.round((double)(this.getHeight() / 2)), this.getWidth(), (int)Math.round((double)(this.getHeight() / 2)));
        graphics2D.drawLine((int)Math.round((double)(this.getWidth() / 2)), 0, (int)Math.round((double)(this.getWidth() / 2)), this.getHeight());
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        double d7 = 0.0;
        double d8 = 0.0;
        d7 = Math.abs(d) > Math.abs(d3) ? Math.abs(d / 5.0) : Math.abs(d3 / 5.0);
        d8 = Math.abs(d2) > Math.abs(d4) ? Math.abs(d2 / 5.0) : Math.abs(d4 / 5.0);
        double d9 = 0.0;
        double d10 = 0.0;
        for (n4 = 0; n4 < dArray.length; ++n4) {
            dArray[n4] = d9;
            d9 += d7;
            dArray2[n4] = d10;
            d10 += d8;
        }
        for (n4 = 1; n4 < dArray.length; ++n4) {
            graphics2D.drawLine((int)Math.round(dArray[n4] * d5) + this.getWidth() / 2, this.getHeight() / 2 - 5, (int)Math.round(dArray[n4] * d5) + this.getWidth() / 2, this.getHeight() / 2 + 5);
        }
        for (n4 = 1; n4 < dArray.length; ++n4) {
            graphics2D.drawLine(this.getWidth() / 2 - (int)Math.round(dArray[n4] * d5), this.getHeight() / 2 - 5, this.getWidth() / 2 - (int)Math.round(dArray[n4] * d5), this.getHeight() / 2 + 5);
        }
        graphics2D.drawLine(this.getWidth() / 2 - (int)Math.round(dArray[5] * d5), this.getHeight() / 2 + (int)Math.round(dArray[5] * d6), this.getWidth() / 2 + (int)Math.round(dArray[5] * d5), this.getHeight() / 2 - (int)Math.round(dArray[5] * d6));
        graphics2D.setColor(Color.gray);
        graphics2D.setStroke(new BasicStroke(1.0f));
        for (n4 = 1; n4 < dArray2.length; ++n4) {
            graphics2D.drawLine(0, this.getHeight() / 2 + (int)Math.round(dArray2[n4] * d6), this.getWidth(), this.getHeight() / 2 + (int)Math.round(dArray2[n4] * d6));
        }
        for (n4 = 1; n4 < dArray2.length; ++n4) {
            graphics2D.drawLine(0, this.getHeight() / 2 - (int)Math.round(dArray2[n4] * d6), this.getWidth(), this.getHeight() / 2 - (int)Math.round(dArray2[n4] * d6));
        }
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.setColor(Color.black);
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(2);
        for (n3 = 1; n3 < dArray.length; ++n3) {
            graphics2D.drawString(decimalFormat.format(dArray[n3]), (int)Math.round(dArray[n3] * d5) + this.getWidth() / 2 - 10, this.getHeight() / 2 + 20);
        }
        for (n3 = 1; n3 < dArray.length; ++n3) {
            graphics2D.drawString("-" + decimalFormat.format(dArray[n3]), this.getWidth() / 2 - (int)Math.round(dArray[n3] * d5) - 10, this.getHeight() / 2 + 20);
        }
        for (n3 = 1; n3 < dArray2.length; ++n3) {
            graphics2D.drawString(decimalFormat.format(dArray2[n3]), this.getWidth() / 2 - 30, this.getHeight() / 2 - (int)Math.round(dArray2[n3] * d6) - 5);
        }
        for (n3 = 1; n3 < dArray2.length; ++n3) {
            graphics2D.drawString("-" + decimalFormat.format(dArray2[n3]), this.getWidth() / 2 - 30, this.getHeight() / 2 + (int)Math.round(dArray2[n3] * d6) - 5);
        }
        n3 = (int)Math.round(this.delta * d6);
        graphics2D.setStroke(basicStroke);
        graphics2D.drawLine(this.getWidth() / 2 - (int)Math.round(dArray[5] * d5), this.getHeight() / 2 + (int)Math.round(dArray[5] * d6) - n3, this.getWidth() / 2 + (int)Math.round(dArray[5] * d5), this.getHeight() / 2 - (int)Math.round(dArray[5] * d6) - n3);
        graphics2D.drawLine(this.getWidth() / 2 - (int)Math.round(dArray[5] * d5), this.getHeight() / 2 + (int)Math.round(dArray[5] * d6) + n3, this.getWidth() / 2 + (int)Math.round(dArray[5] * d5), this.getHeight() / 2 - (int)Math.round(dArray[5] * d6) + n3);
        graphics2D.setStroke(new BasicStroke(2.0f));
        boolean bl = false;
        boolean bl2 = false;
        int n7 = 0;
        int n8 = 0;
        for (n2 = 0; n2 < this.xArray.length; ++n2) {
            if (!(this.xArray[n2] > 0.0) || !(this.yArray[n2] - this.xArray[n2] > this.delta)) continue;
            n7 = n2;
            bl = true;
            break;
        }
        for (n2 = 0; n2 < this.xArray.length; ++n2) {
            if (!(this.xArray[n2] < 0.0) || !(this.xArray[n2] - this.yArray[n2] > this.delta)) continue;
            n8 = n2;
            bl2 = true;
        }
        Color[] colorArray = new Color[this.xArray.length];
        if (bl && bl2) {
            for (n = 0; n < n8 + 1; ++n) {
                colorArray[n] = Color.green.darker();
            }
            for (n = n8 + 1; n < n7; ++n) {
                colorArray[n] = Color.black;
            }
            for (n = n7; n < this.xArray.length; ++n) {
                colorArray[n] = Color.red;
            }
        } else if (bl && !bl2) {
            for (n = 0; n < n7; ++n) {
                colorArray[n] = Color.black;
            }
            for (n = n7; n < this.xArray.length; ++n) {
                colorArray[n] = Color.red;
            }
        } else if (!bl && bl2) {
            for (n = 0; n < n8 + 1; ++n) {
                colorArray[n] = Color.green.darker();
            }
            for (n = n8 + 1; n < this.xArray.length; ++n) {
                colorArray[n] = Color.black;
            }
        } else if (!bl && !bl2) {
            for (n = 0; n < this.xArray.length; ++n) {
                colorArray[n] = Color.black;
            }
        }
        for (n = 0; n < this.xArray.length; ++n) {
            graphics2D.setColor(colorArray[n]);
            this.drawPoint(graphics2D, this.xArray[n], this.yArray[n], this.getXScalingFactor(d, d3), this.getYScalingFactor(d2, d4), 5);
            graphics2D.setColor(Color.black);
        }
        graphics2D.drawString("X axis = Expected, Y axis = Observed", this.getWidth() / 2 + 25, this.getHeight() - 25);
    }

    private void paint2(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        this.originX = 30;
        this.originY = (int)Math.round((double)(this.getHeight() - 30));
        double d = this.getMax(this.xArray);
        double d2 = this.getMax(this.yArray);
        double d3 = this.getMin(this.xArray);
        double d4 = this.getMin(this.yArray);
        double d5 = this.getXScalingFactor(d, d3);
        double d6 = this.getYScalingFactor(d2, d4);
        float[] fArray = new float[]{10.0f};
        BasicStroke basicStroke = new BasicStroke(2.0f, 0, 0, 10.0f, fArray, 0.0f);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.drawLine(0, (int)Math.round((double)(this.getHeight() - 30)), this.getWidth(), (int)Math.round((double)(this.getHeight() - 30)));
        graphics2D.drawLine(30, 0, 30, this.getHeight());
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        double d7 = 0.0;
        double d8 = 0.0;
        d7 = Math.abs(d) > Math.abs(d3) ? Math.abs(d / 5.0) : Math.abs(d3 / 5.0);
        d8 = Math.abs(d2) > Math.abs(d4) ? Math.abs(d2 / 5.0) : Math.abs(d4 / 5.0);
        double d9 = 0.0;
        double d10 = 0.0;
        for (n4 = 0; n4 < dArray.length; ++n4) {
            dArray[n4] = d9;
            d9 += d7;
            dArray2[n4] = d10;
            d10 += d8;
        }
        for (n4 = 1; n4 < dArray.length; ++n4) {
            graphics2D.drawLine((int)Math.round(dArray[n4] * d5) + 30, this.getHeight() - 30 - 5, (int)Math.round(dArray[n4] * d5) + 30, this.getHeight() - 30 + 5);
        }
        graphics2D.drawLine(30, this.getHeight() - 30, 30 + (int)Math.round(dArray[5] * d5), this.getHeight() - 30 - (int)Math.round(dArray[5] * d6));
        graphics2D.setColor(Color.gray);
        graphics2D.setStroke(new BasicStroke(1.0f));
        for (n4 = 1; n4 < dArray2.length; ++n4) {
            graphics2D.drawLine(0, this.getHeight() - 30 - (int)Math.round(dArray2[n4] * d6), this.getWidth(), this.getHeight() - 30 - (int)Math.round(dArray2[n4] * d6));
        }
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.setColor(Color.black);
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(2);
        for (n3 = 1; n3 < dArray.length; ++n3) {
            graphics2D.drawString(decimalFormat.format(dArray[n3]), (int)Math.round(dArray[n3] * d5) + 10, this.getHeight() - 5);
        }
        for (n3 = 1; n3 < dArray2.length; ++n3) {
            graphics2D.drawString(decimalFormat.format(dArray2[n3]), 5, this.getHeight() - 30 - (int)Math.round(dArray2[n3] * d6) - 5);
        }
        n3 = (int)Math.round(this.delta * d6);
        graphics2D.setStroke(basicStroke);
        graphics2D.drawLine(30, this.getHeight() - 30 - n3, 30 + (int)Math.round(dArray[5] * d5), this.getHeight() - 30 - (int)Math.round(dArray[5] * d6) - n3);
        graphics2D.drawLine(30, this.getHeight() - 30 + n3, 30 + (int)Math.round(dArray[5] * d5), this.getHeight() - 30 - (int)Math.round(dArray[5] * d6) + n3);
        graphics2D.setStroke(new BasicStroke(2.0f));
        boolean bl = false;
        boolean bl2 = false;
        int n7 = 0;
        int n8 = 0;
        for (n2 = 0; n2 < this.xArray.length; ++n2) {
            if (!(this.xArray[n2] > 0.0) || !(this.yArray[n2] - this.xArray[n2] > this.delta)) continue;
            n7 = n2;
            bl = true;
            break;
        }
        for (n2 = 0; n2 < this.xArray.length; ++n2) {
            if (!(this.xArray[n2] < 0.0) || !(this.xArray[n2] - this.yArray[n2] > this.delta)) continue;
            n8 = n2;
            bl2 = true;
        }
        Color[] colorArray = new Color[this.xArray.length];
        if (bl && bl2) {
            for (n = 0; n < n8 + 1; ++n) {
                colorArray[n] = Color.green.darker();
            }
            for (n = n8 + 1; n < n7; ++n) {
                colorArray[n] = Color.black;
            }
            for (n = n7; n < this.xArray.length; ++n) {
                colorArray[n] = Color.red;
            }
        } else if (bl && !bl2) {
            for (n = 0; n < n7; ++n) {
                colorArray[n] = Color.black;
            }
            for (n = n7; n < this.xArray.length; ++n) {
                colorArray[n] = Color.red;
            }
        } else if (!bl && bl2) {
            for (n = 0; n < n8 + 1; ++n) {
                colorArray[n] = Color.green.darker();
            }
            for (n = n8 + 1; n < this.xArray.length; ++n) {
                colorArray[n] = Color.black;
            }
        } else if (!bl && !bl2) {
            for (n = 0; n < this.xArray.length; ++n) {
                colorArray[n] = Color.black;
            }
        }
        for (n = 0; n < this.xArray.length; ++n) {
            graphics2D.setColor(colorArray[n]);
            this.drawPoint(graphics2D, this.xArray[n], this.yArray[n], this.getXScalingFactor(d, d3), this.getYScalingFactor(d2, d4), 5);
            graphics2D.setColor(Color.black);
        }
        graphics2D.drawString("X axis = Expected, Y axis = Observed", 40, 20);
    }

    private void drawPoint(Graphics2D graphics2D, double d, double d2, double d3, double d4, int n) {
        int n2 = (int)Math.round(d * d3);
        int n3 = (int)Math.round(d2 * d4);
        int n4 = 0;
        int n5 = 0;
        if (this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7) {
            n4 = (int)Math.round((double)(this.getWidth() / 2)) + n2;
            n5 = (int)Math.round((double)(this.getHeight() / 2)) - n3;
        } else if (this.studyDesign == 6) {
            n4 = 30 + n2;
            n5 = (int)Math.round((double)(this.getHeight() - 30)) - n3;
        }
        graphics2D.fillOval(n4, n5, n, n);
    }

    private double getMax(double[] dArray) {
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(d < dArray[i])) continue;
            d = dArray[i];
        }
        return d;
    }

    private double getMin(double[] dArray) {
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(d > dArray[i])) continue;
            d = dArray[i];
        }
        return d;
    }

    private double getXScalingFactor(double d, double d2) {
        double d3 = 1.0;
        if (d > 0.0 && d2 > 0.0) {
            d3 = d;
        } else if (d > 0.0 && d2 < 0.0) {
            d3 = d > Math.abs(d2) ? d : Math.abs(d2);
        } else if (d <= 0.0) {
            d3 = Math.abs(d2);
        } else if (d2 == 0.0) {
            d3 = d;
        }
        double d4 = 0.0;
        if (this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7) {
            d4 = (double)(this.getWidth() / 2 - 50) / d3;
        } else if (this.studyDesign == 6) {
            d4 = (double)(this.getWidth() - 50 - 30) / d3;
        }
        return d4;
    }

    private double getYScalingFactor(double d, double d2) {
        double d3 = 1.0;
        if (d > 0.0 && d2 > 0.0) {
            d3 = d;
        } else if (d > 0.0 && d2 < 0.0) {
            d3 = d > Math.abs(d2) ? d : Math.abs(d2);
        } else if (d <= 0.0) {
            d3 = Math.abs(d2);
        } else if (d2 == 0.0) {
            d3 = d;
        }
        double d4 = 0.0;
        if (this.studyDesign == 4 || this.studyDesign == 5 || this.studyDesign == 7) {
            d4 = (double)(this.getHeight() / 2 - 50) / d3;
        } else if (this.studyDesign == 6) {
            d4 = (double)(this.getHeight() - 30 - 50) / d3;
        }
        return d4;
    }

    public void onDeselected() {
    }

    public void onDataChanged(IData iData) {
    }

    public void onClosed() {
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onSelected(IFramework iFramework) {
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
    }

    public JComponent getHeaderComponent() {
        return null;
    }
}

