/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentHeader;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class SVMDiscriminantExperimentViewer
extends JPanel
implements IViewer {
    private int numRetainedPos;
    private int numRecruitedNeg;
    private Color RecruitColor = Color.red;
    private boolean classifyGenes = true;
    private ExperimentHeader header;
    private Experiment experiment;
    private IFramework framework;
    private IData data;
    protected int clusterIndex;
    private int[][] clusters;
    private float[][] discriminants;
    protected int[] samplesOrder;
    protected Dimension elementSize = new Dimension(20, 5);
    protected int labelIndex = -1;
    protected boolean isAntiAliasing = true;
    protected boolean isDrawBorders = true;
    protected boolean isDrawAnnotations = true;
    public static Color missingColor = new Color(128, 128, 128);
    public static Color maskColor = new Color(255, 255, 255, 128);
    private float maxValue = 3.0f;
    private float minValue = -3.0f;
    protected int firstSelectedRow = -1;
    protected int lastSelectedRow = -1;
    public BufferedImage posColorImage = this.createGradientImage(Color.red, Color.black);
    public BufferedImage negColorImage = this.createGradientImage(Color.black, Color.green);
    private int annotationWidth;
    private Insets insets = new Insets(0, 10, 0, 0);
    private static final int RECT_HEIGHT = 15;
    private static final float INITIAL_MAX_VALUE = 3.0f;
    private static final float INITIAL_MIN_VALUE = -3.0f;
    private static final String NO_GENES_STR = "No Genes in Cluster!";
    private static final String NO_EXPERIMENTS_STR = "No Experiments In Cluster!";
    private static final Font ERROR_FONT = new Font("monospaced", 1, 20);
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    private boolean haveColorBar;
    private JPopupMenu popup;

    public SVMDiscriminantExperimentViewer(Experiment experiment, int[][] nArray, int n, int n2, float[][] fArray, int[] nArray2, boolean bl) {
        if (experiment == null) {
            throw new IllegalArgumentException("experiment == null");
        }
        this.experiment = experiment;
        this.clusters = nArray == null ? SVMDiscriminantExperimentViewer.defGenesOrder(experiment.getNumberOfGenes()) : nArray;
        this.discriminants = fArray;
        this.samplesOrder = nArray2 == null ? SVMDiscriminantExperimentViewer.defSamplesOrder(experiment.getNumberOfSamples()) : nArray2;
        this.classifyGenes = bl;
        this.isDrawAnnotations = true;
        this.header = new ExperimentHeader(this.experiment, this.clusters, this.samplesOrder);
        this.setBackground(Color.white);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        SVMExperimentActionListener sVMExperimentActionListener = new SVMExperimentActionListener();
        this.addMouseListener(sVMExperimentActionListener);
        this.popup = this.createJPopupMenu(sVMExperimentActionListener);
        this.numRetainedPos = n;
        this.numRecruitedNeg = n2;
    }

    private JPopupMenu createJPopupMenu(SVMExperimentActionListener sVMExperimentActionListener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, sVMExperimentActionListener);
        return jPopupMenu;
    }

    protected void addMenuItems(JPopupMenu jPopupMenu, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem("Store cluster", GUIFactory.getIcon("new16.gif"));
        jMenuItem.setActionCommand(STORE_CLUSTER_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("analysis16.gif"));
        jMenuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Delete public cluster", GUIFactory.getIcon("delete16.gif"));
        jMenuItem.setActionCommand(SET_DEF_COLOR_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
        jMenuItem.setActionCommand(SAVE_CLUSTER_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save all clusters...", GUIFactory.getIcon("save16.gif"));
        jMenuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
    }

    private static int[] defSamplesOrder(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private static int[][] defGenesOrder(int n) {
        int[][] nArray = new int[1][n];
        for (int i = 0; i < nArray[0].length; ++i) {
            nArray[0][i] = i;
        }
        return nArray;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return null;
    }

    public BufferedImage getPosColorImage() {
        return this.posColorImage;
    }

    public BufferedImage getNegColorImage() {
        return this.negColorImage;
    }

    public Color getMissingColor() {
        return missingColor;
    }

    public void selectRows(int n, int n2) {
        this.firstSelectedRow = n;
        this.lastSelectedRow = n2;
        this.repaint();
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.data = iFramework.getData();
        IDisplayMenu iDisplayMenu = iFramework.getDisplayMenu();
        Integer n = (Integer)iFramework.getUserObject();
        this.setClusterIndex(n == null ? 0 : n);
        this.labelIndex = iDisplayMenu.getLabelIndex();
        this.maxValue = Math.abs(iDisplayMenu.getMaxRatioScale());
        this.minValue = -Math.abs(iDisplayMenu.getMinRatioScale());
        this.setElementSize(iDisplayMenu.getElementSize());
        this.setAntialiasing(iDisplayMenu.isAntiAliasing());
        this.setDrawBorders(iDisplayMenu.isDrawingBorder());
        this.updateSize();
        this.header.setData(this.data);
        this.onMenuChanged(iDisplayMenu);
        this.header.setValues(this.minValue, this.maxValue);
        this.header.setAntiAliasing(iDisplayMenu.isAntiAliasing());
        this.header.updateSizes(this.getSize().width, this.elementSize.width);
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.setDrawBorders(iDisplayMenu.isDrawingBorder());
        this.maxValue = Math.abs(iDisplayMenu.getMaxRatioScale());
        this.minValue = -Math.abs(iDisplayMenu.getMinRatioScale());
        this.negColorImage = iDisplayMenu.getNegativeGradientImage();
        this.posColorImage = iDisplayMenu.getPositiveGradientImage();
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.header.setValues(this.minValue, this.maxValue);
        if (this.elementSize.equals(iDisplayMenu.getElementSize()) && this.labelIndex == iDisplayMenu.getLabelIndex() && this.isAntiAliasing == iDisplayMenu.isAntiAliasing()) {
            return;
        }
        this.setElementSize(iDisplayMenu.getElementSize());
        this.setAntialiasing(iDisplayMenu.isAntiAliasing());
        this.labelIndex = iDisplayMenu.getLabelIndex();
        this.haveColorBar = this.areProbesColored();
        this.updateSize();
        this.header.setAntiAliasing(iDisplayMenu.isAntiAliasing());
        this.header.updateSizes(this.getSize().width, this.elementSize.width);
    }

    public void onDataChanged(IData iData) {
        this.data = iData;
        this.haveColorBar = this.areProbesColored();
        this.header.setData(iData);
        System.out.println("Data changed, p colored? =" + this.haveColorBar);
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public void setClusterIndex(int n) {
        this.clusterIndex = n;
    }

    public int getClusterIndex() {
        return this.clusterIndex;
    }

    public int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    public int[][] getClusters() {
        return this.clusters;
    }

    protected int getMultipleArrayDataRow(int n) {
        return this.experiment.getGeneIndexMappedToData(this.clusters[this.clusterIndex][n]);
    }

    private int[] getIDataRowIndices(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.getMultipleArrayDataRow(i);
        }
        return nArray2;
    }

    protected int getExperimentRow(int n) {
        return this.clusters[this.clusterIndex][n];
    }

    private int getColumn(int n) {
        return this.samplesOrder[n];
    }

    protected Experiment getExperiment() {
        return this.experiment;
    }

    protected IData getData() {
        return this.data;
    }

    public void launchNewSession() {
        this.framework.launchNewMAV(this.getIDataRowIndices(this.getCluster()), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
    }

    public void setClusterColor(Color color) {
        if (color == null) {
            this.framework.removeCluster(this.getIDataRowIndices(this.getCluster()), this.experiment, 0);
        }
    }

    public void storeCluster() {
        this.framework.storeCluster(this.getIDataRowIndices(this.getCluster()), this.experiment, 0);
        this.onDataChanged(this.data);
        this.updateSize();
    }

    public void saveClusters(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent(this) : frame;
        ExperimentUtil.saveExperiment(frame, this.getExperiment(), this.getData(), this.getClusters());
    }

    public void saveCluster(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent(this) : frame;
        ExperimentUtil.saveExperiment(frame, this.getExperiment(), this.getData(), this.getCluster());
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveClusters(frame);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveCluster(frame);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSetColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color color = JColorChooser.showDialog(frame, "Choose color", CentroidViewer.DEF_CLUSTER_COLOR);
        if (color != null) {
            this.setClusterColor(color);
        }
    }

    private void setElementSize(Dimension dimension) {
        this.elementSize = new Dimension(dimension);
    }

    private void setAntialiasing(boolean bl) {
        this.isAntiAliasing = bl;
    }

    private void setDrawBorders(boolean bl) {
        this.isDrawBorders = bl;
    }

    public BufferedImage createGradientImage(Color color, Color color2) {
        BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 255.0f, 0.0f, color2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.drawRect(0, 0, 255, 1);
        return bufferedImage;
    }

    protected boolean areProbesColored() {
        int[] nArray = this.getCluster();
        for (int i = 0; i < nArray.length; ++i) {
            if (this.data.getProbeColor(this.getMultipleArrayDataRow(i)) == null) continue;
            return true;
        }
        return false;
    }

    private void updateSize() {
        if (this.clusters == null || this.getCluster().length == 0) {
            this.setFont(ERROR_FONT);
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = fontMetrics.stringWidth(NO_GENES_STR) + 10;
            int n2 = fontMetrics.getHeight() + 30;
            this.setSize(n, n2);
            this.setPreferredSize(new Dimension(n, n2));
            return;
        }
        this.setFont(new Font("monospaced", 0, this.elementSize.height));
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        int n = this.elementSize.width * this.samplesOrder.length;
        if (this.isDrawAnnotations) {
            this.annotationWidth = this.getMaxWidth(graphics2D);
            n += 20 + this.annotationWidth;
        }
        if (this.haveColorBar) {
            n += this.elementSize.width + 10;
        }
        int n3 = this.elementSize.height * this.getCluster().length + 1;
        this.setSize(n, n3);
        this.setPreferredSize(new Dimension(n, n3));
    }

    private int getMaxWidth(Graphics2D graphics2D) {
        if (graphics2D == null || this.data == null || this.getCluster() == null) {
            return 0;
        }
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = 0;
        for (int i = 0; i < this.getCluster().length; ++i) {
            String string = this.data.getElementAttribute(this.getMultipleArrayDataRow(i), this.labelIndex);
            n = Math.max(n, fontMetrics.stringWidth(string));
        }
        return n;
    }

    private Color getColor(float f) {
        if (Float.isNaN(f)) {
            return missingColor;
        }
        float f2 = f < 0.0f ? this.minValue : this.maxValue;
        int n = (int)(255.0f * f / f2);
        n = n > 255 ? 255 : n;
        int n2 = f < 0.0f ? this.negColorImage.getRGB(255 - n, 0) : this.posColorImage.getRGB(n, 0);
        return new Color(n2);
    }

    private void onSetDefaultColor() {
        this.setClusterColor(null);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        super.paint(graphics);
        if (this.data == null) {
            return;
        }
        this.setBackground(Color.white);
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMinimumFractionDigits(4);
        decimalFormat.setMaximumFractionDigits(4);
        decimalFormat.setPositivePrefix("+");
        int n3 = this.samplesOrder.length;
        if (this.clusters == null || this.getCluster().length == 0) {
            graphics.setColor(new Color(0, 0, 128));
            graphics.setFont(ERROR_FONT);
            graphics.drawString(NO_GENES_STR, 10, 30);
            return;
        }
        if (this.samplesOrder.length == 0) {
            graphics.setColor(new Color(0, 0, 128));
            graphics.setFont(ERROR_FONT);
            graphics.drawString(NO_EXPERIMENTS_STR, 10, 30);
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        int n4 = this.getTopIndex(rectangle.y);
        int n5 = this.getBottomIndex(rectangle.y + rectangle.height, this.getCluster().length);
        int n6 = this.getLeftIndex(rectangle.x);
        int n7 = this.getRightIndex(rectangle.x + rectangle.width, n3);
        for (n2 = n6; n2 < n7; ++n2) {
            for (n = n4; n < n5; ++n) {
                this.fillRectAt(graphics, n, n2);
            }
        }
        if (this.haveColorBar) {
            for (n2 = n4; n2 < n5; ++n2) {
                this.fillClusterRectAt(graphics, n2, n3 * this.elementSize.width + 5);
            }
        }
        if (this.isDrawAnnotations) {
            if (this.isAntiAliasing) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (n7 >= n3) {
                String string = "";
                graphics.setColor(Color.black);
                int n8 = this.clusterIndex == 0 ? this.numRetainedPos : this.numRecruitedNeg;
                n = this.elementSize.width * n3 + 10;
                for (int i = n4; i < n5; ++i) {
                    if (this.labelIndex >= 0) {
                        if (this.classifyGenes && (this.clusterIndex == 0 && i >= n8 || this.clusterIndex == 1 && i < n8)) {
                            graphics.setColor(this.RecruitColor);
                        } else {
                            graphics.setColor(Color.black);
                        }
                        string = this.data.getElementAttribute(this.getMultipleArrayDataRow(i), this.labelIndex);
                    }
                    int n9 = (i + 1) * this.elementSize.height;
                    if (this.discriminants.length >= this.getCluster().length) {
                        graphics.drawString(decimalFormat.format(this.discriminants[this.clusterIndex][i]) + "   " + string, n + this.insets.left, n9);
                        continue;
                    }
                    graphics.drawString(string, n + this.insets.left, n9);
                }
            }
        }
        graphics.setColor(Color.black);
    }

    private void fillRectAt(Graphics graphics, int n, int n2) {
        int n3 = n2 * this.elementSize.width + this.insets.left;
        int n4 = n * this.elementSize.height;
        boolean bl = this.firstSelectedRow >= 0 && this.lastSelectedRow >= 0 && (n < this.firstSelectedRow || n > this.lastSelectedRow);
        graphics.setColor(this.getColor(this.experiment.get(this.getExperimentRow(n), this.getColumn(n2))));
        graphics.fillRect(n3, n4, this.elementSize.width, this.elementSize.height);
        if (bl) {
            graphics.setColor(maskColor);
            graphics.fillRect(n3, n4, this.elementSize.width, this.elementSize.height);
        }
        if (this.isDrawBorders) {
            graphics.setColor(Color.black);
            graphics.drawRect(n3, n4, this.elementSize.width - 1, this.elementSize.height - 1);
        }
    }

    private void drawRectAt(Graphics graphics, int n, int n2, Color color) {
        graphics.setColor(color);
        graphics.drawRect(n2 * this.elementSize.width + this.insets.left, n * this.elementSize.height, this.elementSize.width - 1, this.elementSize.height - 1);
    }

    private void fillClusterRectAt(Graphics graphics, int n, int n2) {
        Color color = this.data.getProbeColor(this.getMultipleArrayDataRow(n));
        if (color == null) {
            color = Color.white;
        }
        graphics.setColor(color);
        graphics.fillRect(n2 + this.insets.left, n * this.elementSize.height, this.elementSize.width - 1, this.elementSize.height);
    }

    private int getTopIndex(int n) {
        if (n < 0) {
            return 0;
        }
        return n / this.elementSize.height;
    }

    private int getLeftIndex(int n) {
        if (n < this.insets.left) {
            return 0;
        }
        return (n - this.insets.left) / this.elementSize.width;
    }

    private int getRightIndex(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = n / this.elementSize.width + 1;
        return n3 > n2 ? n2 : n3;
    }

    private int getBottomIndex(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = n / this.elementSize.height + 1;
        return n3 > n2 ? n2 : n3;
    }

    private int findColumn(int n) {
        int n2 = this.samplesOrder.length * this.elementSize.width;
        if (n >= n2 + this.insets.left || n < this.insets.left) {
            return -1;
        }
        return (n - this.insets.left) / this.elementSize.width;
    }

    private int findRow(int n) {
        int n2 = this.getCluster().length * this.elementSize.height;
        if (n >= n2 || n < 0) {
            return -1;
        }
        return n / this.elementSize.height;
    }

    private boolean isLegalPosition(int n, int n2) {
        return this.isLegalRow(n) && this.isLegalColumn(n2);
    }

    private boolean isLegalColumn(int n) {
        return n >= 0 && n <= this.samplesOrder.length - 1;
    }

    private boolean isLegalRow(int n) {
        return n >= 0 && n <= this.getCluster().length - 1;
    }

    private class SVMExperimentActionListener
    extends MouseAdapter
    implements ActionListener {
        private SVMExperimentActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(SVMDiscriminantExperimentViewer.SAVE_CLUSTER_CMD)) {
                SVMDiscriminantExperimentViewer.this.onSaveCluster();
            } else if (string.equals(SVMDiscriminantExperimentViewer.SAVE_ALL_CLUSTERS_CMD)) {
                SVMDiscriminantExperimentViewer.this.onSaveClusters();
            } else if (string.equals(SVMDiscriminantExperimentViewer.SET_DEF_COLOR_CMD)) {
                SVMDiscriminantExperimentViewer.this.onSetDefaultColor();
            } else if (string.equals(SVMDiscriminantExperimentViewer.STORE_CLUSTER_CMD)) {
                SVMDiscriminantExperimentViewer.this.storeCluster();
            } else if (string.equals(SVMDiscriminantExperimentViewer.LAUNCH_NEW_SESSION_CMD)) {
                SVMDiscriminantExperimentViewer.this.launchNewSession();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() || SVMDiscriminantExperimentViewer.this.getCluster() == null || SVMDiscriminantExperimentViewer.this.getCluster().length == 0) {
                return;
            }
            SVMDiscriminantExperimentViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class Listener
    extends MouseAdapter
    implements MouseMotionListener {
        private String oldStatusText;
        private int oldRow = -1;
        private int oldColumn = -1;

        private Listener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            int n = SVMDiscriminantExperimentViewer.this.findColumn(mouseEvent.getX());
            int n2 = SVMDiscriminantExperimentViewer.this.findRow(mouseEvent.getY());
            if (!SVMDiscriminantExperimentViewer.this.isLegalPosition(n2, n)) {
                return;
            }
            if (mouseEvent.isControlDown()) {
                SVMDiscriminantExperimentViewer.this.framework.displaySingleArrayViewer(SVMDiscriminantExperimentViewer.this.experiment.getSampleIndex(SVMDiscriminantExperimentViewer.this.getColumn(n)));
                return;
            }
            if (!mouseEvent.isShiftDown()) {
                SVMDiscriminantExperimentViewer.this.framework.displaySlideElementInfo(SVMDiscriminantExperimentViewer.this.experiment.getSampleIndex(SVMDiscriminantExperimentViewer.this.getColumn(n)), SVMDiscriminantExperimentViewer.this.getMultipleArrayDataRow(n2));
                return;
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (SVMDiscriminantExperimentViewer.this.experiment.getNumberOfSamples() == 0 || mouseEvent.isShiftDown()) {
                return;
            }
            int n = SVMDiscriminantExperimentViewer.this.findColumn(mouseEvent.getX());
            int n2 = SVMDiscriminantExperimentViewer.this.findRow(mouseEvent.getY());
            if (this.isCurrentPosition(n2, n)) {
                return;
            }
            Graphics graphics = null;
            if (SVMDiscriminantExperimentViewer.this.isLegalPosition(n2, n)) {
                graphics = SVMDiscriminantExperimentViewer.this.getGraphics();
                SVMDiscriminantExperimentViewer.this.drawRectAt(graphics, n2, n, Color.white);
                SVMDiscriminantExperimentViewer.this.framework.setStatusText("Gene: " + SVMDiscriminantExperimentViewer.this.data.getUniqueId(SVMDiscriminantExperimentViewer.this.getMultipleArrayDataRow(n2)) + " Sample: " + SVMDiscriminantExperimentViewer.this.data.getSampleName(SVMDiscriminantExperimentViewer.this.experiment.getSampleIndex(SVMDiscriminantExperimentViewer.this.getColumn(n))) + " Value: " + SVMDiscriminantExperimentViewer.this.experiment.get(SVMDiscriminantExperimentViewer.this.getExperimentRow(n2), SVMDiscriminantExperimentViewer.this.getColumn(n)));
            } else {
                SVMDiscriminantExperimentViewer.this.framework.setStatusText(this.oldStatusText);
            }
            if (SVMDiscriminantExperimentViewer.this.isLegalPosition(this.oldRow, this.oldColumn)) {
                graphics = graphics != null ? graphics : SVMDiscriminantExperimentViewer.this.getGraphics();
                SVMDiscriminantExperimentViewer.this.fillRectAt(graphics, this.oldRow, this.oldColumn);
            }
            this.setOldPosition(n2, n);
            if (graphics != null) {
                graphics.dispose();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.oldStatusText = SVMDiscriminantExperimentViewer.this.framework.getStatusText();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (SVMDiscriminantExperimentViewer.this.isLegalPosition(this.oldRow, this.oldColumn)) {
                Graphics graphics = SVMDiscriminantExperimentViewer.this.getGraphics();
                SVMDiscriminantExperimentViewer.this.fillRectAt(graphics, this.oldRow, this.oldColumn);
                graphics.dispose();
            }
            this.setOldPosition(-1, -1);
            SVMDiscriminantExperimentViewer.this.framework.setStatusText(this.oldStatusText);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        private void setOldPosition(int n, int n2) {
            this.oldColumn = n2;
            this.oldRow = n;
        }

        private boolean isCurrentPosition(int n, int n2) {
            return n == this.oldRow && n2 == this.oldColumn;
        }
    }
}

