/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.file.AffymetrixFileLoader;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.GenePixFileLoader;
import org.tigr.microarray.mev.file.MevFileLoader;
import org.tigr.microarray.mev.file.StanfordFileLoader;
import org.tigr.microarray.mev.file.TavFileLoader;

public class SuperExpressionFileLoader {
    private ClassLoader cl = this.getClass().getClassLoader();
    public static ImageIcon ICON_COMPUTER;
    public static ImageIcon ICON_DISK;
    public static ImageIcon ICON_FOLDER;
    public static ImageIcon ICON_EXPANDEDFOLDER;
    protected ExpressionFileLoader[] fileLoaders;
    protected ExpressionFileLoader selectedFileLoader;
    protected FileFilter[] fileFilters;
    protected FileFilter selectedFileFilter;
    protected JFrame mainFrame;
    protected JPanel fileFilterPanel;
    protected JLabel fileFilterLabel;
    protected JComboBox fileFilterComboBox;
    protected JPanel fileLoaderPanel;
    protected JButton infoButton;
    protected JButton cancelButton;
    protected JButton loadButton;
    protected JPanel buttonPanel;
    protected JPanel selectionPanel;
    protected JSplitPane mainSplitPane;
    protected GBA gba;
    protected EventListener eventListener;
    protected MultipleArrayViewer viewer;
    protected BluejayDObjectList dlist;
    protected Loader loader;
    protected int loaderIndex = 0;

    public SuperExpressionFileLoader(boolean bl) {
        ICON_COMPUTER = new ImageIcon(this.cl.getResource("org/tigr/images/PCIcon.gif"));
        ICON_DISK = new ImageIcon(this.cl.getResource("org/tigr/images/disk.gif"));
        ICON_FOLDER = new ImageIcon(this.cl.getResource("org/tigr/images/Directory.gif"));
        ICON_EXPANDEDFOLDER = new ImageIcon(this.cl.getResource("org/tigr/images/expandedfolder.gif"));
        this.loader = new Loader();
        this.initializeFileLoaders();
    }

    public SuperExpressionFileLoader(MultipleArrayViewer multipleArrayViewer) {
        ICON_COMPUTER = new ImageIcon(this.cl.getResource("org/tigr/images/PCIcon.gif"));
        ICON_DISK = new ImageIcon(this.cl.getResource("org/tigr/images/disk.gif"));
        ICON_FOLDER = new ImageIcon(this.cl.getResource("org/tigr/images/Directory.gif"));
        ICON_EXPANDEDFOLDER = new ImageIcon(this.cl.getResource("org/tigr/images/expandedfolder.gif"));
        System.out.println(ICON_COMPUTER);
        System.out.println(ICON_DISK);
        System.out.println(ICON_FOLDER);
        System.out.println(ICON_EXPANDEDFOLDER);
        this.viewer = multipleArrayViewer;
        this.loader = new Loader();
        this.initializeFileLoaders();
        this.initializeGUI();
    }

    public SuperExpressionFileLoader() {
        ICON_COMPUTER = new ImageIcon(this.cl.getResource("org/tigr/images/PCIcon.gif"));
        ICON_DISK = new ImageIcon(this.cl.getResource("org/tigr/images/disk.gif"));
        ICON_FOLDER = new ImageIcon(this.cl.getResource("org/tigr/images/Directory.gif"));
        ICON_EXPANDEDFOLDER = new ImageIcon(this.cl.getResource("org/tigr/images/expandedfolder.gif"));
        this.loader = new Loader();
        this.initializeFileLoaders();
        this.initializeGUI();
    }

    protected void initializeFileLoaders() {
        int n = 0;
        this.fileLoaders = new ExpressionFileLoader[5];
        this.fileLoaders[0] = new MevFileLoader(this);
        this.fileLoaders[1] = new StanfordFileLoader(this);
        this.fileLoaders[2] = new TavFileLoader(this);
        this.fileLoaders[3] = new AffymetrixFileLoader(this);
        this.fileLoaders[4] = new GenePixFileLoader(this);
        this.selectedFileLoader = this.fileLoaders[n];
        this.fileFilters = new FileFilter[this.fileLoaders.length];
        for (int i = 0; i < this.fileLoaders.length; ++i) {
            this.fileFilters[i] = this.fileLoaders[i].getFileFilter();
        }
        this.selectedFileFilter = this.fileFilters[n];
    }

    public void initializeGUI() {
        this.gba = new GBA();
        this.eventListener = new EventListener();
        this.mainFrame = new JFrame("Expression File Loader");
        this.mainFrame.getContentPane().setLayout(new GridBagLayout());
        this.fileFilterLabel = new JLabel("Load expression files of type:");
        this.fileFilterComboBox = new JComboBox();
        this.addFileFilters(this.fileFilters);
        this.fileFilterComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SuperExpressionFileLoader.this.changeSelectedFileFilterAndLoader(SuperExpressionFileLoader.this.fileFilterComboBox.getSelectedIndex());
            }
        });
        HeaderImagePanel headerImagePanel = new HeaderImagePanel();
        this.fileFilterPanel = new JPanel();
        this.fileFilterPanel.setLayout(new GridBagLayout());
        this.gba.add(this.fileFilterPanel, this.fileFilterLabel, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.fileFilterPanel, this.fileFilterComboBox, 1, 0, 2, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.fileLoaderPanel = this.selectedFileLoader.getFileLoaderPanel();
        this.fileLoaderPanel.setSize(new Dimension(600, 600));
        this.fileLoaderPanel.setPreferredSize(new Dimension(600, 600));
        this.infoButton = new JButton(null, new ImageIcon(this.cl.getResource("org/tigr/images/Information24.gif")));
        this.infoButton.setActionCommand("info-command");
        this.infoButton.addActionListener(this.eventListener);
        this.infoButton.setFocusPainted(false);
        this.infoButton.setBorder(BorderFactory.createBevelBorder(0));
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this.eventListener);
        this.cancelButton.setBorder(BorderFactory.createBevelBorder(0));
        this.cancelButton.setSize(60, 30);
        this.cancelButton.setPreferredSize(new Dimension(60, 30));
        this.cancelButton.setFocusPainted(false);
        this.loadButton = new JButton("Load");
        this.loadButton.addActionListener(this.eventListener);
        this.loadButton.setBorder(BorderFactory.createBevelBorder(0, new Color(240, 240, 240), new Color(180, 180, 180), new Color(10, 0, 0), new Color(10, 10, 10)));
        this.loadButton.setSize(60, 30);
        this.loadButton.setPreferredSize(new Dimension(60, 30));
        this.loadButton.setFocusPainted(false);
        this.loadButton.setEnabled(false);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.gba.add(this.buttonPanel, this.infoButton, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.buttonPanel, new JLabel(new ImageIcon(this.cl.getResource("org/tigr/images/dialog_button_bar.gif"))), 1, 0, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.buttonPanel, this.cancelButton, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.buttonPanel, this.loadButton, 3, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.mainFrame.getContentPane(), headerImagePanel, 0, 0, 1, 1, 1, 0, 2, 10);
        this.gba.add(this.mainFrame.getContentPane(), this.fileFilterPanel, 0, 1, 1, 1, 1, 0, 1, 10);
        this.gba.add(this.mainFrame.getContentPane(), this.fileLoaderPanel, 0, 2, 1, 2, 1, 1, 1, 10);
        this.gba.add(this.mainFrame.getContentPane(), this.buttonPanel, 0, 4, 1, 1, 1, 0, 2, 10);
        this.mainFrame.setSize(1000, 750);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.mainFrame.setLocation((dimension.width - this.mainFrame.getSize().width) / 2, (dimension.height - this.mainFrame.getSize().height) / 2);
        this.mainFrame.setVisible(true);
    }

    public void setLoadEnabled(boolean bl) {
        this.loadButton.setEnabled(bl);
    }

    public void changeSelectedFileFilterAndLoader(int n) {
        if (n < 0 || n >= this.fileLoaders.length || n >= this.fileFilters.length) {
            return;
        }
        this.selectedFileLoader = this.fileLoaders[n];
        this.selectedFileFilter = this.fileFilters[n];
        this.loaderIndex = n;
        this.changeFileLoaderPanel(this.selectedFileLoader);
    }

    public void changeFileLoaderPanel(ExpressionFileLoader expressionFileLoader) {
        Container container = this.mainFrame.getContentPane();
        container.remove(this.fileLoaderPanel);
        this.fileLoaderPanel = expressionFileLoader.getFileLoaderPanel();
        this.gba.add(container, this.fileLoaderPanel, 0, 2, 1, 2, 1, 1, 1, 10);
        this.checkLoadEnable();
        container.validate();
        container.repaint();
    }

    public void addFileFilter(FileFilter fileFilter) {
        if (fileFilter == null) {
            return;
        }
        this.fileFilterComboBox.addItem(fileFilter.getDescription());
    }

    public void addFileFilters(FileFilter[] fileFilterArray) {
        for (int i = 0; i < fileFilterArray.length; ++i) {
            this.addFileFilter(fileFilterArray[i]);
        }
    }

    public void checkLoadEnable() {
        this.selectedFileLoader.checkLoadEnable();
    }

    public void onInfo() {
        HelpWindow helpWindow = new HelpWindow(this.getFrame(), "File Loader");
        if (helpWindow.getWindowContent()) {
            helpWindow.setSize(450, 650);
            helpWindow.setLocation();
            helpWindow.show();
        } else {
            helpWindow.setVisible(false);
            helpWindow.dispose();
        }
    }

    public void onCancel() {
        this.clean();
    }

    public void onLoad() {
        this.clean();
        Thread thread = new Thread(new Loader());
        thread.setPriority(1);
        thread.start();
        this.selectedFileLoader.showModal();
        this.dlist.getViewMenu().getcbExperiment().setEnabled(true);
    }

    public void clean() {
        this.mainFrame.dispose();
    }

    public JFrame getFrame() {
        return this.mainFrame;
    }

    public MultipleArrayViewer getArrayViewer() {
        return this.viewer;
    }

    public static void main(String[] stringArray) {
        SuperExpressionFileLoader superExpressionFileLoader = new SuperExpressionFileLoader();
    }

    private ISlideData[] toISlideDataArray(Vector vector) {
        if (vector == null || vector.size() < 1) {
            return null;
        }
        ISlideData[] iSlideDataArray = new ISlideData[vector.size()];
        for (int i = 0; i < iSlideDataArray.length; ++i) {
            iSlideDataArray[i] = (ISlideData)vector.elementAt(i);
        }
        return iSlideDataArray;
    }

    public void setDlist(BluejayDObjectList bluejayDObjectList) {
        this.dlist = bluejayDObjectList;
    }

    public class FillPanel
    extends JPanel {
        GradientPaint gp;
        Color backgroundColor = new Color(25, 25, 169);
        Color fadeColor = new Color(140, 220, 240);

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getSize();
            this.gp = new GradientPaint(0.0f, dimension.height / 2, this.backgroundColor, dimension.width, dimension.height / 2, this.fadeColor);
            graphics2D.setPaint(this.gp);
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
            graphics2D.setColor(Color.black);
        }
    }

    public class HeaderImagePanel
    extends JPanel {
        public HeaderImagePanel() {
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel(new ImageIcon(SuperExpressionFileLoader.this.cl.getResource("org/tigr/images/dialog_banner2.gif")));
            jLabel.setOpaque(false);
            jLabel.setAlignmentX(0.0f);
            FillPanel fillPanel = new FillPanel();
            fillPanel.setBackground(Color.blue);
            this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)fillPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private class Loader
    implements Runnable {
        public void run() {
            Vector vector = null;
            int n = 0;
            try {
                SuperExpressionFileLoader.this.selectedFileLoader.showModal();
                vector = SuperExpressionFileLoader.this.selectedFileLoader.loadExpressionFiles();
                n = SuperExpressionFileLoader.this.loaderIndex == 1 ? 1 : (SuperExpressionFileLoader.this.loaderIndex == 3 ? ((AffymetrixFileLoader)SuperExpressionFileLoader.this.selectedFileLoader).getAffyDataType() : 0);
                SuperExpressionFileLoader.this.selectedFileLoader.dispose();
                if (vector != null) {
                    SuperExpressionFileLoader.this.viewer.fireDataLoaded(SuperExpressionFileLoader.this.toISlideDataArray(vector), n);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class EventListener
    implements ActionListener {
        private EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SuperExpressionFileLoader.this.infoButton) {
                SuperExpressionFileLoader.this.onInfo();
            } else if (object == SuperExpressionFileLoader.this.cancelButton) {
                SuperExpressionFileLoader.this.onCancel();
            } else if (object == SuperExpressionFileLoader.this.loadButton) {
                SuperExpressionFileLoader.this.onLoad();
            }
        }
    }
}

