/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.io.FileNotFoundException;
import org.tigr.midas.display.ParameterPane;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.math.StatsTools;
import org.tigr.midas.util.AndFlags;
import org.tigr.midas.util.BlockFiller;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.CyToLogProdRatio;
import org.tigr.midas.util.NegateFlags;
import org.tigr.midas.util.logger;

public class IterativeLinReg {
    private ColumnWorker fCW;
    private int totalRowCount;
    private double[] cy3Column;
    private double[] cy5Column;
    private double[] logCy3;
    private double[] logCy5;
    private boolean[] inputFlag;
    private double slope;
    private double intercept;
    private String linearEquation;
    private String[] linearEquations;
    private double r2;
    private double[] r2s;
    private int m = 0;
    private int[] ms;

    /*
     * Unable to fully structure code
     */
    public IterativeLinReg(ColumnWorker fileCW, double nSD, String processMode) throws Exception {
        super();
        DEBUG = false;
        try {
            block30: {
                block29: {
                    this.fCW = fileCW;
                    this.cy3Column = this.fCW.getColumnOneArray();
                    this.cy5Column = this.fCW.getColumnTwoArray();
                    this.totalRowCount = this.fCW.getRowCounts();
                    tempFlag = this.fCW.getRowFlagArray();
                    this.inputFlag = new boolean[tempFlag.length];
                    System.arraycopy(tempFlag, 0, this.inputFlag, 0, tempFlag.length);
                    iterLogFlag = new boolean[fileCW.getRowCounts()];
                    iterLogFlag = new NegateFlags(iterLogFlag).getNegateFlag();
                    iterLogFlag = new AndFlags(iterLogFlag, this.inputFlag).getAndFlag();
                    logger.log("    Pre-normalized global results outputing ...");
                    cyTran = new CyToLogProdRatio(this.cy3Column, this.cy5Column, this.inputFlag);
                    s = new StatsTools();
                    if (!processMode.equalsIgnoreCase("block")) break block29;
                    blockFiller = new BlockFiller(fileCW);
                    this.totalRowCount = this.fCW.getRowCounts();
                    blockNumber = blockFiller.getBlockNumber();
                    this.linearEquations = new String[blockNumber];
                    this.r2s = new double[blockNumber];
                    this.ms = new int[blockNumber];
                    blockCount = 0;
                    while (blockCount < blockNumber) {
                        blockCy3Column = blockFiller.getBlockCy3(blockCount);
                        blockCy5Column = blockFiller.getBlockCy5(blockCount);
                        blockRawNdx = blockFiller.getOrigIndex(blockCount);
                        blockSize = blockFiller.getBlockSize(blockCount);
                        logger.log("    ============================");
                        logger.log("              Block " + blockCount);
                        logger.log("    ============================");
                        residue = new double[blockSize];
                        lastR2 = 1.0;
                        this.r2 = 0.0;
                        this.slope = 0.0;
                        this.intercept = 0.0;
                        residueCount = 0;
                        this.m = 0;
                        block3: while (true) {
                            if (Math.abs(lastR2 - this.r2) <= 0.001) {
                                logger.log("    *********************************");
                                this.linearEquations[blockCount] = "log(cy5) = log(cy3) * " + this.slope + " + " + this.intercept;
                                this.r2s[blockCount] = this.r2;
                                this.ms[blockCount] = this.m;
                                logger.log("    Block final linear equation: " + this.linearEquations[blockCount]);
                                break;
                            }
                            if (this.m > 100) {
                                logger.log("    *********************************");
                                logger.log("    Maximum iteration number 100 reached! ");
                                this.linearEquations[blockCount] = "log(cy5) = log(cy3) * " + this.slope + " + " + this.intercept;
                                this.r2s[blockCount] = this.r2;
                                this.ms[blockCount] = this.m;
                                logger.log("    Block final linear equation: " + this.linearEquations[blockCount]);
                                break;
                            }
                            if (this.m > 0) {
                                logger.log("    residueCount        = " + residueCount);
                            }
                            lastR2 = this.r2;
                            ++this.m;
                            cyTran = new CyToLogProdRatio(blockCy3Column, blockCy5Column, blockRawNdx, iterLogFlag);
                            logCy3 = cyTran.getLogX();
                            logCy5 = cyTran.getLogY();
                            s.linearRegression(logCy3, logCy5);
                            this.slope = s.getSlope();
                            this.intercept = s.getIntercept();
                            this.r2 = s.getCorrelationCoeff() * s.getCorrelationCoeff();
                            logger.log("    ------ iteration " + this.m + " ------");
                            logger.log("    Datasize            = " + s.getDataSize());
                            logger.log("    Slope               = " + this.slope);
                            logger.log("    Intercept           = " + this.intercept);
                            logger.log("    Corr.Coeff^2        = " + this.r2);
                            ndx = 0;
                            while (ndx < blockSize) {
                                residue[ndx] = blockCy3Column[ndx] > 1.0 && blockCy5Column[ndx] > 1.0 && iterLogFlag[blockRawNdx[ndx]] != false ? Math.abs(MathTools.log10((double)blockCy5Column[ndx]) - (MathTools.log10((double)blockCy3Column[ndx]) * this.slope + this.intercept)) : 0.0;
                                ++ndx;
                            }
                            s.computeMeanSDforNonZero(residue);
                            residueCount = 0;
                            ndx = 0;
                            while (true) {
                                if (ndx >= blockSize) continue block3;
                                if (iterLogFlag[blockRawNdx[ndx]] & Math.abs(residue[ndx]) < s.getXSD() * nSD) {
                                    iterLogFlag[blockRawNdx[ndx]] = true;
                                    ++residueCount;
                                } else {
                                    iterLogFlag[blockRawNdx[ndx]] = false;
                                }
                                ++ndx;
                            }
                            break;
                        }
                        if (ParameterPane.pRefStr.equalsIgnoreCase("Cy3")) {
                            ndx = 0;
                            while (ndx < blockSize) {
                                if (blockCy3Column[ndx] != 0.0 && blockCy5Column[ndx] != 0.0 && this.inputFlag[blockRawNdx[ndx]]) {
                                    this.cy5Column[blockRawNdx[ndx]] = Math.pow(10.0, (MathTools.log10((double)this.cy5Column[blockRawNdx[ndx]]) - this.intercept) / this.slope);
                                }
                                ++ndx;
                            }
                        } else {
                            ndx = 0;
                            while (ndx < blockSize) {
                                if (blockCy3Column[ndx] != 0.0 && blockCy5Column[ndx] != 0.0 && this.inputFlag[blockRawNdx[ndx]]) {
                                    blockCy3Column[ndx] = Math.pow(10.0, MathTools.log10((double)blockCy3Column[ndx]) * this.slope + this.intercept);
                                    this.cy3Column[blockRawNdx[ndx]] = Math.pow(10.0, MathTools.log10((double)this.cy3Column[blockRawNdx[ndx]]) * this.slope + this.intercept);
                                }
                                ++ndx;
                            }
                        }
                        ++blockCount;
                    }
                    break block30;
                }
                residue = new double[this.totalRowCount];
                lastR2 = 1.0;
                this.r2 = 0.0;
                this.slope = 0.0;
                this.intercept = 0.0;
                residueCount = 0;
                block8: while (true) lbl-1000:
                // 3 sources

                {
                    block31: {
                        if (Math.abs(lastR2 - this.r2) <= 0.001) {
                            this.linearEquation = "log(cy5) = log(cy3) * " + this.slope + " + " + this.intercept;
                            logger.log("    *********************************");
                            logger.log("    Final linear equation: " + this.linearEquation);
                            break;
                        }
                        if (this.m > 100) {
                            this.linearEquation = "log(cy5) = log(cy3) * " + this.slope + " + " + this.intercept;
                            logger.log("    *********************************");
                            logger.log("    Maximum iteration number 100 reached! ");
                            logger.log("    Final linear equation: " + this.linearEquation);
                            break;
                        }
                        if (this.m > 0) {
                            logger.log("    residueCount        = " + residueCount);
                        }
                        lastR2 = this.r2;
                        ++this.m;
                        cyTran = new CyToLogProdRatio(this.cy3Column, this.cy5Column, iterLogFlag);
                        logCy3 = cyTran.getLogX();
                        logCy5 = cyTran.getLogY();
                        s.linearRegression(logCy3, logCy5);
                        this.slope = s.getSlope();
                        this.intercept = s.getIntercept();
                        this.r2 = s.getCorrelationCoeff() * s.getCorrelationCoeff();
                        logger.log("    ------ iteration " + this.m + " ------");
                        logger.log("    Datasize            = " + s.getDataSize());
                        logger.log("    Slope               = " + this.slope);
                        logger.log("    Intercept           = " + this.intercept);
                        logger.log("    Corr.Coeff^2        = " + this.r2);
                        rawNdx = 0;
                        while (rawNdx < this.totalRowCount) {
                            residue[rawNdx] = this.cy3Column[rawNdx] > 1.0 && this.cy5Column[rawNdx] > 1.0 && iterLogFlag[rawNdx] != false ? Math.abs(MathTools.log10((double)this.cy5Column[rawNdx]) - (MathTools.log10((double)this.cy3Column[rawNdx]) * this.slope + this.intercept)) : 0.0;
                            ++rawNdx;
                        }
                        s.computeMeanSDforNonZero(residue);
                        residueCount = 0;
                        rawNdx = 0;
                        while (rawNdx < this.totalRowCount) {
                            if (iterLogFlag[rawNdx] & Math.abs(residue[rawNdx]) < s.getXSD() * nSD) {
                                iterLogFlag[rawNdx] = true;
                                ++residueCount;
                            } else {
                                iterLogFlag[rawNdx] = false;
                            }
                            ++rawNdx;
                        }
                        if (!ParameterPane.pRefStr.equalsIgnoreCase("Cy3")) break block31;
                        rawNdx = 0;
                        while (true) {
                            if (rawNdx >= this.totalRowCount) ** GOTO lbl-1000
                            if (this.cy3Column[rawNdx] != 0.0 && this.cy5Column[rawNdx] != 0.0 && this.inputFlag[rawNdx]) {
                                this.cy5Column[rawNdx] = Math.pow(10.0, (MathTools.log10((double)this.cy5Column[rawNdx]) - this.intercept) / this.slope);
                            }
                            ++rawNdx;
                        }
                    }
                    rawNdx = 0;
                    while (true) {
                        if (rawNdx >= this.totalRowCount) continue block8;
                        if (this.cy3Column[rawNdx] != 0.0 && this.cy5Column[rawNdx] != 0.0 && this.inputFlag[rawNdx]) {
                            this.cy3Column[rawNdx] = Math.pow(10.0, MathTools.log10((double)this.cy3Column[rawNdx]) * this.slope + this.intercept);
                        }
                        ++rawNdx;
                    }
                    break;
                }
            }
            logger.log("    Post-normalized global results outputing ...");
            cyTran = new CyToLogProdRatio(this.cy3Column, this.cy5Column, this.inputFlag);
            this.fCW.setColOneArray(this.cy3Column);
            this.fCW.setColTwoArray(this.cy5Column);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.print(ex.getMessage());
            throw ex;
        }
    }

    public final ColumnWorker getIterLinRegColumnWorker() {
        return this.fCW;
    }

    public final String getLinearEquation() {
        return this.linearEquation;
    }

    public final String[] getLinearEquations() {
        return this.linearEquations;
    }

    public final double getCorrCoeff() {
        return this.r2;
    }

    public final double[] getCorrCoeffs() {
        return this.r2s;
    }

    public final int getIterationCount() {
        return this.m;
    }

    public final int[] getIterationCounts() {
        return this.ms;
    }

    public static void main(String[] args) {
        try {
            ColumnWorker fileCW = new ColumnWorker("C:\\DataFiles0\\32K\\SimonData\\1233259D2F.tav");
            fileCW.setColumnsForMeta(2, 3);
            fileCW.setColumns(6, 7, 15, 16);
            fileCW.computeGoodRatiosAndLogRatios(0L, 0L);
            IterativeLinReg iterLinReg = new IterativeLinReg(fileCW, 2.0, "block");
        }
        catch (FileNotFoundException nfex) {
            nfex.printStackTrace();
        }
        catch (NumberFormatException nex) {
            nex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

