/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.io.FileNotFoundException;
import org.tigr.midas.display.ParameterPane;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.math.StatsTools;
import org.tigr.midas.util.AndFlags;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.CyToLogProdRatio;
import org.tigr.midas.util.NegateFlags;
import org.tigr.midas.util.logger;

public class IterativeLogMean {
    private ColumnWorker fCW;
    private int totalRowCount;
    private double[] cy3Column;
    private double[] cy5Column;
    private boolean[] inputFlag;
    private double[] logRatio;
    private double slideRawLogRatioMean;
    private double slideRawLogRatioSD;
    private double logRatioMean;
    private double logRatioSD;
    private int m = 0;
    private int[] withinRangeCounts = new int[100];
    private double[] logRatioMeans = new double[100];
    private double[] logRatioSDs = new double[100];

    public IterativeLogMean(ColumnWorker fileCW, double nSD) throws Exception {
        this.fCW = fileCW;
        this.cy3Column = fileCW.getColumnOneArray();
        this.cy5Column = fileCW.getColumnTwoArray();
        boolean[] tempFlag = fileCW.getRowFlagArray();
        this.inputFlag = new boolean[tempFlag.length];
        System.arraycopy(tempFlag, 0, this.inputFlag, 0, tempFlag.length);
        boolean[] iterLogFlag = new boolean[fileCW.getRowCounts()];
        iterLogFlag = new NegateFlags(iterLogFlag).getNegateFlag();
        iterLogFlag = new AndFlags(iterLogFlag, this.inputFlag).getAndFlag();
        this.totalRowCount = this.fCW.getRowCounts();
        int lastQualiCount = 0;
        CyToLogProdRatio lpr = new CyToLogProdRatio(this.cy3Column, this.cy5Column, iterLogFlag);
        this.logRatio = lpr.getLogRatio();
        lastQualiCount = this.logRatio.length;
        while (true) {
            StatsTools sTools = new StatsTools();
            sTools.computeMeanSD(this.logRatio);
            this.logRatioMean = sTools.getXMean();
            this.logRatioSD = sTools.getXSD();
            logger.log("    ------ iteration " + this.m + " ------");
            logger.log("    Within Range Count  = " + lastQualiCount);
            logger.log("    logRatioMean        = " + this.logRatioMean);
            logger.log("    logRatioSD          = " + this.logRatioSD);
            this.withinRangeCounts[this.m] = lastQualiCount;
            this.logRatioMeans[this.m] = this.logRatioMean;
            this.logRatioSDs[this.m] = this.logRatioSD;
            int qualifiedCount = 0;
            int rawNdx = 0;
            while (rawNdx < this.totalRowCount) {
                if (this.cy3Column[rawNdx] > 1.0 && this.cy5Column[rawNdx] > 1.0 && iterLogFlag[rawNdx]) {
                    if (ParameterPane.pRefStr.equalsIgnoreCase("Cy3")) {
                        int n = rawNdx;
                        this.cy5Column[n] = this.cy5Column[n] / Math.pow(2.0, this.logRatioMean);
                    } else {
                        int n = rawNdx;
                        this.cy3Column[n] = this.cy3Column[n] * Math.pow(2.0, this.logRatioMean);
                    }
                    if (Math.abs(MathTools.log2((double)(this.cy5Column[rawNdx] / this.cy3Column[rawNdx]))) < this.logRatioSD * nSD) {
                        this.logRatio[qualifiedCount] = MathTools.log2((double)(this.cy5Column[rawNdx] / this.cy3Column[rawNdx]));
                        ++qualifiedCount;
                    } else {
                        iterLogFlag[rawNdx] = false;
                    }
                }
                ++rawNdx;
            }
            if (qualifiedCount == lastQualiCount || this.m > 100) {
                logger.log("    *********************************");
                break;
            }
            if (this.m > 100) {
                logger.log("    Maximum iteration number 100 reached! ");
                break;
            }
            double[] t = new double[this.logRatio.length];
            System.arraycopy(this.logRatio, 0, t, 0, this.logRatio.length);
            this.logRatio = new double[qualifiedCount];
            System.arraycopy(t, 0, this.logRatio, 0, qualifiedCount);
            lastQualiCount = qualifiedCount;
            ++this.m;
        }
        this.fCW.setColOneArray(this.cy3Column);
        this.fCW.setColTwoArray(this.cy5Column);
    }

    public final ColumnWorker getIterLogMeanColumnWorker() {
        return this.fCW;
    }

    public final int getIterationCounts() {
        return this.m;
    }

    public final int[] getWithinRangeCounts() {
        return this.withinRangeCounts;
    }

    public final double[] getLogRatioMeans() {
        return this.logRatioMeans;
    }

    public final double[] getLogRatioSDs() {
        return this.logRatioSDs;
    }

    public static void main(String[] args) {
        try {
            ColumnWorker fileCW = new ColumnWorker("C:\\DataFiles0\\32K\\SimonData\\1233259D2F.tav");
            fileCW.setColumnsForMeta(2, 3);
            fileCW.setColumns(6, 7, 15, 16);
            fileCW.computeGoodRatiosAndLogRatios(0L, 0L);
            IterativeLogMean ilm = new IterativeLogMean(fileCW, 3.0);
        }
        catch (FileNotFoundException nfex) {
            nfex.printStackTrace();
        }
        catch (NumberFormatException nex) {
            nex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

