/*
 * Decompiled with CFR 0.152.
 */
package MAANOVA;

import Jama.Matrix;
import MAANOVA.AnovaTable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.tigr.midas.util.ColumnWorker;

public class AnovaObject {
    private Matrix yhat;
    private Matrix rss;
    private double[] G;
    private Matrix VG;
    private Matrix DG;
    private Matrix AG;
    private int[] anova_model = new int[3];
    private AnovaTable table = new AnovaTable();
    private String[] featNameArray;
    private boolean bfeatNameArray = false;

    public AnovaTable GetTable() {
        return this.table;
    }

    public void setTable(int row, Matrix M) {
        this.table.setTable(row, M);
    }

    public void setLeft(int row, String str) {
        this.table.setLeft(row, str);
    }

    public void setDF(int DF) {
        this.table.setDF(DF);
    }

    public Matrix getVG() {
        return this.VG;
    }

    public Matrix getAG() {
        return this.AG;
    }

    public Matrix getDG() {
        return this.DG;
    }

    public Matrix getRss() {
        return this.rss;
    }

    public double[] getG() {
        return this.G;
    }

    public void setRss(Matrix a, int i) {
        this.rss.set(i, 0, a.get(0, 0));
    }

    public Matrix getYhat() {
        return this.yhat.copy();
    }

    public void setYhat(Matrix M) {
        this.yhat = M.copy();
    }

    public void setG(int i, double a) {
        this.G[i] = a;
    }

    public void setVG(int i, double[] a, int n) {
        Matrix M = new Matrix(a, n);
        Matrix L = M.transpose();
        this.VG.setMatrix(i, i, 0, this.VG.getColumnDimension() - 1, L);
    }

    public void setDG(int i, double[] a, int n) {
        Matrix M = new Matrix(a, n);
        Matrix L = M.transpose();
        this.DG.setMatrix(i, i, 0, this.DG.getColumnDimension() - 1, L);
    }

    public void setAG(int i, int j, Matrix M) {
        this.AG.setMatrix(i, j, 0, this.AG.getColumnDimension() - 1, M);
    }

    public void setAG(Matrix M) {
        this.AG = M;
    }

    public void setModel(int[] a) {
        this.anova_model = a;
    }

    public void setFeatNameArray(String[] FN) {
        this.featNameArray = FN;
    }

    public void AllocateStorage(int ngenes, int nvars, int narrays, int rep) {
        this.yhat = new Matrix(ngenes * rep, 2 * narrays, 0.0);
        this.rss = new Matrix(ngenes, 1, 0.0);
        this.G = new double[ngenes];
        int i = 0;
        while (i < ngenes - 1) {
            this.G[i] = 0.0;
            ++i;
        }
        this.VG = new Matrix(ngenes, nvars, 0.0);
        this.DG = new Matrix(ngenes, 2, 0.0);
        this.AG = new Matrix(rep * ngenes, narrays, 0.0);
    }

    public void setFeatNameFlag(boolean f) {
        this.bfeatNameArray = f;
    }

    public void setYhatToColumnWorkerArray(ColumnWorker[] CWA) {
        int size = this.yhat.getRowDimension();
        int sizeX = this.yhat.getColumnDimension();
        int j = 0;
        while (j < sizeX) {
            int k = j / 2;
            int i = 0;
            while (i < size) {
                double d1 = Math.exp(this.yhat.get(i, j));
                CWA[k].getColumnOneArray()[i] = (float)d1;
                double d2 = Math.exp(this.yhat.get(i, j + 1));
                CWA[k].getColumnTwoArray()[i] = (float)d2;
                ++i;
            }
            System.out.println("j = " + j + " j/2 = " + j / 2);
            j += 2;
        }
    }

    public void PrintToFile(String file) {
        try {
            PrintWriter PW = new PrintWriter(new FileOutputStream(file));
            NumberFormat nf = NumberFormat.getNumberInstance();
            DecimalFormat df = new DecimalFormat("#0.##E0");
            nf.setMaximumFractionDigits(4);
            double d3 = 0.0;
            int rssSize = this.rss.getRowDimension();
            int size = this.yhat.getRowDimension();
            int sizeX = this.yhat.getColumnDimension();
            int rep = size / rssSize;
            double[] d = new double[sizeX];
            String[] s = new String[sizeX];
            int sizeVG = this.VG.getColumnDimension();
            double[] dVG = new double[sizeVG];
            String[] s_VG = new String[sizeVG];
            int sizeDG = this.DG.getColumnDimension();
            double[] dDG = new double[sizeDG];
            String[] s_DG = new String[sizeDG];
            int sizeAG = this.AG.getColumnDimension();
            double[] dAG = new double[sizeAG];
            String[] s_AG = new String[sizeAG];
            int k = 0;
            int i = 0;
            while (i < size) {
                String sDG;
                double d4;
                String sVG;
                double GV;
                double rssV;
                double d1 = this.yhat.get(i, 0);
                String s_Yhat = nf.format(d1);
                int j = 1;
                while (j < sizeX) {
                    d[j] = this.yhat.get(i, j);
                    s[j] = nf.format(d[j]);
                    s_Yhat = s_Yhat + "\t" + s[j];
                    ++j;
                }
                double d2 = this.AG.get(i, 0);
                String sAG = nf.format(d2);
                int m = 1;
                while (m < sizeAG) {
                    dAG[m] = this.AG.get(i, m);
                    s_AG[m] = nf.format(dAG[m]);
                    sAG = sAG + "\t" + s_AG[m];
                    ++m;
                }
                if (i == 0) {
                    rssV = this.rss.get(0, 0);
                    GV = this.G[0];
                    d3 = this.VG.get(0, 0);
                    sVG = nf.format(d3);
                    d4 = this.DG.get(0, 0);
                    sDG = nf.format(d4);
                    int m1 = 1;
                    while (m1 < sizeVG) {
                        dVG[m1] = this.VG.get(0, m1);
                        s_VG[1] = nf.format(dVG[m1]);
                        sVG = sVG + "\t" + s_VG[m1];
                        ++m1;
                    }
                    int m2 = 0;
                    while (m2 < sizeDG) {
                        dDG[m2] = this.DG.get(0, m2);
                        s_DG[m2] = nf.format(dDG[m2]);
                        sDG = sDG + "\t" + s_DG[m2];
                        ++m2;
                    }
                } else if ((float)i % (float)rep == 0.0f) {
                    k = i / rep;
                    rssV = this.rss.get(k, 0);
                    GV = this.G[k];
                } else {
                    rssV = this.rss.get(k, 0);
                    GV = this.G[k];
                }
                d3 = this.VG.get(k, 0);
                sVG = nf.format(d3);
                d4 = this.DG.get(k, 0);
                sDG = nf.format(d4);
                int m2 = 1;
                while (m2 < sizeVG) {
                    dVG[m2] = this.VG.get(k, m2);
                    s_VG[m2] = nf.format(dVG[m2]);
                    sVG = sVG + "\t" + s_VG[m2];
                    ++m2;
                }
                int m3 = 1;
                while (m3 < sizeDG) {
                    dDG[m3] = this.DG.get(k, m3);
                    s_DG[m3] = nf.format(dDG[m3]);
                    sDG = sDG + "\t" + s_DG[m3];
                    ++m3;
                }
                String s_rss = df.format(rssV);
                String s_G = nf.format(GV);
                PW.println(s_Yhat + "\t" + s_rss + "\t" + s_G + "\t" + sVG + "\t" + sAG + "\t" + sDG);
                ++i;
            }
            PW.flush();
            PW.close();
        }
        catch (IOException e) {}
    }

    public void PrintToStanfordTypeFile(String file, String[] VectorStr, String[] featNameArray) {
        try {
            PrintWriter PW = new PrintWriter(new FileOutputStream(file));
            NumberFormat nf = NumberFormat.getNumberInstance();
            DecimalFormat df = new DecimalFormat("#0.##E0");
            nf.setMaximumFractionDigits(4);
            double d3 = 0.0;
            int rssSize = this.rss.getRowDimension();
            int size = this.yhat.getRowDimension();
            int sizeX = this.yhat.getColumnDimension();
            int narrays = sizeX / 2;
            int rep = size / rssSize;
            double[] d = new double[sizeX];
            String[] s = new String[sizeX];
            double[] logratio = new double[sizeX];
            String[] s_log = new String[narrays];
            String s_logratio = "";
            int sizeVG = this.VG.getColumnDimension();
            double[] dVG = new double[sizeVG];
            String[] s_VG = new String[sizeVG];
            int sizeDG = this.DG.getColumnDimension();
            double[] dDG = new double[sizeDG];
            String[] s_DG = new String[sizeDG];
            int sizeAG = this.AG.getColumnDimension();
            double[] dAG = new double[sizeAG];
            String[] s_AG = new String[sizeAG];
            String s_FeatName = "";
            String s_Yhat = "";
            int i = 0;
            while (i < narrays) {
                int index = i + 1;
                s_Yhat = s_Yhat + VectorStr[i] + "\t";
                ++i;
            }
            String sAG = "";
            i = 0;
            while (i < sizeAG) {
                sAG = sAG + "AG" + "\t";
                ++i;
            }
            String sVG = "";
            i = 0;
            while (i < sizeVG) {
                sVG = sVG + "VG" + "\t";
                ++i;
            }
            String sDG = "";
            i = 0;
            while (i < sizeDG) {
                sDG = sDG + "DG" + "\t";
                ++i;
            }
            PW.println("UID\tname\t" + s_Yhat);
            int k = 0;
            double LCF = 1.0 / Math.log(2.0);
            i = 0;
            while (i < size) {
                int count;
                double d4;
                double GV;
                double rssV;
                double d1 = this.yhat.get(i, 0);
                s_Yhat = nf.format(d1);
                int j = 1;
                while (j < sizeX) {
                    d[j] = Math.exp(this.yhat.get(i, j));
                    s[j] = nf.format(d[j]);
                    s_Yhat = s_Yhat + "\t" + s[j];
                    ++j;
                }
                d1 = Math.exp(this.yhat.get(i, 0));
                double d2 = Math.exp(this.yhat.get(i, 1));
                logratio[0] = LCF * Math.log(d2 / d1);
                s_logratio = nf.format(logratio[0]);
                int k2 = 1;
                int k1 = 2;
                while (k1 < sizeX) {
                    logratio[k2] = LCF * Math.log(d[k1 + 1] / d[k1]);
                    s_log[k2] = nf.format(logratio[k2]);
                    s_logratio = s_logratio + "\t" + s_log[k2];
                    ++k2;
                    k1 += 2;
                }
                d2 = this.AG.get(i, 0);
                sAG = nf.format(d2);
                int m = 1;
                while (m < sizeAG) {
                    dAG[m] = this.AG.get(i, m);
                    s_AG[m] = nf.format(dAG[m]);
                    sAG = sAG + "\t" + s_AG[m];
                    ++m;
                }
                if (i == 0) {
                    rssV = this.rss.get(0, 0);
                    GV = this.G[0];
                    d3 = this.VG.get(0, 0);
                    sVG = nf.format(d3);
                    d4 = this.DG.get(0, 0);
                    sDG = nf.format(d4);
                    int m1 = 1;
                    while (m1 < sizeVG) {
                        dVG[m1] = this.VG.get(0, m1);
                        s_VG[1] = nf.format(dVG[m1]);
                        sVG = sVG + "\t" + s_VG[m1];
                        ++m1;
                    }
                    int m2 = 0;
                    while (m2 < sizeDG) {
                        dDG[m2] = this.DG.get(0, m2);
                        s_DG[m2] = nf.format(dDG[m2]);
                        sDG = sDG + "\t" + s_DG[m2];
                        ++m2;
                    }
                } else if ((float)i % (float)rep == 0.0f) {
                    k = i / rep;
                    rssV = this.rss.get(k, 0);
                    GV = this.G[k];
                } else {
                    rssV = this.rss.get(k, 0);
                    GV = this.G[k];
                }
                d3 = this.VG.get(k, 0);
                sVG = nf.format(d3);
                d4 = this.DG.get(k, 0);
                sDG = nf.format(d4);
                int m2 = 1;
                while (m2 < sizeVG) {
                    dVG[m2] = this.VG.get(k, m2);
                    s_VG[m2] = nf.format(dVG[m2]);
                    sVG = sVG + "\t" + s_VG[m2];
                    ++m2;
                }
                int m3 = 1;
                while (m3 < sizeDG) {
                    dDG[m3] = this.DG.get(k, m3);
                    s_DG[m3] = nf.format(dDG[m3]);
                    sDG = sDG + "\t" + s_DG[m3];
                    ++m3;
                }
                if (this.bfeatNameArray) {
                    s_FeatName = featNameArray[i];
                    count = i + 1;
                    PW.println(count + "\t" + s_FeatName + "\t" + s_logratio);
                } else {
                    count = i + 1;
                    PW.println(count + "\t" + s_logratio);
                }
                ++i;
            }
            PW.flush();
            PW.close();
        }
        catch (IOException e) {}
    }
}

