/*
 * Decompiled with CFR 0.152.
 */
package MAANOVA;

import Jama.Matrix;
import MAANOVA.AnovaObject;
import MAANOVA.DefaultGraph2DModel;
import MAANOVA.FtestObject;
import MAANOVA.JScatterGraph;
import MAANOVA.MyMatlab;
import java.awt.Graphics;
import java.util.Arrays;
import javax.swing.JPanel;

class DrawPanelVolcano
extends JPanel {
    private FtestObject FO;
    private Matrix p1;
    private Matrix p2;
    private Matrix p3;
    private float f1_th;
    private float f2_th;
    private float f3_th;
    private AnovaObject AO;
    private String Flag;

    public DrawPanelVolcano(AnovaObject ao, FtestObject fo, float f1, float f2, float f3, String flag) {
        this.FO = fo;
        this.Flag = flag;
        this.AO = ao;
        this.f1_th = f1;
        this.f2_th = f2;
        this.f2_th = f3;
    }

    public void paintComponent(Graphics g) {
        double[] xvalue;
        super.paintComponent(g);
        DefaultGraph2DModel gm = new DefaultGraph2DModel();
        DefaultGraph2DModel gm2 = new DefaultGraph2DModel();
        MyMatlab MatLab = new MyMatlab();
        int[] method = this.FO.getMethod();
        int[] m = new int[]{1, 2, 3};
        if (!Arrays.equals(method, m)) {
            throw new IllegalArgumentException("You do not have three F test result in Ftest object");
        }
        this.p1 = this.FO.getF1().getPtab();
        if (this.Flag == "max") {
            this.p2 = this.FO.getF2().getPvalmax();
            this.p3 = this.FO.getF3().getPvalmax();
        } else if (this.Flag == "pg") {
            this.p2 = this.FO.getF2().getPvalpg();
            this.p3 = this.FO.getF3().getPvalpg();
        } else {
            throw new IllegalArgumentException("Unknown method name");
        }
        int[] idx1 = MatLab.FindDouble(this.p1.getColumnPackedCopy(), this.f1_th, 1);
        int[] idx2 = MatLab.FindDouble(this.p2.getColumnPackedCopy(), this.f2_th, 1);
        int[] idx3 = MatLab.FindDouble(this.p3.getColumnPackedCopy(), this.f3_th, 1);
        Matrix VG = this.AO.getVG();
        int s = VG.getColumnDimension();
        if (s == 2) {
            Matrix xv = VG.getMatrix(0, VG.getRowDimension() - 1, 0, 0).minus(VG.getMatrix(0, VG.getRowDimension() - 1, 1, 1)).times(1.0 / Math.log(2.0));
            xvalue = xv.getColumnPackedCopy();
        } else {
            double[] xval = MatLab.Sum(VG.times(VG));
            xvalue = new double[xval.length];
            int i = 0;
            while (i < xval.length) {
                xvalue[i] = Math.sqrt(xval[i]);
                ++i;
            }
        }
        double[] xval1 = new double[idx2.length];
        double[] p1_idx2 = new double[idx2.length];
        double[] p1_arr = this.p1.getColumnPackedCopy();
        double[] xvaltest = new double[xvalue.length / 2];
        double[] p1_test = new double[p1_arr.length / 2];
        double[] p1_arrlog = new double[p1_arr.length];
        int i = 0;
        while (i < p1_arr.length) {
            p1_arrlog[i] = -Math.log(p1_arr[i]) / Math.log(10.0);
            ++i;
        }
        gm.setXAxis(xvalue);
        gm.addSeries(p1_arrlog);
        gm.nextSeries();
        int i2 = 0;
        while (i2 < idx2.length) {
            int id = idx2[i2];
            xval1[i2] = xvalue[id];
            double p1_temp = p1_arr[id];
            p1_idx2[i2] = -Math.log(p1_temp) / Math.log(10.0);
            ++i2;
        }
        gm.setXAxis(xval1);
        gm.addSeries(p1_idx2);
        JScatterGraph SG = new JScatterGraph(gm);
        SG.setNumbering(true);
        SG.setXIncrement(0.0f);
        SG.setYIncrement(0.0f);
        SG.setBounds(0, 0, 600, 600);
        SG.offscreenPaint(g);
        SG.rescale();
    }
}

