/*
 * Decompiled with CFR 0.152.
 */
package MAANOVA;

import MAANOVA.Graph2DModel;
import MAANOVA.GraphDataEvent;
import MAANOVA.GraphDataListener;
import MAANOVA.JDoubleBufferedComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public abstract class JGraph2D
extends JDoubleBufferedComponent
implements GraphDataListener {
    protected Graph2DModel model;
    protected boolean numbering = true;
    protected Point origin = new Point();
    protected float minX;
    protected float minY;
    protected float maxX;
    protected float maxY;
    private boolean autoYExtrema = true;
    protected Color[] seriesColor = new Color[]{Color.red, Color.blue, Color.green, Color.black, Color.yellow, Color.cyan, Color.lightGray, Color.magenta, Color.orange, Color.pink};
    private float xScale;
    private float yScale;
    private float xInc;
    private float yInc;
    private boolean autoXInc = true;
    private boolean autoYInc = true;
    protected final int scalePad = 5;
    protected final int axisPad = 25;
    protected int leftAxisPad;

    public JGraph2D(Graph2DModel gm) {
        this.model = gm;
        this.model.addGraphDataListener(this);
        this.dataChanged(new GraphDataEvent(this.model));
    }

    public final void setModel(Graph2DModel gm) {
        this.model.removeGraphDataListener(this);
        this.model = gm;
        this.model.addGraphDataListener(this);
        this.dataChanged(new GraphDataEvent(this.model));
    }

    public final Graph2DModel getModel() {
        return this.model;
    }

    public void dataChanged(GraphDataEvent e) {
        this.minX = 0.0f;
        this.maxX = Float.NEGATIVE_INFINITY;
        this.model.firstSeries();
        int i = 0;
        while (i < this.model.seriesLength()) {
            float tmpX = this.model.getXCoord(i);
            this.minX = Math.min(tmpX, this.minX);
            this.maxX = Math.max(tmpX, this.maxX);
            ++i;
        }
        int n = 1;
        while (this.model.nextSeries()) {
            ++n;
        }
        if (n > this.seriesColor.length) {
            Color[] tmp = this.seriesColor;
            this.seriesColor = new Color[n];
            System.arraycopy(tmp, 0, this.seriesColor, 0, tmp.length);
            int i2 = tmp.length;
            while (i2 < n) {
                this.seriesColor[i2] = this.seriesColor[i2 - tmp.length];
                ++i2;
            }
        }
        if (this.autoYExtrema) {
            this.setYExtrema(0.0f, 0.0f);
        }
        this.setNumbering(this.numbering);
        this.rescale();
    }

    public final void setNumbering(boolean flag) {
        this.numbering = flag;
        this.leftAxisPad = 25;
        if (this.numbering) {
            int yNumPad = 8 * Math.max(String.valueOf(this.maxY).length(), String.valueOf(this.minY).length());
            if (this.minX < 0.0f) {
                int negXLen = (int)((float)(Math.max(this.getWidth(), this.getMinimumSize().width) - 60) * this.minX / (this.minX - this.maxX));
                yNumPad = Math.max(yNumPad - negXLen, 0);
            }
            this.leftAxisPad += yNumPad;
        }
    }

    public final void setXIncrement(float dx) {
        if (dx < 0.0f) {
            throw new IllegalArgumentException("Increment should be positive.");
        }
        this.autoXInc = dx == 0.0f;
        this.xInc = dx;
    }

    public final void setYIncrement(float dy) {
        if (dy < 0.0f) {
            throw new IllegalArgumentException("Increment should be positive.");
        }
        this.autoYInc = dy == 0.0f;
        this.yInc = dy;
    }

    public final void setYExtrema(float min, float max) {
        if (min == 0.0f && max == 0.0f) {
            float tmp;
            this.autoYExtrema = true;
            this.minY = 0.0f;
            this.maxY = Float.NEGATIVE_INFINITY;
            this.model.firstSeries();
            int i = 0;
            while (i < this.model.seriesLength()) {
                tmp = this.model.getYCoord(i);
                this.minY = Math.min(tmp, this.minY);
                this.maxY = Math.max(tmp, this.maxY);
                ++i;
            }
            while (this.model.nextSeries()) {
                int i2 = 0;
                while (i2 < this.model.seriesLength()) {
                    tmp = this.model.getYCoord(i2);
                    this.minY = Math.min(tmp, this.minY);
                    this.maxY = Math.max(tmp, this.maxY);
                    ++i2;
                }
            }
            if (this.minY == this.maxY) {
                this.minY -= 0.5f;
                this.maxY += 0.5f;
            }
        } else {
            if (max <= min) {
                throw new IllegalArgumentException("Maximum should be greater than minimum; max = " + max + " and min = " + min);
            }
            this.autoYExtrema = false;
            this.minY = min;
            this.maxY = max;
        }
        this.rescale();
    }

    public final void setColor(int n, Color c) {
        this.seriesColor[n] = c;
    }

    public final void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.rescale();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(200, 200);
    }

    public final void rescale() {
        Dimension s = this.getMinimumSize();
        int thisWidth = Math.max(this.getWidth(), s.width);
        int thisHeight = Math.max(this.getHeight(), s.height);
        this.xScale = (float)(thisWidth - (this.leftAxisPad + 25)) / (this.maxX - this.minX);
        this.yScale = (float)(thisHeight - 50) / (this.maxY - this.minY);
        if (this.autoXInc) {
            this.xInc = JGraph2D.round(40.0f / this.xScale);
        }
        if (this.autoYInc) {
            this.yInc = JGraph2D.round(40.0f / this.yScale);
        }
        this.origin.x = this.leftAxisPad - Math.round(this.minX * this.xScale);
        this.origin.y = thisHeight - 25 + Math.round(this.minY * this.yScale);
        this.redraw();
    }

    protected final Point dataToScreen(float x, float y) {
        return new Point(this.origin.x + Math.round(this.xScale * x), this.origin.y - Math.round(this.yScale * y));
    }

    protected final Point2D.Float screenToData(Point p) {
        return new Point2D.Float((float)(p.x - this.origin.x) / this.xScale, (float)(this.origin.y - p.y) / this.yScale);
    }

    protected final void drawAxes(Graphics g) {
        Rectangle r = new Rectangle();
        super.getBounds(r);
        g.setColor(Color.white);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.setColor(this.getForeground());
        if (this.minY > 0.0f) {
            g.drawLine(this.leftAxisPad - 5, this.getHeight() - 25, this.getWidth() - 20, this.getHeight() - 25);
        } else {
            g.drawLine(this.leftAxisPad - 5, this.origin.y, this.getWidth() - 20, this.origin.y);
        }
        if (this.minX > 0.0f) {
            g.drawLine(this.leftAxisPad, 20, this.leftAxisPad, this.getHeight() - 20);
        } else {
            g.drawLine(this.origin.x, 20, this.origin.x, this.getHeight() - 20);
        }
        if (this.numbering) {
            Point p;
            int strWidth;
            String str;
            FontMetrics metrics = g.getFontMetrics();
            int strHeight = metrics.getHeight();
            float x = this.minX > 0.0f ? this.minX : this.xInc;
            while (x <= this.maxX) {
                str = String.valueOf(JGraph2D.round(x));
                strWidth = metrics.stringWidth('+' + str);
                p = this.dataToScreen(x, this.minY > 0.0f ? this.minY : 0.0f);
                g.drawLine(p.x, p.y, p.x, p.y + 5);
                g.drawString(str, p.x - strWidth / 2, p.y + 5 + strHeight);
                x += this.xInc;
            }
            x = -this.xInc;
            while (x >= this.minX) {
                str = String.valueOf(JGraph2D.round(x));
                strWidth = metrics.stringWidth(str);
                p = this.dataToScreen(x, this.minY > 0.0f ? this.minY : 0.0f);
                g.drawLine(p.x, p.y, p.x, p.y + 5);
                g.drawString(str, p.x - strWidth / 2, p.y + 5 + strHeight);
                x -= this.xInc;
            }
            float y = this.minY > 0.0f ? this.minY : this.yInc;
            while (y <= this.maxY) {
                str = String.valueOf(JGraph2D.round(y));
                strWidth = metrics.stringWidth(str);
                p = this.dataToScreen(this.minX > 0.0f ? this.minX : 0.0f, y);
                g.drawLine(p.x, p.y, p.x - 5, p.y);
                g.drawString(str, p.x - 8 - strWidth, p.y + strHeight / 4);
                y += this.yInc;
            }
            y = -this.yInc;
            while (y >= this.minY) {
                str = String.valueOf(JGraph2D.round(y));
                strWidth = metrics.stringWidth(str);
                p = this.dataToScreen(this.minX > 0.0f ? this.minX : 0.0f, y);
                g.drawLine(p.x, p.y, p.x - 5, p.y);
                g.drawString(str, p.x - 8 - strWidth, p.y + strHeight / 4);
                y -= this.yInc;
            }
        }
    }

    protected static final float round(float x) {
        float factor;
        float mag;
        int SIG_FIG = 2;
        int sign = 1;
        if (x < 0.0f) {
            sign = -1;
        }
        if ((mag = Math.abs(x)) < 1.0f) {
            float tmp = 10.0f * mag;
            int places = 1;
            while (tmp < 1.0f) {
                tmp *= 10.0f;
                ++places;
            }
            factor = (float)Math.pow(10.0, places + 2 - 1);
        } else {
            float tmp = mag / 10.0f;
            int places = 1;
            while (tmp > 1.0f) {
                tmp /= 10.0f;
                ++places;
            }
            factor = (float)Math.pow(10.0, 2 - places);
        }
        return (float)(sign * Math.round(mag * factor)) / factor;
    }
}

