/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.MevAttributes;
import org.tigr.microarray.converter.Converter;
import org.tigr.microarray.converter.ImaGeneAttributes;
import org.tigr.microarray.converter.MevConverter;
import org.tigr.util.FileReading;
import org.tigr.util.MyTimer;
import org.tigr.util.io.IOUtil;

public class ImaGeneMev
extends MevConverter
implements ImaGeneAttributes,
MevAttributes {
    private JFrame parent;
    private String ch1FileName;
    private String ch2FileName;
    private String title;
    private Vector ig2FileNames;
    private int fPixAddr;
    private int gAnnType;
    private final String TAB = "\t";
    private final String PAN = "#";

    public ImaGeneMev(String gfName, String mfName) {
        this.inFileNames = new Vector(1);
        this.outFileNames = new Vector(1);
        this.inFileNames.add(gfName);
        this.outFileNames.add(mfName);
        this.title = new String("Genepix vs Mev");
        this.msg = new String("");
        Converter.ready = false;
        this.wantSort = true;
        Converter.fetalError = false;
        Converter.minorError = false;
    }

    public ImaGeneMev(JFrame frame, Vector ig1Names, Vector ig2Names, Vector mfNames, String barTitle, int annNum) {
        this.parent = frame;
        this.inFileNames = ig1Names;
        this.ig2FileNames = ig2Names;
        this.outFileNames = mfNames;
        this.msg = new String("");
        this.title = barTitle;
        this.gAnnType = annNum;
        Converter.ready = false;
        this.wantSort = true;
        Converter.fetalError = false;
        Converter.minorError = false;
    }

    public int getTaskEnd() {
        return this.taskEnd;
    }

    public int getCurrent() {
        return this.counter;
    }

    public String getErrorMsg() {
        return this.msg;
    }

    public String getFileName() {
        return this.ch1FileName;
    }

    public void run() {
        String aLine = new String("");
        String densA = new String("");
        String densB = new String("");
        String flagA = new String("");
        String flagB = new String("");
        String ident = new String("");
        String spAreaA = new String("");
        String spAreaB = new String("");
        String bgA = new String("");
        String bgB = new String("");
        String medA = new String("");
        String medB = new String("");
        StringBuffer mevLine = new StringBuffer(200);
        int maxRow = 0;
        int maxCol = 0;
        BufferedWriter mevWriter = null;
        FileOutputStream mevFileOut = null;
        this.taskEnd = this.determineTaskEnd();
        if (this.taskEnd == 1) {
            return;
        }
        this.taskEnd <<= 1;
        this.counter = 0;
        int numOfFiles = this.inFileNames.size();
        int i = 0;
        while (i < numOfFiles) {
            boolean noError = true;
            this.ch1FileName = (String)this.inFileNames.elementAt(i);
            this.ch2FileName = (String)this.ig2FileNames.elementAt(i);
            String mevFileName = (String)this.outFileNames.elementAt(i);
            String[] ch1File = this.readInput(this.ch1FileName);
            String[] ch2File = this.readInput(this.ch2FileName);
            int ch1HeaderLines = this.getHeaderLines(ch1File);
            int ch2HeaderLines = this.getHeaderLines(ch2File);
            aLine = ch1File[ch1HeaderLines + 1];
            String[] f1ColNames = this.separateLine(aLine);
            aLine = ch2File[ch2HeaderLines + 1];
            String[] f2ColNames = this.separateLine(aLine);
            int mRowIndex = this.findRightCol(f1ColNames, "Meta Row");
            int mColIndex = this.findRightCol(f1ColNames, "Meta Column");
            int colIndex = this.findRightCol(f1ColNames, "Column");
            int rowIndex = this.findRightCol(f1ColNames, "Row");
            int[] ch1NumSpotsAndMaxMetaCol = this.noSpotDropped(this.ch1FileName, ch1File, ch1HeaderLines, mRowIndex, mColIndex, rowIndex, colIndex);
            int[] ch2NumSpotsAndMaxMetaCol = this.noSpotDropped(this.ch2FileName, ch2File, ch2HeaderLines, mRowIndex, mColIndex, rowIndex, colIndex);
            if (ch1NumSpotsAndMaxMetaCol[0] < 0 || ch2NumSpotsAndMaxMetaCol[0] < 0 || ch1NumSpotsAndMaxMetaCol[0] != ch2NumSpotsAndMaxMetaCol[0]) {
                noError = false;
                this.counter += numOfFiles;
            }
            if (noError) {
                int f1FlagIndex = this.findRightCol(f1ColNames, "Flag");
                int f2FlagIndex = this.findRightCol(f2ColNames, "Flag");
                int f1SignalArea = this.findRightCol(f1ColNames, "Signal Area");
                int f2SignalArea = this.findRightCol(f2ColNames, "Signal Area");
                if (f1SignalArea < 1 || f2SignalArea < 1) {
                    JOptionPane.showMessageDialog(this.parent, "The Signal Area is missing in either of the data files \nso that converter cannot process these pair of files; however,\nConverting will continue for the remaining files", this.parent.getTitle(), 0);
                    noError = false;
                    this.counter += numOfFiles;
                }
                if (noError) {
                    int f1SignalMedian = this.findRightCol(f1ColNames, "Signal Median");
                    int f1BgMedian = this.findRightCol(f1ColNames, "Background Median");
                    int f1SignalTotal = this.findRightCol(f1ColNames, "Signal Total");
                    int f1BgTotal = this.findRightCol(f1ColNames, "Background Total");
                    int f1BgArea = this.findRightCol(f1ColNames, "Background Area");
                    int f2SignalMedian = this.findRightCol(f2ColNames, "Signal Median");
                    int f2BgMedian = this.findRightCol(f2ColNames, "Background Median");
                    int f2SignalTotal = this.findRightCol(f2ColNames, "Background Total");
                    int f2BgTotal = this.findRightCol(f2ColNames, "Background Total");
                    int f2BgArea = this.findRightCol(f2ColNames, "Background Area");
                    int geneIndex = this.findRightCol(f1ColNames, "Gene ID");
                    try {
                        int slideCol;
                        int slideRow;
                        int row;
                        int col;
                        int metaCol;
                        int metaRow;
                        String[] f2ColValues;
                        String[] f1ColValues;
                        int k;
                        mevFileOut = new FileOutputStream(mevFileName);
                        mevWriter = new BufferedWriter(new OutputStreamWriter(mevFileOut));
                        this.sortKeys = new int[3][ch1NumSpotsAndMaxMetaCol[0]];
                        this.outFile = new String[ch1NumSpotsAndMaxMetaCol[0]];
                        String inputFileName = IOUtil.extractFileNameFromPath(this.ch1FileName);
                        inputFileName = inputFileName + " and " + IOUtil.extractFileNameFromPath(this.ch2FileName);
                        String[] mevFileHeader = this.generateHeader(inputFileName, ch1NumSpotsAndMaxMetaCol[0]);
                        int j = 0;
                        while (j < mevFileHeader.length) {
                            mevWriter.write(mevFileHeader[j]);
                            mevWriter.newLine();
                            mevWriter.flush();
                            ++j;
                        }
                        int numSpots = ch1NumSpotsAndMaxMetaCol[0] + ch1HeaderLines + 2;
                        inputFileName = IOUtil.extractFileNameFromPath(this.ch1FileName);
                        inputFileName = IOUtil.dropExtension(inputFileName);
                        inputFileName = inputFileName + "_and_" + IOUtil.extractFileNameFromPath(this.ch2FileName);
                        this.counter += ch1HeaderLines;
                        if (f1SignalMedian > 1 && f2SignalMedian > 1) {
                            j = ch1HeaderLines + 2;
                            k = 0;
                            while (j < numSpots) {
                                f1ColValues = this.separateLine(ch1File[j]);
                                f2ColValues = this.separateLine(ch2File[j]);
                                metaRow = Integer.parseInt(f1ColValues[mRowIndex]);
                                metaCol = Integer.parseInt(f1ColValues[mColIndex]);
                                col = Integer.parseInt(f1ColValues[colIndex]);
                                row = Integer.parseInt(f1ColValues[rowIndex]);
                                ident = f1ColValues[geneIndex];
                                spAreaA = f1ColValues[f1SignalArea];
                                spAreaB = f2ColValues[f2SignalArea];
                                bgA = this.calculateBackground(f1ColValues, f1BgMedian, f1SignalArea);
                                bgB = this.calculateBackground(f2ColValues, f2BgMedian, f2SignalArea);
                                flagA = this.setFlag(f1ColValues, f1FlagIndex);
                                flagB = this.setFlag(f2ColValues, f2FlagIndex);
                                maxRow = ch1NumSpotsAndMaxMetaCol[2];
                                maxCol = ch1NumSpotsAndMaxMetaCol[3];
                                slideRow = (metaRow - 1) * maxRow + row;
                                slideCol = (metaCol - 1) * maxCol + col;
                                mevLine.append(ident).append("\t");
                                if (this.gBkgCorrect) {
                                    densA = this.calculateIntegrateIntensity(f1ColValues, f1SignalMedian, f1BgMedian, f1SignalArea, true);
                                    densB = this.calculateIntegrateIntensity(f2ColValues, f2SignalMedian, f2BgMedian, f2SignalArea, true);
                                    medA = this.calculateMedianIntensity(f1ColValues, f1SignalMedian, f1BgMedian, true);
                                    medB = this.calculateMedianIntensity(f2ColValues, f2SignalMedian, f2BgMedian, true);
                                } else {
                                    densA = this.calculateIntegrateIntensity(f1ColValues, f1SignalMedian, f1BgMedian, f1SignalArea, false);
                                    densB = this.calculateIntegrateIntensity(f2ColValues, f2SignalMedian, f2BgMedian, f2SignalArea, false);
                                    medA = this.calculateMedianIntensity(f1ColValues, f1SignalMedian, f1BgMedian, false);
                                    medB = this.calculateMedianIntensity(f2ColValues, f2SignalMedian, f2BgMedian, false);
                                }
                                if (this.gUseMedian) {
                                    mevLine.append(medA).append("\t").append(medB);
                                    aLine = densA + "\t" + densB;
                                } else {
                                    mevLine.append(densA).append("\t").append(densB);
                                    aLine = medA + "\t" + medB;
                                }
                                mevLine.append("\t").append(slideRow).append("\t").append(slideCol);
                                mevLine.append("\t").append(metaRow).append("\t").append(metaCol);
                                mevLine.append("\t").append(row).append("\t").append(col).append("\t");
                                mevLine.append(bgA).append("\t").append(bgB).append("\t").append(flagA);
                                mevLine.append("\t").append(flagB).append("\t").append(spAreaA).append("\t");
                                mevLine.append(spAreaB).append("\t").append(aLine);
                                this.outFile[k] = new String(mevLine.toString());
                                mevLine.delete(0, mevLine.length());
                                this.sortKeys[0][k] = k;
                                this.sortKeys[1][k] = slideRow;
                                this.sortKeys[2][k] = slideCol;
                                ++this.counter;
                                ++j;
                                ++k;
                            }
                        } else {
                            j = ch1HeaderLines + 2;
                            k = 0;
                            while (j < numSpots) {
                                f1ColValues = this.separateLine(ch1File[j]);
                                f2ColValues = this.separateLine(ch2File[j]);
                                metaRow = Integer.parseInt(f1ColValues[mRowIndex]);
                                metaCol = Integer.parseInt(f1ColValues[mColIndex]);
                                col = Integer.parseInt(f1ColValues[colIndex]);
                                row = Integer.parseInt(f1ColValues[rowIndex]);
                                ident = f1ColValues[geneIndex];
                                spAreaA = f1ColValues[f1SignalArea];
                                spAreaB = f2ColValues[f2SignalArea];
                                bgA = f1ColValues[f1BgTotal];
                                bgB = f2ColValues[f2BgTotal];
                                flagA = this.setFlag(f1ColValues, f1FlagIndex);
                                flagB = this.setFlag(f2ColValues, f2FlagIndex);
                                maxRow = ch1NumSpotsAndMaxMetaCol[2];
                                maxCol = ch1NumSpotsAndMaxMetaCol[3];
                                slideRow = (metaRow - 1) * maxRow + row;
                                slideCol = (metaCol - 1) * maxCol + col;
                                mevLine.append(ident).append("\t");
                                if (this.gBkgCorrect) {
                                    densA = this.calculateIntegrateIntensity(f1ColValues, f1SignalTotal, f1BgTotal, f1BgArea, f1SignalArea, true);
                                    densB = this.calculateIntegrateIntensity(f2ColValues, f2SignalTotal, f2BgTotal, f2BgArea, f2SignalArea, true);
                                    medA = this.calculateMedianIntensity(f1ColValues, f1SignalTotal, f1BgTotal, f1BgArea, f1SignalArea, true);
                                    medB = this.calculateMedianIntensity(f2ColValues, f2SignalTotal, f2BgTotal, f2BgArea, f2SignalArea, true);
                                } else {
                                    densA = this.calculateIntegrateIntensity(f1ColValues, f1SignalTotal, f1BgTotal, f1BgArea, f1SignalArea, false);
                                    densB = this.calculateIntegrateIntensity(f2ColValues, f2SignalTotal, f2BgTotal, f2BgArea, f2SignalArea, false);
                                    medA = this.calculateMedianIntensity(f1ColValues, f1SignalTotal, f1BgTotal, f1BgArea, f1SignalArea, false);
                                    medB = this.calculateMedianIntensity(f2ColValues, f2SignalTotal, f2BgTotal, f2BgArea, f2SignalArea, false);
                                }
                                if (this.gUseMedian) {
                                    mevLine.append(medA).append("\t").append(medB);
                                    aLine = densA + "\t" + densB;
                                } else {
                                    mevLine.append(densA).append("\t").append(densB);
                                    aLine = medA + "\t" + medB;
                                }
                                mevLine.append("\t").append(slideRow).append("\t").append(slideCol);
                                mevLine.append("\t").append(metaRow).append("\t").append(metaCol);
                                mevLine.append("\t").append(row).append("\t").append(col).append("\t");
                                mevLine.append(bgA).append("\t").append(bgB).append("\t").append(flagA);
                                mevLine.append("\t").append(flagB).append("\t").append(spAreaA).append("\t");
                                mevLine.append(spAreaB).append("\t").append(aLine);
                                this.outFile[k] = new String(mevLine.toString());
                                mevLine.delete(0, mevLine.length());
                                this.sortKeys[0][k] = k;
                                this.sortKeys[1][k] = slideRow;
                                this.sortKeys[2][k] = slideCol;
                                ++this.counter;
                                ++j;
                                ++k;
                            }
                        }
                        if (this.wantSort) {
                            this.sorted = this.sortRowCol(ch1NumSpotsAndMaxMetaCol[1], maxCol);
                            j = 0;
                            while (j < this.outFile.length) {
                                mevWriter.write(this.outFile[this.sorted[j]]);
                                mevWriter.newLine();
                                mevWriter.flush();
                                ++this.counter;
                                ++j;
                            }
                        } else {
                            j = 0;
                            while (j < this.outFile.length) {
                                mevWriter.write(this.outFile[j]);
                                mevWriter.newLine();
                                mevWriter.flush();
                                ++this.counter;
                                ++j;
                            }
                        }
                        mevFileOut.close();
                    }
                    catch (IOException ie) {
                        Converter.fetalError = true;
                        System.out.println("Error in writing file: " + ie.getMessage());
                        this.msg = this.msg + "**********\n";
                        this.msg = this.msg + "Error in writing file: " + ie.getMessage() + "\n";
                    }
                }
            }
            ++i;
        }
        Converter.ready = true;
        this.counter = this.taskEnd;
    }

    public void setSortSpots(boolean b) {
        this.wantSort = b;
    }

    private String calculateBackground(String[] tuple, int backg, int area) {
        String bg = new String("");
        try {
            float fPix = Float.parseFloat(tuple[area]);
            float bMedian = Float.parseFloat(tuple[backg]);
            int temp = (int)(bMedian * fPix);
            bg = bg + temp;
        }
        catch (NumberFormatException nfex) {
            Converter.minorError = true;
            bg = "null";
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "There is an unacceptable value for either Signal Area or Backgroud Median; and the background was set to null.\n";
        }
        return bg;
    }

    private String calculateIntegrateIntensity(String[] tuple, int med, int backg, int sArea, boolean bgSub) {
        String den = new String("");
        try {
            float signal = Float.parseFloat(tuple[med]);
            float bg = Float.parseFloat(tuple[backg]);
            float area = Float.parseFloat(tuple[sArea]);
            int temp = bgSub ? (int)((signal - bg) * area) : (int)(signal * area);
            den = den + temp;
        }
        catch (NumberFormatException nfex) {
            Converter.minorError = true;
            den = "null";
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "There is a null value for either Signal Median or Background Median ";
            this.msg = this.msg + "and the intensity was set to null.\n";
        }
        return den;
    }

    private String calculateIntegrateIntensity(String[] tuple, int sigTot, int bgTot, int bgArea, int sArea, boolean bgSub) {
        String den = new String("");
        float st = Float.parseFloat(tuple[sigTot]);
        float bt = Float.parseFloat(tuple[bgTot]);
        float ba = Float.parseFloat(tuple[bgArea]);
        float area = Float.parseFloat(tuple[sArea]);
        int temp = bgSub ? (int)(st - bt / ba * area) : (int)st;
        den = den + temp;
        return den;
    }

    private String calculateMedianIntensity(String[] tuple, int med, int backg, boolean bgSub) {
        String den = new String("");
        try {
            float fMedian = Float.parseFloat(tuple[med]);
            float bMedian = Float.parseFloat(tuple[backg]);
            float temp = bgSub ? fMedian - bMedian : fMedian;
            den = den + (int)temp;
        }
        catch (NumberFormatException nfex) {
            Converter.minorError = true;
            den = "null";
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "There is an unacceptable value to calculate intensity; and the intensity was set to null.\n";
        }
        return den;
    }

    private String calculateMedianIntensity(String[] tuple, int sigTot, int bgTot, int bgArea, int sArea, boolean bgSub) {
        String den = new String("");
        float st = Float.parseFloat(tuple[sigTot]);
        float bt = Float.parseFloat(tuple[bgTot]);
        float ba = Float.parseFloat(tuple[bgArea]);
        float area = Float.parseFloat(tuple[sArea]);
        int temp = bgSub ? (int)(st / area - bt / ba) : (int)(st / area);
        den = den + temp;
        return den;
    }

    private String[] generateHeader(String fName, int numRow) {
        String[] tempHeader = new String[8];
        String bkgVal = this.gBkgCorrect ? "ON" : "OFF";
        tempHeader[0] = new String("# version: V1.0");
        tempHeader[1] = new String("# format_version:V4.0");
        tempHeader[2] = new String("# date: " + MyTimer.getCurrentDateAndTime('.'));
        tempHeader[3] = new String("# created by: " + this.title);
        tempHeader[4] = new String("# row_count:" + numRow);
        tempHeader[5] = new String("# Converted from ImaGene files: " + fName);
        tempHeader[6] = new String("# background_correction:" + bkgVal);
        tempHeader[7] = this.gUseMedian ? "UID\tMedA\tMedB\tR\tC\tMR\tMC\tSR\tSC\tBkgA\tBkgB\tFlagA\tFlagB\tSAA\tSAB\tIA\tIB" : "UID\tIA\tIB\tR\tC\tMR\tMC\tSR\tSC\tBkgA\tBkgB\tFlagA\tFlagB\tSAA\tSAB\tMedA\tMedB";
        return tempHeader;
    }

    private int getDataEndLine(String[] dataFile) {
        int end = 0;
        int i = dataFile.length - 1;
        while (i > 0) {
            String line = dataFile[i];
            String[] elements = this.separateLine(line);
            end = i;
            int j = 0;
            while (j < elements.length) {
                String temp = elements[j];
                if (temp.equalsIgnoreCase("End Raw Data")) {
                    j = elements.length;
                    i = 0;
                }
                ++j;
            }
            --i;
        }
        return end - 1;
    }

    private int getHeaderLines(String[] dataFile) {
        int numLine = 0;
        int i = 0;
        while (i < dataFile.length) {
            String line = dataFile[i];
            String[] elements = this.separateLine(line);
            numLine = i;
            int j = 0;
            while (j < elements.length) {
                String temp = elements[j];
                if (temp.equalsIgnoreCase("Begin Raw Data")) {
                    j = elements.length;
                    i = dataFile.length;
                }
                ++j;
            }
            ++i;
        }
        return numLine;
    }

    private BufferedWriter createAnnoWriter(String fName, String inName, int numSpots) {
        BufferedWriter out;
        try {
            FileOutputStream fOut = new FileOutputStream(fName);
            out = new BufferedWriter(new OutputStreamWriter(fOut));
            String[] annoFileHeader = this.generateHeader(inName, numSpots);
            annoFileHeader[5] = "UID\tR\tC";
            int i = 0;
            while (i < annoFileHeader.length) {
                out.write(annoFileHeader[i]);
                out.newLine();
                out.flush();
                ++i;
            }
        }
        catch (IOException ie) {
            Converter.fetalError = true;
            Converter.ready = false;
            System.out.println("Error in creating ann file: " + ie.getMessage());
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "Error in creating ann file: " + ie.getMessage() + "\n";
            return null;
        }
        return out;
    }

    private int findRightCol(String[] str, String key) {
        int addr = 0;
        int size = str.length;
        String temp = new String("");
        int i = 0;
        while (i < str.length) {
            if (str[i].equalsIgnoreCase(key)) {
                addr = i;
                i = str.length;
            }
            ++i;
        }
        return addr;
    }

    private String[] readInput(String inName) {
        String[] tempVec;
        block3: {
            tempVec = null;
            try {
                FileReading fileReader = new FileReading(inName, 1);
                if (fileReader.done) {
                    tempVec = fileReader.getFileContentAsArray();
                    break block3;
                }
                this.setErrorMessage(fileReader.getProcessMessage());
                this.taskEnd = 1;
                this.counter = 1;
            }
            catch (IOException e) {
                this.setErrorMessage(e.getMessage());
                this.taskEnd = 1;
                this.counter = 1;
            }
        }
        return tempVec;
    }

    private int[] noSpotDropped(String fName, String[] dataFile, int dataStart, int mRow, int mCol, int row, int col) {
        int[] num = new int[5];
        int heading = dataStart;
        int dataEnd = this.getDataEndLine(dataFile);
        String tempLine = dataFile[dataEnd];
        String[] vecVal = this.separateLine(tempLine);
        int maxMetaRow = Integer.parseInt(vecVal[mRow]);
        int maxMetaCol = Integer.parseInt(vecVal[mCol]);
        int maxRow = Integer.parseInt(vecVal[row]);
        int maxCol = Integer.parseInt(vecVal[col]);
        num[0] = maxMetaRow * maxMetaCol * maxRow * maxCol;
        num[1] = maxMetaCol;
        num[2] = maxRow;
        num[3] = maxCol;
        num[4] = dataEnd;
        if (num[0] != dataEnd - heading - 1) {
            JOptionPane.showMessageDialog(null, "You might have dropped some of your spots in the file \n(" + fName + ".\nThe converter requires an original ImaGene output file." + "\nConverting will continue for the remaining files", this.parent.getTitle(), 0);
            num[0] = -1;
        }
        return num;
    }

    private boolean isChar(char x) {
        boolean b = true;
        switch (x) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                b = false;
                break;
            }
            default: {
                b = true;
            }
        }
        return b;
    }

    private String setFlag(String[] tuple, int indx) {
        String f = new String("");
        int flagInt = Integer.parseInt(tuple[indx]);
        f = flagInt != 0 ? "X" : "B";
        return f;
    }
}

