/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.border.BevelBorder;
import org.tigr.microarray.converter.ConvertPanel;
import org.tigr.microarray.converter.ExpressConverter;
import org.tigr.util.LongTextChanger;
import org.tigr.util.io.IOUtil;
import org.tigr.util.swing.MultiInputOutputs;

public class MevPanel
extends ConvertPanel {
    private JCheckBox keepAllCB;
    MultiInputOutputs inOut;
    private boolean keepAll;

    public MevPanel() {
        this((ExpressConverter)null);
    }

    public MevPanel(ExpressConverter ec) {
        super(ec);
        this.wantSort = true;
        this.keepAll = false;
        this.outputReady = false;
        this.selectedFiles = new Vector(10, 3);
        this.outputFileNames = new Vector(10, 3);
        this.createGUI();
    }

    public void adjustGUI(int index) {
        String tmpName = new String("");
        this.outputType = index;
        int numFiles = this.outputFileNames.size();
        int i = 0;
        while (i < numFiles) {
            tmpName = (String)this.outputFileNames.elementAt(i);
            tmpName = IOUtil.dropExtension(tmpName);
            tmpName = tmpName + "." + this.FILE_TYPE[this.outputType];
            this.outputFileNames.setElementAt(tmpName, i);
            ++i;
        }
        this.validate();
    }

    public void changeFileList(Vector inFiles, Vector outFiles) {
        this.selectedFiles = inFiles;
        this.outputFileNames = outFiles;
        this.inOut.setInputListData(inFiles);
        this.inOut.setOutputListData(outFiles);
        this.inOut.showNumberOfFiles(this.selectedFiles.size());
    }

    protected void createGUI() {
        int sizeX = (int)((double)ExpressConverter.scrWidth * 0.83);
        int sizeY = (int)((double)ExpressConverter.scrHeight * 0.7);
        BevelBorder low = new BevelBorder(1);
        this.setLayout(new GridBagLayout());
        this.inOut = new MultiInputOutputs(sizeX, sizeY);
        this.inOut.setLabelTexts("MEV Files:", "TAV Files:");
        this.inOut.setDividerLocation(0.3);
        this.inOut.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pce) {
                if (pce.getPropertyName().equals(MevPanel.this.inOut.OUT_READY) && pce.getNewValue().toString().equals("true")) {
                    MevPanel.this.parent.activateButton(MevPanel.this.inOut.isOutputReady(), MevPanel.this.inOut.isOutputReady());
                }
            }
        });
        this.keepAllCB = new JCheckBox("Keep Unique ID in the MEV File(s).");
        this.keepAllCB.setToolTipText("Attach the UID to the TAV file(s).");
        this.keepAllCB.setSelected(this.keepAll);
        this.keepAllCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ce) {
                if (MevPanel.this.keepAllCB.isSelected()) {
                    MevPanel.this.keepAll = true;
                } else {
                    MevPanel.this.keepAll = false;
                }
            }
        });
        this.gba.add(this, this.inOut, 0, 0, 2, 1, 1, 1, 1, 10, 5, 5, 10, 5);
        this.gba.add(this, this.sortCB, 0, 1, 1, 1, 1, 0, 2, 10, 10, 15, 3, 5);
        this.gba.add(this, this.keepAllCB, 0, 2, 1, 1, 1, 0, 2, 10, 3, 15, 3, 5);
    }

    public void editDirectory(String path) {
        int selected = -1;
        String tempPath = path;
        selected = this.inOut.getSelectedOutputIndex();
        int num = this.outputFileNames.size();
        int i = 0;
        while (i < num) {
            String tempName = (String)this.outputFileNames.elementAt(i);
            tempName = IOUtil.extractFileNameFromPath(tempName);
            tempName = tempPath + "\\" + tempName;
            this.outputFileNames.setElementAt(tempName, i);
            ++i;
        }
        this.inOut.setOutputListData(this.outputFileNames);
        if (selected >= 0) {
            this.inOut.setOutputSelectedIndex(selected);
        } else {
            this.inOut.setOutputSelectedIndex(0);
        }
    }

    public void editFileName() {
        int selected = -1;
        selected = this.inOut.getSelectedOutputIndex();
        if (selected >= 0) {
            String tempName = this.inOut.getSelectedOutputName(selected);
            LongTextChanger changer = new LongTextChanger(this.parent, true, tempName);
            changer.setTitle("ExpressConveter V.1.7");
            changer.show();
            if (changer.isTextChanged()) {
                tempName = changer.getText();
                StringTokenizer token = new StringTokenizer(tempName, ":");
                if (token.countTokens() <= 1) {
                    tempName = "c:\\" + tempName;
                }
                tempName = (tempName = IOUtil.dropExtension(tempName)).lastIndexOf(46) == tempName.length() - 1 ? tempName + this.FILE_TYPE[this.outputType] : tempName + "." + this.FILE_TYPE[this.outputType];
                this.outputFileNames.setElementAt(tempName, selected);
                this.inOut.setOutputListData(this.outputFileNames);
                this.inOut.setOutputSelectedIndex(selected);
            }
        }
    }

    public boolean keepAllInformation() {
        return this.keepAll;
    }

    public void removeFileFromList() {
        int[] addrs = this.inOut.getSelectedInputIndices();
        if (addrs.length > 0) {
            int i = 0;
            while (i < addrs.length) {
                this.selectedFiles.remove(addrs[i]);
                this.outputFileNames.remove(addrs[i]);
                ++i;
            }
            this.inOut.setInputListData(this.selectedFiles);
            this.inOut.setOutputListData(this.outputFileNames);
            if (this.outputFileNames.size() > 0) {
                this.inOut.setOutputSelectedIndex(0);
            }
            this.inOut.showNumberOfFiles(this.selectedFiles.size());
        }
    }

    public Vector getOutputFileNames() {
        return this.outputFileNames;
    }

    public Vector getSelectedFiles() {
        return this.selectedFiles;
    }

    public boolean getOutputReady() {
        return this.inOut.isOutputReady();
    }

    public void setSelectedFiles(String[] newFiles) {
        String temp = new String("");
        int num = newFiles.length;
        int i = 0;
        while (i < num) {
            if (!this.selectedFiles.contains(newFiles[i])) {
                this.selectedFiles.add(newFiles[i]);
                this.outputFileNames.add(IOUtil.dropExtension(newFiles[i]) + "." + this.FILE_TYPE[this.outputType]);
            }
            ++i;
        }
        this.inOut.addDataToLists(this.selectedFiles, this.outputFileNames);
        this.inOut.setOutputSelectedIndex(0);
        this.inOut.showNumberOfFiles(this.selectedFiles.size());
    }

    public void reset() {
        this.selectedFiles.removeAllElements();
        this.outputFileNames.removeAllElements();
        this.inOut.showNumberOfFiles(0);
        this.inOut.setInputListData(this.selectedFiles);
        this.inOut.setOutputListData(this.outputFileNames);
        this.wantSort = true;
        this.keepAll = false;
        this.outputReady = false;
        this.sortCB.setSelected(this.wantSort);
        this.parent.activateButton(this.outputReady, this.outputReady);
    }
}

