/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.tigr.microarray.MevAttributes;
import org.tigr.microarray.MevFileParser;
import org.tigr.microarray.converter.Converter;

public class MevTav
extends Converter
implements MevAttributes {
    private final String NULL = "null";
    private boolean keepAll;
    private String title;

    public MevTav() {
    }

    public MevTav(Vector inNames, Vector mfNames, String barTitle) {
        this.inFileNames = inNames;
        this.outFileNames = mfNames;
        this.title = barTitle;
        this.keepAll = false;
    }

    public void run() {
        String aLine = new String("");
        String extraInfo = new String("");
        FileOutputStream tavFileOut = null;
        BufferedWriter tavWriter = null;
        this.taskEnd = this.determineTaskEnd();
        if (this.taskEnd == 1) {
            return;
        }
        this.taskEnd <<= 1;
        this.counter = 0;
        int numOfFiles = this.inFileNames.size();
        int i = 0;
        while (i < numOfFiles) {
            boolean noError = true;
            this.inFileNamePath = (String)this.inFileNames.elementAt(i);
            String tavFileName = (String)this.outFileNames.elementAt(i);
            File mevFileIn = new File(this.inFileNamePath);
            MevFileParser parser = new MevFileParser();
            parser.loadFile(mevFileIn);
            if (!parser.isMevFileLoaded()) {
                Converter.fetalError = true;
                this.msg = this.msg + "**********\n";
                this.msg = this.msg + "Error in loading mev file with MevFileParser.\n";
                this.taskEnd = 1;
                this.counter = 1;
                return;
            }
            Hashtable headerMap = this.setHeaderMap(parser.getColumnHeaders());
            String[][] mevFile = parser.getDataMatrix();
            int fSize = mevFile.length;
            this.taskEnd -= 2;
            if (!this.isOriginal(mevFile, fSize)) {
                JOptionPane.showMessageDialog(null, "You might have dropped some of your spots in the file \n(" + this.inFileNamePath + ".\nThe converter requires an file with all spots." + "\nConverting will continue for the remaining files", this.title + " -- Mev-Tav", 0);
                noError = false;
                this.counter += numOfFiles;
            }
            if (noError) {
                try {
                    tavFileOut = new FileOutputStream(tavFileName);
                    tavWriter = new BufferedWriter(new OutputStreamWriter(tavFileOut));
                    this.sortKeys = new int[3][fSize];
                    this.outFile = new String[fSize];
                    int maxMetaCol = Integer.parseInt(mevFile[fSize - 1][6]);
                    int maxCol = Integer.parseInt(mevFile[fSize - 1][8]);
                    int j = 0;
                    int k = 0;
                    while (j < fSize) {
                        aLine = this.setLine(mevFile[j], headerMap);
                        int slideRow = Integer.parseInt(mevFile[j][3]);
                        int slideCol = Integer.parseInt(mevFile[j][4]);
                        extraInfo = "\t" + mevFile[j][0];
                        if (this.keepAll) {
                            aLine = aLine + extraInfo;
                        }
                        this.outFile[k] = new String(aLine);
                        this.sortKeys[0][k] = k;
                        this.sortKeys[1][k] = slideRow;
                        this.sortKeys[2][k] = slideCol;
                        ++this.counter;
                        ++j;
                        ++k;
                    }
                    if (this.wantSort) {
                        this.sorted = this.sortRowCol(maxMetaCol, maxCol);
                        j = 0;
                        while (j < this.outFile.length) {
                            tavWriter.write(this.outFile[this.sorted[j]]);
                            tavWriter.newLine();
                            tavWriter.flush();
                            ++this.counter;
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < this.outFile.length) {
                            tavWriter.write(this.outFile[j]);
                            tavWriter.newLine();
                            tavWriter.flush();
                            ++this.counter;
                            ++j;
                        }
                    }
                    tavFileOut.close();
                }
                catch (IOException ie) {
                    Converter.fetalError = true;
                    Converter.ready = false;
                    System.out.println("Error in writing file: " + ie.getMessage());
                    this.msg = this.msg + "**********\n";
                    this.msg = this.msg + "Error in writing file: " + ie.getMessage() + "\n";
                    return;
                }
                catch (Exception e) {
                    Converter.fetalError = true;
                    Converter.ready = false;
                    this.msg = this.msg + "**********\n";
                    this.msg = this.msg + "Error: " + e.getMessage() + ". Please report the developer.\n";
                    return;
                }
            }
            ++i;
        }
        Converter.ready = true;
        this.counter = this.taskEnd;
    }

    public void setKeepAllInformation(boolean b) {
        this.keepAll = b;
    }

    private Hashtable setHeaderMap(Vector header) {
        Hashtable<String, Integer> map = new Hashtable<String, Integer>(13);
        Integer offset = this.getOffset(header, "SA");
        if (offset > 0) {
            map.put("SA", offset);
        }
        if ((offset = this.getOffset(header, "SAA")) > 0) {
            map.put("SAA", offset);
        }
        if ((offset = this.getOffset(header, "SAB")) > 0) {
            map.put("SAB", offset);
        }
        if ((offset = this.getOffset(header, "Flag")) > 0) {
            map.put("Flag", offset);
        }
        if ((offset = this.getOffset(header, "FlagA")) > 0) {
            map.put("FlagA", offset);
        }
        if ((offset = this.getOffset(header, "FlagB")) > 0) {
            map.put("FlagB", offset);
        }
        if ((offset = this.getOffset(header, "Bkg")) > 0) {
            map.put("Bkg", offset);
        }
        if ((offset = this.getOffset(header, "BkgA")) > 0) {
            map.put("BkgA", offset);
        }
        if ((offset = this.getOffset(header, "BkgB")) > 0) {
            map.put("BkgB", offset);
        }
        if ((offset = this.getOffset(header, "BG")) > 0) {
            map.put("BG", offset);
        }
        if ((offset = this.getOffset(header, "BGA")) > 0) {
            map.put("BGA", offset);
        }
        if ((offset = this.getOffset(header, "BGB")) > 0) {
            map.put("BGB", offset);
        }
        if ((offset = this.getOffset(header, "QC")) > 0) {
            map.put("QC", offset);
        }
        if ((offset = this.getOffset(header, "QCA")) > 0) {
            map.put("QCA", offset);
        }
        if ((offset = this.getOffset(header, "QCB")) > 0) {
            map.put("QCB", offset);
        }
        return map;
    }

    private String setLine(String[] mData, Hashtable hMap) {
        String line = new String("");
        int i = 3;
        while (i < 9) {
            line = line + mData[i] + "\t";
            ++i;
        }
        line = line + mData[1] + "\t" + mData[2];
        if (hMap.size() > 0) {
            if (hMap.containsKey("SA")) {
                line = line + "\t" + mData[(Integer)hMap.get("SA")];
                line = line + "\tnull";
            } else {
                line = hMap.containsKey("SAA") ? line + "\t" + mData[(Integer)hMap.get("SAA")] : line + "\tnull";
                line = hMap.containsKey("SAB") ? line + "\t" + mData[(Integer)hMap.get("SAB")] : line + "\tnull";
            }
            line = line + "\tnull";
            line = line + "\tnull";
            line = line + "\tnull";
            if (hMap.containsKey("Bkg")) {
                line = line + "\t" + mData[(Integer)hMap.get("Bkg")];
                line = line + "\tnull";
            } else if (hMap.containsKey("BG")) {
                line = line + "\t" + mData[(Integer)hMap.get("BG")];
                line = line + "\tnull";
            } else {
                line = hMap.containsKey("BkgA") ? line + "\t" + mData[(Integer)hMap.get("BkgA")] : (hMap.containsKey("BGA") ? line + "\t" + mData[(Integer)hMap.get("BGA")] : line + "\tnull");
                line = hMap.containsKey("BkgB") ? line + "\t" + mData[(Integer)hMap.get("BkgB")] : (hMap.containsKey("BGB") ? line + "\t" + mData[(Integer)hMap.get("BGB")] : line + "\tnull");
            }
            if (hMap.containsKey("Flag")) {
                line = line + "\t" + mData[(Integer)hMap.get("Flag")];
                line = line + "\tnull";
            } else {
                line = hMap.containsKey("FlagA") ? line + "\t" + mData[(Integer)hMap.get("FlagA")] : line + "\tnull";
                line = hMap.containsKey("FlagB") ? line + "\t" + mData[(Integer)hMap.get("FlagB")] : line + "\tnull";
            }
        }
        return line;
    }

    private Integer getOffset(Vector header, String key) {
        int i = 8;
        while (i < header.size()) {
            String hName = (String)header.elementAt(i);
            if (hName.equalsIgnoreCase(key)) {
                Integer temp = new Integer(i);
                return temp;
            }
            ++i;
        }
        Integer temp = new Integer(-1);
        return temp;
    }

    private boolean isOriginal(String[][] inFile, int size) {
        boolean noChange = true;
        int numSpot = size - 1;
        int mr = 0;
        int mc = 0;
        int sr = 0;
        int sc = 0;
        try {
            mr = Integer.parseInt(inFile[numSpot][5]);
            mc = Integer.parseInt(inFile[numSpot][6]);
            sr = Integer.parseInt(inFile[numSpot][7]);
            sc = Integer.parseInt(inFile[numSpot][8]);
        }
        catch (NumberFormatException nfex) {
            noChange = false;
            return noChange;
        }
        if (mr * mc * sr * sc != numSpot + 1) {
            noChange = false;
        }
        return noChange;
    }
}

