/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.MevAttributes;
import org.tigr.microarray.converter.Converter;
import org.tigr.microarray.converter.MevConverter;
import org.tigr.util.FileReading;
import org.tigr.util.MyTimer;
import org.tigr.util.io.IOUtil;
import org.tigr.util.io.MyIni;

public class ScanArrayMev
extends MevConverter
implements MevAttributes {
    private JFrame parent;
    private boolean gSwap;
    private String bgChA;
    private String bgChB;
    private String chA;
    private String chB;
    private String chApixel;
    private String chBpixel;
    private String inFileNamePath;
    private String mevFileName;
    private String barTitle;
    private int areaPixel;
    private int quantWay;
    private int gAnnType;
    private final int TOTAL = 0;
    private final int MEAN = 1;
    private final int MODE = 2;
    private final int MEDIAN = 3;
    private final String ARRAY_ROW = "Array Row";
    private final String ARRAY_COL = "Array Column";
    private final String BEGIN_DATA = "Begin Data";
    private final String COLUMN = "Column";
    private final String END_DATA = "End Data";
    private final String NAME = "Name";
    private final String RW = "Row";
    private final String INTENSITY = "Intensity";
    private final String BKG = "Background";
    private final String AREA = "Area";
    private final String TAB = "\t";
    private final String PAN = "#";

    public ScanArrayMev(String sfName, String tfName, int way, String title) {
        this.inFileNames = new Vector(1);
        this.outFileNames = new Vector(1);
        this.inFileNames.add(sfName);
        this.outFileNames.add(tfName);
        this.gSwap = false;
        this.quantWay = way;
        this.barTitle = title;
    }

    public ScanArrayMev(JFrame p, Vector sfNames, Vector tfNames, int way, String title, int annNum) {
        this.parent = p;
        this.inFileNames = sfNames;
        this.outFileNames = tfNames;
        this.quantWay = way;
        this.gSwap = false;
        this.barTitle = title;
        this.gAnnType = annNum;
    }

    public void needSwapChannels(boolean b) {
        this.gSwap = b;
    }

    public void run() {
        String aLine = new String("");
        String densA = new String("");
        String densB = new String("");
        String bgA = new String("");
        String bgB = new String("");
        String medA = new String("null");
        String medB = new String("null");
        String extraInfo = new String("");
        String[] channels = new String[]{"ch1", "ch2"};
        String[] annoFile = null;
        StringBuffer mevLine = new StringBuffer(200);
        int max = 0;
        int maxRow = 0;
        int maxCol = 0;
        int maxArrayRow = 0;
        int maxArrayCol = 0;
        BufferedWriter mevWriter = null;
        BufferedWriter annoWriter = null;
        FileOutputStream mevFileOut = null;
        this.taskEnd = this.determineTaskEnd();
        if (this.taskEnd == 1) {
            return;
        }
        this.taskEnd <<= 1;
        this.counter = 0;
        int numOfFiles = this.inFileNames.size();
        int i = 0;
        while (i < numOfFiles) {
            Vector scanArrayFile;
            boolean noError;
            block54: {
                noError = true;
                this.inFileNamePath = (String)this.inFileNames.elementAt(i);
                this.mevFileName = (String)this.outFileNames.elementAt(i);
                try {
                    FileReading fileReader = new FileReading(this.inFileNamePath);
                    if (fileReader.done) {
                        scanArrayFile = fileReader.getFileContentInLines();
                        break block54;
                    }
                    this.setErrorMessage(fileReader.getProcessMessage());
                    this.taskEnd = 1;
                    this.counter = 1;
                    return;
                }
                catch (IOException e) {
                    this.setErrorMessage(e.getMessage());
                    this.taskEnd = 1;
                    this.counter = 1;
                    return;
                }
            }
            String[] dataStart = this.getValueAndIndex(scanArrayFile, "Begin Data");
            String[] dataEnd = this.getValueAndIndex(scanArrayFile, "End Data");
            if (dataStart[0] == null) {
                this.setErrorMessage(IOUtil.extractFileNameFromPath(this.inFileNamePath) + " might be saved as Unicode file. " + "Please save it as ASCII text and try again.\n");
                return;
            }
            int hLines = Integer.parseInt(dataStart[1]) + 1;
            int lastLine = Integer.parseInt(dataEnd[1]) - 1;
            int numSpot = lastLine - hLines;
            aLine = (String)scanArrayFile.elementAt(hLines);
            this.defineKeys(channels);
            String[] colNames = this.separateLine(aLine);
            int arrayRowIndex = this.findRightCol(colNames, "Array Row");
            int arrayColIndex = this.findRightCol(colNames, "Array Column");
            int colIndex = this.findRightCol(colNames, "Column");
            int rowIndex = this.findRightCol(colNames, "Row");
            int ch1AreaLoc = this.findRightCol(colNames, this.chApixel);
            int ch2AreaLoc = this.findRightCol(colNames, this.chBpixel);
            aLine = (String)scanArrayFile.elementAt(lastLine);
            String[] colValues = this.separateLine(aLine);
            if (colValues.length > 2) {
                maxArrayRow = Integer.parseInt(colValues[arrayRowIndex]);
                maxArrayCol = Integer.parseInt(colValues[arrayColIndex]);
                maxCol = Integer.parseInt(colValues[colIndex]);
                maxRow = Integer.parseInt(colValues[rowIndex]);
                max = maxArrayRow * maxArrayCol;
            } else {
                JOptionPane.showMessageDialog(this.parent, "You might add extra space at the end of file.\nPlease remove it and try again.", this.parent.getTitle(), 0);
                noError = false;
                this.counter += numOfFiles;
            }
            if (noError) {
                if (max * maxCol * maxRow != numSpot) {
                    JOptionPane.showMessageDialog(this.parent, "You might have dropped some of your spots.\nThe converter requires an original ScanArray file.", this.parent.getTitle(), 0);
                    noError = false;
                    this.counter += numOfFiles;
                }
                if (noError) {
                    int ch1IntenLoc = this.findRightCol(colNames, this.chA);
                    int ch1Bkg = this.findRightCol(colNames, this.bgChA);
                    int ch2IntenLoc = this.findRightCol(colNames, this.chB);
                    int ch2Bkg = this.findRightCol(colNames, this.bgChB);
                    int nameIndex = this.findRightCol(colNames, "Name");
                    try {
                        String annoFileNamePath = IOUtil.dropExtension(this.mevFileName);
                        annoFileNamePath = annoFileNamePath + ".ann";
                        mevFileOut = new FileOutputStream(this.mevFileName);
                        mevWriter = new BufferedWriter(new OutputStreamWriter(mevFileOut));
                        this.sortKeys = new int[3][numSpot];
                        this.outFile = new String[numSpot];
                        String scanArrayFileName = IOUtil.extractFileNameFromPath(this.inFileNamePath);
                        String[] mevFileHeader = this.generateHeader(scanArrayFileName, numSpot, true);
                        int j = 0;
                        while (j < mevFileHeader.length) {
                            mevWriter.write(mevFileHeader[j]);
                            mevWriter.newLine();
                            mevWriter.flush();
                            ++j;
                        }
                        if (this.gAnnType == 1) {
                            annoFile = new String[numSpot];
                            annoWriter = this.createAnnoWriter(annoFileNamePath, scanArrayFileName, numSpot);
                        } else if (i < 1) {
                            annoFile = new String[numSpot];
                            annoWriter = this.createAnnoWriter(annoFileNamePath, scanArrayFileName, numSpot);
                        }
                        this.counter += hLines;
                        int unid = 1;
                        j = hLines + 1;
                        int k = 0;
                        while (j <= lastLine) {
                            int spAreaB;
                            int spAreaA;
                            aLine = (String)scanArrayFile.elementAt(j);
                            colValues = this.separateLine(aLine);
                            int metaRow = Integer.parseInt(colValues[arrayRowIndex]);
                            int metaCol = Integer.parseInt(colValues[arrayColIndex]);
                            int col = Integer.parseInt(colValues[colIndex]);
                            int row = Integer.parseInt(colValues[rowIndex]);
                            if (this.gSwap) {
                                spAreaA = this.calculateSpotArea(colValues, ch2AreaLoc);
                                spAreaB = this.calculateSpotArea(colValues, ch1AreaLoc);
                                bgA = this.calculateBackground(colValues, ch2Bkg);
                                bgB = this.calculateBackground(colValues, ch1Bkg);
                                if (this.quantWay != 0) {
                                    if (this.gBkgCorrect) {
                                        densA = this.calculateIntegrateIntensity(colValues, ch2IntenLoc, ch2Bkg, ch2AreaLoc, true);
                                        densB = this.calculateIntegrateIntensity(colValues, ch1IntenLoc, ch1Bkg, ch1AreaLoc, true);
                                        if (this.quantWay == 3) {
                                            medA = this.calculateMedianIntensity(colValues, ch2IntenLoc, ch2Bkg, true);
                                            medB = this.calculateMedianIntensity(colValues, ch1IntenLoc, ch1Bkg, true);
                                        }
                                    } else {
                                        densA = this.calculateIntegrateIntensity(colValues, ch2IntenLoc, ch2Bkg, ch2AreaLoc, false);
                                        densB = this.calculateIntegrateIntensity(colValues, ch1IntenLoc, ch1Bkg, ch1AreaLoc, false);
                                        if (this.quantWay == 3) {
                                            medA = this.calculateMedianIntensity(colValues, ch2IntenLoc, ch2Bkg, false);
                                            medB = this.calculateMedianIntensity(colValues, ch1IntenLoc, ch1Bkg, false);
                                        }
                                    }
                                } else if (this.gBkgCorrect) {
                                    densA = this.calculateIntegrateIntensity(colValues, ch2IntenLoc, ch2Bkg, true);
                                    densB = this.calculateIntegrateIntensity(colValues, ch1IntenLoc, ch1Bkg, true);
                                } else {
                                    densA = this.calculateIntegrateIntensity(colValues, ch2IntenLoc, ch2Bkg, false);
                                    densB = this.calculateIntegrateIntensity(colValues, ch1IntenLoc, ch1Bkg, false);
                                }
                            } else {
                                spAreaA = this.calculateSpotArea(colValues, ch1AreaLoc);
                                spAreaB = this.calculateSpotArea(colValues, ch2AreaLoc);
                                bgA = this.calculateBackground(colValues, ch1Bkg);
                                bgB = this.calculateBackground(colValues, ch2Bkg);
                                if (this.quantWay != 0) {
                                    if (this.gBkgCorrect) {
                                        densA = this.calculateIntegrateIntensity(colValues, ch1IntenLoc, ch1Bkg, ch1AreaLoc, true);
                                        densB = this.calculateIntegrateIntensity(colValues, ch2IntenLoc, ch2Bkg, ch2AreaLoc, true);
                                        if (this.quantWay == 3) {
                                            medA = this.calculateMedianIntensity(colValues, ch1IntenLoc, ch1Bkg, true);
                                            medB = this.calculateMedianIntensity(colValues, ch2IntenLoc, ch2Bkg, true);
                                        }
                                    } else {
                                        densA = this.calculateIntegrateIntensity(colValues, ch1IntenLoc, ch1Bkg, ch1AreaLoc, false);
                                        densB = this.calculateIntegrateIntensity(colValues, ch2IntenLoc, ch2Bkg, ch2AreaLoc, false);
                                        if (this.quantWay == 3) {
                                            medA = this.calculateMedianIntensity(colValues, ch1IntenLoc, ch1Bkg, false);
                                            medB = this.calculateMedianIntensity(colValues, ch2IntenLoc, ch2Bkg, false);
                                        }
                                    }
                                } else if (this.gBkgCorrect) {
                                    densA = this.calculateIntegrateIntensity(colValues, ch1IntenLoc, ch1Bkg, true);
                                    densB = this.calculateIntegrateIntensity(colValues, ch2IntenLoc, ch2Bkg, true);
                                } else {
                                    densA = this.calculateIntegrateIntensity(colValues, ch1IntenLoc, ch1Bkg, false);
                                    densB = this.calculateIntegrateIntensity(colValues, ch2IntenLoc, ch2Bkg, false);
                                }
                            }
                            int slideRow = (metaRow - 1) * maxRow + row;
                            int slideCol = (metaCol - 1) * maxCol + col;
                            mevLine.append(unid).append("\t");
                            if (this.gUseMedian) {
                                mevLine.append(medA).append("\t").append(medB);
                                aLine = densA + "\t" + densB;
                            } else {
                                mevLine.append(densA).append("\t").append(densB);
                                aLine = medA + "\t" + medB;
                            }
                            mevLine.append("\t").append(slideRow).append("\t").append(slideCol);
                            mevLine.append("\t").append(metaRow).append("\t").append(metaCol);
                            mevLine.append("\t").append(row).append("\t").append(col).append("\t");
                            mevLine.append(bgA).append("\t").append(bgB).append("\t").append(spAreaA);
                            mevLine.append("\t").append(spAreaB).append("\t").append(aLine);
                            this.outFile[k] = new String(mevLine.toString());
                            mevLine.delete(0, mevLine.length());
                            if (this.gAnnType == 1) {
                                extraInfo = unid + "\t" + slideRow + "\t" + slideCol + "\t" + colValues[nameIndex];
                                annoFile[k] = new String(extraInfo);
                            } else if (i < 1) {
                                extraInfo = unid + "\t" + slideRow + "\t" + slideCol + "\t" + colValues[nameIndex];
                                annoFile[k] = new String(extraInfo);
                            }
                            this.sortKeys[0][k] = k;
                            this.sortKeys[1][k] = slideRow;
                            this.sortKeys[2][k] = slideCol;
                            ++this.counter;
                            ++unid;
                            ++j;
                            ++k;
                        }
                        if (this.wantSort) {
                            this.sorted = this.sortRowCol(maxArrayCol, maxCol);
                            j = 0;
                            while (j < this.outFile.length) {
                                mevWriter.write(this.outFile[this.sorted[j]]);
                                mevWriter.newLine();
                                mevWriter.flush();
                                if (this.gAnnType == 1) {
                                    annoWriter.write(annoFile[this.sorted[j]]);
                                    annoWriter.newLine();
                                    annoWriter.flush();
                                } else if (i < 1) {
                                    annoWriter.write(annoFile[this.sorted[j]]);
                                    annoWriter.newLine();
                                    annoWriter.flush();
                                }
                                ++this.counter;
                                ++j;
                            }
                        } else {
                            j = 0;
                            while (j < this.outFile.length) {
                                mevWriter.write(this.outFile[j]);
                                mevWriter.newLine();
                                mevWriter.flush();
                                if (this.gAnnType == 1) {
                                    annoWriter.write(annoFile[j]);
                                    annoWriter.newLine();
                                    annoWriter.flush();
                                } else if (i < 1) {
                                    annoWriter.write(annoFile[j]);
                                    annoWriter.newLine();
                                    annoWriter.flush();
                                }
                                ++this.counter;
                                ++j;
                            }
                        }
                        mevFileOut.close();
                        if (this.gAnnType == 1) {
                            annoWriter.close();
                        } else if (i < 1) {
                            annoWriter.close();
                        }
                    }
                    catch (IOException ie) {
                        Converter.fetalError = true;
                        System.out.println("Error in writing file: " + ie.getMessage());
                        this.msg = this.msg + "**********\n";
                        this.msg = this.msg + "Error in writing file: " + ie.getMessage() + "\n";
                    }
                }
            }
            ++i;
        }
        Converter.ready = true;
        this.counter = this.taskEnd;
    }

    private String calculateBackground(String[] tuple, int backg) {
        String bg = new String("");
        try {
            float fPix = Float.parseFloat(tuple[this.areaPixel]);
            float bMedian = Float.parseFloat(tuple[backg]);
            int temp = (int)(bMedian * fPix);
            bg = bg + temp;
        }
        catch (NumberFormatException nfex) {
            Converter.minorError = true;
            bg = "null";
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "There is an unacceptable value to calculate background;\n";
            this.msg = this.msg + "and the background was set to null.\n";
        }
        return bg;
    }

    private String calculateIntegrateIntensity(String[] tuple, int med, int backg, boolean bgSub) {
        String den;
        block3: {
            den = new String("");
            try {
                float fMedian = Float.parseFloat(tuple[med]);
                float bMedian = Float.parseFloat(tuple[backg]);
                if (bgSub) {
                    den = den + (int)(fMedian - bMedian);
                    break block3;
                }
                den = den + (int)fMedian;
            }
            catch (NumberFormatException nfex) {
                Converter.minorError = true;
                den = "null";
                this.msg = this.msg + "**********\n";
                this.msg = this.msg + "There is an unacceptable value to calculate intensity; and the intensity was set to null.\n";
            }
        }
        return den;
    }

    private String calculateIntegrateIntensity(String[] tuple, int med, int backg, int areaIndx, boolean bgSub) {
        String den = new String("");
        try {
            float fMedian = Float.parseFloat(tuple[med]);
            float bMedian = Float.parseFloat(tuple[backg]);
            float fPix = Float.parseFloat(tuple[areaIndx]);
            float temp = bgSub ? (fMedian - bMedian) * fPix : fMedian * (fPix /= 100.0f);
            den = den + (int)temp;
        }
        catch (NumberFormatException nfex) {
            Converter.minorError = true;
            den = "null";
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "There is an unacceptable value to calculate intensity; and the intensity was set to null.\n";
        }
        return den;
    }

    private String calculateMedianIntensity(String[] tuple, int med, int backg, boolean bgSub) {
        String den;
        block3: {
            den = new String("");
            try {
                float fMedian = Float.parseFloat(tuple[med]);
                float bMedian = Float.parseFloat(tuple[backg]);
                if (bgSub) {
                    den = den + (int)(fMedian - bMedian);
                    break block3;
                }
                den = den + (int)fMedian;
            }
            catch (NumberFormatException nfex) {
                Converter.minorError = true;
                den = "null";
                this.msg = this.msg + "**********\n";
                this.msg = this.msg + "There is an unacceptable value to calculate intensity; and the intensity was set to null.\n";
            }
        }
        return den;
    }

    private int calculateSpotArea(String[] tuple, int areaIndx) {
        float area = Float.parseFloat(tuple[areaIndx]);
        int temp = (int)(area /= 100.0f);
        return temp;
    }

    private String[] generateHeader(String fName, int numRow, boolean mev) {
        String[] tempHeader = mev ? new String[8] : new String[7];
        String bkgVal = this.gBkgCorrect ? "ON" : "OFF";
        tempHeader[0] = new String("# version: V1.0");
        tempHeader[1] = new String("# format_version:V4.0");
        tempHeader[2] = new String("# date: " + MyTimer.getCurrentDateAndTime('.'));
        tempHeader[3] = new String("# created by: " + this.barTitle);
        tempHeader[4] = new String("# row_count:" + numRow);
        tempHeader[5] = new String("# converted from ScanArray file: " + fName);
        if (mev) {
            tempHeader[6] = new String("# background_correction:" + bkgVal);
            tempHeader[7] = this.gUseMedian ? "UID\tMedA\tMedB\tR\tC\tMR\tMC\tSR\tSC\tBkgA\tBkgB\tSAA\tSAB\tIA\tIB" : "UID\tIA\tIB\tR\tC\tMR\tMC\tSR\tSC\tBkgA\tBkgB\tSAA\tSAB\tMedA\tMedB";
        } else {
            tempHeader[6] = "UID\tR\tC\tName";
        }
        return tempHeader;
    }

    private String[] getValueAndIndex(Vector fileCont, String key) {
        StringTokenizer token = null;
        int size = fileCont.size();
        String temp = new String("");
        String wantKey = new String("");
        String[] value = new String[2];
        int i = 0;
        while (i < size) {
            temp = (String)fileCont.elementAt(i);
            if (!temp.equals("") && this.isChar(temp.charAt(0)) && (wantKey = (token = new StringTokenizer(temp, "\t")).nextToken()).equalsIgnoreCase(key)) {
                value[0] = new String(MyIni.removeEndSpace(wantKey));
                value[1] = "" + i;
                i = size;
            }
            ++i;
        }
        return value;
    }

    private BufferedWriter createAnnoWriter(String fName, String inName, int numSpots) {
        BufferedWriter out;
        try {
            FileOutputStream fOut = new FileOutputStream(fName);
            out = new BufferedWriter(new OutputStreamWriter(fOut));
            String[] annoFileHeader = this.generateHeader(inName, numSpots, false);
            int i = 0;
            while (i < annoFileHeader.length) {
                out.write(annoFileHeader[i]);
                out.newLine();
                out.flush();
                ++i;
            }
        }
        catch (IOException ie) {
            Converter.fetalError = true;
            Converter.ready = false;
            System.out.println("Error in creating ann file: " + ie.getMessage());
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "Error in creating ann file: " + ie.getMessage() + "\n";
            return null;
        }
        return out;
    }

    private void defineKeys(String[] chs) {
        this.chA = new String(chs[0] + " " + "Intensity");
        this.chB = new String(chs[1] + " " + "Intensity");
        this.chApixel = new String(chs[0] + " " + "Area");
        this.chBpixel = new String(chs[1] + " " + "Area");
        this.bgChA = new String(chs[0] + " " + "Background");
        this.bgChB = new String(chs[1] + " " + "Background");
    }

    private int findRightCol(String[] str, String key) {
        int addr = 0;
        int size = str.length;
        String temp = new String("");
        int i = 0;
        while (i < str.length) {
            if (str[i].equalsIgnoreCase(key)) {
                addr = i;
                i = str.length;
            }
            ++i;
        }
        return addr;
    }

    private boolean isChar(char x) {
        boolean b = true;
        switch (x) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                b = false;
                break;
            }
            default: {
                b = true;
            }
        }
        return b;
    }
}

