/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tigr.microarray.converter.ConvertPanel;
import org.tigr.microarray.converter.ExpressConverter;
import org.tigr.util.LongTextChanger;
import org.tigr.util.MadamFileFilter;
import org.tigr.util.io.IOUtil;

public class ScanArrayPanel
extends ConvertPanel {
    private JComboBox intensityModeCombx;
    private JPanel intensityPanel;
    private JCheckBox keepAllCB;
    private JCheckBox gSwapChanCB;
    private JList gInputFileList;
    private JLabel intensityLB;
    private String gfName;
    private String tfName;
    private String info;
    private int quantWay = 0;
    private boolean keepAll = false;
    private boolean gSwapChan = false;
    private final String NUM_FILE = "  Number of Files:  ";
    private final String[] INTEN_MODE = new String[]{"Total", "Mean", "Mode", "Median"};
    private final int TOTAL = 0;
    private final int MEAN = 1;
    private final int MODE = 2;
    private final int MEDIAN = 3;

    public ScanArrayPanel(ExpressConverter convt) {
        super(convt);
        this.info = new String("");
        this.createGUI();
    }

    public void adjustGUI(int index) {
        String tmpName = new String("");
        this.outputType = index;
        if (this.outputType == 0) {
            this.gOutputFileLB.setText("TAV Files:");
            this.keepAllCB.setEnabled(true);
            this.activeIntensityWay(false);
        } else {
            this.gOutputFileLB.setText("MEV Files:");
            this.keepAllCB.setEnabled(false);
            this.activeIntensityWay(true);
        }
        int numFiles = this.outputFileNames.size();
        int i = 0;
        while (i < numFiles) {
            tmpName = (String)this.outputFileNames.elementAt(i);
            tmpName = IOUtil.dropExtension(tmpName);
            tmpName = tmpName + "." + this.FILE_TYPE[this.outputType];
            this.outputFileNames.setElementAt(tmpName, i);
            ++i;
        }
        this.validate();
    }

    public void changeFileList(Vector inFiles, Vector outFiles) {
        this.selectedFiles = inFiles;
        this.outputFileNames = outFiles;
        this.gInputFileList.setListData(inFiles);
        this.gOutputFileList.setListData(outFiles);
        this.gFileNumLB.setText("  Number of Files:  " + this.selectedFiles.size());
    }

    public void editDirectory(String path) {
        int selected = -1;
        String tempPath = path;
        selected = this.gOutputFileList.getSelectedIndex();
        int num = this.outputFileNames.size();
        int i = 0;
        while (i < num) {
            String tempName = (String)this.outputFileNames.elementAt(i);
            tempName = IOUtil.extractFileNameFromPath(tempName);
            tempName = tempPath + "\\" + tempName;
            this.outputFileNames.setElementAt(tempName, i);
            ++i;
        }
        this.gOutputFileList.setListData(this.outputFileNames);
        if (selected >= 0) {
            this.gOutputFileList.setSelectedIndex(selected);
        } else {
            this.gOutputFileList.setSelectedIndex(0);
        }
    }

    public void editFileName() {
        int selected = -1;
        selected = this.gOutputFileList.getSelectedIndex();
        if (selected >= 0) {
            String tempName = (String)this.gOutputFileList.getModel().getElementAt(selected);
            LongTextChanger changer = new LongTextChanger(this.parent, true, tempName);
            changer.setTitle("ExpressConveter V.1.7");
            changer.show();
            if (changer.isTextChanged()) {
                tempName = changer.getText();
                StringTokenizer token = new StringTokenizer(tempName, ":");
                if (token.countTokens() <= 1) {
                    tempName = "c:\\" + tempName;
                }
                tempName = (tempName = IOUtil.dropExtension(tempName)).lastIndexOf(46) == tempName.length() - 1 ? tempName + this.FILE_TYPE[this.outputType] : tempName + "." + this.FILE_TYPE[this.outputType];
                this.outputFileNames.setElementAt(tempName, selected);
                this.gOutputFileList.setListData(this.outputFileNames);
                this.gOutputFileList.setSelectedIndex(selected);
            }
        }
    }

    public Vector getOutputFileNames() {
        return this.outputFileNames;
    }

    public int getQuantiationWay() {
        return this.quantWay;
    }

    public Vector getSelectedFiles() {
        return this.selectedFiles;
    }

    public boolean isOutputReady() {
        return this.outputReady;
    }

    public boolean keepAllInformation() {
        return this.keepAll;
    }

    public boolean swapOriginalChannel() {
        return this.gSwapChan;
    }

    public void removeFileFromList() {
        int[] addrs = this.gOutputFileList.getSelectedIndices();
        if (addrs.length > 0) {
            int i = 0;
            while (i < addrs.length) {
                this.selectedFiles.remove(addrs[i]);
                this.outputFileNames.remove(addrs[i]);
                ++i;
            }
            this.gInputFileList.setListData(this.selectedFiles);
            this.gOutputFileList.setListData(this.outputFileNames);
            if (this.outputFileNames.size() > 0) {
                this.gOutputFileList.setSelectedIndex(0);
            }
            this.gFileNumLB.setText("  Number of Files:  " + this.selectedFiles.size());
        }
    }

    public void reset() {
        this.selectedFiles.removeAllElements();
        this.outputFileNames.removeAllElements();
        this.gFileNumLB.setText("  Number of Files:  ");
        this.gInputFileList.setListData(this.selectedFiles);
        this.gOutputFileList.setListData(this.outputFileNames);
        this.wantSort = true;
        this.keepAll = false;
        this.outputReady = false;
        this.gSwapChan = false;
        this.sortCB.setSelected(this.wantSort);
        this.keepAllCB.setSelected(this.keepAll);
        this.gSwapChanCB.setSelected(this.gSwapChan);
        this.parent.activateButton(this.outputReady, this.outputReady);
    }

    public void setSelectedFiles(String[] newFiles) {
        String temp = new String("");
        int num = newFiles.length;
        int i = 0;
        while (i < num) {
            if (!this.selectedFiles.contains(newFiles[i])) {
                this.selectedFiles.add(newFiles[i]);
                this.outputFileNames.add(IOUtil.dropExtension(newFiles[i]) + "." + this.FILE_TYPE[this.outputType]);
            }
            ++i;
        }
        this.gInputFileList.setListData(this.selectedFiles);
        this.gOutputFileList.setListData(this.outputFileNames);
        this.gOutputFileList.setSelectedIndex(0);
        this.gFileNumLB.setText("  Number of Files:  " + this.selectedFiles.size());
    }

    private File getFile(String ext, String fileType, String path) {
        JFileChooser fileChooser = new JFileChooser(path);
        MadamFileFilter wanted = new MadamFileFilter(ext, fileType);
        fileChooser.setFileFilter(wanted);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setDialogTitle("Save Output As");
        fileChooser.setMultiSelectionEnabled(false);
        int result = fileChooser.showSaveDialog(this);
        if (result == 1) {
            return null;
        }
        File temp = fileChooser.getSelectedFile();
        return temp;
    }

    protected void createGUI() {
        this.setLayout(new GridBagLayout());
        this.gInputFileLB = new JLabel("ScanArray Files:");
        this.gInputFileList = new JList();
        this.gInputFileList.setBorder(this.gLow);
        this.actionHandler(this.gInputFileList);
        this.actionHandler(this.gOutputFileList);
        this.gFilesSP = new JScrollPane(this.gInputFileList);
        this.intensityLB = new JLabel("Intensity Generated By:");
        this.intensityPanel = new JPanel(new GridBagLayout());
        this.gSwapChanCB = new JCheckBox("Swap Channel");
        this.gSwapChanCB.setToolTipText("If file has channel 1 as Cy5, swap it as Cy3.");
        this.gSwapChanCB.setSelected(this.gSwapChan);
        this.gSwapChanCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ce) {
                if (ScanArrayPanel.this.gSwapChanCB.isSelected()) {
                    ScanArrayPanel.this.gSwapChan = true;
                } else {
                    ScanArrayPanel.this.gSwapChan = false;
                }
            }
        });
        this.intensityModeCombx = new JComboBox<String>(this.INTEN_MODE);
        this.intensityModeCombx.setBorder(this.gLow);
        this.intensityModeCombx.setPreferredSize(new Dimension(80, 23));
        this.intensityModeCombx.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                ScanArrayPanel.this.quantWay = ScanArrayPanel.this.intensityModeCombx.getSelectedIndex();
            }
        });
        this.keepAllCB = new JCheckBox("Keep All Information in the ScanArray File.");
        this.keepAllCB.setToolTipText("Attach all anotation info at the end.");
        this.keepAllCB.setSelected(this.keepAll);
        this.keepAllCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ce) {
                if (ScanArrayPanel.this.keepAllCB.isSelected()) {
                    ScanArrayPanel.this.keepAll = true;
                } else {
                    ScanArrayPanel.this.keepAll = false;
                }
            }
        });
        this.gba.add(this, this.gFileSplitPane, 0, 0, 2, 1, 1, 1, 1, 10, 5, 5, 10, 5);
        this.gba.add(this, this.sortCB, 0, 1, 1, 1, 1, 0, 2, 10, 10, 15, 3, 5);
        this.gba.add(this, this.keepAllCB, 0, 2, 1, 1, 1, 0, 2, 10, 3, 15, 3, 5);
        this.gba.add(this, this.gIntenPanel, 1, 1, 1, 2, 1, 0, 2, 17, 10, 0, 3, 5);
        this.gba.add(this.intensityPanel, this.intensityLB, 0, 0, 1, 1, 1, 0, 2, 17, 0, 0, 0, 5);
        this.gba.add(this.intensityPanel, this.intensityModeCombx, 1, 0, 1, 1, 0, 0, 0, 13, 0, 5, 0, 10);
        this.gba.add(this.intensityPanel, this.gSwapChanCB, 2, 0, 1, 1, 0, 0, 0, 13, 0, 5, 0, 2);
        this.gba.add(this.gInputPL, this.gInputFileLB, 0, 0, 1, 1, 1, 0, 2, 10, 5, 10, 5, 2);
        this.gba.add(this.gInputPL, this.intensityPanel, 1, 0, 1, 1, 0, 0, 0, 10, 5, 0, 5, 5);
        this.gba.add(this.gInputPL, this.gFilesSP, 0, 1, 2, 1, 1, 1, 1, 10, 1, 2, 5, 2);
    }
}

