/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.converter.Converter;
import org.tigr.util.FileReading;
import org.tigr.util.io.MyIni;

public class ScanArrayTav
extends Converter {
    private JFrame parent;
    private String bgChA;
    private String bgChB;
    private String chA;
    private String chB;
    private String chApixel;
    private String chBpixel;
    private String saFileName;
    private String tavFileName;
    private FileReading fileReader;
    private int numSpot;
    private int areaPixel;
    private int quantWay;
    private boolean keepAll;
    private boolean gSwap;
    private final int TOTAL = 1;
    private final int MEAN = 2;
    private final int MODE = 3;
    private final int MEDIAN = 4;
    private final String ARRAY_ROW = "Array Row";
    private final String ARRAY_COL = "Array Column";
    private final String BEGIN_DATA = "Begin Data";
    private final String COLUMN = "Column";
    private final String END_DATA = "End Data";
    private final String RW = "Row";
    private final String INTENSITY = "Intensity";
    private final String BKG = "Background";
    private final String AREA = "Area";
    private final String NULL = "null";

    public ScanArrayTav(String sfName, String tfName, int way) {
        this.inFileNames = new Vector(1);
        this.outFileNames = new Vector(1);
        this.inFileNames.add(sfName);
        this.outFileNames.add(tfName);
        Converter.ready = false;
        this.wantSort = true;
        this.keepAll = true;
        this.gSwap = false;
        Converter.fetalError = false;
        Converter.minorError = false;
        this.quantWay = way;
    }

    public ScanArrayTav(JFrame p, Vector sfNames, Vector tfNames, int way) {
        this.parent = p;
        this.inFileNames = sfNames;
        this.outFileNames = tfNames;
        this.msg = new String("");
        Converter.ready = false;
        this.wantSort = true;
        this.keepAll = true;
        this.gSwap = false;
        Converter.fetalError = false;
        Converter.minorError = false;
        this.quantWay = way;
    }

    public int getTaskEnd() {
        return this.taskEnd;
    }

    public String getFileName() {
        return this.saFileName;
    }

    public int getCurrent() {
        return this.counter;
    }

    public String getErrorMsg() {
        return this.msg;
    }

    public void run() {
        String aLine = new String("");
        String densA = new String("");
        String densB = new String("");
        String tavLine = new String("");
        String flagA = new String("");
        String flagB = new String("");
        String bgA = new String("");
        String bgB = new String("");
        String extraInfo = new String("");
        String[] channels = new String[]{"ch1", "ch2"};
        int max = 0;
        int maxRow = 0;
        int maxCol = 0;
        int maxArrayRow = 0;
        int maxArrayCol = 0;
        int[] needLoc = new int[10];
        BufferedWriter bufWriter = null;
        FileOutputStream fileOut = null;
        this.taskEnd = this.determineTaskEnd();
        if (this.taskEnd == 1) {
            return;
        }
        this.taskEnd <<= 1;
        this.counter = 0;
        int numOfFiles = this.inFileNames.size();
        int i = 0;
        while (i < numOfFiles) {
            Vector scanArrayFile;
            boolean noError;
            block24: {
                noError = true;
                this.saFileName = (String)this.inFileNames.elementAt(i);
                this.tavFileName = (String)this.outFileNames.elementAt(i);
                try {
                    FileReading fileReader = new FileReading(this.saFileName);
                    if (fileReader.done) {
                        scanArrayFile = fileReader.getFileContentInLines();
                        break block24;
                    }
                    this.setErrorMessage(fileReader.getProcessMessage());
                    this.taskEnd = 1;
                    this.counter = 1;
                    return;
                }
                catch (IOException e) {
                    this.setErrorMessage(e.getMessage());
                    this.taskEnd = 1;
                    this.counter = 1;
                    return;
                }
            }
            String[] dataStart = this.getValueAndIndex(scanArrayFile, "Begin Data");
            String[] dataEnd = this.getValueAndIndex(scanArrayFile, "End Data");
            int hLines = Integer.parseInt(dataStart[1]) + 1;
            int lastLine = Integer.parseInt(dataEnd[1]) - 1;
            this.numSpot = lastLine - hLines;
            aLine = (String)scanArrayFile.elementAt(hLines);
            this.defineKeys(channels);
            String[] colNames = this.separateLine(aLine);
            int arrayRowIndex = this.findRightCol(colNames, "Array Row");
            int arrayColIndex = this.findRightCol(colNames, "Array Column");
            int colIndex = this.findRightCol(colNames, "Column");
            int rowIndex = this.findRightCol(colNames, "Row");
            int ch1AreaLoc = this.findRightCol(colNames, this.chApixel);
            int ch2AreaLoc = this.findRightCol(colNames, this.chBpixel);
            aLine = (String)scanArrayFile.elementAt(lastLine);
            String[] colValues = this.separateLine(aLine);
            if (colValues.length > 2) {
                maxArrayRow = Integer.parseInt(colValues[arrayRowIndex]);
                maxArrayCol = Integer.parseInt(colValues[arrayColIndex]);
                maxCol = Integer.parseInt(colValues[colIndex]);
                maxRow = Integer.parseInt(colValues[rowIndex]);
                max = maxArrayRow * maxArrayCol;
            } else {
                JOptionPane.showMessageDialog(this.parent, "You might add extra space at the end of file.\nPlease remove it and try again.", this.parent.getTitle(), 0);
                noError = false;
                this.counter += numOfFiles;
            }
            if (noError) {
                if (max * maxCol * maxRow != this.numSpot) {
                    JOptionPane.showMessageDialog(this.parent, "You might have dropped some of your spots.\nThe converter requires an original ScanArray file.", this.parent.getTitle(), 0);
                    noError = false;
                    this.counter += numOfFiles;
                }
                if (noError) {
                    int ch1IntenLoc = this.findRightCol(colNames, this.chA);
                    int ch1Bkg = this.findRightCol(colNames, this.bgChA);
                    int ch2IntenLoc = this.findRightCol(colNames, this.chB);
                    int ch2Bkg = this.findRightCol(colNames, this.bgChB);
                    needLoc[0] = ch1IntenLoc;
                    needLoc[1] = ch1Bkg;
                    needLoc[2] = ch1AreaLoc;
                    needLoc[3] = ch2IntenLoc;
                    needLoc[4] = ch2Bkg;
                    needLoc[5] = ch2AreaLoc;
                    needLoc[6] = arrayRowIndex;
                    needLoc[7] = arrayColIndex;
                    needLoc[8] = rowIndex;
                    needLoc[9] = colIndex;
                    try {
                        fileOut = new FileOutputStream(this.tavFileName);
                        bufWriter = new BufferedWriter(new OutputStreamWriter(fileOut));
                        this.sortKeys = new int[3][this.numSpot];
                        this.outFile = new String[this.numSpot];
                        this.counter += hLines;
                        int j = hLines + 1;
                        int k = 0;
                        while (j <= lastLine) {
                            int spAreaB;
                            int spAreaA;
                            aLine = (String)scanArrayFile.elementAt(j);
                            colValues = this.separateLine(aLine);
                            int metaRow = Integer.parseInt(colValues[arrayRowIndex]);
                            int metaCol = Integer.parseInt(colValues[arrayColIndex]);
                            int col = Integer.parseInt(colValues[colIndex]);
                            int row = Integer.parseInt(colValues[rowIndex]);
                            if (this.gSwap) {
                                spAreaA = this.calculateSpotArea(colValues, ch2AreaLoc);
                                spAreaB = this.calculateSpotArea(colValues, ch1AreaLoc);
                                bgA = this.calculateBackground(colValues, ch2Bkg);
                                bgB = this.calculateBackground(colValues, ch1Bkg);
                                if (this.quantWay != 1) {
                                    densA = this.calculateDensity(colValues, ch2IntenLoc, ch2Bkg, ch2AreaLoc);
                                    densB = this.calculateDensity(colValues, ch1IntenLoc, ch1Bkg, ch1AreaLoc);
                                } else {
                                    densA = "" + (int)Float.parseFloat(colValues[ch2IntenLoc]);
                                    densB = "" + (int)Float.parseFloat(colValues[ch1IntenLoc]);
                                }
                            } else {
                                spAreaA = this.calculateSpotArea(colValues, ch1AreaLoc);
                                spAreaB = this.calculateSpotArea(colValues, ch2AreaLoc);
                                bgA = this.calculateBackground(colValues, ch1Bkg);
                                bgB = this.calculateBackground(colValues, ch2Bkg);
                                if (this.quantWay != 1) {
                                    densA = this.calculateDensity(colValues, ch1IntenLoc, ch1Bkg, ch1AreaLoc);
                                    densB = this.calculateDensity(colValues, ch2IntenLoc, ch2Bkg, ch2AreaLoc);
                                } else {
                                    densA = "" + (int)Float.parseFloat(colValues[ch1IntenLoc]);
                                    densB = "" + (int)Float.parseFloat(colValues[ch2IntenLoc]);
                                }
                            }
                            flagA = "null";
                            flagB = "null";
                            int slideRow = (metaRow - 1) * maxRow + row;
                            int slideCol = (metaCol - 1) * maxCol + col;
                            tavLine = slideRow + "\t" + slideCol + "\t" + metaRow + "\t" + metaCol + "\t" + row + "\t" + col + "\t" + densA + "\t" + densB + "\t" + spAreaA + "\t" + spAreaB + "\tnull\tnull\tnull\t" + bgA + "\t" + bgB + "\t" + flagA + "\t" + flagB;
                            if (this.keepAll) {
                                extraInfo = this.setAnnotaionInfo(colValues, needLoc);
                                tavLine = tavLine + extraInfo.toString();
                            }
                            this.outFile[k] = new String(tavLine);
                            this.sortKeys[0][k] = k;
                            this.sortKeys[1][k] = slideRow;
                            this.sortKeys[2][k] = slideCol;
                            ++this.counter;
                            ++j;
                            ++k;
                        }
                        if (this.wantSort) {
                            this.sorted = this.sortRowCol(maxArrayCol, maxCol);
                            j = 0;
                            while (j < this.outFile.length) {
                                bufWriter.write(this.outFile[this.sorted[j]]);
                                bufWriter.newLine();
                                bufWriter.flush();
                                ++this.counter;
                                ++j;
                            }
                        } else {
                            j = 0;
                            while (j < this.outFile.length) {
                                bufWriter.write(this.outFile[j]);
                                bufWriter.newLine();
                                bufWriter.flush();
                                ++this.counter;
                                ++j;
                            }
                        }
                        fileOut.close();
                    }
                    catch (IOException ie) {
                        Converter.fetalError = true;
                        System.out.println("Error in writing file: " + ie.getMessage());
                        this.msg = this.msg + "**********\n";
                        this.msg = this.msg + "Error in writing file: " + ie.getMessage() + "\n";
                    }
                }
            }
            ++i;
        }
        Converter.ready = true;
        this.counter = this.taskEnd;
    }

    public void setSortSpots(boolean b) {
        this.wantSort = b;
    }

    public void setSwapChannel(boolean b) {
        this.gSwap = b;
    }

    public void setKeepAllInformation(boolean b) {
        this.keepAll = b;
    }

    private String calculateBackground(String[] tuple, int backg) {
        String bg = new String("");
        try {
            float fPix = Float.parseFloat(tuple[this.areaPixel]);
            float bMedian = Float.parseFloat(tuple[backg]);
            int temp = (int)(bMedian * fPix);
            bg = bg + temp;
        }
        catch (NumberFormatException nfex) {
            Converter.minorError = true;
            bg = "null";
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "There is an unacceptable value to calculate background;\n";
            this.msg = this.msg + "and the background was set to null.\n";
        }
        return bg;
    }

    private String calculateDensity(String[] tuple, int med, int backg, int areaIndx) {
        String den = new String("");
        try {
            float fMedian = Float.parseFloat(tuple[med]);
            float bMedian = Float.parseFloat(tuple[backg]);
            float fPix = Float.parseFloat(tuple[areaIndx]);
            int temp = (int)((fMedian - bMedian) * (fPix /= 100.0f));
            den = den + temp;
        }
        catch (NumberFormatException nfex) {
            Converter.minorError = true;
            den = "null";
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "There is an unacceptable value to calculate intensity; and the intensity was set to null.\n";
        }
        return den;
    }

    private int calculateSpotArea(String[] tuple, int areaIndx) {
        float area = Float.parseFloat(tuple[areaIndx]);
        int temp = (int)(area /= 100.0f);
        return temp;
    }

    private String[] getValueAndIndex(Vector fileCont, String key) {
        StringTokenizer token = null;
        int size = fileCont.size();
        String temp = new String("");
        String wantKey = new String("");
        String[] value = new String[2];
        int i = 0;
        while (i < size) {
            temp = (String)fileCont.elementAt(i);
            if (!temp.equals("") && this.isChar(temp.charAt(0)) && (wantKey = (token = new StringTokenizer(temp, "\t")).nextToken()).equalsIgnoreCase(key)) {
                value[0] = new String(MyIni.removeEndSpace(wantKey));
                value[1] = "" + i;
                i = size;
            }
            ++i;
        }
        return value;
    }

    private void defineKeys(String[] chs) {
        this.chA = new String(chs[0] + " " + "Intensity");
        this.chB = new String(chs[1] + " " + "Intensity");
        this.chApixel = new String(chs[0] + " " + "Area");
        this.chBpixel = new String(chs[1] + " " + "Area");
        this.bgChA = new String(chs[0] + " " + "Background");
        this.bgChB = new String(chs[1] + " " + "Background");
    }

    private int findRightCol(String[] str, String key) {
        int addr = 0;
        int size = str.length;
        String temp = new String("");
        int i = 0;
        while (i < str.length) {
            if (str[i].equalsIgnoreCase(key)) {
                addr = i;
                i = str.length;
            }
            ++i;
        }
        return addr;
    }

    private boolean isChar(char x) {
        boolean b = true;
        switch (x) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                b = false;
                break;
            }
            default: {
                b = true;
            }
        }
        return b;
    }

    private String setAnnotaionInfo(String[] val, int[] noNeed) {
        StringBuffer temp = new StringBuffer();
        boolean want = true;
        int i = 0;
        while (i < val.length) {
            int j = 0;
            while (j < noNeed.length) {
                if (noNeed[j] == i) {
                    want = false;
                    j = noNeed.length;
                } else {
                    want = true;
                }
                ++j;
            }
            if (want) {
                temp.append("\t" + val[i]);
            }
            ++i;
        }
        return temp.toString();
    }
}

