/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.tigr.util.awt.GBA;

public class LongTextChanger
extends JDialog
implements ActionListener {
    private JTextField textTF;
    private JScrollPane textSP;
    private JPanel basePanel;
    private JPanel butnPanel;
    private JButton okBtn;
    private JButton cancelBtn;
    private GBA gba;
    private String text;
    private String title;
    private boolean dirtyData;

    public LongTextChanger() {
        this((JFrame)null);
    }

    public LongTextChanger(JFrame frame) {
        this(frame, true, new String(""));
    }

    public LongTextChanger(JFrame frame, boolean m, String input) {
        this(frame, m, new String(""), input);
    }

    public LongTextChanger(JFrame frame, boolean m, String title, String input) {
        super((Frame)frame, m);
        this.text = input;
        this.title = title;
        this.dirtyData = false;
        this.createGUI();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                LongTextChanger.this.dirtyData = false;
                LongTextChanger.this.terminate();
            }
        });
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.cancelBtn) {
            this.dirtyData = false;
            this.terminate();
        } else if (ae.getSource() == this.okBtn) {
            if (this.dirtyData) {
                this.text = this.textTF.getText();
                if (this.text.equals("")) {
                    this.alertUsers("You must type the file name here.");
                } else {
                    this.terminate();
                }
            } else {
                this.terminate();
            }
        }
    }

    private void alertUsers(String msg) {
        JOptionPane.showMessageDialog(this, msg, this.title, 0);
    }

    private void createGUI() {
        BevelBorder high = new BevelBorder(0);
        BevelBorder low = new BevelBorder(1);
        this.gba = new GBA();
        int sizeX = 400;
        int sizeY = 80;
        int btnWide = 70;
        int btnHigh = 23;
        this.basePanel = new JPanel(new GridBagLayout());
        this.textTF = new JTextField(this.text);
        this.textTF.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent ce) {
                if (!LongTextChanger.this.textTF.getText().equals(LongTextChanger.this.text)) {
                    LongTextChanger.this.dirtyData = true;
                } else {
                    LongTextChanger.this.dirtyData = false;
                }
            }
        });
        this.textSP = new JScrollPane(this.textTF);
        this.textSP.setVerticalScrollBarPolicy(21);
        this.textSP.setHorizontalScrollBarPolicy(32);
        this.textSP.setBorder(low);
        this.textSP.setPreferredSize(new Dimension(sizeX, sizeY - 35));
        this.butnPanel = new JPanel(new GridBagLayout());
        this.okBtn = new JButton("OK");
        this.okBtn.setBorder(high);
        this.okBtn.setPreferredSize(new Dimension(btnWide, btnHigh));
        this.okBtn.addActionListener(this);
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.setBorder(high);
        this.cancelBtn.setPreferredSize(new Dimension(btnWide, btnHigh));
        this.cancelBtn.addActionListener(this);
        this.getContentPane().add(this.basePanel);
        this.setTitle(this.title);
        this.gba.add(this.basePanel, this.textSP, 0, 0, 1, 1, 1, 0, 2, 10, 10, 5, 5, 5);
        this.gba.add(this.basePanel, this.butnPanel, 0, 1, 1, 1, 1, 0, 2, 10, 5, 5, 5, 5);
        this.gba.add(this.butnPanel, this.okBtn, 0, 0, 1, 1, 0, 0, 0, 10, 5, 5, 5, 5);
        this.gba.add(this.butnPanel, this.cancelBtn, 1, 0, 1, 1, 0, 0, 0, 10, 5, 5, 5, 5);
        this.resize(sizeX, sizeY);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - sizeX) / 2;
        int y = (screenSize.height - sizeY) / 2;
        this.setLocation(x, y);
        this.setResizable(false);
        this.pack();
    }

    public String getText() {
        return this.text;
    }

    public boolean isTextChanged() {
        return this.dirtyData;
    }

    private void terminate() {
        this.setVisible(false);
        this.dispose();
    }
}

