/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.formula;

import org.tigr.util.formula.ExpressionException;
import org.tigr.util.formula.ExpressionParser;
import org.tigr.util.formula.node.EvaluateException;

public class MathExpression {
    private boolean gTreeReady = false;
    private boolean gUninary = false;
    private boolean gInt = true;
    private ExpressionParser gParser;
    private String gExpr;

    public MathExpression() {
    }

    public MathExpression(String formula) {
        this();
        this.setExpression(formula);
        this.parseFormula();
    }

    public void setExpression(String expr) throws ExpressionException {
        if (expr == null) {
            throw new ExpressionException(this, "Invalid expression : " + expr);
        }
        this.gExpr = expr;
    }

    public void IntegerResult(boolean b) {
        this.gInt = b;
    }

    public String getExpression() {
        return this.gExpr;
    }

    public String evaluate() throws EvaluateException {
        String result = null;
        if (this.getExpression() == null) {
            throw new EvaluateException("Invalid empty expression");
        }
        if (this.gTreeReady) {
            result = this.gParser.evaluate();
        }
        if (result == null) {
            throw new EvaluateException("No evaluation");
        }
        return result;
    }

    public String evaluate(String[] vals) throws EvaluateException {
        String result = null;
        if (this.gExpr == null) {
            throw new EvaluateException("Invalid empty expression");
        }
        int indx = this.isUninary(this.gExpr);
        if (indx >= 0) {
            return vals[indx];
        }
        if (this.gTreeReady) {
            result = this.gParser.evaluate(vals, this.gInt);
        }
        if (result == null) {
            throw new EvaluateException("No evaluation");
        }
        return result;
    }

    private int isUninary(String formula) {
        int num = -1;
        try {
            num = Integer.parseInt(formula);
        }
        catch (NumberFormatException ne) {
            return -1;
        }
        return num;
    }

    private void parseFormula() {
        if (this.gExpr.equals("")) {
            this.gUninary = true;
            return;
        }
        this.gParser = new ExpressionParser(this.gExpr);
        int indx = this.isUninary(this.gExpr);
        if (indx >= 0) {
            this.gUninary = true;
        } else {
            this.gTreeReady = this.gParser.execute();
        }
    }
}

